/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.ddi;

import com.bwanms.ddi.DDCallbackInterface;
import com.bwanms.mediation.MOAccessSession;
import com.bwanms.mediation.MediationException;
import com.bwanms.mediation.snmp.SNMPTrapV1AgentEvent;
import com.bwanms.meta.mo.MOChangeProcessor;
import com.bwanms.meta.mo.MOChangeProcessorUtil;
import com.bwanms.mo.ManagedObject;
import com.bwanms.model.Equipment;
import com.bwanms.model.EquipmentNotifyerEventTypes;
import com.bwanms.model.ManagedEntityBase;
import com.bwanms.model.TreeChangingLabel;
import com.bwanms.model.fault.Event;
import com.bwanms.persistence.Datastore;
import com.bwanms.rb.configuration.info.RbConfigSectionFactory;
import com.bwanms.rb.ddi.RbAuSynchronizationHelper;
import com.bwanms.rb.ddi.RbBSCreateBackupFileCommand;
import com.bwanms.rb.ddi.RbBSTrapProcessor;
import com.bwanms.rb.ddi.RbBaseStationSynchronizationStrategy;
import com.bwanms.rb.ddi.RbEntityEvents;
import com.bwanms.rb.ddi.RbNpuSynchronizationHelper;
import com.bwanms.rb.ddi.RbSNMPTrapV1;
import com.bwanms.rb.mo.RbAuConfigEntry;
import com.bwanms.rb.mo.RbBSSwitchingModeParameters;
import com.bwanms.rb.mo.RbIfInfoEntry;
import com.bwanms.rb.mo.RbNpuConfigEntry;
import com.bwanms.rb.model.RbAU;
import com.bwanms.rb.model.RbBS;
import com.bwanms.rb.model.RbNPU;
import com.bwanms.rb.util.RbVersions;
import com.bwanms.util.version.impl.DefaultVersion;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.hibernate.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbBSSynchronizationStrategy
extends RbBaseStationSynchronizationStrategy {
    private static final Logger logger = Logger.getLogger(RbBSSynchronizationStrategy.class);
    private static Map<Class<? extends ManagedObject>, Method> moChangeProcessors = MOChangeProcessorUtil.getProcessors(RbBSSynchronizationStrategy.class);
    RbAuSynchronizationHelper auHelper;
    RbNpuSynchronizationHelper npuHelper;
    private RbBSTrapProcessor trapProcessor;

    public RbBSSynchronizationStrategy(RbBS bs, DDCallbackInterface ddCallback) {
        super(bs, ddCallback);
        this.auHelper = new RbAuSynchronizationHelper(bs);
        this.npuHelper = new RbNpuSynchronizationHelper(bs);
        this.trapProcessor = new RbBSTrapProcessor(this);
    }

    @MOChangeProcessor(moClass=RbNpuConfigEntry.class)
    public void processRbNpuConfigEntryChange(String instanceID, RbNpuConfigEntry npuInstance) {
        logger.debug((Object)("[" + this.bsEq.getEUID() + "] Processing NPU: " + instanceID));
        if (npuInstance == null) {
            logger.error((Object)("Null NPU instance " + instanceID));
            return;
        }
        RbNPU managedNPU = ((RbBS)this.bsEq).findNpuBySlotNumber(Integer.parseInt(instanceID));
        if (npuInstance.isConnected()) {
            if (npuInstance.isActive()) {
                ((RbBS)this.bsEq).setOperationalSoftwareVersion(npuInstance.getRbNpuOperSwVersion());
                ((RbBS)this.bsEq).setShadowSoftwareVersion(npuInstance.getRbNpuShadowSwVersion());
                ((RbBS)this.bsEq).setRunningSoftwareVersion(npuInstance.getRuningSwVersion());
                ((RbBS)this.bsEq).setHardwareRevision(npuInstance.getRbNpuHwRevision());
                ((RbBS)this.bsEq).setSerialNumber(npuInstance.getRbNpuSerialNo());
            }
            String serialNumber = npuInstance.getRbNpuSerialNo();
            logger.debug((Object)("[" + this.bsEq.getEUID() + "] NPU is connected " + serialNumber));
            if (managedNPU != null) {
                if (!serialNumber.equals(managedNPU.getSerialNumber())) {
                    this.npuHelper.disconnectNPU(managedNPU);
                    this.ddCallback.setEquipmentState(null, (Equipment)managedNPU, -1);
                    managedNPU = null;
                } else {
                    this.npuHelper.updateNPU(managedNPU, npuInstance);
                    this.ddCallback.setEquipmentState(null, (Equipment)managedNPU, 0);
                }
            }
            if (managedNPU == null) {
                RbNPU newNPU = this.npuHelper.findNPU(serialNumber);
                if (newNPU == null) {
                    newNPU = this.npuHelper.createNPU(npuInstance);
                    ManagedEntityBase.persist((Session)Datastore.session(), (ManagedEntityBase)newNPU);
                    this.npuHelper.updateNPU(newNPU, npuInstance);
                    this.npuHelper.connectNPU(newNPU, npuInstance.getRbSlotNumber());
                    this.ddCallback.equipmentCreate(null, (Equipment)newNPU);
                    this.ddCallback.setEquipmentState(null, (Equipment)newNPU, 0);
                } else {
                    this.npuHelper.connectNPU(newNPU, npuInstance.getRbSlotNumber());
                    this.ddCallback.setEquipmentState(null, (Equipment)newNPU, 0);
                }
                managedNPU = newNPU;
            }
        } else if (managedNPU != null) {
            this.npuHelper.disconnectNPU(managedNPU);
            this.ddCallback.setEquipmentState(null, (Equipment)managedNPU, -1);
        }
        if (managedNPU != null) {
            Datastore.session().saveOrUpdate((Object)managedNPU);
        }
    }

    public void disconnectAU(int slotNumber) {
        RbAU au = ((RbBS)this.bsEq).findAuBySlotNumber(slotNumber);
        if (au != null) {
            this.auHelper.disconnectAU(au);
            this.ddCallback.setEquipmentState(null, (Equipment)au, -1);
        }
    }

    @MOChangeProcessor(moClass=RbAuConfigEntry.class)
    public void processRbAuConfigEntryChange(String instanceID, RbAuConfigEntry auInstance) {
        logger.debug((Object)("[" + this.bsEq.getEUID() + "] Processing AU: " + instanceID));
        if (auInstance == null) {
            logger.error((Object)("[" + this.bsEq.getEUID() + "] Null AU instance " + instanceID));
            return;
        }
        RbAU managedAU = ((RbBS)this.bsEq).findAuBySlotNumber(Integer.parseInt(instanceID));
        if (auInstance.isConnected()) {
            String serialNumber = auInstance.getRbAuSerialNo();
            logger.debug((Object)("[" + this.bsEq.getEUID() + "] AU is connected " + serialNumber));
            if (managedAU != null) {
                if (!serialNumber.equals(managedAU.getSerialNumber())) {
                    this.auHelper.disconnectAU(managedAU);
                    this.ddCallback.setEquipmentState(null, (Equipment)managedAU, -1);
                    managedAU = null;
                } else {
                    this.auHelper.updateAU(managedAU, auInstance);
                    this.ddCallback.setEquipmentState(null, (Equipment)managedAU, 0);
                }
            }
            if (managedAU == null) {
                RbAU newAU = this.auHelper.findAU(serialNumber);
                if (newAU == null) {
                    newAU = this.auHelper.createAU(auInstance);
                    ManagedEntityBase.persist((Session)Datastore.session(), (ManagedEntityBase)newAU);
                    this.auHelper.updateAU(newAU, auInstance);
                    this.auHelper.connectAU(newAU, auInstance.getRbSlotNumber());
                    this.ddCallback.equipmentCreate(null, (Equipment)newAU);
                    this.ddCallback.setEquipmentState(null, (Equipment)newAU, 0);
                } else {
                    this.auHelper.connectAU(newAU, auInstance.getRbSlotNumber());
                    this.auHelper.updateAU(newAU, auInstance);
                    this.ddCallback.setEquipmentState(null, (Equipment)newAU, 0);
                }
                managedAU = newAU;
            }
            HashMap<EquipmentNotifyerEventTypes, Object> equipmentProperties = new HashMap<EquipmentNotifyerEventTypes, Object>();
            equipmentProperties.put(EquipmentNotifyerEventTypes.TREE_LABEL_CHANGED, new TreeChangingLabel(new String[]{"AU." + instanceID}, RbConfigSectionFactory.getAuLabel(auInstance, managedAU.getSlotNumber())));
            HashMap<Integer, String> treeChangingProperties = new HashMap<Integer, String>();
            treeChangingProperties.put(-auInstance.getRbSlotNumber().intValue(), auInstance.getRuningSwVersion());
            equipmentProperties.put(EquipmentNotifyerEventTypes.TREE_STRUCTURE_CHANGED, treeChangingProperties);
            this.notifyClient(equipmentProperties);
        } else {
            if (managedAU != null) {
                this.ddCallback.setEquipmentState(null, (Equipment)managedAU, -1);
            }
            try {
                HashMap<EquipmentNotifyerEventTypes, Object> equipmentProperties = new HashMap<EquipmentNotifyerEventTypes, Object>();
                TreeChangingLabel treeChangingLabel = new TreeChangingLabel(new String[]{"AU." + instanceID}, RbConfigSectionFactory.getAuLabel(null, Integer.parseInt(instanceID)));
                equipmentProperties.put(EquipmentNotifyerEventTypes.TREE_LABEL_CHANGED, treeChangingLabel);
                this.notifyClient(equipmentProperties);
            }
            catch (NumberFormatException nfe) {
                logger.debug((Object)("Can't send meesage for refresh tree node AU " + instanceID));
            }
        }
        if (managedAU != null) {
            Datastore.session().saveOrUpdate((Object)managedAU);
        }
    }

    @Override
    public void processAgentEventInternal(SNMPTrapV1AgentEvent snmpTrap, RbSNMPTrapV1 rbTrap) throws MediationException {
        this.trapProcessor.processAgentEvent(snmpTrap, rbTrap);
    }

    @Override
    public void signalBaseStationDelete() {
        Session session = Datastore.session();
        this.disconnectAllSUs(null);
        List<RbAU> aus = ((RbBS)this.bsEq).getManagedAUs();
        for (RbAU au : aus) {
            this.ddCallback.equipmentRemove(null, (Equipment)au);
            session.delete((Object)au);
        }
        List<RbNPU> npus = ((RbBS)this.bsEq).getManagedNPUs();
        for (RbNPU npu : npus) {
            this.ddCallback.equipmentRemove(null, (Equipment)npu);
            session.delete((Object)npu);
        }
        this.disconnectAllServices();
        RbEntityEvents.clearBsTrapSendingInfo(this.bsEq);
    }

    void disconnectAllAUs(Event cause) {
        List<RbAU> aus = ((RbBS)this.bsEq).getManagedAUs();
        for (RbAU au : new ArrayList<RbAU>(aus)) {
            this.auHelper.disconnectAU(au);
            this.ddCallback.setEquipmentState(cause, (Equipment)au, -1);
        }
    }

    void disconnectAllNPUs(Event cause) {
        List<RbNPU> npus = ((RbBS)this.bsEq).getManagedNPUs();
        for (RbNPU npu : new ArrayList<RbNPU>(npus)) {
            this.npuHelper.disconnectNPU(npu);
            this.ddCallback.setEquipmentState(cause, (Equipment)npu, -1);
        }
    }

    @Override
    public void disconnectAllEquipment(Event cause) {
        this.disconnectAllSUs(cause);
        this.disconnectAllAUs(cause);
        this.disconnectAllNPUs(cause);
    }

    @Override
    protected boolean isValidSysObjectID(String sysObjectID) {
        return "1.3.6.1.4.1.12394.1.2".equals(sysObjectID) || "1.3.6.1.4.1.12394.1.6".equals(sysObjectID);
    }

    @Override
    protected void createBackupSuSyncFile() throws MediationException {
        this.sendCommand(7);
    }

    @Override
    protected void createBackupFile() throws MediationException {
        this.sendCommand(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendCommand(int cmdValue) throws MediationException {
        MOAccessSession snmpAccess = null;
        try {
            snmpAccess = this.createMOAccessSessionForConfigFileCreation();
            RbBSCreateBackupFileCommand command = new RbBSCreateBackupFileCommand();
            command.setRbSlotNumber(5);
            command.setRbNpuCreateBackupConfigFile(cmdValue);
            snmpAccess.commitObject(null, (Object)command);
        }
        finally {
            this.closeMOAccessSession(snmpAccess);
        }
    }

    @Override
    protected void syncStepRetrieveVersionInformationImpl(MOAccessSession access) throws MediationException {
        RbNpuConfigEntry config = (RbNpuConfigEntry)((Object)access.fetchObject(null, RbNpuConfigEntry.class, new String[]{"rbNpuOperSwVersion", "rbNpuShadowSwVersion", "rbNpuRunningSoftware"}, "5").get(0));
        this.bsEq.setOperationalSoftwareVersion(config.getRbNpuOperSwVersion());
        this.bsEq.setShadowSoftwareVersion(config.getRbNpuShadowSwVersion());
        this.bsEq.setRunningSoftwareVersion(config.getRuningSwVersion());
        if (new DefaultVersion("4.1.1").compareTo(this.bsEq.getSoftwareVersion()) < 0) {
            RbBSSwitchingModeParameters provisioning = (RbBSSwitchingModeParameters)((Object)access.fetchObject(null, RbBSSwitchingModeParameters.class, new String[]{"rbCrtServiceSwitchingMode"}, "5").get(0));
            this.bsEq.setSwitchingMode(provisioning.getRbCrtServiceSwitchingMode());
        } else {
            this.bsEq.setSwitchingMode(null);
        }
        RbIfInfoEntry ifInfo = (RbIfInfoEntry)((Object)access.fetchObject(null, RbIfInfoEntry.class, new String[]{"ifPhysAddress"}, "2").get(0));
        this.bsEq.setMngmntIfMAC(ifInfo.getIfPhysAddress());
        if (RbVersions.V_3_5.isOlderOrEqualWith(this.bsEq.getSoftwareVersion()) && RbVersions.V_4_0.isNewerThan(this.bsEq.getSoftwareVersion())) {
            this.setRbBaseStationTime(access);
        }
    }

    @Override
    protected Map<Class<? extends ManagedObject>, Method> getMOChangeProcessors() {
        return moChangeProcessors;
    }

    @Override
    protected void restoreStateImpl() {
        this.reprocessMOs("BS", RbAuConfigEntry.class);
        this.reprocessMOs("BS", RbNpuConfigEntry.class);
        this.reprocessMOs("BS", RbBSSwitchingModeParameters.class);
        super.restoreStateImpl();
    }
}

