/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.ddi;

import com.bwanms.ddi.DDCallbackInterface;
import com.bwanms.mediation.MOAccessSession;
import com.bwanms.mediation.MediationException;
import com.bwanms.meta.mo.MOChangeProcessor;
import com.bwanms.meta.mo.MOChangeProcessorUtil;
import com.bwanms.mo.ManagedObject;
import com.bwanms.model.Equipment;
import com.bwanms.model.ManagedEntityBase;
import com.bwanms.persistence.Datastore;
import com.bwanms.rb.ddi.RbAuSynchronizationHelper;
import com.bwanms.rb.ddi.RbBaseStationSynchStrategyLocal;
import com.bwanms.rb.ddi.RbNpuSynchronizationHelper;
import com.bwanms.rb.mo.RbAuConfigEntry;
import com.bwanms.rb.mo.RbBSSwitchingModeParameters;
import com.bwanms.rb.mo.RbIfInfoEntry;
import com.bwanms.rb.mo.RbNpuConfigEntry;
import com.bwanms.rb.mo.RbSlotConfigEntry;
import com.bwanms.rb.model.RbAU;
import com.bwanms.rb.model.RbBS;
import com.bwanms.rb.model.RbNPU;
import com.bwanms.util.version.impl.DefaultVersion;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.hibernate.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbBSSynchStrategyLocal
extends RbBaseStationSynchStrategyLocal {
    private static final Logger logger = Logger.getLogger(RbBSSynchStrategyLocal.class);
    private static Map<Class<? extends ManagedObject>, Method> moChangeProcessors = MOChangeProcessorUtil.getProcessors(RbBSSynchStrategyLocal.class);
    RbAuSynchronizationHelper auHelper;
    RbNpuSynchronizationHelper npuHelper;

    public RbBSSynchStrategyLocal(RbBS bs, DDCallbackInterface ddCallback) {
        super(bs, ddCallback);
        this.auHelper = new RbAuSynchronizationHelper(bs);
        this.npuHelper = new RbNpuSynchronizationHelper(bs);
    }

    @MOChangeProcessor(moClass=RbNpuConfigEntry.class)
    public void processRbNpuConfigEntryChange(String instanceID, RbNpuConfigEntry npuInstance) {
        logger.debug((Object)("[" + this.bsEq.getEUID() + "] Processing NPU: " + instanceID));
        if (npuInstance == null) {
            logger.error((Object)("Null NPU instance " + instanceID));
            return;
        }
        RbNPU managedNPU = ((RbBS)this.bsEq).findNpuBySlotNumber(Integer.parseInt(instanceID));
        if (npuInstance.isConnected()) {
            if (npuInstance.isActive()) {
                ((RbBS)this.bsEq).setOperationalSoftwareVersion(npuInstance.getRbNpuOperSwVersion());
                ((RbBS)this.bsEq).setShadowSoftwareVersion(npuInstance.getRbNpuShadowSwVersion());
                ((RbBS)this.bsEq).setRunningSoftwareVersion(npuInstance.getRuningSwVersion());
                ((RbBS)this.bsEq).setHardwareRevision(npuInstance.getRbNpuHwRevision());
                ((RbBS)this.bsEq).setSerialNumber(npuInstance.getRbNpuSerialNo());
            }
            String serialNumber = npuInstance.getRbNpuSerialNo();
            logger.debug((Object)("[" + this.bsEq.getEUID() + "] NPU is connected " + serialNumber));
            if (managedNPU != null) {
                if (!serialNumber.equals(managedNPU.getSerialNumber())) {
                    this.npuHelper.disconnectNPU(managedNPU);
                    this.ddCallback.setEquipmentState(null, (Equipment)managedNPU, -1);
                    managedNPU = null;
                } else {
                    this.npuHelper.updateNPU(managedNPU, npuInstance);
                    this.ddCallback.setEquipmentState(null, (Equipment)managedNPU, 0);
                }
            }
            if (managedNPU == null) {
                RbNPU newNPU = this.npuHelper.findNPU(serialNumber);
                if (newNPU == null) {
                    newNPU = this.npuHelper.createNPU(npuInstance);
                    ManagedEntityBase.persist((Session)Datastore.session(), (ManagedEntityBase)newNPU);
                    this.npuHelper.updateNPU(newNPU, npuInstance);
                    this.npuHelper.connectNPU(newNPU, npuInstance.getRbSlotNumber());
                    this.ddCallback.equipmentCreate(null, (Equipment)newNPU);
                    this.ddCallback.setEquipmentState(null, (Equipment)newNPU, 0);
                } else {
                    this.npuHelper.connectNPU(newNPU, npuInstance.getRbSlotNumber());
                    this.ddCallback.setEquipmentState(null, (Equipment)newNPU, 0);
                }
                managedNPU = newNPU;
            }
        } else if (managedNPU != null) {
            this.npuHelper.disconnectNPU(managedNPU);
            this.ddCallback.setEquipmentState(null, (Equipment)managedNPU, -1);
        }
        if (managedNPU != null) {
            Datastore.session().saveOrUpdate((Object)managedNPU);
        }
    }

    public void disconnectAU(int slotNumber) {
        RbAU au = ((RbBS)this.bsEq).findAuBySlotNumber(slotNumber);
        if (au != null) {
            this.auHelper.disconnectAU(au);
            this.ddCallback.setEquipmentState(null, (Equipment)au, -1);
        }
    }

    @MOChangeProcessor(moClass=RbAuConfigEntry.class)
    public void processRbAuConfigEntryChange(String instanceID, RbAuConfigEntry auInstance) {
        logger.debug((Object)("[" + this.bsEq.getEUID() + "] Processing AU: " + instanceID));
        if (auInstance == null) {
            logger.error((Object)("[" + this.bsEq.getEUID() + "] Null AU instance " + instanceID));
            return;
        }
        RbAU managedAU = ((RbBS)this.bsEq).findAuBySlotNumber(Integer.parseInt(instanceID));
        if (auInstance.isConnected()) {
            String serialNumber = auInstance.getRbAuSerialNo();
            logger.debug((Object)("[" + this.bsEq.getEUID() + "] AU is connected " + serialNumber));
            if (managedAU != null) {
                if (!serialNumber.equals(managedAU.getSerialNumber())) {
                    this.auHelper.disconnectAU(managedAU);
                    this.ddCallback.setEquipmentState(null, (Equipment)managedAU, -1);
                    managedAU = null;
                } else {
                    this.auHelper.updateAU(managedAU, auInstance);
                    this.ddCallback.setEquipmentState(null, (Equipment)managedAU, 0);
                }
            }
            if (managedAU == null) {
                RbAU newAU = this.auHelper.findAU(serialNumber);
                if (newAU == null) {
                    newAU = this.auHelper.createAU(auInstance);
                    ManagedEntityBase.persist((Session)Datastore.session(), (ManagedEntityBase)newAU);
                    this.auHelper.updateAU(newAU, auInstance);
                    this.auHelper.connectAU(newAU, auInstance.getRbSlotNumber());
                    this.ddCallback.equipmentCreate(null, (Equipment)newAU);
                    this.ddCallback.setEquipmentState(null, (Equipment)newAU, 0);
                } else {
                    this.auHelper.connectAU(newAU, auInstance.getRbSlotNumber());
                    this.auHelper.updateAU(newAU, auInstance);
                    this.ddCallback.setEquipmentState(null, (Equipment)newAU, 0);
                }
                managedAU = newAU;
            }
        } else if (managedAU != null) {
            this.auHelper.disconnectAU(managedAU);
            this.ddCallback.setEquipmentState(null, (Equipment)managedAU, -1);
        }
        if (managedAU != null) {
            Datastore.session().saveOrUpdate((Object)managedAU);
        }
    }

    @Override
    protected boolean isValidSysObjectID(String sysObjectID) {
        return "1.3.6.1.4.1.12394.1.2".equals(sysObjectID) || "1.3.6.1.4.1.12394.1.6".equals(sysObjectID);
    }

    @Override
    protected void syncStepRetrieveVersionInformationImpl(MOAccessSession access) throws MediationException {
        RbNpuConfigEntry config = (RbNpuConfigEntry)((Object)access.fetchObject(null, RbNpuConfigEntry.class, new String[]{"rbNpuOperSwVersion", "rbNpuShadowSwVersion", "rbNpuRunningSoftware", "rbNpuSerialNo"}, "5").get(0));
        this.bsEq.setOperationalSoftwareVersion(config.getRbNpuOperSwVersion());
        this.bsEq.setShadowSoftwareVersion(config.getRbNpuShadowSwVersion());
        this.bsEq.setRunningSoftwareVersion(config.getRuningSwVersion());
        this.bsEq.setSerialNumber(config.getRbNpuSerialNo());
        if (new DefaultVersion("4.1.1").compareTo(this.bsEq.getSoftwareVersion()) < 0) {
            RbBSSwitchingModeParameters provisioning = (RbBSSwitchingModeParameters)((Object)access.fetchObject(null, RbBSSwitchingModeParameters.class, new String[]{"rbCrtServiceSwitchingMode"}, "5").get(0));
            this.bsEq.setSwitchingMode(provisioning.getRbCrtServiceSwitchingMode());
        } else {
            this.bsEq.setSwitchingMode(null);
        }
        RbIfInfoEntry ifInfo = (RbIfInfoEntry)((Object)access.fetchObject(null, RbIfInfoEntry.class, new String[]{"ifPhysAddress"}, "2").get(0));
        this.bsEq.setMngmntIfMAC(ifInfo.getIfPhysAddress());
    }

    @Override
    protected void signalBaseStationDelete() {
    }

    @Override
    protected Map<Class<? extends ManagedObject>, Method> getMOChangeProcessors() {
        return moChangeProcessors;
    }

    @Override
    protected List<Class<? extends ManagedObject>> getFullConfigManagedObjectClasses() {
        ArrayList<Class<? extends ManagedObject>> moClasses = new ArrayList<Class<? extends ManagedObject>>();
        moClasses.add(RbSlotConfigEntry.class);
        moClasses.add(RbNpuConfigEntry.class);
        moClasses.add(RbAuConfigEntry.class);
        return moClasses;
    }
}

