/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.ddi;

import com.bwanms.persistence.Datastore;
import com.bwanms.rb.mo.RbAuConfigEntry;
import com.bwanms.rb.model.RbAU;
import com.bwanms.rb.model.RbAUEquipmentConfiguration;
import com.bwanms.rb.model.RbBS;
import org.apache.log4j.Logger;
import org.hibernate.Query;

public class RbAuSynchronizationHelper {
    private static final Logger logger = Logger.getLogger(RbAuSynchronizationHelper.class);
    private static final String[] auTypes = new String[]{"UNKNOWN", "AU2CH", "AU4CH", "AU2CH-HP", "AU4CH-HP", "AU-CH-HP-4M"};
    private RbBS bs;

    public RbAuSynchronizationHelper(RbBS bs) {
        this.bs = bs;
    }

    public static String getAuTypeString(Integer auType) {
        if (auType == null) {
            return auTypes[0];
        }
        if (auType > -1 && auType < auTypes.length) {
            return auTypes[auType];
        }
        return auTypes[0];
    }

    RbAU createAU(RbAuConfigEntry auInstance) {
        RbAU au = new RbAU();
        au.setEUID(auInstance.getRbAuSerialNo());
        au.setName("AU " + auInstance.getRbSlotNumber());
        au.setModel(RbAuSynchronizationHelper.getAuTypeString(auInstance.getRbAuIduType()));
        au.setHardwareRevision(auInstance.getRbAuIduHwRevision());
        logger.debug((Object)("Created AU: " + (Object)((Object)au)));
        RbAUEquipmentConfiguration config = new RbAUEquipmentConfiguration();
        config.setEquipment(au);
        au.setCurrentConfiguration(config);
        config.createPrimaryNetworkResource();
        return au;
    }

    void connectAU(RbAU au, int slotNumber) {
        if (au.getManagerBS() != null) {
            RbBS managerBS = au.getManagerBS();
            managerBS.getManagedAUs().remove((Object)au);
        }
        au.setManagerBS(this.bs, slotNumber);
        au.setLocation(this.bs.getLocation());
        au.setIpAddr(this.bs.getIpAddr());
    }

    void disconnectAU(RbAU managedAU) {
        managedAU.setManagerBS(null, 0);
        managedAU.setIpAddr(null);
    }

    RbAU findAU(String auSerialNo) {
        Query query = Datastore.session().createQuery("from " + RbAU.class.getName() + " where EUID = :euid");
        query.setString("euid", auSerialNo);
        RbAU au = (RbAU)((Object)query.uniqueResult());
        return au;
    }

    void updateAU(RbAU au, RbAuConfigEntry auInstance) {
        au.setModel(RbAuSynchronizationHelper.getAuTypeString(auInstance.getRbAuIduType()));
        au.setFaultStatus(auInstance.getRbAuFaultStatus());
        au.setSerialNumber(auInstance.getRbAuSerialNo());
        au.setRunningSoftwareVersion(auInstance.getRuningSwVersion());
        au.setShadowSoftwareVersion(auInstance.getRbAuShadowSwVersion());
        au.setOperationalSoftwareVersion(auInstance.getRbAuOperSwVersion());
        au.setHardwareRevision(auInstance.getRbAuIduHwRevision());
    }
}

