/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.ddi;

import com.bwanms.ddi.ConfigurationChangedEvent;
import com.bwanms.ddi.ConfigurationNotSynchronizedException;
import com.bwanms.ddi.DDCallbackInterface;
import com.bwanms.ddi.EquipmentSynchronizationStrategy;
import com.bwanms.domain.logic.ConfigurationHelper;
import com.bwanms.domain.logic.Helpers;
import com.bwanms.mediation.CommunicationException;
import com.bwanms.mediation.MediationException;
import com.bwanms.mo.EquipmentConfiguration;
import com.bwanms.mo.NetworkResourceConfiguration;
import com.bwanms.model.AgentEvent;
import com.bwanms.model.Equipment;
import com.bwanms.model.fault.Event;
import com.bwanms.rb.model.RbAU;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbAUSynchronizationStrategy
implements EquipmentSynchronizationStrategy {
    private static final Logger logger = Logger.getLogger(RbAUSynchronizationStrategy.class);
    private RbAU au;
    private DDCallbackInterface ddCallback;

    public RbAUSynchronizationStrategy(RbAU au, DDCallbackInterface observer) {
        this.au = au;
        this.ddCallback = observer;
    }

    public void synchronizeState() {
    }

    public List<ConfigurationChangedEvent> configurationChanged(ConfigurationChangedEvent changes) throws ConfigurationNotSynchronizedException {
        return null;
    }

    public void downloadConfiguration() throws MediationException {
        long startTime = System.currentTimeMillis();
        ConfigurationHelper configHelper = Helpers.getConfigurationHelper();
        EquipmentConfiguration currentConfig = this.au.findCurrentConfiguration();
        NetworkResourceConfiguration primaryNRConfig = currentConfig.findPrimaryNetworkResourceConfiguration();
        try {
            configHelper.retrieveCurrentConfiguration(this.au.getId(), primaryNRConfig.getName(), primaryNRConfig.getManagedObjectClasses(), true);
        }
        catch (CommunicationException e) {
            this.ddCallback.communicationError((Equipment)this.au);
            throw e;
        }
        logger.debug((Object)("DownloadConfiguration RbBS: " + (System.currentTimeMillis() - startTime) + " millis"));
    }

    public void setUnreachable(Event generatedBy) {
    }

    public boolean emitNmsEvent(AgentEvent agentEvent) {
        return false;
    }

    public void processAgentEvent(AgentEvent agentEvent) {
    }
}

