/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.configuration.info;

import com.bwanms.ddi.EquipmentConfigSectionFactory;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.configuration.ConfigSection;
import com.bwanms.gui.configuration.ConfigSectionView;
import com.bwanms.gui.configuration.ConfigSectionViewFactory;
import com.bwanms.gui.configuration.DefaultEMSSection;
import com.bwanms.gui.configuration.FormsConfigSectionView;
import com.bwanms.gui.configuration.ManagedObjectsAccessSupport;
import com.bwanms.gui.configuration.ManagedObjectsAccessSupportCallback;
import com.bwanms.gui.configuration.ManagedObjectsConfigForm;
import com.bwanms.gui.configuration.UnifiedFormsConfigSectionView;
import com.bwanms.gui.configuration.UnifiedMOsAccessSupport;
import com.bwanms.gui.configuration.UnifiedMOsConfigForm;
import com.bwanms.gui.configuration.pm.PerformanceMonitoringSectionView;
import com.bwanms.mo.EquipmentConfiguration;
import com.bwanms.mo.ManagedObject;
import com.bwanms.model.Equipment;
import com.bwanms.rb.configuration.errors.RbEquipmentAgentException;
import com.bwanms.rb.ddi.RbAuSynchronizationHelper;
import com.bwanms.rb.gui.configuration.GPSConfigForm;
import com.bwanms.rb.gui.configuration.GPSConfigForm42;
import com.bwanms.rb.gui.configuration.MbstSubscriberUnitsConfigFormTDD;
import com.bwanms.rb.gui.configuration.RbConfigBackupConfigForm;
import com.bwanms.rb.gui.configuration.RbFrequencyBandsUploadConfigForm;
import com.bwanms.rb.gui.configuration.RbLicenseUploadConfigForm;
import com.bwanms.rb.gui.configuration.SwMBSUpgradeSettingsConfigForm;
import com.bwanms.rb.gui.configuration.pm.FilteringPMView;
import com.bwanms.rb.gui.configuration.pm.MbstPerformanceMonitoringView;
import com.bwanms.rb.gui.configuration.pm.NpuPerformanceMonitoringView;
import com.bwanms.rb.gui.configuration.pm.SuPerformanceMonitoringView;
import com.bwanms.rb.mo.RbAuConfigEntry;
import com.bwanms.rb.mo.RbNpuConfigEntry;
import com.bwanms.rb.model.RbBS;
import com.bwanms.rb.model.RbBSNRConfiguration;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.model.RbMBS;
import com.bwanms.rb.model.RbSU;
import com.bwanms.rb.util.RbFeatures;
import com.bwanms.rb.util.RbVersions;
import com.bwanms.util.MessageBox;
import com.bwanms.util.PlatformConfiguration;
import com.bwanms.util.version.Version;
import com.bwanms.util.version.VersionFactory;
import java.awt.Component;
import java.util.List;
import org.apache.log4j.Logger;

public class RbConfigSectionFactory
implements EquipmentConfigSectionFactory {
    private static final Logger logger = Logger.getLogger(RbConfigSectionFactory.class);
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(RbConfigSectionFactory.class);
    private static final boolean localPlatform = PlatformConfiguration.isLocalPlatform();

    public ConfigSection createRbBSEquipmentConfigSection(final RbBS bs) {
        int slotNumber;
        RbConfigSection result = new RbConfigSection(bs, "Chassis", "com.bwanms.rb.gui.configuration.BMAXChasisConfigForm"){

            public String getName() {
                return "BS";
            }

            public String getLabel() {
                if (localPlatform) {
                    return i18n.translateString("RbBSView");
                }
                return i18n.translateString("RbBS", new Object[]{bs.getIPAddress()});
            }
        };
        result.addChildSection((ConfigSection)new RbConfigSection((Equipment)bs, "GeneralParameters", "com.bwanms.rb.gui.configuration.BsGeneralParametersConfigForm"));
        if (bs.getSoftwareVersion().compareTo((Object)RbVersions.V_4_1_1) >= 0) {
            result.addChildSection((ConfigSection)new RbConfigSection((Equipment)bs, "TrapsControl", "com.bwanms.rb.gui.configuration.TrapsControlConfigFormSw411"));
        } else if (bs.getSoftwareVersion().compareTo((Object)VersionFactory.getInstance().createVersion("2.1.1.2")) >= 0) {
            result.addChildSection((ConfigSection)new RbConfigSection((Equipment)bs, "TrapsControl", "com.bwanms.rb.gui.configuration.TrapsControlConfigFormSw211"));
        } else if (bs.getSoftwareVersion().compareTo((Object)VersionFactory.getInstance().createVersion("2.0.1.36")) >= 0) {
            result.addChildSection((ConfigSection)new RbConfigSection((Equipment)bs, "TrapsControl", "com.bwanms.rb.gui.configuration.TrapsControlConfigForm21"));
        } else {
            result.addChildSection((ConfigSection)new RbConfigSection((Equipment)bs, "TrapsControl", "com.bwanms.rb.gui.configuration.TrapsControlConfigForm"));
        }
        if (bs.getSoftwareVersion().isNewerOrEqualWith(RbVersions.V_4_0)) {
            result.addChildSection((ConfigSection)new RbConfigSection((Equipment)bs, "RadiusClient", "com.bwanms.rb.gui.configuration.RadiusClientConfigForm"));
            result.addChildSection((ConfigSection)new RbPerformanceConfigSection(bs, "RadiusPerformance", "com.bwanms.rb.gui.configuration.pm.RadiusPerformanceMonitoringView"));
            if (bs.getSoftwareVersion().isNewerOrEqualWith(RbVersions.V_4_2)) {
                result.addChildSection((ConfigSection)new RbConfigSection((Equipment)bs, "GPS", GPSConfigForm42.class.getName()));
            } else {
                result.addChildSection((ConfigSection)new RbConfigSection((Equipment)bs, "GPS", GPSConfigForm.class.getName()));
            }
            if (RbFeatures.isServiceGroupAvailable(bs)) {
                result.addChildSection((ConfigSection)new RbConfigSection((Equipment)bs, "PFParameters", "com.bwanms.rb.gui.configuration.PFParametersConfigForm"));
                result.addChildSection((ConfigSection)new RbConfigSection((Equipment)bs, "PFPerformance", "com.bwanms.rb.gui.configuration.pm.PFPerformanceMonitoringView"));
            }
            result.addChildSection((ConfigSection)new RbConfigSection((Equipment)bs, "RadioParameters", "com.bwanms.rb.gui.configuration.BsRadioParametersConfigFormTDD"));
            if (!localPlatform) {
                result.addChildSection((ConfigSection)new RbConfigSection((Equipment)bs, "SoftwareUpgradeSettings", "com.bwanms.rb.gui.configuration.SwUpgradeSettingsConfigForm"));
            }
        } else {
            result.addChildSection((ConfigSection)new RbConfigSection((Equipment)bs, "RadioParameters", "com.bwanms.rb.gui.configuration.BsRadioParametersConfigForm"));
        }
        result.addChildSection((ConfigSection)new RbConfigSection((Equipment)bs, "RadioClusters", "com.bwanms.rb.gui.configuration.BSRadioClustersConfigForm"));
        result.addChildSection((ConfigSection)new RbConfigSection((Equipment)bs, "OutdoorUnits", "com.bwanms.rb.gui.configuration.OutdoorUnitsConfigForm"));
        result.addChildSection((ConfigSection)new RbConfigSection((Equipment)bs, "DefaultParameters", "com.bwanms.rb.gui.configuration.BsDefaultsConfigForm"));
        if (bs.getSwitchingMode() == RbBaseStationEquipment.SWITCHING_MODE_ETHERNET_CS) {
            result.addChildSection((ConfigSection)this.createFilteringSectionInfo(bs));
        }
        if (bs.getSoftwareVersion().isNewerOrEqualWith(RbVersions.V_4_0)) {
            result.addChildSection((ConfigSection)new RbConfigSection((Equipment)bs, "SubscriberUnits", "com.bwanms.rb.gui.configuration.SubscriberUnitsConfigFormTDD"));
        } else {
            result.addChildSection((ConfigSection)new RbConfigSection((Equipment)bs, "SubscriberUnits", "com.bwanms.rb.gui.configuration.SubscriberUnitsConfigForm"));
        }
        if (bs.getSoftwareVersion().isNewerOrEqualWith(RbVersions.V_4_5)) {
            result.addChildSection((ConfigSection)new RbPerformanceConfigSection(bs, "SURadioMonitoring", "com.bwanms.rb.gui.configuration.pm.SURadioMonitoringView"));
        }
        result.addChildSection(this.createServicesUnifiedSectionInfo(bs));
        result.addChildSection((ConfigSection)new RbConfigSection((Equipment)bs, "Licenses", "com.bwanms.rb.gui.configuration.BsLicensesConfigForm"));
        if (localPlatform && bs.getSoftwareVersion().isNewerOrEqualWith(RbVersions.V_4_0)) {
            result.addChildSection((ConfigSection)new RbConfigSection((Equipment)bs, "LicenseUpload", RbLicenseUploadConfigForm.class.getName()));
        }
        result.addChildSection(this.createRbNpuSectionInfo(bs));
        for (slotNumber = 1; slotNumber <= 4; ++slotNumber) {
            result.addChildSection(this.createRbAUEquipmentConfigSection(bs, slotNumber));
        }
        for (slotNumber = 7; slotNumber <= 9; ++slotNumber) {
            result.addChildSection(this.createRbAUEquipmentConfigSection(bs, slotNumber));
        }
        if (localPlatform) {
            RbConfigSection result2 = new RbConfigSection(bs, "SoftwareControl");
            result2.addChildSection((ConfigSection)new RbConfigSection((Equipment)bs, "SoftwareUpgrade", "com.bwanms.rb.gui.configuration.SoftwareUpgradeConfigForm"));
            if (bs.getSoftwareVersion().isNewerOrEqualWith(RbVersions.V_4_0)) {
                result2.addChildSection((ConfigSection)new RbConfigSection((Equipment)bs, "SoftwareUpgradeSettings", "com.bwanms.rb.gui.configuration.SwUpgradeSettingsConfigForm"));
            }
            result.addChildSection((ConfigSection)result2);
            if (bs.getSoftwareVersion().isNewerOrEqualWith(RbVersions.V_2_5)) {
                result.addChildSection((ConfigSection)new RbConfigSection((Equipment)bs, "BackupConfiguration", RbConfigBackupConfigForm.class.getName()));
            }
            if (bs.getSoftwareVersion().isNewerOrEqualWith(RbVersions.V_4_1_1)) {
                result.addChildSection((ConfigSection)new RbConfigSection((Equipment)bs, "FrequencyBandsUpload", RbFrequencyBandsUploadConfigForm.class.getName()));
            }
        }
        return result;
    }

    private RbConfigSection createFilteringSectionInfo(RbBS bs) {
        RbConfigSection result = new RbConfigSection(bs, "Filtering");
        result.addChildSection((ConfigSection)new RbConfigSection((Equipment)bs, "Filters", "com.bwanms.rb.gui.configuration.FiltersConfigForm"));
        result.addChildSection((ConfigSection)new RbConfigSection((Equipment)bs, "MACDenyList", "com.bwanms.rb.gui.configuration.MACDenyListConfigForm"));
        result.addChildSection((ConfigSection)new RbPerformanceConfigSection(bs, "Performance", FilteringPMView.class.getName()));
        return result;
    }

    private RbConfigSection createFilteringSectionInfo(RbMBS mbs) {
        RbConfigSection result = new RbConfigSection(mbs, "Filtering");
        result.addChildSection((ConfigSection)new RbConfigSection((Equipment)mbs, "Filters", "com.bwanms.rb.gui.configuration.MbstFiltersConfigForm"));
        result.addChildSection((ConfigSection)new RbConfigSection((Equipment)mbs, "MACDenyList", "com.bwanms.rb.gui.configuration.MACDenyListConfigForm"));
        result.addChildSection((ConfigSection)new RbPerformanceConfigSection(mbs, "Performance", FilteringPMView.class.getName()));
        return result;
    }

    private ConfigSection createServicesSectionInfo(RbBaseStationEquipment bs) {
        RbConfigSection result = new RbConfigSection(bs, "Services");
        result.addChildSection((ConfigSection)new RbConfigSection((Equipment)bs, "Services", "com.bwanms.rb.gui.configuration.services.RbServicesConfigForm"));
        if (bs.getSwitchingMode() == RbBaseStationEquipment.SWITCHING_MODE_ETHERNET_CS) {
            result.addChildSection((ConfigSection)new RbConfigSection((Equipment)bs, "Subscribers", "com.bwanms.rb.gui.configuration.services.RbSubscribersConfigForm"));
        }
        result.addChildSection((ConfigSection)new RbConfigSection((Equipment)bs, "ServiceProfiles", "com.bwanms.rb.gui.configuration.services.RbServiceProfilesConfigForm"));
        result.addChildSection((ConfigSection)new RbConfigSection((Equipment)bs, "ForwardingRules", "com.bwanms.rb.gui.configuration.services.RbForwardingRulesConfigForm"));
        result.addChildSection((ConfigSection)new RbConfigSection((Equipment)bs, "PolicyRules", "com.bwanms.rb.gui.configuration.services.RbPriorityClassifiersConfigForm"));
        result.addChildSection((ConfigSection)new RbConfigSection((Equipment)bs, "QoSProfiles", "com.bwanms.rb.gui.configuration.services.RbQoSProfilesConfigForm"));
        Version bsSWVersion = bs.getSoftwareVersion();
        if (bsSWVersion.isNewerOrEqualWith(RbVersions.V_3_0) && bsSWVersion.isOlderThan(RbVersions.V_4_0)) {
            result.addChildSection((ConfigSection)new RbConfigSection((Equipment)bs, "QinQ", "com.bwanms.rb.gui.configuration.QinQConfigForm"));
        }
        if (RbFeatures.isSipAwareAvailable(bs)) {
            result.addChildSection((ConfigSection)new RbConfigSection((Equipment)bs, "VoiceDomain", "com.bwanms.rb.gui.configuration.services.RbVoiceDomainsConfigForm"));
        }
        return result;
    }

    private ConfigSection createServicesUnifiedSectionInfo(RbBaseStationEquipment bs) {
        RbUnifiedConfigSection result = new RbUnifiedConfigSection(bs, "Services");
        result.addChildSection((ConfigSection)new RbUnifiedConfigSection((Equipment)bs, "Services", "com.bwanms.rb.gui.configuration.services.RbServicesConfigForm"));
        if (bs.getSwitchingMode() == RbBaseStationEquipment.SWITCHING_MODE_ETHERNET_CS) {
            result.addChildSection((ConfigSection)new RbUnifiedConfigSection((Equipment)bs, "Subscribers", "com.bwanms.rb.gui.configuration.services.RbSubscribersConfigForm"));
        }
        result.addChildSection((ConfigSection)new RbUnifiedConfigSection((Equipment)bs, "ServiceProfiles", "com.bwanms.rb.gui.configuration.services.RbServiceProfilesConfigForm"));
        result.addChildSection((ConfigSection)new RbUnifiedConfigSection((Equipment)bs, "ForwardingRules", "com.bwanms.rb.gui.configuration.services.RbForwardingRulesConfigForm"));
        result.addChildSection((ConfigSection)new RbUnifiedConfigSection((Equipment)bs, "PolicyRules", "com.bwanms.rb.gui.configuration.services.RbPriorityClassifiersConfigForm"));
        result.addChildSection((ConfigSection)new RbUnifiedConfigSection((Equipment)bs, "QoSProfiles", "com.bwanms.rb.gui.configuration.services.RbQoSProfilesConfigForm"));
        Version bsSWVersion = bs.getSoftwareVersion();
        if (bsSWVersion.isNewerOrEqualWith(RbVersions.V_3_0) && bsSWVersion.isOlderThan(RbVersions.V_4_0)) {
            result.addChildSection((ConfigSection)new RbUnifiedConfigSection((Equipment)bs, "QinQ", "com.bwanms.rb.gui.configuration.QinQConfigForm"));
        }
        if (RbFeatures.isSipAwareAvailable(bs)) {
            result.addChildSection((ConfigSection)new RbUnifiedConfigSection((Equipment)bs, "VoiceDomain", "com.bwanms.rb.gui.configuration.services.RbVoiceDomainsConfigForm"));
        }
        if (RbFeatures.isServiceGroupAvailable(bs)) {
            result.addChildSection((ConfigSection)new RbUnifiedConfigSection((Equipment)bs, "ServiceGroup", "com.bwanms.rb.gui.configuration.services.RbServiceGroupConfigForm"));
        }
        if (RbVersions.V_3_6.isSupersetOf(bs.getSoftwareVersion())) {
            result.addChildSection((ConfigSection)new RbConfigSection((Equipment)bs, "DefaultServiceGroup", "com.bwanms.rb.gui.configuration.services.RbFDDDefaultServiceGroupConfigForm"));
        }
        return result;
    }

    private ConfigSection createRbMBSEquipmentConfigSection(final RbMBS mbs) {
        RbConfigSection result = new RbConfigSection(mbs, "Chassis", "com.bwanms.rb.gui.configuration.MBSChasisConfigForm"){

            public String getName() {
                return "MBS";
            }

            public String getLabel() {
                if (localPlatform) {
                    return i18n.translateString("RbMBSView");
                }
                return i18n.translateString("RbMBS", new Object[]{mbs.getIPAddress()});
            }
        };
        result.addChildSection((ConfigSection)new RbConfigSection((Equipment)mbs, "GeneralDetails", "com.bwanms.rb.gui.configuration.MbstGeneralDetailsConfigForm"));
        result.addChildSection((ConfigSection)new RbConfigSection((Equipment)mbs, "GeneralParameters", "com.bwanms.rb.gui.configuration.BsGeneralParametersConfigForm"));
        if (mbs.getSoftwareVersion().compareTo((Object)RbVersions.V_4_1_1) >= 0) {
            result.addChildSection((ConfigSection)new RbConfigSection((Equipment)mbs, "TrapsControl", "com.bwanms.rb.gui.configuration.TrapsControlConfigFormSw411"));
        } else if (mbs.getSoftwareVersion().compareTo((Object)VersionFactory.getInstance().createVersion("2.1.1.2")) >= 0) {
            result.addChildSection((ConfigSection)new RbConfigSection((Equipment)mbs, "TrapsControl", "com.bwanms.rb.gui.configuration.TrapsControlConfigFormSw211"));
        } else if (mbs.getSoftwareVersion().compareTo((Object)VersionFactory.getInstance().createVersion("2.0.1.36")) >= 0) {
            result.addChildSection((ConfigSection)new RbConfigSection((Equipment)mbs, "TrapsControl", "com.bwanms.rb.gui.configuration.TrapsControlConfigForm21"));
        } else {
            result.addChildSection((ConfigSection)new RbConfigSection((Equipment)mbs, "TrapsControl", "com.bwanms.rb.gui.configuration.TrapsControlConfigForm"));
        }
        if (mbs.getSoftwareVersion().isNewerOrEqualWith(RbVersions.V_4_0)) {
            result.addChildSection((ConfigSection)new RbConfigSection((Equipment)mbs, "RadiusClient", "com.bwanms.rb.gui.configuration.RadiusClientConfigForm"));
            result.addChildSection((ConfigSection)new RbPerformanceConfigSection(mbs, "RadiusPerformance", "com.bwanms.rb.gui.configuration.pm.RadiusPerformanceMonitoringView"));
            if (mbs.getSoftwareVersion().isNewerOrEqualWith(RbVersions.V_4_2)) {
                result.addChildSection((ConfigSection)new RbConfigSection((Equipment)mbs, "GPS", GPSConfigForm42.class.getName()));
            } else {
                result.addChildSection((ConfigSection)new RbConfigSection((Equipment)mbs, "GPS", GPSConfigForm.class.getName()));
            }
            if (!localPlatform) {
                result.addChildSection((ConfigSection)new RbConfigSection((Equipment)mbs, "SoftwareUpgradeSettings", SwMBSUpgradeSettingsConfigForm.class.getName()));
            }
        }
        if (mbs.getSoftwareVersion().isNewerOrEqualWith(RbVersions.V_4_2)) {
            if (RbFeatures.isSipAwareAvailable(mbs)) {
                result.addChildSection((ConfigSection)new RbConfigSection((Equipment)mbs, "PFParameters", "com.bwanms.rb.gui.configuration.PFParametersConfigForm"));
                result.addChildSection((ConfigSection)new RbConfigSection((Equipment)mbs, "PFPerformance", "com.bwanms.rb.gui.configuration.pm.PFPerformanceMonitoringView"));
            }
            result.addChildSection((ConfigSection)new RbConfigSection((Equipment)mbs, "RadioParameters", "com.bwanms.rb.gui.configuration.BsRadioParametersConfigFormTDD"));
        } else {
            result.addChildSection((ConfigSection)new RbConfigSection((Equipment)mbs, "RadioParameters", "com.bwanms.rb.gui.configuration.BsRadioParametersConfigForm"));
        }
        result.addChildSection((ConfigSection)new RbConfigSection((Equipment)mbs, "RadioClusters", "com.bwanms.rb.gui.configuration.MBSRadioClustersConfigForm"));
        result.addChildSection((ConfigSection)new RbConfigSection((Equipment)mbs, "OutdoorUnits", "com.bwanms.rb.gui.configuration.MbstOutdoorUnitsConfigForm"));
        result.addChildSection((ConfigSection)new RbConfigSection((Equipment)mbs, "DefaultParameters", "com.bwanms.rb.gui.configuration.BsDefaultsConfigForm"));
        result.addChildSection((ConfigSection)this.createFilteringSectionInfo(mbs));
        if (mbs.getSoftwareVersion().compareTo((Object)RbVersions.V_4_2) >= 0) {
            result.addChildSection((ConfigSection)new RbConfigSection((Equipment)mbs, "SubscriberUnits", MbstSubscriberUnitsConfigFormTDD.class.getName()));
        } else {
            result.addChildSection((ConfigSection)new RbConfigSection((Equipment)mbs, "SubscriberUnits", "com.bwanms.rb.gui.configuration.MbstSubscriberUnitsConfigForm"));
        }
        result.addChildSection(this.createServicesUnifiedSectionInfo(mbs));
        RbConfigSection access = new RbConfigSection(mbs, "AccessParameters");
        result.addChildSection((ConfigSection)access);
        if (mbs.getSoftwareVersion().compareTo((Object)RbVersions.V_4_0) >= 0) {
            access.addChildSection((ConfigSection)new RbConfigSection((Equipment)mbs, "AirInterface", "com.bwanms.rb.gui.configuration.MbstAirIFConfigFormTDD"));
            access.addChildSection((ConfigSection)new RbConfigSection((Equipment)mbs, "Channels", "com.bwanms.rb.gui.configuration.MBSChannelConfigForm41"));
        } else {
            access.addChildSection((ConfigSection)new RbConfigSection((Equipment)mbs, "AirInterface", "com.bwanms.rb.gui.configuration.MbstAirIFConfigForm"));
            if (mbs.getSoftwareVersion().compareTo((Object)RbVersions.V_3_0) >= 0) {
                access.addChildSection((ConfigSection)new RbConfigSection((Equipment)mbs, "Channels", "com.bwanms.rb.gui.configuration.MBSChannelConfigForm"));
            } else {
                access.addChildSection((ConfigSection)new RbConfigSection((Equipment)mbs, "Channels", "com.bwanms.rb.gui.configuration.MBSChannelConfigFormSW25"));
            }
        }
        result.addChildSection((ConfigSection)new RbConfigSection((Equipment)mbs, "DataPort", "com.bwanms.rb.gui.configuration.MbstDataPortConfigForm"));
        result.addChildSection((ConfigSection)new RbConfigSection((Equipment)mbs, "ManagementPort", "com.bwanms.rb.gui.configuration.MbstManagementPortConfigForm"));
        result.addChildSection((ConfigSection)new RbConfigSection((Equipment)mbs, "AuthorizedManagers", "com.bwanms.rb.gui.configuration.AuthorizedManagersConfigForm"));
        result.addChildSection((ConfigSection)new RbConfigSection((Equipment)mbs, "FrequencyBands", "com.bwanms.rb.gui.configuration.MbstFreqBandsConfigForm"));
        result.addChildSection((ConfigSection)new RbConfigSection((Equipment)mbs, "UnitControl", "com.bwanms.rb.gui.configuration.MbsUnitControlConfigForm"));
        if (mbs.getSoftwareVersion().compareTo((Object)VersionFactory.getInstance().createVersion("2.1.1.2")) >= 0) {
            result.addChildSection((ConfigSection)new RbConfigSection((Equipment)mbs, "BridgeAndVoice", "com.bwanms.rb.gui.configuration.MbstBridgeAndVoiceConfigForm21"));
        } else {
            result.addChildSection((ConfigSection)new RbConfigSection((Equipment)mbs, "BridgeAndVoice", "com.bwanms.rb.gui.configuration.MbstBridgeAndVoiceConfigForm"));
        }
        result.addChildSection((ConfigSection)new RbPerformanceConfigSection(mbs, "Performance", MbstPerformanceMonitoringView.class.getName()));
        result.addChildSection((ConfigSection)new RbConfigSection((Equipment)mbs, "Licenses", "com.bwanms.rb.gui.configuration.BsLicensesConfigForm"));
        if (localPlatform && mbs.getSoftwareVersion().isNewerOrEqualWith(RbVersions.V_4_0)) {
            result.addChildSection((ConfigSection)new RbConfigSection((Equipment)mbs, "LicenseUpload", RbLicenseUploadConfigForm.class.getName()));
        }
        if (localPlatform) {
            RbConfigSection software = new RbConfigSection(mbs, "SoftwareControl");
            software.addChildSection((ConfigSection)new RbConfigSection((Equipment)mbs, "SoftwareUpgrade", "com.bwanms.rb.gui.configuration.SoftwareUpgradeConfigForm"));
            if (mbs.getSoftwareVersion().isNewerOrEqualWith(RbVersions.V_2_5)) {
                result.addChildSection((ConfigSection)new RbConfigSection((Equipment)mbs, "BackupConfiguration", RbConfigBackupConfigForm.class.getName()));
            }
            if (mbs.getSoftwareVersion().isNewerOrEqualWith(RbVersions.V_4_1_1)) {
                result.addChildSection((ConfigSection)new RbConfigSection((Equipment)mbs, "FrequencyBandsUpload", RbFrequencyBandsUploadConfigForm.class.getName()));
                software.addChildSection((ConfigSection)new RbConfigSection((Equipment)mbs, "SoftwareUpgradeSettings", SwMBSUpgradeSettingsConfigForm.class.getName()));
            }
            result.addChildSection((ConfigSection)software);
        }
        return result;
    }

    private ConfigSection createRbNpuSectionInfo(RbBS bs) {
        RbNpuConfigEntry npuEntry = null;
        RbBSNRConfiguration bsNrConfiguration = (RbBSNRConfiguration)bs.findCurrentConfiguration().findNetworkResourceConfiguration("BS");
        List<RbNpuConfigEntry> npuEntries = bsNrConfiguration.getRbNpuConfigEntries();
        if (null != npuEntries && !npuEntries.isEmpty()) {
            npuEntry = npuEntries.get(0);
        }
        RbNpuConfigEntry npu = npuEntry;
        String npuNRName = "BS";
        RbCardConfigSection result = bs.getSoftwareVersion().compareTo((Object)VersionFactory.getInstance().createVersion("2.1.1.2")) >= 0 ? (bs.getSoftwareVersion().compareTo((Object)VersionFactory.getInstance().createVersion("4.0")) >= 0 ? new RbCardConfigSection(bs, "BS", (ManagedObject)npu, "NPU", "com.bwanms.rb.gui.configuration.NpuSummaryConfigForm25") : new RbCardConfigSection(bs, "BS", (ManagedObject)npu, "NPU", "com.bwanms.rb.gui.configuration.NpuSummaryConfigForm21")) : new RbCardConfigSection(bs, "BS", (ManagedObject)npu, "NPU", "com.bwanms.rb.gui.configuration.NpuSummaryConfigForm");
        result.addChildSection((ConfigSection)new RbCardConfigSection(bs, "BS", (ManagedObject)npu, "DataPort", "com.bwanms.rb.gui.configuration.DataPortConfigForm"));
        result.addChildSection((ConfigSection)new RbCardConfigSection(bs, "BS", (ManagedObject)npu, "ManagementPort", "com.bwanms.rb.gui.configuration.ManagementPortConfigForm"));
        result.addChildSection((ConfigSection)new RbCardConfigSection(bs, "BS", (ManagedObject)npu, "AuthorizedManagers", "com.bwanms.rb.gui.configuration.AuthorizedManagersConfigForm"));
        result.addChildSection((ConfigSection)new RbCardConfigSection(bs, "BS", (ManagedObject)npu, "FrequencyBands", "com.bwanms.rb.gui.configuration.NPUFreqBandsConfigForm"));
        result.addChildSection((ConfigSection)new RbCardConfigSection(bs, "BS", (ManagedObject)npu, "UnitControl", "com.bwanms.rb.gui.configuration.NpuUnitControlConfigForm"));
        if (bs.getSoftwareVersion().compareTo((Object)VersionFactory.getInstance().createVersion("2.1.1.2")) >= 0) {
            result.addChildSection((ConfigSection)new RbCardConfigSection(bs, "BS", (ManagedObject)npu, "BridgeAndVoice", "com.bwanms.rb.gui.configuration.NpuBridgeAndVoiceConfigForm"));
        } else {
            result.addChildSection((ConfigSection)new RbCardConfigSection(bs, "BS", (ManagedObject)npu, "Bridge", "com.bwanms.rb.gui.configuration.NpuBridgeConfigForm"));
        }
        result.addChildSection((ConfigSection)new RbPerformanceConfigSection(bs, "BS", (ManagedObject)npu, "Performance", NpuPerformanceMonitoringView.class.getName()));
        return result;
    }

    private ConfigSection createRbAUEquipmentConfigSection(RbBS bs, int slotNumber) {
        RbBSNRConfiguration bsNrConfiguration = (RbBSNRConfiguration)bs.findCurrentConfiguration().findNetworkResourceConfiguration("BS");
        RbAuConfigEntry auEntry = null;
        for (RbAuConfigEntry entry : bsNrConfiguration.getRbAuConfigEntries()) {
            if (entry.getRbSlotNumber() != slotNumber) continue;
            auEntry = entry;
            break;
        }
        RbAuConfigEntry au = auEntry;
        String auNRName = "AU." + slotNumber;
        StringBuffer auSummaryCfgForm = new StringBuffer("com.bwanms.rb.gui.configuration.AUSummaryConfigForm");
        if (bs.getSoftwareVersion().compareTo((Object)VersionFactory.getInstance().createVersion("3.0")) >= 0) {
            auSummaryCfgForm.append("SW30");
        } else if (bs.getSoftwareVersion().compareTo((Object)VersionFactory.getInstance().createVersion("2.1.1.2")) >= 0) {
            auSummaryCfgForm.append("21");
        }
        RbCardConfigSection result = new RbCardConfigSection(bs, auNRName, (ManagedObject)au, "", auSummaryCfgForm.toString()){

            public String getLabel() {
                return this.label;
            }
        };
        result.setName("AU." + slotNumber);
        result.setLabel(RbConfigSectionFactory.getAuLabel(au, slotNumber));
        if (bs.getSwitchingMode() == RbBaseStationEquipment.SWITCHING_MODE_ETHERNET_CS) {
            result.addChildSection((ConfigSection)new RbCardConfigSection(bs, auNRName, (ManagedObject)au, "VoiceParameters", "com.bwanms.rb.gui.configuration.AUGeneralConfigForm"));
        } else if (bs.getSoftwareVersion().compareTo((Object)VersionFactory.getInstance().createVersion("4.5")) >= 0) {
            result.addChildSection((ConfigSection)new RbCardConfigSection(bs, auNRName, (ManagedObject)au, "VoiceParameters", "com.bwanms.rb.gui.configuration.AUGeneralConfigForm"));
        }
        if (bs.getSoftwareVersion().compareTo((Object)RbVersions.V_4_1_1) >= 0) {
            result.addChildSection((ConfigSection)new RbCardConfigSection(bs, auNRName, (ManagedObject)au, "Channels", "com.bwanms.rb.gui.configuration.AUChannelConfigFormSW41"));
        } else if (bs.getSoftwareVersion().compareTo((Object)RbVersions.V_3_0) >= 0) {
            result.addChildSection((ConfigSection)new RbCardConfigSection(bs, auNRName, (ManagedObject)au, "Channels", "com.bwanms.rb.gui.configuration.AUChannelConfigFormSW30"));
        } else {
            result.addChildSection((ConfigSection)new RbCardConfigSection(bs, auNRName, (ManagedObject)au, "Channels", "com.bwanms.rb.gui.configuration.AUChannelConfigForm"));
        }
        if (bs.getSoftwareVersion().compareTo((Object)VersionFactory.getInstance().createVersion("4.0")) >= 0) {
            result.addChildSection((ConfigSection)new RbCardConfigSection(bs, auNRName, (ManagedObject)au, "AirInterface", "com.bwanms.rb.gui.configuration.AUAirIFConfigFormTDD"));
        } else {
            result.addChildSection((ConfigSection)new RbCardConfigSection(bs, auNRName, (ManagedObject)au, "AirInterface", "com.bwanms.rb.gui.configuration.AUAirIFConfigForm"));
        }
        try {
            if (RbVersions.V_4_5.isOlderOrEqualWith(bs.getSoftwareVersion()) && null != au && !au.getRuningSwVersion().equals("") && RbVersions.V_4_5.isOlderOrEqualWith(au.getSoftwareVersion())) {
                result.addChildSection((ConfigSection)new RbPerformanceConfigSection(bs, auNRName, (ManagedObject)au, "SpectrumAnalysis", "com.bwanms.rb.gui.configuration.pm.AUSpectrumAnalysisMonitoringView"));
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        result.addChildSection((ConfigSection)new RbCardConfigSection(bs, auNRName, (ManagedObject)au, "UnitControl", "com.bwanms.rb.gui.configuration.AuUnitControlConfigForm"));
        if (au != null) {
            result.addChildSection((ConfigSection)new RbPerformanceConfigSection(bs, auNRName, (ManagedObject)au, "Performance", "com.bwanms.rb.gui.configuration.pm.AuPerformanceMonitoringView"));
        }
        return result;
    }

    public static String getAuLabel(RbAuConfigEntry au, int slotNumber) {
        if (null != au && au.isConnected()) {
            return i18n.translateString("RbAUConnected", new Object[]{slotNumber, au.getRbAuSerialNo()}) + " " + RbAuSynchronizationHelper.getAuTypeString(au.getRbAuIduType());
        }
        return i18n.translateString("RbAUDisconnected", new Object[]{slotNumber});
    }

    private ConfigSection createRbSUEquipmentConfigSection(RbSU su) {
        final RbBaseStationEquipment bs = su.getManagerBS();
        boolean bsSwUnder41 = bs.getSoftwareVersion().isOlderThan(VersionFactory.getInstance().createVersion("4.1"));
        String cfgFormSuffix = "";
        if (bs.getSoftwareVersion().compareTo((Object)VersionFactory.getInstance().createVersion("4.0")) >= 0) {
            cfgFormSuffix = "Sw25";
        }
        RbSUConfigSection result = new RbSUConfigSection(su, "SUSummary", "com.bwanms.rb.gui.configuration.SuSummaryConfigForm" + cfgFormSuffix){

            public String getName() {
                return "SU";
            }

            public String getLabel() {
                return i18n.translateString("RbSU", new Object[]{this.su.getMacAddress(), this.su.getServingAUId(), bs.getName(), bs.getEUID()});
            }
        };
        result.addChildSection((ConfigSection)new RbSUConfigSection(su, "RegistrationParameters", "com.bwanms.rb.gui.configuration.SURegistrationParamConfigForm"));
        result.addChildSection((ConfigSection)new RbSUConfigSection(su, "Bridging", "com.bwanms.rb.gui.configuration.SUBridgingParamConfigForm"));
        if (su.getOperationMode().equals(2)) {
            if (bs.getSoftwareVersion().isNewerOrEqualWith(VersionFactory.getInstance().createVersion("4.0.2"))) {
                result.addChildSection((ConfigSection)new RbSUConfigSection(su, "AirInterface", "com.bwanms.rb.gui.configuration.SUAirIFConfigForm402"));
            } else {
                result.addChildSection((ConfigSection)new RbSUConfigSection(su, "AirInterface", "com.bwanms.rb.gui.configuration.SUAirIFConfigForm"));
            }
            result.addChildSection((ConfigSection)new RbSUConfigSection(su, "FrequencyScanning", "com.bwanms.rb.gui.configuration.SuFrequencyScanningConfigForm402"));
            result.addChildSection((ConfigSection)new RbSUConfigSection(su, "BestBSTAUSelection", "com.bwanms.rb.gui.configuration.SuBestBSTAUSelectionConfigForm"));
        } else {
            result.addChildSection((ConfigSection)new RbSUConfigSection(su, "AirInterface", "com.bwanms.rb.gui.configuration.SUAirIFConfigForm"));
        }
        result.addChildSection((ConfigSection)new RbSUConfigSection(su, "Gateways", "com.bwanms.rb.gui.configuration.SUGatewaysConfigForm"));
        result.addChildSection((ConfigSection)new RbSUConfigSection(su, "UnitControl", "com.bwanms.rb.gui.configuration.SuUnitControlConfigForm"));
        result.addChildSection((ConfigSection)new RbSUConfigSection(su, "EthPort", "com.bwanms.rb.gui.configuration.SuEthPortConfigForm"));
        result.addChildSection((ConfigSection)new RbSUConfigSection(su, "BurstCounters", "com.bwanms.rb.gui.configuration.SuBurstCountersConfigForm"));
        result.addChildSection((ConfigSection)new RbPerformanceConfigSection(su, "Performance", SuPerformanceMonitoringView.class.getName()));
        if (su.hasLimittedCapabilities() && bsSwUnder41) {
            result.addChildSection((ConfigSection)new RbSUConfigSection(su, "Licenses", "com.bwanms.rb.gui.configuration.SuLicensesConfigForm"));
        }
        return result;
    }

    public ConfigSection createEquipmentConfigSection(EquipmentConfiguration configuration) {
        Equipment equipment = configuration.getEquipment();
        if (equipment instanceof RbBS) {
            return this.createRbBSEquipmentConfigSection((RbBS)equipment);
        }
        if (equipment instanceof RbMBS) {
            return this.createRbMBSEquipmentConfigSection((RbMBS)equipment);
        }
        if (equipment instanceof RbSU) {
            return this.createRbSUEquipmentConfigSection((RbSU)equipment);
        }
        throw new UnsupportedOperationException("Cannot handle: " + equipment.getClass().getName());
    }

    private static class RbUnifiedFormsConfigSectionView
    extends UnifiedFormsConfigSectionView {
        private static Internationalizer errorI18n = Internationalizer.getInternationalizer(RbEquipmentAgentException.class);

        public RbUnifiedFormsConfigSectionView() {
            this.setManagedObjectsAccessSupport((ManagedObjectsAccessSupport)new UnifiedMOsAccessSupport((ManagedObjectsAccessSupportCallback)new RbMOAccessCallback()));
        }

        class RbMOAccessCallback
        extends FormsConfigSectionView.MOAccessCallback {
            RbMOAccessCallback() {
                super((FormsConfigSectionView)RbUnifiedFormsConfigSectionView.this);
            }

            protected void handleThrowable(Throwable x) {
                if (x instanceof RbEquipmentAgentException) {
                    RbEquipmentAgentException rbAgentEx = (RbEquipmentAgentException)((Object)x);
                    String errCode = String.valueOf(rbAgentEx.getErrorCode());
                    if (errorI18n.canTranslate(errCode)) {
                        MessageBox.Error.showOptionEquipmentError((Component)RbUnifiedFormsConfigSectionView.this.getParentComponent(), i18n.translateString("RbAgentException", new Object[]{rbAgentEx.getErrorCode(), errorI18n.translateString(errCode)}));
                    } else {
                        super.handleThrowable(x);
                    }
                } else {
                    super.handleThrowable(x);
                }
            }
        }
    }

    private static class RbFormsConfigSectionView
    extends FormsConfigSectionView {
        private static Internationalizer errorI18n = Internationalizer.getInternationalizer(RbEquipmentAgentException.class);

        public RbFormsConfigSectionView() {
            this.setManagedObjectsAccessSupport(new ManagedObjectsAccessSupport((ManagedObjectsAccessSupportCallback)new RbMOAccessCallback()));
        }

        class RbMOAccessCallback
        extends FormsConfigSectionView.MOAccessCallback {
            RbMOAccessCallback() {
                super((FormsConfigSectionView)RbFormsConfigSectionView.this);
            }

            protected void handleThrowable(Throwable x) {
                if (x instanceof RbEquipmentAgentException) {
                    RbEquipmentAgentException rbAgentEx = (RbEquipmentAgentException)((Object)x);
                    String errCode = String.valueOf(rbAgentEx.getErrorCode());
                    if (errorI18n.canTranslate(errCode)) {
                        MessageBox.Error.showOptionEquipmentError((Component)RbFormsConfigSectionView.this.getParentComponent(), i18n.translateString("RbAgentException", new Object[]{rbAgentEx.getErrorCode(), errorI18n.translateString(errCode)}));
                    } else {
                        super.handleThrowable(x);
                    }
                } else {
                    super.handleThrowable(x);
                }
            }
        }
    }

    private class PerformanceConfigSectionViewFactory
    implements ConfigSectionViewFactory {
        private String viewClass;
        private Equipment eq;

        public PerformanceConfigSectionViewFactory(Equipment eq, String viewClass) {
            this.eq = eq;
            this.viewClass = viewClass;
        }

        public ConfigSectionView createView() {
            try {
                PerformanceMonitoringSectionView ret = (PerformanceMonitoringSectionView)Class.forName(this.viewClass).newInstance();
                ret.setEquipment(this.eq);
                return ret;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private class RbUnifiedConfigSectionViewFactory
    implements ConfigSectionViewFactory {
        private String[][] panels;

        public RbUnifiedConfigSectionViewFactory(String[][] panels) {
            this.panels = panels;
        }

        public ConfigSectionView createView() {
            RbUnifiedFormsConfigSectionView result = new RbUnifiedFormsConfigSectionView();
            for (int i = 0; i < this.panels.length; ++i) {
                try {
                    UnifiedMOsConfigForm form = (UnifiedMOsConfigForm)Class.forName(this.panels[i][1]).newInstance();
                    result.addConfigForm((ManagedObjectsConfigForm)form);
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)("Can't add panel [" + this.panels[i][1] + "] to multiple config panel."), (Throwable)e);
                }
            }
            return result;
        }
    }

    private class RbConfigSectionViewFactory
    implements ConfigSectionViewFactory {
        private String[][] panels;

        public RbConfigSectionViewFactory(String[][] panels) {
            this.panels = panels;
        }

        public ConfigSectionView createView() {
            RbFormsConfigSectionView result = new RbFormsConfigSectionView();
            for (int i = 0; i < this.panels.length; ++i) {
                try {
                    ManagedObjectsConfigForm form = (ManagedObjectsConfigForm)Class.forName(this.panels[i][1]).newInstance();
                    result.addConfigForm(form);
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)("Can't add panel [" + this.panels[i][1] + "] to multiple config panel."), (Throwable)e);
                }
            }
            return result;
        }
    }

    private class RbSUConfigSection
    extends DefaultEMSSection {
        protected RbSU su;

        public RbSUConfigSection(RbSU su, String name, String panel) {
            this(su, name, new String[][]{{name, panel}});
        }

        public RbSUConfigSection(RbSU su, String name, String[][] panels) {
            super((ConfigSectionViewFactory)new RbConfigSectionViewFactory(panels));
            this.setName(name);
            this.setLabel(name);
            this.su = su;
        }

        public String getLabel() {
            return i18n.translateString(super.getLabel());
        }

        public ConfigSectionView getConfigEditor() {
            FormsConfigSectionView view = (FormsConfigSectionView)super.getConfigEditor();
            view.setTitle(this.getLabel());
            view.setEquipment((Equipment)this.su);
            return view;
        }
    }

    private class RbCardConfigSection
    extends DefaultEMSSection {
        protected String nrName;
        protected RbBS bs;
        protected ManagedObject cardMO;

        public RbCardConfigSection(RbBS bs, String nrName, ManagedObject cardMO, String name, String panel) {
            this(bs, nrName, cardMO, name, new String[][]{{name, panel}});
        }

        public RbCardConfigSection(RbBS bs, String nrName, ManagedObject cardMO, String name, String[][] panels) {
            super((ConfigSectionViewFactory)new RbConfigSectionViewFactory(panels));
            this.setName(name);
            this.setLabel(name);
            this.nrName = nrName;
            this.bs = bs;
            this.cardMO = cardMO;
        }

        public String getLabel() {
            return i18n.translateString(super.getLabel());
        }

        public ConfigSectionView getConfigEditor() {
            FormsConfigSectionView view = (FormsConfigSectionView)super.getConfigEditor();
            view.setTitle(this.getLabel());
            view.setEquipment((Equipment)this.bs);
            view.setAttribute("NR", (Object)this.nrName);
            if (this.cardMO != null) {
                view.setAttribute(this.cardMO instanceof RbAuConfigEntry ? "AU" : "NPU", (Object)this.cardMO);
            }
            return view;
        }
    }

    private class RbPerformanceConfigSection
    extends DefaultEMSSection {
        private String nr;
        private ManagedObject cardMO;

        public RbPerformanceConfigSection(Equipment equipment, String nr, ManagedObject cardMO, String name, String viewClass) {
            super((ConfigSectionViewFactory)new PerformanceConfigSectionViewFactory(equipment, viewClass));
            this.nr = null;
            this.setName(name);
            this.setLabel(name);
            this.nr = nr;
            this.cardMO = cardMO;
        }

        public RbPerformanceConfigSection(Equipment equipment, String name, String viewClass) {
            super((ConfigSectionViewFactory)new PerformanceConfigSectionViewFactory(equipment, viewClass));
            this.nr = null;
            this.setName(name);
            this.setLabel(name);
        }

        public String getLabel() {
            return i18n.translateString(super.getLabel());
        }

        public ConfigSectionView getConfigEditor() {
            ConfigSectionView view = super.getConfigEditor();
            if (view != null) {
                if (this.nr != null) {
                    view.setAttribute("NR", (Object)this.nr);
                }
                if (this.cardMO != null) {
                    view.setAttribute(this.cardMO instanceof RbAuConfigEntry ? "AU" : "NPU", (Object)this.cardMO);
                }
            }
            return view;
        }
    }

    private class RbUnifiedConfigSection
    extends DefaultEMSSection {
        private Equipment equipment;

        public RbUnifiedConfigSection(Equipment equipment, String name) {
            this(equipment, name, new String[0][]);
        }

        public RbUnifiedConfigSection(Equipment equipment, String name, String panel) {
            this(equipment, name, new String[][]{{name, panel}});
        }

        public RbUnifiedConfigSection(Equipment equipment, String name, String[][] panels) {
            super((ConfigSectionViewFactory)new RbUnifiedConfigSectionViewFactory(panels));
            this.equipment = equipment;
            this.setName(name);
            this.setLabel(name);
        }

        public String getLabel() {
            return i18n.translateString(super.getLabel());
        }

        public ConfigSectionView getConfigEditor() {
            UnifiedFormsConfigSectionView view = (UnifiedFormsConfigSectionView)super.getConfigEditor();
            if (view != null) {
                view.setTitle(this.getLabel());
                view.setEquipment(this.equipment);
                view.setAttribute("NR", (Object)"BS");
            }
            return view;
        }
    }

    private class RbConfigSection
    extends DefaultEMSSection {
        private Equipment equipment;

        public RbConfigSection(Equipment equipment, String name) {
            this(equipment, name, new String[0][]);
        }

        public RbConfigSection(Equipment equipment, String name, String panel) {
            this(equipment, name, new String[][]{{name, panel}});
        }

        public RbConfigSection(Equipment equipment, String name, String[][] panels) {
            super((ConfigSectionViewFactory)new RbConfigSectionViewFactory(panels));
            this.equipment = equipment;
            this.setName(name);
            this.setLabel(name);
        }

        public String getLabel() {
            return i18n.translateString(super.getLabel());
        }

        public ConfigSectionView getConfigEditor() {
            FormsConfigSectionView view = (FormsConfigSectionView)super.getConfigEditor();
            if (view != null) {
                view.setTitle(this.getLabel());
                view.setEquipment(this.equipment);
                view.setAttribute("NR", (Object)"BS");
            }
            return view;
        }
    }
}

