/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.configuration.errors;

import com.bwanms.domain.logic.Helpers;
import com.bwanms.mediation.AgentException;
import com.bwanms.model.ConfigurationErrorHandler;
import com.bwanms.model.Equipment;
import com.bwanms.platform.PlatformFactory;
import com.bwanms.protocols.snmp.SNMPAgentError;
import com.bwanms.protocols.snmp.SNMPAgentErrorException;
import com.bwanms.rb.configuration.errors.RbEquipmentAgentException;
import com.bwanms.rb.configuration.errors.RbErrorHandlerEntry;
import com.bwanms.rb.model.RbAU;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.model.RbNPU;
import com.bwanms.rb.model.RbSU;
import com.bwanms.services.EquipmentAgentException;
import com.bwanms.util.IpAddress;
import com.bwanms.util.version.Version;
import com.bwanms.util.version.impl.DefaultVersion;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class RbConfigurationErrorHandler
implements ConfigurationErrorHandler {
    private static Logger logger = Logger.getLogger(RbConfigurationErrorHandler.class);
    private static List<IpAddress[]> mediationIpRanges = new ArrayList<IpAddress[]>();

    public boolean accept(Equipment equipment) {
        if (equipment.getClass().getPackage().getName().equals("com.bwanms.rb.model")) {
            RbBaseStationEquipment bsEquipment = RbConfigurationErrorHandler.getBSEquipment(equipment);
            return null != bsEquipment && bsEquipment.getSoftwareVersion().isNewerOrEqualWith((Version)new DefaultVersion("4.1"));
        }
        return false;
    }

    public EquipmentAgentException handleConfigError(AgentException exception, Equipment equipment) {
        RbBaseStationEquipment bsEquipment;
        Throwable cause = exception.getCause();
        if (null != cause && cause instanceof SNMPAgentErrorException && null != (bsEquipment = RbConfigurationErrorHandler.getBSEquipment(equipment))) {
            try {
                SNMPAgentError agentError = ((SNMPAgentErrorException)cause).getAgentError();
                List errHandlerEntries = Helpers.getConfigurationHelper().retrieveData((Equipment)bsEquipment, null, RbErrorHandlerEntry.class, RbConfigurationErrorHandler.getMediationIpAddress(bsEquipment.getIPAddress()) + "." + agentError.getRequestID());
                RbErrorHandlerEntry errHandlerEntry = (RbErrorHandlerEntry)errHandlerEntries.get(0);
                return new RbEquipmentAgentException((Throwable)exception, (int)errHandlerEntry.getRbSnmpErrHandlerCode());
            }
            catch (Exception e) {
                logger.debug((Object)e, (Throwable)e);
            }
        }
        return new EquipmentAgentException((Throwable)exception);
    }

    private static RbBaseStationEquipment getBSEquipment(Equipment equipment) {
        RbBaseStationEquipment bsEquipment = null;
        if (equipment instanceof RbBaseStationEquipment) {
            bsEquipment = (RbBaseStationEquipment)equipment;
        } else if (equipment instanceof RbSU) {
            bsEquipment = ((RbSU)equipment).getManagerBS();
        } else if (equipment instanceof RbAU) {
            bsEquipment = ((RbAU)equipment).getManagerBS();
        } else if (equipment instanceof RbNPU) {
            bsEquipment = ((RbNPU)equipment).getManagerBS();
        }
        return bsEquipment;
    }

    private static String getMediationIpAddress(String equipmentIpAddress) {
        IpAddress eqIpAddress = new IpAddress(equipmentIpAddress);
        for (IpAddress[] range : mediationIpRanges) {
            if (eqIpAddress.compareTo(range[1]) < 0 || eqIpAddress.compareTo(range[2]) > 0) continue;
            return range[0].toString();
        }
        return PlatformFactory.getMediationLayerPlatform(null).getIPAddress();
    }

    private static void parseIPRanges(String ipAddressRanges) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("parseIPRanges() - pRanges is " + ipAddressRanges));
        }
        StringTokenizer st = new StringTokenizer(ipAddressRanges, ",");
        while (st.hasMoreTokens()) {
            IpAddress[] range = new IpAddress[3];
            String rangeToken = st.nextToken();
            int pos = rangeToken.indexOf(61);
            if (-1 == pos) continue;
            range[0] = new IpAddress(rangeToken.substring(0, pos).trim());
            if (-1 != (pos = (rangeToken = rangeToken.substring(pos + 1).trim()).indexOf(47))) {
                String ipAddr = rangeToken.substring(0, pos).trim();
                String mask = rangeToken.substring(pos + 1).trim();
                long[] range1 = RbConfigurationErrorHandler.convertIPSubnetToRange(ipAddr, mask);
                range[1] = new IpAddress(range1[0]);
                range[2] = new IpAddress(range1[1]);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Added new range 1 " + range[1] + " - " + range[2]));
                }
            } else {
                pos = rangeToken.indexOf(45);
                if (-1 != pos) {
                    String startIpAddr = rangeToken.substring(0, pos).trim();
                    String endIpAddr = rangeToken.substring(pos + 1).trim();
                    range[1] = new IpAddress(startIpAddr);
                    range[2] = new IpAddress(endIpAddr);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Added new range 2 " + range[1] + " - " + range[2]));
                    }
                } else {
                    range[1] = new IpAddress(rangeToken);
                    range[2] = new IpAddress(rangeToken);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Added new range 2 " + range[1] + " - " + range[2]));
                    }
                }
            }
            mediationIpRanges.add(range);
        }
    }

    private static long[] convertIPSubnetToRange(String pIpAddr, String pIpMask) {
        long _ipAddr = IpAddress.parse((String)pIpAddr);
        long _mask = IpAddress.parse((String)pIpMask);
        long[] _range = new long[]{_ipAddr & _mask, _ipAddr | 0xFFFFFFFFL & (_mask ^ 0xFFFFFFFFFFFFFFFFL)};
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("convertIPSubnetToRange: " + pIpAddr + "/" + pIpMask + " to " + new IpAddress(_range[0]) + "-" + new IpAddress(_range[1])));
        }
        return _range;
    }

    static {
        RbConfigurationErrorHandler.parseIPRanges(System.getProperty("com.bwanms.rb.mediationIpAddressRanges", ""));
    }
}

