/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.configfile;

import com.bwanms.mediation.AbstractMOAccessSession;
import com.bwanms.mediation.MediationException;
import com.bwanms.protocols.Protocol;
import com.bwanms.rb.configfile.ConfigFile;
import com.bwanms.rb.configfile.RbConfigFile;
import com.bwanms.rb.configfile.RbConfigFileParameter;
import com.bwanms.rb.configfile.RbConfigFileTableEntry;
import com.bwanms.util.BeanUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbConfigFileMOAccessSession
extends AbstractMOAccessSession {
    private static final Logger log = Logger.getLogger(RbConfigFileMOAccessSession.class);
    private HashMap<Class, List> cache;
    private ConfigFile configFile;

    public RbConfigFileMOAccessSession(ConfigFile configFile) {
        this.configFile = configFile;
        this.cache = new HashMap();
    }

    public void commitObject(String networkResource, Object mo, String[] includedProperties) throws MediationException {
        throw new UnsupportedOperationException("Commit not supported");
    }

    public Class<? extends Protocol> getProtocol() {
        return RbConfigFile.class;
    }

    public void close() {
    }

    public <T> List<T> fetchObject(String networkResource, Class<T> moClass, String[] includedProperties, String[] instances) throws MediationException {
        log.debug((Object)("Processing class [" + moClass.getName() + "]"));
        ArrayList<T> entries = this.cache.get(moClass);
        if (entries != null) {
            return entries;
        }
        RbConfigFileTableEntry tableEntry = moClass.getAnnotation(RbConfigFileTableEntry.class);
        if (tableEntry == null) {
            throw new AssertionError((Object)(moClass.getName() + " is not annotated with " + RbConfigFileTableEntry.class.getName()));
        }
        ConfigFile.Resource resource = null;
        String[] resources = tableEntry.resourceName().split(";");
        for (int i = 0; i < resources.length && resource == null; ++i) {
            resource = this.configFile.getResource(resources[i]);
        }
        if (resource == null) {
            throw new MediationException("Resource not found [" + tableEntry.resourceName() + "]");
        }
        ConfigFile.DbTable dbTable = resource.getDbTable(tableEntry.tableName());
        if (dbTable == null && resource.getValue() == null) {
            throw new MediationException("Resource [" + resource.getName() + "] does not contain table [" + tableEntry.tableName() + "]");
        }
        HashMap<Method, String> setterToFieldMap = new HashMap<Method, String>();
        for (Method getter : BeanUtils.getPropertyGetters(moClass)) {
            RbConfigFileParameter configParameter = getter.getAnnotation(RbConfigFileParameter.class);
            if (configParameter == null || !this.accept(includedProperties, BeanUtils.getPropertyNameFromGetter((Method)getter))) continue;
            try {
                Method setter = BeanUtils.getSetter(moClass, (String)BeanUtils.getPropertyNameFromGetter((Method)getter));
                setterToFieldMap.put(setter, configParameter.name());
            }
            catch (Exception e) {
                throw new AssertionError((Object)("No setter found for annotated getter: " + getter.getDeclaringClass().getName() + "." + getter.getName()));
            }
        }
        Method indexSetter = null;
        try {
            indexSetter = moClass.getMethod("setRowIndex", Integer.class);
        }
        catch (Exception e) {
            log.debug((Object)"No declared setRowIndex method");
        }
        try {
            if (dbTable != null) {
                int rowCount = dbTable.getDataRecordCount();
                entries = new ArrayList<T>(rowCount);
                for (int row = 0; row < rowCount; ++row) {
                    T entry = moClass.newInstance();
                    if (indexSetter != null) {
                        indexSetter.invoke(entry, row);
                    }
                    for (Method setter : setterToFieldMap.keySet()) {
                        try {
                            String fieldName = (String)setterToFieldMap.get(setter);
                            Object value = dbTable.getValue(row, fieldName);
                            setter.invoke(entry, value);
                        }
                        catch (Exception e) {
                            log.debug((Object)("Exception for: " + setter.getName()), (Throwable)e);
                            throw e;
                        }
                    }
                    entries.add(entry);
                }
            } else if (resource.getValue() != null) {
                entries = new ArrayList(1);
                T entry = moClass.newInstance();
                for (Method setter : setterToFieldMap.keySet()) {
                    try {
                        setter.invoke(entry, resource.getValue());
                    }
                    catch (Exception e) {
                        log.debug((Object)("Exception for: " + setter.getName()), (Throwable)e);
                        throw e;
                    }
                }
                entries.add(entry);
            }
            this.cache.put(moClass, entries);
            return entries;
        }
        catch (Exception e) {
            throw new MediationException((Throwable)e);
        }
    }

    private boolean accept(String[] includedProperties, String property) {
        if (includedProperties == null) {
            return true;
        }
        for (String incl : includedProperties) {
            if (!incl.equals(property)) continue;
            return true;
        }
        return false;
    }

    public <T> List<T> fetchObject(String networkResource, Class<T> moClass, String[] includedProperties, String instanceQuery) throws MediationException {
        return this.fetchObject(networkResource, moClass, includedProperties, new String[]{"*"});
    }
}

