/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.configfile;

import com.bwanms.util.OctetString;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigFile {
    private static final Logger log = Logger.getLogger(ConfigFile.class);
    public static final int FIELD_TYPE_NULL = 0;
    public static final int FIELD_TYPE_STRING = 1;
    public static final int FIELD_TYPE_BYTES = 2;
    public static final int FIELD_TYPE_UINT8 = 3;
    public static final int FIELD_TYPE_INT8 = 4;
    public static final int FIELD_TYPE_UINT16 = 5;
    public static final int FIELD_TYPE_INT16 = 6;
    public static final int FIELD_TYPE_UINT32 = 7;
    public static final int FIELD_TYPE_INT32 = 8;
    public static final int FIELD_TYPE_IPADDR = 9;
    public static final int FIELD_TYPE_MAC = 10;
    public static final int FIELD_TYPE_TIME = 11;
    public static final int FIELD_TYPE_DATE = 12;
    public static final HashMap<Integer, Class> TYPE_MAP = new HashMap();
    private HashMap<String, Resource> resources = new HashMap();

    private ConfigFile() {
    }

    public Resource getResource(String name) {
        return this.resources.get(name);
    }

    public Collection<Resource> getResources() {
        return this.resources.values();
    }

    public static ConfigFile parse(InputStream in) throws IOException {
        ConfigFile ret = new ConfigFile();
        ret.parseInternal(in);
        return ret;
    }

    private void parseInternal(InputStream in) throws IOException {
        DataInputStream din = new DataInputStream(in);
        while (din.available() > 0) {
            Resource resource = Resource.parse(din);
            this.resources.put(resource.getName(), resource);
        }
    }

    private static String toOctetString(byte[] bytes) {
        return OctetString.toOctetString((byte[])bytes);
    }

    private static String readZeroEndedString(byte[] buff) {
        int idx = 0;
        for (int i = 0; i < buff.length; ++i) {
            if (buff[i] != 0) continue;
            idx = i;
            return new String(buff, 0, idx);
        }
        return new String(buff, 0, buff.length);
    }

    private static String readZeroEndedString(DataInputStream in, int len) throws IOException {
        byte[] buff = new byte[len];
        in.read(buff);
        return ConfigFile.readZeroEndedString(buff);
    }

    private static long toUnsignedInt(int value) {
        String hex = Integer.toHexString(value);
        return Long.parseLong(hex, 16);
    }

    private static String toIpAddress(byte[] bytes) {
        return OctetString.toDottedDecimalForm((String)OctetString.toOctetString((byte[])bytes));
    }

    static {
        TYPE_MAP.put(1, String.class);
        TYPE_MAP.put(2, String.class);
        TYPE_MAP.put(3, Integer.class);
        TYPE_MAP.put(4, Integer.class);
        TYPE_MAP.put(5, Integer.class);
        TYPE_MAP.put(6, Integer.class);
        TYPE_MAP.put(7, Long.class);
        TYPE_MAP.put(8, Integer.class);
        TYPE_MAP.put(9, String.class);
        TYPE_MAP.put(10, String.class);
        TYPE_MAP.put(11, String.class);
        TYPE_MAP.put(12, String.class);
    }

    public static class DbField {
        private int type;
        private int size;
        private String name;

        private DbField() {
        }

        public static DbField fromStream(DataInputStream in) throws IOException {
            DbField ret = new DbField();
            ret.parseInternal(in);
            return ret;
        }

        public Class getMappedType() {
            return TYPE_MAP.get(this.type);
        }

        private void parseInternal(DataInputStream in) throws IOException {
            this.type = in.readUnsignedByte();
            this.size = in.readUnsignedByte();
            this.name = ConfigFile.readZeroEndedString(in, 32);
            in.readUnsignedShort();
            in.skip(2L);
            log.debug((Object)("FLD[" + this.name + ",TYPE:" + this.type + ",SIZE:" + this.size + "]"));
        }

        public String getName() {
            return this.name;
        }

        public int getType() {
            return this.type;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DbTable {
        private String name;
        int fieldCount;
        private ArrayList<DbField> fields = new ArrayList();
        private Object[][] data;
        private int headerSize;
        private int recordCount;
        private int dataRecordCount;
        private int recordSize;
        private int persistedFieldCount;

        private DbTable() {
        }

        public String getName() {
            return this.name;
        }

        public List<DbField> getFields() {
            return this.fields;
        }

        public List<DbField> getPersistentFields() {
            ArrayList<DbField> ret = new ArrayList<DbField>(this.persistedFieldCount);
            for (int i = 0; i < this.persistedFieldCount; ++i) {
                ret.add(this.fields.get(i));
            }
            return ret;
        }

        public void computeSize(Resource res) {
            this.recordCount = (res.length - this.headerSize) / (this.recordSize + 2);
            this.dataRecordCount = 0;
        }

        public void prepareData() {
            if (this.recordCount > 5000 || this.persistedFieldCount > 255) {
                log.error((Object)("Corrupt backup file. DbTable[" + this.name + "] is too big [" + this.recordCount + "," + this.persistedFieldCount + "]"));
                throw new RuntimeException("Config File is corrupt");
            }
            this.data = new Object[this.recordCount][this.persistedFieldCount];
        }

        public static DbTable parse(DataInputStream in, Resource res) throws IOException {
            DbTable ret = new DbTable();
            ret.parseInternal(in, res);
            return ret;
        }

        private void parseInternal(DataInputStream in, Resource resource) throws IOException {
            int i;
            this.headerSize = in.readUnsignedShort();
            in.skip(2L);
            this.name = ConfigFile.readZeroEndedString(in, 40);
            in.skip(2L);
            this.recordSize = in.readChar();
            in.skip(2L);
            in.skip(2L);
            this.fieldCount = in.readUnsignedByte();
            this.persistedFieldCount = in.readUnsignedByte();
            this.computeSize(resource);
            log.debug((Object)("DBTBL[" + this.name + ",FLDC:" + this.fieldCount + ",PFLDC:" + this.persistedFieldCount + ",RECC:" + this.recordCount + ",RECS:" + this.recordSize + "]"));
            for (int i2 = 0; i2 < this.fieldCount; ++i2) {
                DbField field = DbField.fromStream(in);
                this.fields.add(field);
            }
            this.prepareData();
            int currentRecord = 0;
            for (i = 0; i < this.recordCount; ++i) {
                if (!this.parseRecord(in, currentRecord)) continue;
                ++currentRecord;
            }
            this.dataRecordCount = currentRecord;
            if (log.isDebugEnabled()) {
                log.debug((Object)"---------------------------------------\n");
                for (i = 0; i < this.dataRecordCount; ++i) {
                    Object[] row = this.data[i];
                    String rowStr = "";
                    for (Object o : row) {
                        rowStr = rowStr + "" + o + ",";
                    }
                    log.debug((Object)rowStr);
                }
                log.debug((Object)"---------------------------------------\n");
            }
        }

        private boolean parseRecord(DataInputStream in, int recNo) throws IOException {
            int checkSum = in.readUnsignedByte();
            in.readUnsignedByte();
            if (checkSum == 0) {
                log.debug((Object)"Deleted record");
                in.skip(this.recordSize);
                return false;
            }
            for (int i = 0; i < this.persistedFieldCount; ++i) {
                DbField fld = this.fields.get(i);
                Object value = null;
                if (fld.size > 10240) {
                    log.error((Object)("Corrupt field size. DbTable[" + this.name + "] FLD[" + fld.name + "] size is [" + fld.size + "]"));
                    throw new RuntimeException("Corrupt backup file");
                }
                int type = fld.getType();
                if ("BaseStationId".equals(fld.getName())) {
                    type = 2;
                }
                switch (type) {
                    case 4: {
                        value = in.readByte();
                        break;
                    }
                    case 3: {
                        value = in.readUnsignedByte();
                        break;
                    }
                    case 5: {
                        value = in.readUnsignedShort();
                        break;
                    }
                    case 6: {
                        value = in.readShort();
                        break;
                    }
                    case 7: {
                        value = ConfigFile.toUnsignedInt(in.readInt());
                        break;
                    }
                    case 8: {
                        value = in.readInt();
                        break;
                    }
                    case 9: {
                        byte[] buff = new byte[4];
                        in.read(buff);
                        value = ConfigFile.toIpAddress(buff);
                        break;
                    }
                    case 1: {
                        value = ConfigFile.readZeroEndedString(in, fld.size);
                        in.skip(1L);
                        break;
                    }
                    case 2: 
                    case 10: {
                        byte[] buff = new byte[fld.size];
                        in.read(buff);
                        value = ConfigFile.toOctetString(buff);
                        break;
                    }
                    case 11: {
                        value = "" + in.readByte() + ":" + in.readByte() + ":" + in.readByte();
                        in.skip(1L);
                        break;
                    }
                    case 12: {
                        value = "" + in.readShort() + "/" + in.readByte() + "/" + in.readByte();
                    }
                }
                if ("BaseStationId".equals(fld.getName())) {
                    in.skip(1L);
                }
                this.data[recNo][i] = value;
            }
            return true;
        }

        public int findRow(String fieldName, Object value) {
            int column = this.findColumn(fieldName);
            for (int row = 0; row < this.dataRecordCount; ++row) {
                if (!this.data[row][column].equals(value)) continue;
                return row;
            }
            return -1;
        }

        public Object getValue(int row, String fieldName) {
            int columnIndex = this.findColumn(fieldName);
            if (columnIndex != -1 && this.data[row] != null && this.data[row].length > columnIndex) {
                return this.data[row][columnIndex];
            }
            return null;
        }

        private int findColumn(String fieldName) {
            int fieldsSize = this.fields.size();
            for (int col = 0; col < fieldsSize; ++col) {
                if (!this.fields.get(col).getName().equals(fieldName)) continue;
                return col;
            }
            log.error((Object)("Column not found: " + fieldName + " in " + this.getName()));
            return -1;
        }

        public int getDataRecordCount() {
            return this.dataRecordCount;
        }
    }

    public static class Resource {
        private String name;
        private int length;
        private DbTable dbTable;
        private Object value;

        private Resource() {
        }

        public String getName() {
            return this.name;
        }

        public int getLength() {
            return this.length;
        }

        public static Resource parse(DataInputStream in) throws IOException {
            Resource ret = new Resource();
            ret.parseInternal(in);
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void parseInternal(DataInputStream in) throws IOException {
            this.name = ConfigFile.readZeroEndedString(in, 32);
            this.length = in.readInt();
            byte[] resBytes = new byte[this.length];
            int bytesRead = in.read(resBytes, 0, this.length);
            if (bytesRead == this.length) {
                log.debug((Object)("RES[" + this.name + ", LEN: " + this.length + " BYTES READ: " + bytesRead + "]"));
            } else {
                log.warn((Object)("RES[" + this.name + ", LEN: " + this.length + " BYTES READ: " + bytesRead + "]"));
            }
            ByteArrayInputStream bis = new ByteArrayInputStream(resBytes);
            DataInputStream dis = new DataInputStream(bis);
            try {
                if (this.name.startsWith("NPU File Signature")) {
                    dis.skip(this.length);
                } else if (this.name.startsWith("SWITCHING_MODE") && 4 == this.length) {
                    this.value = dis.readInt();
                } else {
                    this.dbTable = DbTable.parse(dis, this);
                }
                if (this.length % 2 != 0) {
                    in.skip(1L);
                }
            }
            finally {
                try {
                    dis.close();
                }
                catch (Exception e) {}
            }
        }

        public DbTable getDbTable(String name) {
            if (this.dbTable == null || !name.equals(this.dbTable.getName())) {
                return null;
            }
            return this.dbTable;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

