/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.command;

import com.bwanms.command.NetworkElementCommand;
import com.bwanms.meta.snmp.SNMPParameter;
import com.bwanms.meta.snmp.SNMPTableEntry;

@SNMPTableEntry(entryOID="1.3.6.1.4.1.12394.1.2.5.1.1", indexColumns={"RbSuMacAddr"})
public class RbSuCommand
implements NetworkElementCommand {
    private long equipmentId;
    private Integer rbAuId;
    private String rbSuMacAddr;
    private Integer rbSuSetDefaults;
    private Integer rbSuUnitControl;
    private String rbSuUpgradeSwFileName;
    public static final int RbSuUnitControlNone = 1;
    public static final int RbSuUnitControlReset = 2;
    public static final int RbSuUnitControlPutToShadow = 3;
    public static final int RbSuUnitControlResetAndRunFromShadow = 4;
    public static final int RbSuUnitControlMakeRunningVersionOperational = 5;
    public static final int RbSuSetDefaultsNone = 1;
    public static final int RbSuSetDefaultsFactoryDefault = 2;
    public static final int RbSuSetDefaultsPartialDefault = 3;
    public static final int RbSuSetDefaultsCustomerDefault = 4;
    public static final int RbSuSetDefaultsPartialCustomerDefault = 5;
    private Integer rbSUEthernetResetCounters;
    public static final int RbSUEthernetResetCountersNoAction = 0;
    public static final int RbSUEthernetResetCountersReset = 1;
    private Integer rbSUWirelessResetCounters;
    public static final int RbSUWirelessResetCountersNoAction = 0;
    public static final int RbSUWirelessResetCountersReset = 1;

    public long getEquipmentId() {
        return this.equipmentId;
    }

    public final void setEquipmentId(long id) {
        this.equipmentId = id;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.5.1.1.1", type=2, readOnly=true)
    public Integer getRbAuId() {
        return this.rbAuId;
    }

    public void setRbAuId(Integer rbAuId) {
        this.rbAuId = rbAuId;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.5.1.1.2", type=112, readOnly=true)
    public String getRbSuMacAddr() {
        return this.rbSuMacAddr;
    }

    public void setRbSuMacAddr(String rbSuMacAddr) {
        this.rbSuMacAddr = rbSuMacAddr;
    }

    public static String toStringRbSuUnitControl(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "none(1)";
                break;
            }
            case 2: {
                result = "reset(2)";
                break;
            }
            case 3: {
                result = "putToShadow(3)";
                break;
            }
            case 4: {
                result = "resetAndRunFromShadow(4)";
                break;
            }
            case 5: {
                result = "makeRunningVersionOperational(5)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    public static String toStringRbSuSetDefaults(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "none(1)";
                break;
            }
            case 2: {
                result = "factoryDefault(2)";
                break;
            }
            case 3: {
                result = "partialDefault(3)";
                break;
            }
            case 4: {
                result = "customerDefault(4)";
                break;
            }
            case 5: {
                result = "partialCustomerDefault(5)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(this.getClass().getName()).append('[');
        result.append("rbAuId=").append(this.rbAuId).append(", ");
        result.append("rbSuMacAddr=").append(this.rbSuMacAddr).append(", ");
        result.append("rbSuUnitControl=").append(RbSuCommand.toStringRbSuUnitControl(this.rbSuUnitControl)).append(", ");
        result.append("rbSuSetDefaults=").append(RbSuCommand.toStringRbSuSetDefaults(this.rbSuSetDefaults)).append(", ");
        result.append("rbSuUpgradeSwFileName=").append(this.rbSuUpgradeSwFileName).append(", ");
        result.append("]");
        return result.toString();
    }

    public String getName() {
        return "RbSuCommand command";
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.5.1.1.18", type=2)
    public Integer getRbSuSetDefaults() {
        return this.rbSuSetDefaults;
    }

    public void setRbSuSetDefaults(Integer rbSuSetDefaults) {
        this.rbSuSetDefaults = rbSuSetDefaults;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.5.1.1.17", type=2)
    public Integer getRbSuUnitControl() {
        return this.rbSuUnitControl;
    }

    public void setRbSuUnitControl(Integer rbSuUnitControl) {
        this.rbSuUnitControl = rbSuUnitControl;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.5.1.1.25", type=-128)
    public String getRbSuUpgradeSwFileName() {
        return this.rbSuUpgradeSwFileName;
    }

    public void setRbSuUpgradeSwFileName(String rbSuUpgradeSwFileName) {
        this.rbSuUpgradeSwFileName = rbSuUpgradeSwFileName;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.4.7.20.1.1.2", type=2)
    public Integer getRbSUEthernetResetCounters() {
        return this.rbSUEthernetResetCounters;
    }

    public void setRbSUEthernetResetCounters(Integer rbSUEthernetResetCounters) {
        this.rbSUEthernetResetCounters = rbSUEthernetResetCounters;
    }

    public static String toStringRbSUEthernetResetCounters(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                result = "noAction(0)";
                break;
            }
            case 1: {
                result = "reset(1)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.4.7.21.1.1.1", type=2)
    public Integer getRbSUWirelessResetCounters() {
        return this.rbSUWirelessResetCounters;
    }

    public void setRbSUWirelessResetCounters(Integer rbSUWirelessResetCounters) {
        this.rbSUWirelessResetCounters = rbSUWirelessResetCounters;
    }

    public static String toStringRbSUWirelessResetCounters(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                result = "noAction(0)";
                break;
            }
            case 1: {
                result = "reset(1)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }
}

