/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.command;

import com.bwanms.command.NetworkElementCommand;
import com.bwanms.meta.snmp.SNMPParameter;
import com.bwanms.meta.snmp.SNMPTableEntry;
import com.bwanms.rb.command.RbSwDeleteFiles;
import com.bwanms.rb.mo.RbNpuConfigEntry;
import com.bwanms.rb.model.RbBS;

@SNMPTableEntry(entryOID="1.3.6.1.4.1.12394.1.2.2.2.1.1", indexColumns={"RbSlotNumber"})
public class RbNpuCommand
implements NetworkElementCommand {
    private long equipmentId;
    private Integer rbSlotNumber;
    private Integer rbNpuUnitControl;
    private Integer rbNpuSetDefaults;
    public static final int RbNpuUnitControlNone = 1;
    public static final int RbNpuUnitControlReset = 2;
    public static final int RbNpuUnitControlResetAndRunFromShadow = 4;
    public static final int RbNpuUnitControlMakeRunningVersionOperational = 5;
    public static final int RbNpuSetDefaultsNone = 1;
    public static final int RbNpuSetDefaultsFactoryDefault = 2;
    public static final int RbNpuSetDefaultsPartialDefault = 3;
    public static final int RbNpuSetDefaultsCustomerDefault = 4;
    public static final int RbNpuSetDefaultsPartialCustomerDefault = 5;
    private Integer rbNpuDataPortResetCounters;
    public static final int RbNpuDataPortResetCountersNoAction = 0;
    public static final int RbNpuDataPortResetCountersReset = 1;
    private Integer rbMngmntPortResetCounters;
    public static final int RbMngmntPortResetCountersNoAction = 0;
    public static final int RbMngmntPortResetCountersReset = 1;

    public String getName() {
        return "RbNpuCommand command";
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.2.1.1.1", type=2)
    public Integer getRbSlotNumber() {
        return this.rbSlotNumber;
    }

    public void setRbSlotNumber(Integer rbSlotNumber) {
        this.rbSlotNumber = rbSlotNumber;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.2.2.1.1.13", type=2)
    public Integer getRbNpuUnitControl() {
        return this.rbNpuUnitControl;
    }

    public void setRbNpuUnitControl(Integer rbNpuUnitControl) {
        this.rbNpuUnitControl = rbNpuUnitControl;
    }

    public static String toStringRbNpuUnitControl(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "none(1)";
                break;
            }
            case 2: {
                result = "reset(2)";
                break;
            }
            case 4: {
                result = "resetAndRunFromShadow(4)";
                break;
            }
            case 5: {
                result = "makeRunningVersionOperational(5)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.2.2.1.1.14", type=2)
    public Integer getRbNpuSetDefaults() {
        return this.rbNpuSetDefaults;
    }

    public void setRbNpuSetDefaults(Integer rbNpuSetDefaults) {
        this.rbNpuSetDefaults = rbNpuSetDefaults;
    }

    public String toStringRbNpuSetDefaults(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "none(1)";
                break;
            }
            case 2: {
                result = "factoryDefault(2)";
                break;
            }
            case 3: {
                result = "partialDefault(3)";
                break;
            }
            case 4: {
                result = "customerDefault(4)";
                break;
            }
            case 5: {
                result = "partialCustomerDefault(5)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.4.7.1.1.1.2", type=2)
    public Integer getRbNpuDataPortResetCounters() {
        return this.rbNpuDataPortResetCounters;
    }

    public void setRbNpuDataPortResetCounters(Integer rbNpuDataPortResetCounters) {
        this.rbNpuDataPortResetCounters = rbNpuDataPortResetCounters;
    }

    public static String toStringRbNpuDataPortResetCounters(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                result = "noAction(0)";
                break;
            }
            case 1: {
                result = "reset(1)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.4.7.10.1.1.1", type=2)
    public Integer getRbMngmntPortResetCounters() {
        return this.rbMngmntPortResetCounters;
    }

    public void setRbMngmntPortResetCounters(Integer rbMngmntPortResetCounters) {
        this.rbMngmntPortResetCounters = rbMngmntPortResetCounters;
    }

    public static String toStringRbMngmntPortResetCounters(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                result = "noAction(0)";
                break;
            }
            case 1: {
                result = "reset(1)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(this.getClass().getName()).append('[');
        result.append("rbSlotNumber=").append(this.rbSlotNumber).append(", ");
        result.append("rbNpuUnitControl=").append(RbNpuCommand.toStringRbNpuUnitControl(this.rbNpuUnitControl)).append(", ");
        result.append("]");
        return result.toString();
    }

    public long getEquipmentId() {
        return this.equipmentId;
    }

    public void setEquipmentId(long equipmentId) {
        this.equipmentId = equipmentId;
    }

    public static RbNpuCommand createResetCommand(RbBS bs, RbNpuConfigEntry npuEntry) {
        return RbNpuCommand.createCommand(bs, npuEntry, 2);
    }

    public static RbNpuCommand createResetAndRunFromShadowCommand(RbBS bs, RbNpuConfigEntry npuEntry) {
        return RbNpuCommand.createCommand(bs, npuEntry, 4);
    }

    public static RbNpuCommand createMakeRunningVersionOperationalCommand(RbBS bs, RbNpuConfigEntry npuEntry) {
        return RbNpuCommand.createCommand(bs, npuEntry, 5);
    }

    public static RbNpuCommand createFactoryDefaultsCommand(RbBS bs, RbNpuConfigEntry npuEntry) {
        return RbNpuCommand.createDefaultsCommand(bs, npuEntry, 2);
    }

    public static RbSwDeleteFiles createDeleteSwFilesCommand(RbBS bs, RbNpuConfigEntry npuEntry, String swFile) {
        RbSwDeleteFiles rbCommands = new RbSwDeleteFiles();
        rbCommands.setEquipmentId(bs.getId());
        rbCommands.setRbSwDeleteFiles(swFile);
        return rbCommands;
    }

    private static RbNpuCommand createDefaultsCommand(RbBS bs, RbNpuConfigEntry npuEntry, int commandOperation) {
        RbNpuCommand rbCommands = RbNpuCommand.initCommand(bs, npuEntry);
        rbCommands.setRbNpuSetDefaults(commandOperation);
        return rbCommands;
    }

    private static RbNpuCommand createCommand(RbBS bs, RbNpuConfigEntry npuEntry, int commandOperation) {
        RbNpuCommand rbCommands = RbNpuCommand.initCommand(bs, npuEntry);
        rbCommands.setRbNpuUnitControl(commandOperation);
        return rbCommands;
    }

    private static RbNpuCommand initCommand(RbBS bs, RbNpuConfigEntry npuEntry) {
        RbNpuCommand rbCommands = new RbNpuCommand();
        rbCommands.setEquipmentId(bs.getId());
        rbCommands.setRbSlotNumber(npuEntry.getRbSlotNumber());
        return rbCommands;
    }

    public static RbNpuCommand createResetCountersCommand(RbBS bs, RbNpuConfigEntry npuEntry) {
        RbNpuCommand rbNPUCommand = RbNpuCommand.initCommand(bs, npuEntry);
        return rbNPUCommand;
    }
}

