/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.command;

import com.bwanms.command.NetworkElementCommand;
import com.bwanms.meta.snmp.SNMPParameter;
import com.bwanms.meta.snmp.SNMPTableEntry;
import com.bwanms.rb.mo.RbAuConfigEntry;
import com.bwanms.rb.model.RbBS;

@SNMPTableEntry(entryOID="1.3.6.1.4.1.12394.1.2.2.3.1", indexColumns={"RbSlotNumber"})
public class RbAuCommand
implements NetworkElementCommand {
    private long equipmentId;
    private Integer rbSlotNumber;
    private Integer rbAuUnitControl;
    private String rbAuUpgradeSwFileName;
    private Integer rbAuSetDefaults;
    public static final int RbAuSetDefaultsNone = 1;
    public static final int RbAuSetDefaultsFactoryDefault = 2;
    public static final int RbAuSetDefaultsPartialDefault = 3;
    public static final int RbAuSetDefaultsCustomerDefault = 4;
    public static final int RbAuSetDefaultsPartialCustomerDefault = 5;
    public static final int RbAuUnitControlNone = 1;
    public static final int RbAuUnitControlReset = 2;
    public static final int RbAuUnitControlPutToShadow = 3;
    public static final int RbAuUnitControlResetAndRunFromShadow = 4;
    public static final int RbAuUnitControlMakeRunningVersionOperational = 5;
    private Integer rbAUWirelessResetCounters;
    public static final int RbAUWirelessResetCountersNoAction = 0;
    public static final int RbAUWirelessResetCountersReset = 1;
    private Integer rbAUBackplaneResetCounters;
    public static final int RbAUBackplaneResetCountersNoAction = 0;
    public static final int RbAUBackplaneResetCountersReset = 1;

    public long getEquipmentId() {
        return this.equipmentId;
    }

    public final void setEquipmentId(long id) {
        this.equipmentId = id;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.2.3.1.14", type=2)
    public Integer getRbAuSetDefaults() {
        return this.rbAuSetDefaults;
    }

    public void setRbAuSetDefaults(Integer rbAuSetDefaults) {
        this.rbAuSetDefaults = rbAuSetDefaults;
    }

    public String toStringRbAuSetDefaults(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "none(1)";
                break;
            }
            case 2: {
                result = "factoryDefault(2)";
                break;
            }
            case 3: {
                result = "partialDefault(3)";
                break;
            }
            case 4: {
                result = "customerDefault(4)";
                break;
            }
            case 5: {
                result = "partialCustomerDefault(5)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.2.1.1.1", type=2)
    public Integer getRbSlotNumber() {
        return this.rbSlotNumber;
    }

    public void setRbSlotNumber(Integer rbSlotNumber) {
        this.rbSlotNumber = rbSlotNumber;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.2.3.1.11", type=2)
    public Integer getRbAuUnitControl() {
        return this.rbAuUnitControl;
    }

    public void setRbAuUnitControl(Integer rbAuUnitControl) {
        this.rbAuUnitControl = rbAuUnitControl;
    }

    public static String toStringRbAuUnitControl(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "none(1)";
                break;
            }
            case 2: {
                result = "reset(2)";
                break;
            }
            case 3: {
                result = "putToShadow(3)";
                break;
            }
            case 4: {
                result = "resetAndRunFromShadow(4)";
                break;
            }
            case 5: {
                result = "makeRunningVersionOperational(5)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.2.3.1.17", type=-128)
    public String getRbAuUpgradeSwFileName() {
        return this.rbAuUpgradeSwFileName;
    }

    public void setRbAuUpgradeSwFileName(String rbAuUpgradeSwFileName) {
        this.rbAuUpgradeSwFileName = rbAuUpgradeSwFileName;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.4.7.31.1.1.1", type=2)
    public Integer getRbAUWirelessResetCounters() {
        return this.rbAUWirelessResetCounters;
    }

    public void setRbAUWirelessResetCounters(Integer rbAUWirelessResetCounters) {
        this.rbAUWirelessResetCounters = rbAUWirelessResetCounters;
    }

    public static String toStringRbAUWirelessResetCounters(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                result = "noAction(0)";
                break;
            }
            case 1: {
                result = "reset(1)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.4.7.30.1.1.2", type=2)
    public Integer getRbAUBackplaneResetCounters() {
        return this.rbAUBackplaneResetCounters;
    }

    public void setRbAUBackplaneResetCounters(Integer rbAUBackplaneResetCounters) {
        this.rbAUBackplaneResetCounters = rbAUBackplaneResetCounters;
    }

    public static String toStringRbAUBackplaneResetCounters(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                result = "noAction(0)";
                break;
            }
            case 1: {
                result = "reset(1)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(this.getClass().getName()).append('[');
        result.append("rbSlotNumber=").append(this.rbSlotNumber).append(", ");
        result.append("rbAuUnitControl=").append(RbAuCommand.toStringRbAuUnitControl(this.rbAuUnitControl)).append(", ");
        result.append("rbAuUpgradeSwFileName=").append(this.rbAuUpgradeSwFileName).append(", ");
        result.append("rbAuSetDefaults=").append(this.rbAuSetDefaults).append(", ");
        result.append("]");
        return result.toString();
    }

    public String getName() {
        return "RbAuCommand command";
    }

    public static RbAuCommand createResetCommand(RbBS bs, RbAuConfigEntry auEntry) {
        return RbAuCommand.createCommand(bs, auEntry, 2, null);
    }

    public static RbAuCommand createResetAndRunFromShadowCommand(RbBS bs, RbAuConfigEntry auEntry, String fileName) {
        return RbAuCommand.createCommand(bs, auEntry, 4, fileName);
    }

    public static RbAuCommand createMakeRunningVersionOperationalCommand(RbBS bs, RbAuConfigEntry auEntry, String fileName) {
        return RbAuCommand.createCommand(bs, auEntry, 5, fileName);
    }

    public static RbAuCommand createPutToShadowCommand(RbBS bs, RbAuConfigEntry auEntry, String fileName) {
        return RbAuCommand.createCommand(bs, auEntry, 3, fileName);
    }

    public static RbAuCommand createLoadFactoryDfltCommand(RbBS bs, RbAuConfigEntry auEntry) {
        return RbAuCommand.createDefaultsCommand(bs, auEntry, 2);
    }

    public static RbAuCommand createCommand(RbBS bs, RbAuConfigEntry auEntry, int commandOperation, String fileName) {
        RbAuCommand rbAuCommand = RbAuCommand.initCommand(bs, auEntry);
        rbAuCommand.setRbAuUnitControl(commandOperation);
        if (fileName != null) {
            rbAuCommand.setRbAuUpgradeSwFileName(fileName);
        }
        return rbAuCommand;
    }

    public static RbAuCommand createDefaultsCommand(RbBS bs, RbAuConfigEntry auEntry, int commandOperation) {
        RbAuCommand rbAuCommand = RbAuCommand.initCommand(bs, auEntry);
        rbAuCommand.setRbAuSetDefaults(commandOperation);
        return rbAuCommand;
    }

    private static RbAuCommand initCommand(RbBS bs, RbAuConfigEntry auEntry) {
        RbAuCommand rbAuCommand = new RbAuCommand();
        rbAuCommand.setEquipmentId(bs.getId());
        rbAuCommand.setRbSlotNumber(auEntry.getRbSlotNumber());
        return rbAuCommand;
    }

    public static RbAuCommand createResetCountersCommand(RbBS bs, RbAuConfigEntry auEntry) {
        RbAuCommand rbAuCommand = RbAuCommand.initCommand(bs, auEntry);
        return rbAuCommand;
    }
}

