/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb;

import com.bwanms.validation.IPAddressValidator;
import java.io.IOException;
import java.util.HashSet;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IPFilter
implements Filter {
    public static final String IPFILTER_PROPERTY = "com.ngnms.ws.ipfilter";
    private Logger log = Logger.getLogger(IPFilter.class);
    private HashSet<String> cacheIPs = null;
    private boolean allowAll = false;

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("Web service client address " + request.getRemoteAddr()));
        }
        this.configureIPs();
        if (this.isIPAddressAllowed(request.getRemoteAddr())) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Web service client IP allowed: " + request.getRemoteAddr()));
            }
        } else {
            if (this.log.isEnabledFor((Priority)Level.WARN)) {
                this.log.warn((Object)"");
                this.log.warn((Object)("Web service client IP " + request.getRemoteAddr() + " not allowed !!!"));
                this.log.warn((Object)"");
            }
            throw new ServletException("Web service client IP " + request.getRemoteAddr() + " not allowed");
        }
        chain.doFilter(request, response);
    }

    protected boolean isIPAddressAllowed(String ipAddress) {
        return this.allowAll || null == this.cacheIPs || this.cacheIPs.contains(ipAddress);
    }

    protected void configureIPs() {
        if (this.cacheIPs == null && !this.allowAll) {
            String ipFilterProperty = System.getProperty(IPFILTER_PROPERTY);
            if ("*".equals(ipFilterProperty) || "any".equalsIgnoreCase(ipFilterProperty)) {
                this.log.info((Object)"configure web service: allow access to all IPs");
                this.allowAll = true;
            } else if (ipFilterProperty != null) {
                this.log.info((Object)("configure web service IPs from " + ipFilterProperty));
                this.cacheIPs = new HashSet();
                IPAddressValidator validator = new IPAddressValidator();
                String[] ips = ipFilterProperty.split(",");
                for (int i = 0; i < ips.length; ++i) {
                    if (validator.isValid((Object)ips[i])) {
                        this.cacheIPs.add(ips[i]);
                        continue;
                    }
                    this.log.error((Object)("invalid IP: " + ips[i]));
                }
            } else {
                this.log.info((Object)"System property \"com.ngnms.ws.ipfilter\" is null or not set!");
            }
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    protected HashSet<String> getCacheIPs() {
        return this.cacheIPs;
    }

    protected boolean isAllowAll() {
        return this.allowAll;
    }
}

