/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.tftp.server;

import com.bwanms.tftp.server.TFTPRequestTask;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import org.apache.commons.net.tftp.TFTP;
import org.apache.commons.net.tftp.TFTPAckPacket;
import org.apache.commons.net.tftp.TFTPDataPacket;
import org.apache.commons.net.tftp.TFTPErrorPacket;
import org.apache.commons.net.tftp.TFTPPacket;
import org.apache.log4j.Logger;

public class TFTPWriteRequestTask
extends TFTPRequestTask {
    private static final Logger log = Logger.getLogger(TFTPWriteRequestTask.class);

    public TFTPWriteRequestTask(InetAddress inetAddress, InetAddress inetAddress2, int n, String string, int n2) {
        super(inetAddress, inetAddress2, n, string, n2);
    }

    protected void handleRequest(TFTP tFTP) throws Exception {
        log.info((Object)("Start handling write request : " + this.filename));
        File file = new File(this.filename);
        if (!file.exists() || !file.canWrite()) {
            TFTPErrorPacket tFTPErrorPacket = new TFTPErrorPacket(this.addr, this.port, 2, "Access violation");
            tFTP.send(tFTPErrorPacket);
            log.error((Object)("Transfer aborted : " + tFTPErrorPacket.getMessage()));
            return;
        }
        boolean bl = false;
        int n = 0;
        TFTPAckPacket tFTPAckPacket = new TFTPAckPacket(this.addr, this.port, n);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        boolean bl2 = false;
        while (true) {
            TFTPPacket tFTPPacket;
            tFTP.send(tFTPAckPacket);
            if (bl) break;
            if (n < 65535) {
                ++n;
                bl2 = false;
            } else {
                n = 0;
                bl2 = true;
            }
            tFTPAckPacket.setBlockNumber(n);
            TFTPPacket tFTPPacket2 = tFTP.receive();
            if (tFTPPacket2.getType() != 3) {
                log.error((Object)"Transfer aborted : wrong packet type");
                tFTPPacket = new TFTPErrorPacket(this.addr, this.port, 0, "Wrong packet type");
                tFTP.send(tFTPPacket);
                ((OutputStream)bufferedOutputStream).close();
                bufferedOutputStream = null;
                return;
            }
            tFTPPacket = (TFTPDataPacket)tFTPPacket2;
            if (((TFTPDataPacket)tFTPPacket).getDataLength() < 1) break;
            if (((TFTPDataPacket)tFTPPacket).getBlockNumber() != n) continue;
            ((OutputStream)bufferedOutputStream).write(((TFTPDataPacket)tFTPPacket).getData(), ((TFTPDataPacket)tFTPPacket).getDataOffset(), ((TFTPDataPacket)tFTPPacket).getDataLength());
            if (((TFTPDataPacket)tFTPPacket).getDataLength() >= 512) continue;
            bl = true;
        }
        ((OutputStream)bufferedOutputStream).flush();
        ((OutputStream)bufferedOutputStream).close();
        bufferedOutputStream = null;
        log.info((Object)"File received successfully");
    }
}

