/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.tftp.server;

import com.bwanms.tftp.server.TFTPReadRequestTask;
import com.bwanms.tftp.server.TFTPRequestExecutor;
import com.bwanms.tftp.server.TFTPRequestListener;
import com.bwanms.tftp.server.TFTPRequestTask;
import com.bwanms.tftp.server.TFTPWriteRequestTask;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Random;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.net.tftp.TFTP;
import org.apache.commons.net.tftp.TFTPPacket;
import org.apache.commons.net.tftp.TFTPPacketException;
import org.apache.commons.net.tftp.TFTPRequestPacket;
import org.apache.log4j.Logger;

public class TFTPServer
extends TFTP
implements Runnable {
    private static final Logger log = Logger.getLogger(TFTPServer.class);
    private static final int PORT_ALLOC_MAX_TRIES = 100;
    private InetAddress address = null;
    private int port = -1;
    private String rootDir = null;
    private TFTPRequestExecutor reqExecutor = null;
    private TFTPRequestListener reqListener = null;
    private AtomicBoolean stopFlag = null;
    private static final PortGenerator portGen = new PortGenerator(1024, 32768, PortGenerator.Method.random);

    public TFTPServer() throws UnknownHostException {
        this(InetAddress.getLocalHost(), 69, System.getProperty("user.dir"));
    }

    public TFTPServer(InetAddress inetAddress, int n, String string) {
        this.setDefaultTimeout(0);
        this.address = inetAddress;
        this.port = n;
        this.rootDir = string;
        this.reqExecutor = new TFTPRequestExecutor(10, 20, 5L, TimeUnit.SECONDS, new EmptyBlockingQueue(1));
        this.reqListener = new TFTPRequestListener(this);
        this.stopFlag = new AtomicBoolean(false);
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public void setAddress(InetAddress inetAddress) {
        this.address = inetAddress;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public String getRootDir() {
        return this.rootDir;
    }

    public void setRootDir(String string) {
        this.rootDir = string;
    }

    public boolean start() throws Exception {
        log.info((Object)("Starting TFTP Server on " + this.address.getHostAddress() + "/" + this.port + " ..."));
        if (this.isStarted()) {
            log.warn((Object)"TFTP Server already started!");
            return false;
        }
        this.open(this.port, this.address);
        this.stopFlag.set(false);
        this.reqExecutor.prestartAllCoreThreads();
        this.reqListener.start();
        log.info((Object)"TFTP Server started");
        return true;
    }

    public void stop() throws Exception {
        log.info((Object)"Stopping TFTP Server ...");
        this.stopFlag.set(true);
        this.reqExecutor.shutdown();
        if (this.reqExecutor.getActiveCount() > 0) {
            log.info((Object)"Wait pending transfers to finish...");
            while (!this.reqExecutor.awaitTermination(5L, TimeUnit.SECONDS)) {
            }
        }
        if (this.isOpen()) {
            this.close();
        }
        this.reqListener.join(5000L);
        log.info((Object)"TFTP Server stopped");
    }

    public boolean isStarted() {
        return this.isOpen() && this.reqListener.isAlive();
    }

    public boolean isRunning() {
        return this.isOpen() && this.reqListener.isAlive() && this.stopFlag.get();
    }

    public void run() {
        while (!this.stopFlag.get()) {
            TFTPPacket tFTPPacket = null;
            try {
                tFTPPacket = this.receive();
                try {
                    if (!(tFTPPacket instanceof TFTPRequestPacket)) continue;
                    this.dispatchRequest((TFTPRequestPacket)tFTPPacket);
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    log.error((Object)("Request cannot be processed : " + rejectedExecutionException.getMessage()), (Throwable)rejectedExecutionException);
                }
            }
            catch (SocketTimeoutException socketTimeoutException) {
                log.warn((Object)socketTimeoutException.getMessage(), (Throwable)socketTimeoutException);
            }
            catch (InterruptedIOException interruptedIOException) {
                log.warn((Object)interruptedIOException.getMessage(), (Throwable)interruptedIOException);
            }
            catch (SocketException socketException) {
                log.warn((Object)socketException.getMessage(), (Throwable)socketException);
            }
            catch (IOException iOException) {
                log.warn((Object)iOException.getMessage(), (Throwable)iOException);
            }
            catch (TFTPPacketException tFTPPacketException) {
                log.warn((Object)tFTPPacketException.getMessage(), (Throwable)tFTPPacketException);
            }
            catch (Exception exception) {
                log.error((Object)exception, (Throwable)exception);
                this.stopFlag.set(true);
            }
        }
    }

    protected void finalize() throws Throwable {
        if (this.isStarted() && !this.stopFlag.get()) {
            this.stop();
        }
    }

    protected void dispatchRequest(TFTPRequestPacket tFTPRequestPacket) {
        switch (tFTPRequestPacket.getType()) {
            case 1: {
                this.submitRequestTask(new TFTPReadRequestTask(tFTPRequestPacket.getAddress(), this.address, tFTPRequestPacket.getPort(), this.rootDir + "/" + tFTPRequestPacket.getFilename(), tFTPRequestPacket.getMode()));
                break;
            }
            case 2: {
                this.submitRequestTask(new TFTPWriteRequestTask(tFTPRequestPacket.getAddress(), this.address, tFTPRequestPacket.getPort(), this.rootDir + "/" + tFTPRequestPacket.getFilename(), tFTPRequestPacket.getMode()));
                break;
            }
            default: {
                log.warn((Object)("TFTP server expects only request packets on port " + this.port));
            }
        }
    }

    protected void submitRequestTask(TFTPRequestTask tFTPRequestTask) {
        this.reqExecutor.execute(tFTPRequestTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TFTP newSession(InetAddress inetAddress) throws SocketException {
        TFTP tFTP = new TFTP();
        InetAddress inetAddress2 = inetAddress;
        synchronized (inetAddress2) {
            int n = 0;
            do {
                if (++n > 100) {
                    throw new SocketException("Failed to find a free port after 100 tries.");
                }
                try {
                    int n2 = portGen.generate();
                    log.info((Object)("Try to open TFTP session on port " + n2));
                    tFTP.open(n2, inetAddress);
                    log.info((Object)"Succeeded to open TFTP session");
                }
                catch (BindException bindException) {
                    log.warn((Object)("Failed to open TFTP session : " + bindException.getMessage()));
                }
            } while (!tFTP.isOpen());
        }
        return tFTP;
    }

    public static String reqTypeAsString(int n) {
        String string = "";
        switch (n) {
            case 1: {
                string = "RRQ";
                break;
            }
            case 2: {
                string = "WRQ";
            }
        }
        return string;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EmptyBlockingQueue<E>
    extends LinkedBlockingQueue<Runnable> {
        public EmptyBlockingQueue(int n) {
            super(n);
        }

        @Override
        public boolean offer(Runnable runnable, long l, TimeUnit timeUnit) throws InterruptedException {
            return false;
        }

        @Override
        public boolean offer(Runnable runnable) {
            return false;
        }
    }

    private static final class PortGenerator {
        int basePort;
        int maxPorts;
        Method method;
        Increment incr = new Increment(0);
        Random random = new Random(System.currentTimeMillis());

        public PortGenerator(int n, int n2, Method method) {
            this.basePort = n;
            this.maxPorts = n2;
            this.method = method;
        }

        public int generate() {
            int n = 0;
            switch (this.method) {
                case incremental: {
                    n = this.incr.nextInt();
                    break;
                }
                case random: {
                    n = Math.abs(this.random.nextInt());
                }
            }
            return this.basePort + n % (this.maxPorts - this.basePort);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum Method {
            incremental,
            random;

        }

        class Increment {
            int next;

            public Increment(int n) {
                this.next = n;
            }

            public int nextInt() {
                int n = this.next++;
                return n;
            }
        }
    }
}

