/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.tftp.server;

import com.bwanms.tftp.server.TFTPRequestTask;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.net.InetAddress;
import java.util.BitSet;
import org.apache.commons.net.tftp.TFTP;
import org.apache.commons.net.tftp.TFTPAckPacket;
import org.apache.commons.net.tftp.TFTPDataPacket;
import org.apache.commons.net.tftp.TFTPErrorPacket;
import org.apache.commons.net.tftp.TFTPPacket;
import org.apache.log4j.Logger;

public class TFTPReadRequestTask
extends TFTPRequestTask {
    private static final Logger log = Logger.getLogger(TFTPReadRequestTask.class);

    public TFTPReadRequestTask(InetAddress inetAddress, InetAddress inetAddress2, int n, String string, int n2) {
        super(inetAddress, inetAddress2, n, string, n2);
    }

    protected void handleRequest(TFTP tFTP) throws Exception {
        TFTPPacket tFTPPacket;
        TFTPDataPacket tFTPDataPacket;
        log.info((Object)("Start handling read request : " + this.filename));
        File file = new File(this.filename);
        if (!file.exists() || file.isDirectory() || !file.canRead()) {
            TFTPErrorPacket tFTPErrorPacket = new TFTPErrorPacket(this.addr, this.port, 2, "File not found");
            tFTP.send(tFTPErrorPacket);
            log.error((Object)("Transfer aborted : " + tFTPErrorPacket.getMessage()));
            return;
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        byte[] byArray = new byte[512];
        int n = 0;
        int n2 = 1;
        BitSet bitSet = new BitSet();
        int n3 = 1;
        for (long i = file.length(); i > 0L; i -= (long)n) {
            n = bufferedInputStream.read(byArray);
            tFTPDataPacket = new TFTPDataPacket(this.addr, this.port, n2, byArray, 0, n);
            tFTP.send(tFTPDataPacket);
            log.debug((Object)String.format("DATA : %d", n2));
            tFTPPacket = null;
            boolean bl = false;
            boolean bl2 = true;
            do {
                TFTPPacket tFTPPacket2;
                if ((tFTPPacket2 = tFTP.receive()).getType() != 4) {
                    log.error((Object)"Transfer aborted : wrong packet type");
                    TFTPErrorPacket tFTPErrorPacket = new TFTPErrorPacket(this.addr, this.port, 0, "Wrong packet type");
                    tFTP.send(tFTPErrorPacket);
                    bufferedInputStream.close();
                    bufferedInputStream = null;
                    return;
                }
                tFTPPacket = (TFTPAckPacket)tFTPPacket2;
                log.debug((Object)String.format("ACK : %d", ((TFTPAckPacket)tFTPPacket).getBlockNumber()));
                int n4 = n2 - ((TFTPAckPacket)tFTPPacket).getBlockNumber();
                if (n4 != 1 && (!bl || n4 != -65535)) continue;
                log.debug((Object)("DETECT LOST PACKET : " + n2));
                if (bitSet.get(n3)) continue;
                log.debug((Object)("RETRANSMIT DATA PACKET : " + n2));
                tFTP.send(tFTPDataPacket);
                bitSet.set(n3);
            } while (bl2 = n2 != ((TFTPAckPacket)tFTPPacket).getBlockNumber());
            if (n2 == 65535) {
                n2 = 0;
                bl = true;
            } else {
                ++n2;
                bl = false;
            }
            ++n3;
        }
        if (n == 512) {
            tFTPDataPacket = new TFTPDataPacket(this.addr, this.port, n2, byArray, 0, 0);
            tFTP.send(tFTPDataPacket);
            tFTPPacket = tFTP.receive();
            if (tFTPPacket.getType() != 4) {
                log.error((Object)"Transfer aborted : wrong packet type");
                TFTPErrorPacket tFTPErrorPacket = new TFTPErrorPacket(this.addr, this.port, 0, "Wrong packet type");
                tFTP.send(tFTPErrorPacket);
            }
        }
        bufferedInputStream.close();
        bufferedInputStream = null;
        log.info((Object)"File sent successfully");
    }
}

