/*
 * Decompiled with CFR 0.152.
 */
package inetsoft.report.lens.teaset;

import inetsoft.report.Presenter;
import inetsoft.report.TableLens;
import inetsoft.report.lens.AbstractTableLens;
import inetsoft.report.lens.AttributeTableLens;
import inetsoft.report.painter.ButtonPresenter;
import inetsoft.report.painter.PresenterPainter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import tea.set.SuperGrid;

public class SuperGridLens
extends AttributeTableLens {
    boolean header3d = false;

    public SuperGridLens(SuperGrid superGrid) {
        this.setTable((TableLens)new Table(superGrid));
    }

    public boolean isShow3DHeader() {
        return this.header3d;
    }

    public void setShow3DHeader(boolean bl) {
        this.header3d = bl;
    }

    class Table
    extends AbstractTableLens {
        private SuperGrid grid;

        public Table(SuperGrid superGrid) {
            this.grid = superGrid;
        }

        public int getAlignment(int n, int n2) {
            if (n < this.grid.getHeaderRowCount() || n2 < this.grid.getHeaderColCount()) {
                return 0;
            }
            return this.grid.getAlignment(n - this.grid.getHeaderRowCount(), n2 - this.grid.getHeaderColCount());
        }

        public Color getBackground(int n, int n2) {
            if (n < this.grid.getHeaderRowCount()) {
                return Color.lightGray;
            }
            Color color = this.grid.getBackground(n - this.grid.getHeaderRowCount(), n2 - this.grid.getHeaderColCount());
            return !color.equals(this.grid.getBackground()) ? color : null;
        }

        public int getColBorder(int n, int n2) {
            if (n2 == -1) {
                return this.getColBorder(n, this.getColCount() - 1);
            }
            int n3 = this.grid.getRuling(n - this.grid.getHeaderRowCount(), n2 - this.grid.getHeaderColCount());
            if ((n3 & 2) == 0) {
                return 0;
            }
            switch (this.grid.get3D()) {
                case 0: {
                    return 4097;
                }
                case 1: 
                case 8: {
                    return 24578;
                }
                case 2: 
                case 16: {
                    return 40962;
                }
                case 4: {
                    return 4113;
                }
            }
            return 0;
        }

        public Color getColBorderColor(int n, int n2) {
            return Color.gray;
        }

        public int getColCount() {
            return this.grid.getColCount() + this.grid.getHeaderColCount();
        }

        public int getColWidth(int n) {
            return this.grid.getColWidth(n - this.grid.getHeaderColCount());
        }

        public Font getFont(int n, int n2) {
            return this.grid.getFont(n - this.grid.getHeaderRowCount(), n2 - this.grid.getHeaderColCount());
        }

        public Color getForeground(int n, int n2) {
            return this.grid.getForeground(n - this.grid.getHeaderRowCount(), n2 - this.grid.getHeaderColCount());
        }

        public int getHeaderColCount() {
            return this.grid.getHeaderColCount();
        }

        public int getHeaderRowCount() {
            return this.grid.getHeaderRowCount();
        }

        public Insets getInsets(int n, int n2) {
            return this.grid.getGap(n - this.grid.getHeaderRowCount(), n2 - this.grid.getHeaderColCount());
        }

        public Object getObject(int n, int n2) {
            if (n < this.grid.getHeaderRowCount() || n2 < this.grid.getHeaderColCount()) {
                String string = this.grid.getHeader(n - this.grid.getHeaderRowCount(), n2 - this.grid.getHeaderColCount());
                if (SuperGridLens.this.header3d) {
                    return new PresenterPainter((Object)string, (Presenter)new ButtonPresenter());
                }
                return string;
            }
            return this.grid.getObject(n - this.grid.getHeaderRowCount(), n2 - this.grid.getHeaderColCount());
        }

        public int getRowBorder(int n, int n2) {
            if (n == -1) {
                return this.getRowBorder(this.getRowCount() - 1, n2);
            }
            int n3 = this.grid.getRuling(n - this.grid.getHeaderRowCount(), n2 - this.grid.getHeaderColCount());
            if ((n3 & 1) == 0) {
                return 0;
            }
            switch (this.grid.get3D()) {
                case 0: {
                    return 4097;
                }
                case 1: 
                case 8: {
                    return 24578;
                }
                case 2: 
                case 16: {
                    return 40962;
                }
                case 4: {
                    return 4113;
                }
            }
            return 0;
        }

        public Color getRowBorderColor(int n, int n2) {
            return Color.gray;
        }

        public int getRowCount() {
            return this.grid.getRowCount() + this.grid.getHeaderRowCount();
        }

        public int getRowHeight(int n) {
            return this.grid.getRowHeight(n - this.grid.getHeaderRowCount()) + 2;
        }

        public Dimension getSpan(int n, int n2) {
            return this.grid.getSpanning(n - this.grid.getHeaderRowCount(), n2 - this.grid.getHeaderColCount());
        }
    }
}

