/*
 * Decompiled with CFR 0.152.
 */
package inetsoft.report.j2d;

import inetsoft.report.Margin;
import inetsoft.report.ReportEnv;
import inetsoft.report.StyleSheet;
import inetsoft.report.internal.j2d.Win9xGraphics2D;
import inetsoft.report.j2d.StyleBook;
import inetsoft.report.j2d.StylePrintable;
import java.awt.Graphics;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;

public class Win9xPrinterJob
extends PrinterJob {
    Win9xGraphics2D wing;
    Printable painter = null;
    Pageable book = null;
    PageFormat format = new PageFormat();
    int copies = 1;
    String jobname = "Report";
    boolean cancelled = false;
    PrinterJob defJob = PrinterJob.getPrinterJob();

    public Win9xPrinterJob() {
        this.wing = Win9xGraphics2D.getGraphics(null);
        if (this.wing == null) {
            throw new RuntimeException("Unable to initialize Win9xGraphics2D");
        }
        this.wing.setPrinterJob(this);
    }

    public Win9xPrinterJob(String string) {
        this.wing = Win9xGraphics2D.getGraphics(string);
        if (this.wing == null) {
            throw new RuntimeException("Unable to initialize Win9xGraphics2D");
        }
        this.wing.setPrinterJob(this);
    }

    public void cancel() {
        this.cancelled = true;
    }

    public PageFormat defaultPage(PageFormat pageFormat) {
        return (PageFormat)pageFormat.clone();
    }

    public int getCopies() {
        return this.copies;
    }

    public String getJobName() {
        return this.jobname;
    }

    public String getUserName() {
        try {
            return ReportEnv.getProperty((String)"user.name");
        }
        catch (Exception exception) {
            return "Unknown";
        }
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public PageFormat pageDialog(PageFormat pageFormat) {
        return this.defJob.pageDialog(pageFormat);
    }

    public void print() throws PrinterException {
        this.wing.startDoc(this.getJobName());
        Margin margin = StyleSheet.getPrinterMargin();
        if (this.book != null) {
            if (this.book instanceof StyleBook) {
                StyleSheet.setPrinterMargin((Margin)((StyleBook)this.book).getMargin());
            }
            int n = this.wing.isPages() ? this.wing.getFromPage() : 1;
            int n2 = this.wing.isPages() ? this.wing.getToPage() : this.book.getNumberOfPages();
            int n3 = Math.max(1, n);
            while (n3 <= n2) {
                int n4 = n3 - 1;
                PageFormat pageFormat = this.book.getPageFormat(n4);
                this.wing.setOrientation(pageFormat.getOrientation());
                this.wing.startPage();
                this.book.getPrintable(n4).print((Graphics)((Object)this.wing), pageFormat, n3);
                this.wing.dispose();
                ++n3;
            }
        } else if (this.painter != null) {
            this.wing.setOrientation(this.format.getOrientation());
            if (this.painter instanceof StylePrintable) {
                StyleSheet.setPrinterMargin((Margin)((StylePrintable)this.painter).getMargin());
            }
            int n = 0;
            while (this.painter.print((Graphics)((Object)this.wing), this.format, n) != 1) {
                this.wing.dispose();
                ++n;
            }
        }
        StyleSheet.setPrinterMargin((Margin)margin);
        this.wing.close();
    }

    public boolean printDialog() {
        boolean bl;
        int n = -1;
        if (this.book != null) {
            n = this.book.getNumberOfPages();
        }
        if (bl = this.wing.printDialog(n)) {
            this.copies = this.wing.getCopies();
        }
        return bl;
    }

    public void setCopies(int n) {
        this.copies = n;
        this.wing.setCopies(n);
    }

    public void setJobName(String string) {
        this.jobname = string;
    }

    public void setPageable(Pageable pageable) throws NullPointerException {
        this.book = pageable;
    }

    public void setPrintable(Printable printable) {
        this.painter = printable;
    }

    public void setPrintable(Printable printable, PageFormat pageFormat) {
        this.setPrintable(printable);
        this.format = pageFormat;
    }

    public void setTray(int n) {
        this.wing.setTray(n);
    }

    public PageFormat validatePage(PageFormat pageFormat) {
        return pageFormat;
    }
}

