/*
 * Decompiled with CFR 0.152.
 */
package inetsoft.report.j2d;

import inetsoft.report.Margin;
import inetsoft.report.PreviewPane;
import inetsoft.report.StyleSheet;
import inetsoft.report.io.Builder;
import inetsoft.report.j2d.JPreviewer;
import inetsoft.report.j2d.PreviewPane2D;
import inetsoft.report.j2d.StyleBook;
import inetsoft.report.j2d.StylePrinter;
import inetsoft.report.locale.Catalog;
import java.awt.Component;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterJob;
import java.io.FileInputStream;
import java.io.InputStream;

public class Previewer2D
extends JPreviewer {
    PrinterJob printjob2D;
    Margin pmargin = StyleSheet.getPrinterMargin();

    public Previewer2D() {
        super(Catalog.getString((String)"Print Preview"));
    }

    public Previewer2D(String string) {
        super(string);
    }

    public Previewer2D(String string, int n, int n2) {
        super(string);
    }

    public Previewer2D(String string, PrinterJob printerJob, boolean bl) {
        super(string, bl);
        this.printjob2D = printerJob;
        PageFormat pageFormat = printerJob.defaultPage();
        this.setPageWidth(pageFormat.getWidth() / 72.0);
        this.setPageHeight(pageFormat.getHeight() / 72.0);
        this.setPageResolution(72);
    }

    public Previewer2D(String string, boolean bl) {
        super(string, bl);
    }

    protected PreviewPane createPane() {
        return new PreviewPane2D();
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.err.println("Usage: java inetsoft.report.j2d.Previewer2D report-file");
            System.exit(1);
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(stringArray[0]);
            Builder builder = Builder.getBuilder((int)2, (InputStream)fileInputStream);
            StyleSheet styleSheet = builder.read(".");
            Previewer2D previewer2D = new Previewer2D();
            previewer2D.setExitOnClose(true);
            previewer2D.pack();
            ((Component)previewer2D).setVisible(true);
            previewer2D.print(styleSheet);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void printAction() {
        if (this.sheet == null) {
            return;
        }
        PrinterJob printerJob = this.printjob2D;
        if (printerJob == null) {
            printerJob = StylePrinter.getPrinterJob();
        }
        Paper paper = new Paper();
        PageFormat pageFormat = printerJob.defaultPage();
        if (this.getOrientation() == 1) {
            paper.setSize(this.getPageWidth() * 72.0, this.getPageHeight() * 72.0);
        } else {
            paper.setSize(this.getPageHeight() * 72.0, this.getPageWidth() * 72.0);
        }
        paper.setImageableArea(this.pmargin.left * 72.0, this.pmargin.top * 72.0, paper.getWidth() - (this.pmargin.left + this.pmargin.right) * 72.0, paper.getHeight() - (this.pmargin.top + this.pmargin.bottom) * 72.0);
        pageFormat.setOrientation(this.getOrientation());
        pageFormat.setPaper(paper);
        printerJob.setPageable(new StyleBook(this.sheet, pageFormat));
        if (printerJob.printDialog()) {
            final PrinterJob printerJob2 = printerJob;
            new Thread(){

                public void run() {
                    try {
                        pane.showStatus(String.valueOf(Catalog.getString((String)"Printing")) + "...");
                        printerJob2.print();
                        pane.showStatus("");
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }.start();
        }
    }
}

