/*
 * Decompiled with CFR 0.152.
 */
package inetsoft.report.j2d;

import inetsoft.report.Margin;
import inetsoft.report.ReportEnv;
import inetsoft.report.StyleSheet;
import inetsoft.report.internal.j2d.PSGraphics2D;
import inetsoft.report.internal.j2d.PrintDialog;
import inetsoft.report.j2d.StyleBook;
import inetsoft.report.j2d.StylePrintable;
import java.awt.Component;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.FileOutputStream;
import java.io.OutputStream;

public class PSPrinterJob
extends PrinterJob {
    PSGraphics2D psg;
    Printable painter = null;
    Pageable book = null;
    PageFormat format = new PageFormat();
    int copies = 1;
    String jobname = "Report";
    String printer = "";
    String printOption = "";
    String file = "report.ps";
    boolean toFile = false;
    boolean cancelled = false;
    PrinterJob defJob = PrinterJob.getPrinterJob();

    public PSPrinterJob() {
        this.psg = PSGraphics2D.getGraphics();
        if (this.psg == null) {
            throw new RuntimeException("Unable to initialize PSGraphics2D");
        }
        this.psg.setPrinterJob(this);
    }

    public void cancel() {
        this.cancelled = true;
    }

    public PageFormat defaultPage(PageFormat pageFormat) {
        return (PageFormat)pageFormat.clone();
    }

    public int getCopies() {
        return this.copies;
    }

    public String getFile() {
        return this.file;
    }

    public String getJobName() {
        return this.jobname;
    }

    public String getPrinter() {
        return this.printer;
    }

    public String getUserName() {
        try {
            return ReportEnv.getProperty((String)"user.name");
        }
        catch (Exception exception) {
            return "Unknown";
        }
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public boolean isPrintToFile() {
        return this.toFile;
    }

    public PageFormat pageDialog(PageFormat pageFormat) {
        return this.defJob.pageDialog(pageFormat);
    }

    public void print() throws PrinterException {
        Object object;
        OutputStream outputStream = null;
        try {
            if (this.toFile) {
                outputStream = new FileOutputStream(this.file);
            } else {
                object = "lp -n" + this.getCopies();
                if (this.getPrinter() != null && this.getPrinter().length() > 0) {
                    object = String.valueOf(object) + " -d\"" + this.getPrinter() + "\"";
                }
                if (this.printOption != null && this.printOption.length() > 0) {
                    object = String.valueOf(object) + " " + this.printOption;
                }
                Process process = Runtime.getRuntime().exec((String)object);
                outputStream = process.getOutputStream();
            }
        }
        catch (Exception exception) {
            throw new PrinterException(exception.toString());
        }
        object = StyleSheet.getPrinterMargin();
        if (this.book != null) {
            if (this.book instanceof StyleBook) {
                StyleSheet.setPrinterMargin((Margin)((StyleBook)this.book).getMargin());
            }
            int n = 1;
            int n2 = this.book.getNumberOfPages();
            int n3 = n;
            while (n3 <= n2) {
                int n4 = n3 - 1;
                PageFormat pageFormat = this.book.getPageFormat(n4);
                if (pageFormat.getOrientation() == 0) {
                    this.psg.setPageSize(pageFormat.getPaper().getHeight() / 72.0, pageFormat.getPaper().getWidth() / 72.0);
                } else {
                    this.psg.setPageSize(pageFormat.getPaper().getWidth() / 72.0, pageFormat.getPaper().getHeight() / 72.0);
                }
                this.psg.setOrientation(pageFormat.getOrientation());
                if (n3 == n) {
                    this.psg.startDoc(outputStream);
                }
                this.psg.reset();
                this.book.getPrintable(n4).print(this.psg, pageFormat, n3);
                this.psg.dispose();
                ++n3;
            }
        } else if (this.painter != null) {
            if (this.painter instanceof StylePrintable) {
                StyleSheet.setPrinterMargin((Margin)((StylePrintable)this.painter).getMargin());
            }
            if (this.format.getOrientation() == 0) {
                this.psg.setPageSize(this.format.getPaper().getHeight() / 72.0, this.format.getPaper().getWidth() / 72.0);
            } else {
                this.psg.setPageSize(this.format.getPaper().getWidth() / 72.0, this.format.getPaper().getHeight() / 72.0);
            }
            this.psg.setOrientation(this.format.getOrientation());
            this.psg.startDoc(outputStream);
            int n = 0;
            while (true) {
                this.psg.reset();
                if (this.painter.print(this.psg, this.format, n) == 1) break;
                this.psg.dispose();
                ++n;
            }
        }
        StyleSheet.setPrinterMargin((Margin)object);
        this.psg.close();
    }

    public boolean printDialog() {
        PrintDialog printDialog = new PrintDialog();
        printDialog.setCopies(this.copies);
        printDialog.setPrinter(this.printer);
        printDialog.setFile(this.file);
        printDialog.setPrintToFile(this.toFile);
        printDialog.setPrintOption(this.printOption);
        printDialog.setTitle(this.jobname);
        printDialog.pack();
        ((Component)printDialog).setVisible(true);
        boolean bl = printDialog.isOK();
        if (bl) {
            this.copies = printDialog.getCopies();
            this.printer = printDialog.getPrinter();
            this.file = printDialog.getFile();
            this.toFile = printDialog.isPrintToFile();
            this.printOption = printDialog.getPrintOption();
            this.jobname = printDialog.getTitle();
        }
        return bl;
    }

    public void setCopies(int n) {
        this.copies = n;
    }

    public void setFile(String string) {
        this.file = string;
    }

    public void setJobName(String string) {
        this.jobname = string;
    }

    public void setPageable(Pageable pageable) throws NullPointerException {
        this.book = pageable;
    }

    public void setPrintToFile(boolean bl) {
        this.toFile = bl;
    }

    public void setPrintable(Printable printable) {
        this.painter = printable;
    }

    public void setPrintable(Printable printable, PageFormat pageFormat) {
        this.setPrintable(printable);
        this.format = pageFormat;
    }

    public void setPrinter(String string) {
        this.printer = string;
    }

    public PageFormat validatePage(PageFormat pageFormat) {
        return pageFormat;
    }
}

