/*
 * Decompiled with CFR 0.152.
 */
package inetsoft.report.j2d;

import inetsoft.report.Margin;
import inetsoft.report.StyleSheet;
import inetsoft.report.j2d.StyleBook;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;

public class N_UpBook
extends Book {
    private static final int ROTATE = 256;
    private static final int UPMASK = 255;
    public static final int N_2_UP = 258;
    public static final int N_4_UP = 4;
    public static final int N_6_UP = 262;
    public static final int N_9_UP = 9;
    public static final int N_16_UP = 16;
    double w;
    double h;
    int nrow;
    int ncol;
    int nup;
    double scale;
    StyleBook book;

    public N_UpBook(StyleSheet styleSheet, PageFormat pageFormat, int n) {
        this.nup = n;
        pageFormat.setOrientation(1);
        PageFormat pageFormat2 = (PageFormat)pageFormat.clone();
        pageFormat2.setOrientation((n & 0x100) != 0 ? 0 : 1);
        double d = pageFormat2.getImageableWidth();
        double d2 = pageFormat2.getImageableHeight();
        double d3 = pageFormat2.getImageableX();
        double d4 = pageFormat2.getImageableY();
        switch (n) {
            case 258: {
                this.nrow = 1;
                this.ncol = 2;
                break;
            }
            case 4: {
                this.ncol = 2;
                this.nrow = 2;
                break;
            }
            case 262: {
                this.nrow = 2;
                this.ncol = 3;
                break;
            }
            case 9: {
                this.ncol = 3;
                this.nrow = 3;
                break;
            }
            case 16: {
                this.ncol = 4;
                this.nrow = 4;
                break;
            }
            default: {
                throw new UnsupportedOperationException("N-Up operation not supported: " + n);
            }
        }
        this.w = (d - (double)(this.ncol - 1) * (d3 /= (double)this.ncol)) / (double)this.ncol;
        this.h = (d2 - (double)(this.nrow - 1) * (d4 /= (double)this.nrow)) / (double)this.nrow;
        this.scale = Math.min(this.w / d, this.h / d2);
        this.w = this.scale * pageFormat.getWidth();
        this.h = this.scale * pageFormat.getHeight();
        this.book = new StyleBook(styleSheet, pageFormat);
        int n2 = (int)Math.ceil((float)this.book.getNumberOfPages() / (float)(n & 0xFF));
        int n3 = 0;
        while (n3 < n2) {
            this.append(new NupPage(n3), pageFormat2);
            ++n3;
        }
    }

    class NupPage
    implements Printable {
        int pi;

        public NupPage(int n) {
            this.pi = n * (N_UpBook.this.nup & 0xFF);
        }

        public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
            Graphics2D graphics2D = (Graphics2D)graphics;
            double d = pageFormat.getImageableWidth() / (double)N_UpBook.this.ncol;
            double d2 = pageFormat.getImageableHeight() / (double)N_UpBook.this.nrow;
            double d3 = (d - N_UpBook.this.w) / 2.0 + pageFormat.getImageableX();
            double d4 = (d2 - N_UpBook.this.h) / 2.0 + pageFormat.getImageableY();
            Margin margin = N_UpBook.this.book.getMargin();
            if ((N_UpBook.this.nup & 0x100) != 0) {
                d3 -= margin.top * 72.0 * (1.0 - N_UpBook.this.scale);
                d4 -= margin.left * 72.0 * (1.0 - N_UpBook.this.scale);
            } else {
                d3 -= margin.left * 72.0 * (1.0 - N_UpBook.this.scale);
                d4 -= margin.top * 72.0 * (1.0 - N_UpBook.this.scale);
            }
            int n2 = 0;
            while (n2 < (N_UpBook.this.nup & 0xFF) && this.pi + n2 < N_UpBook.this.book.getNumberOfPages()) {
                int n3 = n2 / N_UpBook.this.ncol;
                int n4 = n2 % N_UpBook.this.ncol;
                Rectangle2D.Double double_ = new Rectangle2D.Double((double)n4 * d + d3, (double)n3 * d2 + d4, N_UpBook.this.w, N_UpBook.this.h);
                Graphics2D graphics2D2 = (Graphics2D)graphics.create();
                graphics2D2.clip(double_);
                graphics2D2.translate(((RectangularShape)double_).getX(), ((RectangularShape)double_).getY());
                graphics2D2.scale(N_UpBook.this.scale, N_UpBook.this.scale);
                N_UpBook.this.book.getPrintable(this.pi + n2).print(graphics2D2, pageFormat, this.pi + n2);
                graphics2D2.dispose();
                ++n2;
            }
            return 0;
        }
    }
}

