/*
 * Decompiled with CFR 0.152.
 */
package inetsoft.report.j2d;

import inetsoft.report.StyleSheet;
import inetsoft.report.j2d.StyleBook;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;

public class MultiBook
implements Pageable {
    Pageable[] books;

    public MultiBook(StyleSheet[] styleSheetArray, PageFormat pageFormat) {
        this.books = new StyleBook[styleSheetArray.length];
        int n = 0;
        int n2 = 0;
        while (n < styleSheetArray.length) {
            styleSheetArray[n].setPageNumberingStart(n2 + 1);
            this.books[n] = new StyleBook(styleSheetArray[n], pageFormat);
            n2 += this.books[n].getNumberOfPages();
            ++n;
        }
    }

    public MultiBook(Pageable[] pageableArray) {
        this.books = pageableArray;
    }

    public Index getBookIndex(int n) {
        int n2 = 0;
        while (n2 < this.books.length) {
            int n3 = this.books[n2].getNumberOfPages();
            if (n < n3) {
                return new Index(n2, n);
            }
            n -= n3;
            ++n2;
        }
        return null;
    }

    public int getNumberOfPages() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.books.length) {
            n += this.books[n2].getNumberOfPages();
            ++n2;
        }
        return n;
    }

    public PageFormat getPageFormat(int n) throws IndexOutOfBoundsException {
        Index index = this.getBookIndex(n);
        if (index == null) {
            throw new IndexOutOfBoundsException();
        }
        return this.books[index.bookIndex].getPageFormat(index.pageIndex);
    }

    public Printable getPrintable(int n) throws IndexOutOfBoundsException {
        Index index = this.getBookIndex(n);
        if (index == null) {
            throw new IndexOutOfBoundsException();
        }
        return this.books[index.bookIndex].getPrintable(index.pageIndex);
    }

    public static class Index {
        public int bookIndex;
        public int pageIndex;

        public Index(int n, int n2) {
            this.bookIndex = n;
            this.pageIndex = n2;
        }
    }
}

