/*
 * Decompiled with CFR 0.152.
 */
package inetsoft.report.j2d;

import inetsoft.report.PreviewPane;
import inetsoft.report.PreviewView;
import inetsoft.report.StyleSheet;
import inetsoft.report.event.SelectionListener;
import inetsoft.report.internal.PagesMenu;
import inetsoft.report.internal.Util;
import inetsoft.report.internal.j2d.Common2D;
import inetsoft.report.io.Builder;
import inetsoft.report.j2d.JPreviewPane;
import inetsoft.report.locale.Catalog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.PrintJob;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;

public class JPreviewer
extends JFrame
implements PreviewView,
ActionListener {
    ItemListener zoomListener = new ItemListener(){

        public void itemStateChanged(ItemEvent itemEvent) {
            int n = JPreviewer.this.zoomChoice.getSelectedIndex();
            if (n >= 0) {
                JPreviewer.this.pane.zoom(zoomperc[n]);
            }
        }
    };
    StyleSheet sheet;
    PreviewPane pane;
    JToggleButton pgcombo;
    PagesMenu menu = null;
    Dimension psize;
    JComboBox zoomChoice;
    PrintJob printjob;
    boolean exitit = false;
    protected JToolBar toolbar = new JToolBar();
    static final String[] zoomname = new String[]{Catalog.getString((String)"500%"), Catalog.getString((String)"200%"), Catalog.getString((String)"150%"), Catalog.getString((String)"100%"), Catalog.getString((String)"75%"), Catalog.getString((String)"50%"), Catalog.getString((String)"25%"), Catalog.getString((String)"10%"), Catalog.getString((String)"Page Width"), Catalog.getString((String)"Whole Page"), Catalog.getString((String)"Two Pages")};
    static final double[] zoomperc = new double[]{5.0, 2.0, 1.5, 1.0, 0.75, 0.5, 0.25, 0.1, -1.0, -2.0, -3.0};

    public JPreviewer() {
        this(Catalog.getString((String)"Print Preview"));
    }

    public JPreviewer(String string) {
        super(string);
        this.getContentPane().setLayout(new BorderLayout());
        JButton jButton = Common2D.createToolButton(null, "/inetsoft/report/images/printer.gif");
        this.toolbar.add(jButton);
        jButton.setToolTipText(Catalog.getString((String)"Print"));
        jButton.addActionListener(this);
        this.toolbar.addSeparator();
        jButton = Common2D.createToolButton(null, "/inetsoft/report/images/onepage.gif");
        this.toolbar.add(jButton);
        jButton.setToolTipText(Catalog.getString((String)"One Page"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JPreviewer.this.zoomChoice.setSelectedItem(Catalog.getString((String)"Whole Page"));
                JPreviewer.this.zoomListener.itemStateChanged(null);
            }
        });
        this.pgcombo = Common2D.createToolButton(null, "/inetsoft/report/images/npage.gif", false);
        this.toolbar.add(this.pgcombo);
        this.pgcombo.setToolTipText(Catalog.getString((String)"Multiple Pages"));
        this.pgcombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (JPreviewer.this.pgcombo.isSelected()) {
                    JPreviewer.this.menu = new PagesMenu((Frame)JPreviewer.this);
                    Point point = JPreviewer.this.pgcombo.getLocationOnScreen();
                    point.y += JPreviewer.this.pgcombo.getSize().height;
                    JPreviewer.this.menu.pack();
                    JPreviewer.this.menu.setLocation(point);
                    JPreviewer.this.menu.setVisible(true);
                    JPreviewer.this.menu.setLocation(point);
                    JPreviewer.this.menu.addWindowListener(new WindowAdapter(JPreviewer.this){
                        private final /* synthetic */ JPreviewer this$0;
                        {
                            this.this$0 = jPreviewer;
                        }

                        public void windowClosed(WindowEvent windowEvent) {
                            this.this$0.menu = null;
                            this.this$0.pgcombo.setSelected(false);
                        }
                    });
                    JPreviewer.this.menu.addActionListener(new ActionListener(JPreviewer.this){
                        private final /* synthetic */ JPreviewer this$0;
                        {
                            this.this$0 = jPreviewer;
                        }

                        public void actionPerformed(ActionEvent actionEvent) {
                            this.this$0.setPages(this.this$0.menu.getRows(), this.this$0.menu.getCols());
                            this.this$0.menu.dispose();
                            this.this$0.menu = null;
                        }
                    });
                } else if (JPreviewer.this.menu != null) {
                    JPreviewer.this.menu.dispose();
                    JPreviewer.this.menu = null;
                }
            }
        });
        this.toolbar.addSeparator();
        this.zoomChoice = new JComboBox();
        this.toolbar.add(this.zoomChoice);
        int n = 0;
        while (n < zoomname.length) {
            this.zoomChoice.addItem(zoomname[n]);
            ++n;
        }
        this.zoomChoice.setSelectedItem(Catalog.getString((String)"100%"));
        this.zoomChoice.setMaximumSize(new Dimension(100, 25));
        this.zoomChoice.setToolTipText(Catalog.getString((String)"Zoom"));
        this.zoomChoice.addItemListener(this.zoomListener);
        this.toolbar.addSeparator();
        jButton = Common2D.createToolButton(null, "/inetsoft/report/images/fullscr.gif");
        this.toolbar.add(jButton);
        jButton.setToolTipText(Catalog.getString((String)"Full Screen"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JPreviewer.this.psize = Toolkit.getDefaultToolkit().getScreenSize();
                JPreviewer.this.pack();
                ((Component)JPreviewer.this).setLocation(0, 0);
            }
        });
        this.toolbar.addSeparator();
        jButton = new JButton(" " + Catalog.getString((String)"Close") + " ");
        this.toolbar.add(jButton);
        jButton.setMargin(new Insets(1, 1, 1, 1));
        jButton.setAlignmentY(0.5f);
        jButton.setToolTipText(Catalog.getString((String)"Close Preview"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JPreviewer.this.dispose();
            }
        });
        this.getContentPane().add((Component)this.toolbar, "North");
        this.pane = this.createPane();
        this.getContentPane().add((Component)this.pane, "Center");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                JPreviewer.this.dispose();
            }
        });
        Util.registerKeyListener((Component)this, (KeyListener)this.pane.getScrollListener());
        this.addNotify();
    }

    public JPreviewer(String string, int n, int n2) {
        this(string);
        this.psize = new Dimension(n, n2);
    }

    public JPreviewer(String string, PrintJob printJob, boolean bl) {
        this(string, bl);
        this.printjob = printJob;
        Dimension dimension = printJob.getPageDimension();
        this.setPageWidth((double)dimension.width / 72.0);
        this.setPageHeight((double)dimension.height / 72.0);
        this.setPageResolution(72);
    }

    public JPreviewer(String string, boolean bl) {
        this(string);
        if (bl) {
            this.zoomChoice.setSelectedItem(Catalog.getString((String)"Whole Page"));
            this.zoomListener.itemStateChanged(null);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.printAction();
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.pane.addSelectionListener(selectionListener);
    }

    protected PreviewPane createPane() {
        return new JPreviewPane();
    }

    public void dispose() {
        if (this.exitit) {
            System.exit(0);
        }
        super.dispose();
    }

    public int getOrientation() {
        return this.pane.getOrientation();
    }

    public double getPageHeight() {
        return this.pane.getPageHeight();
    }

    public int getPageResolution() {
        return this.pane.getPageResolution();
    }

    public double getPageWidth() {
        return this.pane.getPageWidth();
    }

    public Dimension getPreferredSize() {
        if (this.psize != null) {
            return this.psize;
        }
        Dimension dimension = new Dimension(this.getToolkit().getScreenSize());
        dimension.width = Math.min(dimension.width, 800);
        dimension.height = Math.min(dimension.height, 800);
        return dimension;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.err.println("Usage: java inetsoft.report.j2d.JPreviewer report-file");
            System.exit(1);
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(stringArray[0]);
            Builder builder = Builder.getBuilder((int)2, (InputStream)fileInputStream);
            StyleSheet styleSheet = builder.read(".");
            JPreviewer jPreviewer = new JPreviewer();
            jPreviewer.setExitOnClose(true);
            jPreviewer.pack();
            ((Component)jPreviewer).setVisible(true);
            jPreviewer.print(styleSheet);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void print(StyleSheet styleSheet) {
        this.sheet = styleSheet;
        this.pane.print(this.sheet);
    }

    public void printAction() {
        if (this.sheet == null) {
            return;
        }
        PrintJob printJob = this.printjob;
        if (printJob == null) {
            printJob = this.getToolkit().getPrintJob(this, Catalog.getString((String)"Previewer"), null);
        }
        if (printJob == null) {
            return;
        }
        final PrintJob printJob2 = printJob;
        new Thread(){

            public void run() {
                sheet.print(printJob2);
                printJob2.end();
                Dimension dimension = printJob2.getPageDimension();
                if ((double)dimension.width != this.getPageWidth() || (double)dimension.height != this.getPageHeight()) {
                    sheet.reset();
                    this.print(sheet);
                }
            }
        }.start();
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.pane.removeSelectionListener(selectionListener);
    }

    public void setExitOnClose(boolean bl) {
        this.exitit = bl;
    }

    public void setOrientation(int n) {
        this.pane.setOrientation(n);
    }

    public void setPageHeight(double d) {
        this.pane.setPageHeight(d);
    }

    public void setPageResolution(int n) {
        this.pane.setPageResolution(n);
    }

    public void setPageWidth(double d) {
        this.pane.setPageWidth(d);
    }

    public void setPages(int n, int n2) {
        this.pane.setPages(n, n2);
    }

    public void setPreferredSize(Dimension dimension) {
        this.psize = new Dimension(dimension);
    }

    public void zoom(double d) {
        this.pane.zoom(d);
        int n = 0;
        while (n < zoomperc.length) {
            if (Math.abs(zoomperc[n] - d) < 0.05) {
                this.zoomChoice.setSelectedIndex(n);
                break;
            }
            ++n;
        }
    }
}

