/*
 * Decompiled with CFR 0.152.
 */
package inetsoft.report.j2d;

import inetsoft.report.Common;
import inetsoft.report.PreviewPane;
import inetsoft.report.Size;
import inetsoft.report.internal.Util;
import inetsoft.report.locale.Catalog;
import java.awt.Adjustable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentListener;
import javax.swing.BoundedRangeModel;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.plaf.ScrollBarUI;

public class JPreviewPane
extends PreviewPane {
    protected StatusScrollPane scroller;

    protected void addToScrollPane(Component component) {
        ((JScrollPane)this.scrollpane).setViewportView(component);
    }

    protected Container createScrollPane() {
        this.scroller = new StatusScrollPane();
        this.scroller.bar.pageB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JPreviewPane.this.gotoPage();
            }
        });
        this.scroller.getVerticalScrollBar().setUnitIncrement(18);
        this.scroller.getHorizontalScrollBar().setUnitIncrement(18);
        this.scroller.getHorizontalScrollBar().setBlockIncrement(200);
        return this.scroller;
    }

    protected int getBlockIncrement(Adjustable adjustable) {
        return ((JScrollBar)adjustable).getBlockIncrement(1);
    }

    public Adjustable getHAdjustable() {
        return ((JScrollPane)this.scrollpane).getHorizontalScrollBar();
    }

    public Adjustable getVAdjustable() {
        return ((JScrollPane)this.scrollpane).getVerticalScrollBar();
    }

    protected Container getViewport() {
        return ((JScrollPane)this.scrollpane).getViewport();
    }

    public Dimension getViewportSize() {
        return ((JScrollPane)this.scrollpane).getViewport().getSize();
    }

    public void gotoPage() {
        final JDialog jDialog = new JDialog(Util.findFrame((Component)((Object)this)), Catalog.getString((String)"Go To Page"));
        final JTextField jTextField = new JTextField(8);
        jDialog.getContentPane().setLayout(new BorderLayout(20, 20));
        jDialog.getContentPane().add(new Component(){}, "North");
        JPanel jPanel = new JPanel();
        jPanel.add(new JLabel(String.valueOf(Catalog.getString((String)"Page")) + ":"));
        jPanel.add(jTextField);
        jPanel.add(new JLabel(String.valueOf(Catalog.getString((String)"of")) + " " + this.getPageCount()));
        jDialog.getContentPane().add((Component)jPanel, "Center");
        jPanel = new JPanel();
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    this.gotoPage(Integer.parseInt(jTextField.getText()));
                    jDialog.dispose();
                }
                catch (NumberFormatException numberFormatException) {
                    jTextField.setText("");
                }
            }
        };
        JButton jButton = new JButton("     " + Catalog.getString((String)"OK") + "     ");
        jButton.addActionListener(actionListener);
        jPanel.add(jButton);
        jButton = new JButton("   " + Catalog.getString((String)"Cancel") + "   ");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.dispose();
            }
        });
        jPanel.add(jButton);
        jDialog.getContentPane().add((Component)jPanel, "South");
        jTextField.setText(String.valueOf(this.getPageNumber()));
        jTextField.selectAll();
        jTextField.addActionListener(actionListener);
        Point point = ((Component)((Object)this)).getLocationOnScreen();
        Dimension dimension = ((Component)((Object)this)).getSize();
        ((Component)jDialog).setLocation(point.x + dimension.width / 2 - 100, point.y + dimension.height / 2 - 80);
        jDialog.setModal(true);
        jDialog.pack();
        ((Component)jDialog).setVisible(true);
    }

    public void showPageNumber(int n) {
        this.scroller.bar.pageB.setLabel(String.valueOf(Catalog.getString((String)"Page")) + " " + n + " " + Catalog.getString((String)"of") + " " + this.getPageCount());
    }

    public void showPageSize(Size size) {
        this.scroller.bar.sizeB.setLabel(String.valueOf(size.width) + " x " + size.height + " in");
    }

    public void showStatus(String string) {
        this.scroller.bar.statusF.setLabel(string);
    }

    protected void syncScrollPane() {
    }

    protected class StatusScrollPane
    extends JScrollPane {
        StatusScrollBar bar;

        public StatusScrollPane() {
            this.setHorizontalScrollBarPolicy(32);
        }

        public JScrollBar createHorizontalScrollBar() {
            this.bar = new StatusScrollBar();
            return this.bar;
        }

        public StatusScrollBar getScrollBar() {
            return this.bar;
        }
    }

    protected class StatusScrollBar
    extends JScrollBar {
        JScrollBar scrollbar = null;
        JButton pageB = new SmallButton("Page 1 of 1");
        JButton sizeB = new SmallButton("8.5 x 11 in");
        JPanel statusPane = new JPanel();
        JButton statusF = new JButton(this){
            private final /* synthetic */ StatusScrollBar this$1;
            {
                this.this$1 = statusScrollBar;
                this.setHorizontalAlignment(2);
            }

            public float getAlignmentY() {
                return this.this$1.scrollbar.getAlignmentY();
            }

            public Dimension getMaximumSize() {
                return new Dimension(240, this.this$1.scrollbar.getMaximumSize().height);
            }

            public Dimension getMinimumSize() {
                return new Dimension(120, this.this$1.scrollbar.getMinimumSize().height);
            }

            public Dimension getPreferredSize() {
                return new Dimension(180, this.this$1.scrollbar.getPreferredSize().height);
            }
        };

        public StatusScrollBar() {
            super(0);
            this.setLayout(new BoxLayout(this, 0));
            this.checkInit();
            this.add(this.pageB);
            this.pageB.setMargin(new Insets(0, 15, 0, 15));
            Image image = Common.getImage((Object)this, (String)"/inetsoft/report/images/smallpage.gif");
            this.pageB.setIcon(new ImageIcon(image));
            this.add(this.sizeB);
            this.sizeB.setMargin(new Insets(0, 15, 0, 15));
            image = Common.getImage((Object)this, (String)"/inetsoft/report/images/smallpaper.gif");
            this.sizeB.setIcon(new ImageIcon(image));
            this.statusPane.setLayout(new BoxLayout(this.statusPane, 0));
            this.statusPane.add(this.statusF);
            this.add(this.statusPane);
            this.add(this.scrollbar);
        }

        public void addAdjustmentListener(AdjustmentListener adjustmentListener) {
            this.scrollbar.addAdjustmentListener(adjustmentListener);
        }

        public void addStatus(Component component) {
            this.statusPane.add(component);
        }

        private void checkInit() {
            if (this.scrollbar == null) {
                this.scrollbar = new JScrollBar(0);
            }
        }

        public void clearStatus() {
            while (this.statusPane.getComponentCount() > 0) {
                this.statusPane.remove(0);
            }
        }

        public int getBlockIncrement() {
            return this.scrollbar.getBlockIncrement();
        }

        public int getBlockIncrement(int n) {
            return this.scrollbar.getBlockIncrement(n);
        }

        public int getMaximum() {
            return this.scrollbar.getMaximum();
        }

        public int getMinimum() {
            return this.scrollbar.getMinimum();
        }

        public BoundedRangeModel getModel() {
            return this.scrollbar.getModel();
        }

        public int getOrientation() {
            return this.scrollbar.getOrientation();
        }

        public ScrollBarUI getUI() {
            return this.scrollbar.getUI();
        }

        public String getUIClassID() {
            return this.scrollbar.getUIClassID();
        }

        public int getUnitIncrement() {
            return this.scrollbar.getUnitIncrement();
        }

        public int getUnitIncrement(int n) {
            return this.scrollbar.getUnitIncrement(n);
        }

        public int getValue() {
            return this.scrollbar.getValue();
        }

        public boolean getValueIsAdjusting() {
            return this.scrollbar.getValueIsAdjusting();
        }

        public int getVisibleAmount() {
            return this.scrollbar.getVisibleAmount();
        }

        public void removeAdjustmentListener(AdjustmentListener adjustmentListener) {
            this.scrollbar.removeAdjustmentListener(adjustmentListener);
        }

        public void setBlockIncrement(int n) {
            this.scrollbar.setBlockIncrement(n);
        }

        public void setEnabled(boolean bl) {
            this.scrollbar.setEnabled(bl);
        }

        public void setMaximum(int n) {
            this.scrollbar.setMaximum(n);
        }

        public void setMinimum(int n) {
            this.scrollbar.setMinimum(n);
        }

        public void setModel(BoundedRangeModel boundedRangeModel) {
            this.scrollbar.setModel(boundedRangeModel);
        }

        public void setOrientation(int n) {
            this.scrollbar.setOrientation(n);
        }

        public void setUnitIncrement(int n) {
            this.scrollbar.setUnitIncrement(n);
        }

        public void setValue(int n) {
            this.scrollbar.setValue(n);
        }

        public void setValueIsAdjusting(boolean bl) {
            this.scrollbar.setValueIsAdjusting(bl);
        }

        public void setValues(int n, int n2, int n3, int n4) {
            this.scrollbar.setValues(n, n2, n3, n4);
        }

        public void setVisibleAmount(int n) {
            this.scrollbar.setVisibleAmount(n);
        }

        public void updateUI() {
            this.checkInit();
            this.scrollbar.updateUI();
        }

        class SmallButton
        extends JButton {
            public SmallButton(String string) {
                super(string);
            }

            public float getAlignmentY() {
                return StatusScrollBar.this.scrollbar.getAlignmentY();
            }

            public Dimension getMaximumSize() {
                return new Dimension(super.getMaximumSize().width, StatusScrollBar.this.scrollbar.getMaximumSize().height);
            }

            public Dimension getMinimumSize() {
                return new Dimension(super.getMinimumSize().width, StatusScrollBar.this.scrollbar.getMinimumSize().height);
            }

            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, StatusScrollBar.this.scrollbar.getPreferredSize().height);
            }
        }
    }
}

