/*
 * Decompiled with CFR 0.152.
 */
package inetsoft.report.internal.j2d;

import inetsoft.report.Margin;
import inetsoft.report.StyleSheet;
import inetsoft.report.internal.CustomGraphics;
import inetsoft.report.internal.PixelConsumer;
import inetsoft.report.internal.Win32Graphics;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.awt.print.PrinterGraphics;
import java.awt.print.PrinterJob;
import java.text.AttributedCharacterIterator;
import java.util.Map;

public class Win32Graphics2D
extends Graphics2D
implements Cloneable,
CustomGraphics,
PrinterGraphics {
    Win32Graphics wing;
    AffineTransform trans = new AffineTransform();
    FontRenderContext fontContext = new FontRenderContext(new AffineTransform(), true, true);
    Stroke stroke = new BasicStroke();
    Paint brush = Color.black;
    Color bg = Color.white;
    Color fg = Color.black;
    PrinterJob job;

    protected Win32Graphics2D() {
        this.wing = new Win32Graphics();
    }

    public void addRenderingHints(Map map) {
    }

    public void clearRect(int n, int n2, int n3, int n4) {
        this.wing.clearRect((double)n, (double)n2, (double)n3, (double)n4, this.bg);
    }

    public void clip(Shape shape) {
        if (shape instanceof Rectangle2D) {
            Rectangle2D rectangle2D = (Rectangle2D)shape;
            this.clipRect(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        } else if (shape instanceof Rectangle) {
            Rectangle rectangle = (Rectangle)shape;
            this.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        } else {
            throw new RuntimeException("Clipping of " + shape.getClass().getName() + " not supported by Win32Graphics2D");
        }
    }

    public void clipRect(double d, double d2, double d3, double d4) {
        this.wing.clipRect(d, d2, d3, d4);
    }

    public void clipRect(int n, int n2, int n3, int n4) {
        this.clipRect((double)n, (double)n2, (double)n3, (double)n4);
    }

    public void close() {
        this.wing.close();
    }

    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
        this.wing.copyArea(n, n2, n3, n4, n5, n6);
    }

    public Graphics create() {
        try {
            Win32Graphics2D win32Graphics2D = (Win32Graphics2D)this.clone();
            win32Graphics2D.wing = (Win32Graphics)this.wing.create();
            return win32Graphics2D;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void dispose() {
        this.wing.dispose();
    }

    protected boolean doImage(PixelConsumer pixelConsumer, int n, int n2, int n3, int n4, ImageObserver imageObserver, Color color) {
        if (this.wing.isError()) {
            return true;
        }
        byte[] byArray = this.wing.getImageBytes(pixelConsumer, color);
        if (n3 == 0) {
            n3 = pixelConsumer.iwidth;
        }
        if (n4 == 0) {
            n4 = pixelConsumer.iheight;
        }
        this.wing.drawImage0(byArray, pixelConsumer.width, pixelConsumer.height, this.wing.realX((double)n), this.wing.realY((double)n2), this.wing.realW((double)n3), this.wing.realH((double)n4), color == null ? 0xFFFFFF : Win32Graphics.getRGB((Color)color) & 0xFFFFFF, this.wing.isDither());
        return true;
    }

    protected boolean doImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver, Color color) {
        PixelConsumer pixelConsumer = new PixelConsumer(image, n5, n6, n7, n8);
        return this.doImage(pixelConsumer, n, n2, n3, n4, imageObserver, color);
    }

    protected boolean doImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver, Color color) {
        PixelConsumer pixelConsumer = new PixelConsumer(image);
        return this.doImage(pixelConsumer, n, n2, n3, n4, imageObserver, color);
    }

    public void draw(Shape shape) {
        if (shape instanceof Arc2D) {
            Arc2D arc2D = (Arc2D)shape;
            this.wing.drawArc(arc2D.getX(), arc2D.getY(), arc2D.getWidth(), arc2D.getHeight(), arc2D.getAngleStart(), arc2D.getAngleExtent());
        } else if (shape instanceof Ellipse2D) {
            Ellipse2D ellipse2D = (Ellipse2D)shape;
            this.wing.drawOval(ellipse2D.getX(), ellipse2D.getY(), ellipse2D.getWidth(), ellipse2D.getHeight());
        } else if (shape instanceof Line2D) {
            Line2D line2D = (Line2D)shape;
            this.wing.drawLine(line2D.getX1(), line2D.getY1(), line2D.getX2(), line2D.getY2());
        } else if (shape instanceof Rectangle2D) {
            Rectangle2D rectangle2D = (Rectangle2D)shape;
            this.wing.drawRect(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        } else if (shape instanceof RoundRectangle2D) {
            RoundRectangle2D roundRectangle2D = (RoundRectangle2D)shape;
            this.wing.drawRoundRect(roundRectangle2D.getX(), roundRectangle2D.getY(), roundRectangle2D.getWidth(), roundRectangle2D.getHeight(), roundRectangle2D.getArcWidth(), roundRectangle2D.getArcHeight());
        } else if (shape instanceof Rectangle) {
            Rectangle rectangle = (Rectangle)shape;
            this.wing.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        } else if (shape instanceof Polygon) {
            Polygon polygon = (Polygon)shape;
            this.wing.drawPolygon(polygon.xpoints, polygon.ypoints, polygon.npoints);
        } else {
            throw new RuntimeException("Drawing of " + shape.getClass().getName() + " not supported by Win32Graphics2D");
        }
    }

    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.wing.drawArc(n, n2, n3, n4, n5, n6);
    }

    public void drawGlyphVector(GlyphVector glyphVector, float f, float f2) {
        throw new RuntimeException("drawGlyphVector(GlyphVector, float, float) not supported by Win32Graphics2D");
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        return this.doImage(image, n, n2, n3 - n + 1, n4 - n2 + 1, n5, n6, n7, n8, imageObserver, color);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        return this.doImage(image, n, n2, n3 - n + 1, n4 - n2 + 1, n5, n6, n7, n8, imageObserver, null);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        return this.doImage(image, n, n2, n3, n4, imageObserver, color);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        return this.doImage(image, n, n2, n3, n4, imageObserver, null);
    }

    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        return this.doImage(image, n, n2, 0, 0, imageObserver, color);
    }

    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return this.doImage(image, n, n2, 0, 0, imageObserver, null);
    }

    public boolean drawImage(Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        AffineTransform affineTransform2 = this.getTransform();
        this.transform(affineTransform);
        this.drawImage(image, 0, 0, imageObserver);
        this.setTransform(affineTransform2);
        return true;
    }

    public void drawImage(BufferedImage bufferedImage, BufferedImageOp bufferedImageOp, int n, int n2) {
        throw new RuntimeException("drawImage(BufferedImage, BufferedImageOp, int, int) not supported by Win32Graphics2D");
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        this.wing.drawLine((double)n, (double)n2, (double)n3, (double)n4);
    }

    public void drawOval(int n, int n2, int n3, int n4) {
        this.wing.drawOval(n, n2, n3, n4);
    }

    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        this.wing.drawPolygon(nArray, nArray2, n);
    }

    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
        this.wing.drawPolyline(nArray, nArray2, n);
    }

    public void drawRenderableImage(RenderableImage renderableImage, AffineTransform affineTransform) {
        AffineTransform affineTransform2 = this.getTransform();
        this.transform(affineTransform);
        this.drawImage((Image)((Object)renderableImage), 0, 0, null);
        this.setTransform(affineTransform2);
    }

    public void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
        AffineTransform affineTransform2 = this.getTransform();
        this.transform(affineTransform);
        this.drawImage((Image)((Object)renderedImage), 0, 0, null);
        this.setTransform(affineTransform2);
    }

    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.wing.drawRoundRect(n, n2, n3, n4, n5, n6);
    }

    public void drawString(String string, float f, float f2) {
        this.wing.drawString(string, (double)f, (double)f2);
    }

    public void drawString(String string, int n, int n2) {
        this.wing.drawString(string, n, n2);
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, float f, float f2) {
        throw new RuntimeException("drawString(AttributedCharactorIterator, float, float) not supported by Win32Graphics2D");
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
        throw new RuntimeException("drawString(AttributedCharactorIterator, int, int) not supported by Win32Graphics2D");
    }

    public void fill(Shape shape) {
        if (shape instanceof Arc2D) {
            Arc2D arc2D = (Arc2D)shape;
            this.wing.fillArc(arc2D.getX(), arc2D.getY(), arc2D.getWidth(), arc2D.getHeight(), arc2D.getAngleStart(), arc2D.getAngleExtent());
        } else if (shape instanceof Ellipse2D) {
            Ellipse2D ellipse2D = (Ellipse2D)shape;
            this.wing.fillOval(ellipse2D.getX(), ellipse2D.getY(), ellipse2D.getWidth(), ellipse2D.getHeight());
        } else if (shape instanceof Rectangle2D) {
            Rectangle2D rectangle2D = (Rectangle2D)shape;
            this.wing.fillRect(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        } else if (shape instanceof RoundRectangle2D) {
            RoundRectangle2D roundRectangle2D = (RoundRectangle2D)shape;
            this.wing.fillRoundRect(roundRectangle2D.getX(), roundRectangle2D.getY(), roundRectangle2D.getWidth(), roundRectangle2D.getHeight(), roundRectangle2D.getArcWidth(), roundRectangle2D.getArcHeight());
        } else if (shape instanceof Rectangle) {
            Rectangle rectangle = (Rectangle)shape;
            this.wing.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        } else if (shape instanceof Polygon) {
            Polygon polygon = (Polygon)shape;
            this.wing.fillPolygon(polygon.xpoints, polygon.ypoints, polygon.npoints);
        } else {
            throw new RuntimeException("Filling of " + shape.getClass().getName() + " not supported by Win32Graphics2D");
        }
    }

    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.wing.fillArc(n, n2, n3, n4, n5, n6);
    }

    public void fillOval(int n, int n2, int n3, int n4) {
        this.wing.fillOval(n, n2, n3, n4);
    }

    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        this.wing.fillPolygon(nArray, nArray2, n);
    }

    public void fillRect(int n, int n2, int n3, int n4) {
        this.wing.fillRect(n, n2, n3, n4);
    }

    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.wing.fillRoundRect(n, n2, n3, n4, n5, n6);
    }

    public Color getBackground() {
        return this.bg;
    }

    public Shape getClip() {
        return this.wing.getClip();
    }

    public Rectangle getClipBounds() {
        return this.wing.getClipBounds();
    }

    public Color getColor() {
        return this.fg;
    }

    public Composite getComposite() {
        return null;
    }

    public int getCopies() {
        return this.wing.getCopies0();
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        throw new RuntimeException("getDeviceConfiguration() not supported by Win32Graphics2D");
    }

    public Font getFont() {
        return this.wing.getFont();
    }

    public FontMetrics getFontMetrics(Font font) {
        return this.wing.getFontMetrics(font);
    }

    public FontRenderContext getFontRenderContext() {
        return this.fontContext;
    }

    public int getFromPage() {
        return this.wing.getFromPage0();
    }

    public static Win32Graphics2D getGraphics(String string) {
        if (!Win32Graphics.isInitialized()) {
            return null;
        }
        Win32Graphics2D win32Graphics2D = new Win32Graphics2D();
        if (string == null ? win32Graphics2D.wing.create2() == 0 : win32Graphics2D.wing.create1(string) == 0) {
            return null;
        }
        win32Graphics2D.wing.init();
        return win32Graphics2D;
    }

    public int getOrientation() {
        return this.wing.getOrientation();
    }

    public Paint getPaint() {
        return this.brush;
    }

    public PrinterJob getPrinterJob() {
        return this.job;
    }

    public Object getRenderingHint(RenderingHints.Key key) {
        return null;
    }

    public RenderingHints getRenderingHints() {
        return null;
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public int getToPage() {
        return this.wing.getToPage0();
    }

    public AffineTransform getTransform() {
        return new AffineTransform(this.trans);
    }

    public boolean hit(Rectangle rectangle, Shape shape, boolean bl) {
        throw new RuntimeException("hit(Rectangle, Shape, boolean) not supported by Win32Graphics2D");
    }

    public boolean isPages() {
        return this.wing.isPages0();
    }

    public boolean isSupported(int n) {
        return n != 1;
    }

    public boolean printDialog(int n) {
        boolean bl = this.wing.printDialog0(n);
        if (bl) {
            this.wing.init();
        }
        return bl;
    }

    public void rotate(double d) {
        AffineTransform affineTransform = this.getTransform();
        affineTransform.rotate(d);
        this.setTransform(affineTransform);
    }

    public void rotate(double d, double d2, double d3) {
        AffineTransform affineTransform = this.getTransform();
        affineTransform.rotate(d, d2, d3);
        this.setTransform(affineTransform);
    }

    public void scale(double d, double d2) {
        AffineTransform affineTransform = this.getTransform();
        affineTransform.scale(d, d2);
        this.setTransform(affineTransform);
    }

    public void setBackground(Color color) {
        this.bg = color;
    }

    public void setClip(double d, double d2, double d3, double d4) {
        if (this.wing.isError()) {
            return;
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(this.wing.realX(d), this.wing.realY(d2), this.wing.realW(d3), this.wing.realH(d4));
        this.transformRect(double_, new AffineTransform(this.wing.getTransform0()), false);
        Margin margin = StyleSheet.getPrinterMargin();
        double_.x += (double)(this.wing.realX(margin.left * 72.0) - this.wing.getMargin().x);
        double_.y += (double)(this.wing.realY(margin.top * 72.0) - this.wing.getMargin().y);
        this.wing.setClip0((int)double_.x, (int)double_.y, (int)(double_.x + double_.width), (int)(double_.y + double_.height));
    }

    public void setClip(int n, int n2, int n3, int n4) {
        this.setClip((double)n, (double)n2, (double)n3, (double)n4);
    }

    public void setClip(Shape shape) {
        if (shape instanceof Rectangle2D) {
            Rectangle2D rectangle2D = (Rectangle2D)shape;
            this.setClip(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        } else if (shape instanceof Rectangle) {
            Rectangle rectangle = (Rectangle)shape;
            this.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        } else {
            throw new RuntimeException("Clipping of " + shape.getClass().getName() + " not supported by Win32Graphics2D");
        }
    }

    public void setColor(Color color) {
        if (this.wing.isError()) {
            return;
        }
        this.fg = color;
        this.brush = color;
        this.wing.setColor1(Win32Graphics.getRGB((Color)this.fg));
        this.setStroke(this.getStroke());
    }

    public void setComposite(Composite composite) {
        throw new RuntimeException("setComposite() not supported by Win32Graphics2D");
    }

    public void setCopies(int n) {
        if (this.wing.isError()) {
            return;
        }
        this.wing.setCopies0(n);
    }

    public void setFont(Font font) {
        this.wing.setFont(font);
    }

    public void setOrientation(int n) {
        this.wing.setOrientation(n);
    }

    public void setPaint(Paint paint) {
        if (this.wing.isError()) {
            return;
        }
        this.brush = paint;
        if (this.brush instanceof TexturePaint) {
            BufferedImage bufferedImage = ((TexturePaint)this.brush).getImage();
            byte[] byArray = this.wing.getImageBytes(new PixelConsumer((Image)bufferedImage), Color.white);
            this.wing.setBrush0(byArray, bufferedImage.getWidth(null), bufferedImage.getHeight(null), this.wing.isDither());
        } else if (this.brush instanceof Color) {
            this.setColor((Color)this.brush);
        } else {
            throw new RuntimeException("Only TexturePaint is supported by Win32Graphics2D");
        }
    }

    public void setPaintMode() {
        this.wing.setPaintMode();
    }

    public void setPrinterJob(PrinterJob printerJob) {
        this.job = printerJob;
    }

    public void setRenderingHint(RenderingHints.Key key, Object object) {
    }

    public void setRenderingHints(Map map) {
    }

    public void setStroke(Stroke stroke) {
        if (this.wing.isError()) {
            return;
        }
        this.stroke = stroke;
        if (!(this.stroke instanceof BasicStroke)) {
            throw new RuntimeException("Only BasicStroke is supported by Win32Graphics2D");
        }
        BasicStroke basicStroke = (BasicStroke)this.stroke;
        float[] fArray = basicStroke.getDashArray();
        int n = fArray != null && fArray.length > 0 ? (int)fArray[0] : 0;
        this.wing.setPen0(Win32Graphics.getRGB((Color)this.getColor()), this.wing.realW((double)basicStroke.getLineWidth()), basicStroke.getEndCap(), basicStroke.getLineJoin(), n);
    }

    public void setTransform(AffineTransform affineTransform) {
        if (this.wing.isError()) {
            return;
        }
        this.trans = affineTransform;
        double[] dArray = new double[6];
        affineTransform.getMatrix(dArray);
        this.wing.setTransform0(dArray[0], dArray[1], dArray[2], dArray[3], (double)this.wing.realW(dArray[4]), (double)this.wing.realH(dArray[5]));
    }

    public void setTray(int n) {
        this.wing.setTray(n);
    }

    public void setXORMode(Color color) {
        this.wing.setXORMode(color);
    }

    public void shear(double d, double d2) {
        AffineTransform affineTransform = this.getTransform();
        affineTransform.shear(d, d2);
        this.setTransform(affineTransform);
    }

    public void startDoc(String string) {
        this.wing.setError(this.wing.startDoc0(string) < 0);
    }

    public void startPage() {
        this.wing.nextPage();
    }

    public void transform(AffineTransform affineTransform) {
        AffineTransform affineTransform2 = this.getTransform();
        affineTransform2.concatenate(affineTransform);
        this.setTransform(affineTransform2);
    }

    private void transformRect(Rectangle2D.Double double_, AffineTransform affineTransform, boolean bl) {
        Point2D point2D = new Point2D.Double(double_.getX(), double_.getY());
        Point2D point2D2 = new Point2D.Double(double_.getX() + double_.getWidth(), double_.getY() + double_.getHeight());
        if (bl) {
            try {
                point2D = affineTransform.inverseTransform(point2D, null);
                point2D2 = affineTransform.inverseTransform(point2D2, null);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            point2D = affineTransform.transform(point2D, null);
            point2D2 = affineTransform.transform(point2D2, null);
        }
        double_.x = point2D.getX();
        double_.y = point2D.getY();
        double_.width = point2D2.getX() - point2D.getX();
        double_.height = point2D2.getY() - point2D.getY();
    }

    public void translate(double d, double d2) {
        AffineTransform affineTransform = this.getTransform();
        affineTransform.translate(d, d2);
        this.setTransform(affineTransform);
    }

    public void translate(int n, int n2) {
        AffineTransform affineTransform = this.getTransform();
        affineTransform.translate(n, n2);
        this.setTransform(affineTransform);
    }
}

