/*
 * Decompiled with CFR 0.152.
 */
package inetsoft.report.internal.j2d;

import inetsoft.report.internal.CustomGraphics;
import inetsoft.report.internal.PSGraphics;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.awt.print.PrinterGraphics;
import java.awt.print.PrinterJob;
import java.io.OutputStream;
import java.text.AttributedCharacterIterator;
import java.util.Map;

public class PSGraphics2D
extends Graphics2D
implements Cloneable,
CustomGraphics,
PrinterGraphics {
    PSGraphics psg;
    AffineTransform trans = new AffineTransform();
    AffineTransform ptrans = new AffineTransform();
    FontRenderContext fontContext = new FontRenderContext(new AffineTransform(), true, true);
    Stroke stroke = new BasicStroke();
    Rectangle2D clipping = null;
    Paint brush = Color.black;
    Color bg = Color.white;
    Color fg = Color.black;
    PrinterJob job;
    static AffineTransform psmatrix = new AffineTransform();

    static {
        psmatrix.scale(1.0, -1.0);
    }

    protected PSGraphics2D() {
        this.psg = new PSGraphics();
        Rectangle rectangle = this.psg.getClipBounds();
        this.clipping = new Rectangle2D.Double(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void addRenderingHints(Map map) {
    }

    public void clearRect(int n, int n2, int n3, int n4) {
        this.psg.clearRect(n, n2, n3, n4);
    }

    public void clip(Shape shape) {
        if (shape instanceof Rectangle2D) {
            Rectangle2D rectangle2D = (Rectangle2D)shape;
            this.clipRect(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        } else if (shape instanceof Rectangle) {
            Rectangle rectangle = (Rectangle)shape;
            this.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        } else {
            throw new RuntimeException("Clipping of " + shape.getClass().getName() + " not supported by PSGraphics2D");
        }
    }

    public void clipRect(double d, double d2, double d3, double d4) {
        Rectangle2D.Double double_ = new Rectangle2D.Double(d, d2, d3, d4);
        this.transformRect(double_, false);
        this.clipping = this.clipping.createIntersection(double_);
        this.psg.clipRect(d, d2, d3, d4);
    }

    public void clipRect(int n, int n2, int n3, int n4) {
        this.clipRect((double)n, (double)n2, (double)n3, (double)n4);
    }

    public void close() {
        this.psg.close();
    }

    private void concat(AffineTransform affineTransform) {
        double[] dArray = new double[6];
        affineTransform.getMatrix(dArray);
        this.emit("[ " + dArray[0] + " " + -dArray[1] + " " + -dArray[2] + " " + dArray[3] + " " + dArray[4] + " " + -dArray[5] + " ] concat");
    }

    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
        this.psg.copyArea(n, n2, n3, n4, n5, n6);
    }

    public Graphics create() {
        try {
            PSGraphics2D pSGraphics2D = (PSGraphics2D)this.clone();
            pSGraphics2D.ptrans = new AffineTransform(this.ptrans);
            pSGraphics2D.ptrans.concatenate(this.trans);
            pSGraphics2D.trans = new AffineTransform();
            pSGraphics2D.psg = (PSGraphics)this.psg.create();
            return pSGraphics2D;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public Graphics create(int n, int n2, int n3, int n4) {
        PSGraphics2D pSGraphics2D = (PSGraphics2D)super.create(n, n2, n3, n4);
        pSGraphics2D.ptrans.concatenate(pSGraphics2D.trans);
        pSGraphics2D.trans = new AffineTransform();
        return pSGraphics2D;
    }

    public void dispose() {
        this.psg.dispose();
    }

    public void draw(Shape shape) {
        if (shape instanceof Arc2D) {
            Arc2D arc2D = (Arc2D)shape;
            this.psg.drawArc(arc2D.getX(), arc2D.getY(), arc2D.getWidth(), arc2D.getHeight(), arc2D.getAngleStart(), arc2D.getAngleExtent());
        } else if (shape instanceof Ellipse2D) {
            Ellipse2D ellipse2D = (Ellipse2D)shape;
            this.psg.drawOval(ellipse2D.getX(), ellipse2D.getY(), ellipse2D.getWidth(), ellipse2D.getHeight());
        } else if (shape instanceof Line2D) {
            Line2D line2D = (Line2D)shape;
            this.psg.drawLine(line2D.getX1(), line2D.getY1(), line2D.getX2(), line2D.getY2());
        } else if (shape instanceof Rectangle2D) {
            Rectangle2D rectangle2D = (Rectangle2D)shape;
            this.psg.drawRect(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        } else if (shape instanceof RoundRectangle2D) {
            RoundRectangle2D roundRectangle2D = (RoundRectangle2D)shape;
            this.psg.drawRoundRect(roundRectangle2D.getX(), roundRectangle2D.getY(), roundRectangle2D.getWidth(), roundRectangle2D.getHeight(), roundRectangle2D.getArcWidth(), roundRectangle2D.getArcHeight());
        } else if (shape instanceof Rectangle) {
            Rectangle rectangle = (Rectangle)shape;
            this.psg.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        } else if (shape instanceof Polygon) {
            Polygon polygon = (Polygon)shape;
            this.psg.drawPolygon(polygon.xpoints, polygon.ypoints, polygon.npoints);
        } else {
            throw new RuntimeException("Drapsg of " + shape.getClass().getName() + " not supported by PSGraphics2D");
        }
    }

    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.psg.drawArc(n, n2, n3, n4, n5, n6);
    }

    public void drawGlyphVector(GlyphVector glyphVector, float f, float f2) {
        throw new RuntimeException("drawGlyphVector(GlyphVector, float, float) not supported by PSGraphics2D");
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        return this.psg.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, color, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        return this.psg.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        return this.psg.drawImage(image, n, n2, n3, n4, color, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        return this.psg.drawImage(image, n, n2, n3, n4, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        return this.psg.drawImage(image, n, n2, color, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return this.psg.drawImage(image, n, n2, imageObserver);
    }

    public boolean drawImage(Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        AffineTransform affineTransform2 = this.getTransform();
        this.transform(affineTransform);
        this.drawImage(image, 0, 0, imageObserver);
        this.setTransform(affineTransform2);
        return true;
    }

    public void drawImage(BufferedImage bufferedImage, BufferedImageOp bufferedImageOp, int n, int n2) {
        throw new RuntimeException("drawImage(BufferedImage, BufferedImageOp, int, int) not supported by PSGraphics2D");
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        this.psg.drawLine(n, n2, n3, n4);
    }

    public void drawOval(int n, int n2, int n3, int n4) {
        this.psg.drawOval(n, n2, n3, n4);
    }

    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        this.psg.drawPolygon(nArray, nArray2, n);
    }

    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
        this.psg.drawPolyline(nArray, nArray2, n);
    }

    public void drawRenderableImage(RenderableImage renderableImage, AffineTransform affineTransform) {
        AffineTransform affineTransform2 = this.getTransform();
        this.transform(affineTransform);
        this.drawImage((Image)((Object)renderableImage), 0, 0, null);
        this.setTransform(affineTransform2);
    }

    public void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
        AffineTransform affineTransform2 = this.getTransform();
        this.transform(affineTransform);
        this.drawImage((Image)((Object)renderedImage), 0, 0, null);
        this.setTransform(affineTransform2);
    }

    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.psg.drawRoundRect(n, n2, n3, n4, n5, n6);
    }

    public void drawString(String string, float f, float f2) {
        this.psg.drawString(string, (double)f, (double)f2);
    }

    public void drawString(String string, int n, int n2) {
        this.psg.drawString(string, n, n2);
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, float f, float f2) {
        throw new RuntimeException("drawString(AttributedCharactorIterator, float, float) not supported by PSGraphics2D");
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
        throw new RuntimeException("drawString(AttributedCharactorIterator, int, int) not supported by PSGraphics2D");
    }

    void emit(String string) {
        this.psg.emit(string);
    }

    public void fill(Shape shape) {
        if (shape instanceof Arc2D) {
            Arc2D arc2D = (Arc2D)shape;
            this.psg.fillArc(arc2D.getX(), arc2D.getY(), arc2D.getWidth(), arc2D.getHeight(), arc2D.getAngleStart(), arc2D.getAngleExtent());
        } else if (shape instanceof Ellipse2D) {
            Ellipse2D ellipse2D = (Ellipse2D)shape;
            this.psg.fillOval(ellipse2D.getX(), ellipse2D.getY(), ellipse2D.getWidth(), ellipse2D.getHeight());
        } else if (shape instanceof Rectangle2D) {
            Rectangle2D rectangle2D = (Rectangle2D)shape;
            this.psg.fillRect(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        } else if (shape instanceof RoundRectangle2D) {
            RoundRectangle2D roundRectangle2D = (RoundRectangle2D)shape;
            this.psg.fillRoundRect(roundRectangle2D.getX(), roundRectangle2D.getY(), roundRectangle2D.getWidth(), roundRectangle2D.getHeight(), roundRectangle2D.getArcWidth(), roundRectangle2D.getArcHeight());
        } else if (shape instanceof Rectangle) {
            Rectangle rectangle = (Rectangle)shape;
            this.psg.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        } else if (shape instanceof Polygon) {
            Polygon polygon = (Polygon)shape;
            this.psg.fillPolygon(polygon.xpoints, polygon.ypoints, polygon.npoints);
        } else {
            throw new RuntimeException("Filling of " + shape.getClass().getName() + " not supported by PSGraphics2D");
        }
    }

    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.psg.fillArc(n, n2, n3, n4, n5, n6);
    }

    public void fillOval(int n, int n2, int n3, int n4) {
        this.psg.fillOval(n, n2, n3, n4);
    }

    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        this.psg.fillPolygon(nArray, nArray2, n);
    }

    public void fillRect(int n, int n2, int n3, int n4) {
        this.psg.fillRect(n, n2, n3, n4);
    }

    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.psg.fillRoundRect(n, n2, n3, n4, n5, n6);
    }

    public Color getBackground() {
        return this.bg;
    }

    public Shape getClip() {
        return this.getClipBounds();
    }

    public Rectangle getClipBounds() {
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        double_.setRect(this.clipping);
        this.transformRect(double_, true);
        return new Rectangle((int)double_.getX(), (int)double_.getY(), (int)double_.getWidth(), (int)double_.getHeight());
    }

    public Color getColor() {
        return this.fg;
    }

    public Composite getComposite() {
        return null;
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        throw new RuntimeException("getDeviceConfiguration() not supported by PSGraphics2D");
    }

    public Font getFont() {
        return this.psg.getFont();
    }

    public FontMetrics getFontMetrics(Font font) {
        return this.psg.getFontMetrics(font);
    }

    public FontRenderContext getFontRenderContext() {
        return this.fontContext;
    }

    public static PSGraphics2D getGraphics() {
        PSGraphics2D pSGraphics2D = new PSGraphics2D();
        return pSGraphics2D;
    }

    public int getOrientation() {
        return this.psg.getOrientation();
    }

    public Dimension getPageDimension() {
        return this.psg.getPageDimension();
    }

    public Paint getPaint() {
        return this.brush;
    }

    public PrinterJob getPrinterJob() {
        return this.job;
    }

    public Object getRenderingHint(RenderingHints.Key key) {
        return null;
    }

    public RenderingHints getRenderingHints() {
        return null;
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public AffineTransform getTransform() {
        return new AffineTransform(this.trans);
    }

    public boolean hit(Rectangle rectangle, Shape shape, boolean bl) {
        throw new RuntimeException("hit(Rectangle, Shape, boolean) not supported by PSGraphics2D");
    }

    public boolean isSupported(int n) {
        return true;
    }

    public void reset() {
        this.psg.reset();
    }

    public void rotate(double d) {
        this.trans.rotate(d);
        d = -d;
        double d2 = d * 180.0 / Math.PI;
        this.emit(String.valueOf(d2) + " rotate");
    }

    public void rotate(double d, double d2, double d3) {
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.rotate(d, d2, d3);
        this.transform(affineTransform);
    }

    public void scale(double d, double d2) {
        this.trans.scale(d, d2);
        this.emit(String.valueOf(d) + " " + d2 + " scale");
    }

    public void setBackground(Color color) {
        this.bg = color;
    }

    public void setClip(double d, double d2, double d3, double d4) {
        Rectangle2D.Double double_ = new Rectangle2D.Double(d, d2, d3, d4);
        this.transformRect(double_, false);
        this.clipping = double_;
        this.psg.setClip(d, d2, d3, d4);
    }

    public void setClip(int n, int n2, int n3, int n4) {
        this.setClip((double)n, (double)n2, (double)n3, (double)n4);
    }

    public void setClip(Shape shape) {
        if (shape instanceof Rectangle2D) {
            Rectangle2D rectangle2D = (Rectangle2D)shape;
            this.setClip(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        } else if (shape instanceof Rectangle) {
            Rectangle rectangle = (Rectangle)shape;
            this.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        } else {
            throw new RuntimeException("Clipping of " + shape.getClass().getName() + " not supported by PSGraphics2D");
        }
    }

    public void setColor(Color color) {
        this.fg = color;
        this.brush = color;
        this.psg.setColor(this.fg);
        this.setStroke(this.getStroke());
    }

    public void setComposite(Composite composite) {
        throw new RuntimeException("setComposite() not supported by PSGraphics2D");
    }

    public void setFont(Font font) {
        this.psg.setFont(font);
    }

    public void setOrientation(int n) {
        this.psg.setOrientation(n);
        Rectangle rectangle = this.psg.getClipBounds();
        this.clipping = new Rectangle2D.Double(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void setPageSize(double d, double d2) {
        this.psg.setPageSize(d, d2);
        Rectangle rectangle = this.psg.getClipBounds();
        this.clipping = new Rectangle2D.Double(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void setPaint(Paint paint) {
        this.brush = paint;
        if (this.brush instanceof TexturePaint) {
            BufferedImage bufferedImage = ((TexturePaint)this.brush).getImage();
        } else if (this.brush instanceof Color) {
            this.setColor((Color)this.brush);
        } else {
            throw new RuntimeException("Only TexturePaint is supported by PSGraphics2D");
        }
    }

    public void setPaintMode() {
        this.psg.setPaintMode();
    }

    public void setPrinterJob(PrinterJob printerJob) {
        this.job = printerJob;
    }

    public void setRenderingHint(RenderingHints.Key key, Object object) {
    }

    public void setRenderingHints(Map map) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
        if (!(this.stroke instanceof BasicStroke)) throw new RuntimeException("Only BasicStroke is supported by PSGraphics2D");
        BasicStroke basicStroke = (BasicStroke)this.stroke;
        float[] fArray = basicStroke.getDashArray();
        int n = fArray != null && fArray.length > 0 ? (int)fArray[0] : 0;
        this.emit(String.valueOf(basicStroke.getLineWidth()) + " setlinewidth");
        if (n > 0) {
            this.emit("[ " + n + " " + n + " ] 0 setdash");
        } else {
            this.emit("[ ] 0 setdash");
        }
        switch (basicStroke.getEndCap()) {
            case 0: {
                this.emit("0 setlinecap");
                break;
            }
            case 1: {
                this.emit("1 setlinecap");
                break;
            }
            case 2: {
                this.emit("2 setlinecap");
                break;
            }
        }
        switch (basicStroke.getLineJoin()) {
            case 0: {
                this.emit("0 setlinejoin");
                return;
            }
            case 1: {
                this.emit("1 setlinejoin");
                return;
            }
            case 2: {
                this.emit("2 setlinejoin");
                return;
            }
            default: {
                return;
            }
        }
    }

    public void setTransform(AffineTransform affineTransform) {
        this.psg.grestore();
        this.setColor(this.getColor());
        this.setFont(this.getFont());
        this.setClip(this.getClip());
        this.psg.gsave();
        this.trans = affineTransform;
        this.concat(affineTransform);
    }

    public void setXORMode(Color color) {
        this.psg.setXORMode(color);
    }

    public void shear(double d, double d2) {
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.shear(d, d2);
        this.transform(affineTransform);
    }

    public void startDoc(OutputStream outputStream) {
        this.psg.setOutput(outputStream);
        this.psg.startDoc();
    }

    public void transform(AffineTransform affineTransform) {
        this.trans.concatenate(affineTransform);
        this.concat(affineTransform);
    }

    private void transformRect(Rectangle2D.Double double_, boolean bl) {
        Point2D point2D = new Point2D.Double(double_.getX(), double_.getY());
        Point2D point2D2 = new Point2D.Double(double_.getX() + double_.getWidth(), double_.getY() + double_.getHeight());
        if (bl) {
            try {
                point2D = this.trans.inverseTransform(point2D, null);
                point2D2 = this.trans.inverseTransform(point2D2, null);
                point2D = this.ptrans.inverseTransform(point2D, null);
                point2D2 = this.ptrans.inverseTransform(point2D2, null);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            point2D = this.ptrans.transform(point2D, null);
            point2D2 = this.ptrans.transform(point2D2, null);
            point2D = this.trans.transform(point2D, null);
            point2D2 = this.trans.transform(point2D2, null);
        }
        double_.x = point2D.getX();
        double_.y = point2D.getY();
        double_.width = point2D2.getX() - point2D.getX();
        double_.height = point2D2.getY() - point2D.getY();
    }

    public void translate(double d, double d2) {
        this.trans.translate(d, d2);
        this.emit(String.valueOf(d) + " " + -d2 + " translate");
    }

    public void translate(int n, int n2) {
        this.translate((double)n, (double)n2);
    }
}

