/*
 * Decompiled with CFR 0.152.
 */
package inetsoft.report.internal.j2d;

import inetsoft.report.Margin;
import inetsoft.report.Painter;
import inetsoft.report.PreviewPage;
import inetsoft.report.PreviewView;
import inetsoft.report.ReportEnv;
import inetsoft.report.StylePage;
import inetsoft.report.StyleSheet;
import inetsoft.report.internal.Bounds;
import inetsoft.report.internal.CustomGraphics;
import inetsoft.report.internal.Gop;
import inetsoft.report.internal.PaperSize;
import inetsoft.report.j2d.PreviewPage2D;
import inetsoft.report.j2d.Previewer2D;
import inetsoft.report.j2d.StyleBook;
import inetsoft.report.j2d.StylePrinter;
import inetsoft.report.j2d.StyleSheet2D;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterGraphics;
import java.awt.print.PrinterJob;
import java.util.Enumeration;
import java.util.Vector;

public class Gop2D
extends Gop {
    AffineTransform notransform = new AffineTransform();
    FontRenderContext fontRenderContext = new FontRenderContext(this.notransform, false, true);
    String[] fonts;
    Paint[] brush = new Paint[28];
    static BufferedImage dot = new BufferedImage(1, 1, 1);

    static {
        dot.setRGB(0, 0, -1);
    }

    public Gop2D() {
        int n = 0;
        int n2 = 0;
        while (n2 < 2) {
            int n3 = 0;
            while (n3 < 2) {
                int n4 = 0;
                while (n4 < 5) {
                    int n5;
                    Dimension dimension = null;
                    int n6 = n2 == 0 ? 1 : 2;
                    int n7 = n5 = n3 == 0 ? 4 : 6;
                    dimension = n4 == 3 || n4 == 5 ? new Dimension(n5, 2 * n5) : (n4 == 4 || n4 == 6 ? new Dimension(2 * n5, n5) : new Dimension(n5, n5));
                    BufferedImage bufferedImage = new BufferedImage(dimension.width, dimension.height, 10);
                    Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
                    graphics2D.setColor(Color.white);
                    graphics2D.fillRect(0, 0, dimension.width, dimension.height);
                    graphics2D.setStroke(new BasicStroke(n6));
                    graphics2D.setColor(Color.black);
                    switch (n4) {
                        case 0: 
                        case 3: 
                        case 5: {
                            graphics2D.drawLine(0, dimension.height - 1, dimension.width - 1, 0);
                            break;
                        }
                        case 2: {
                            graphics2D.drawLine(0, dimension.height - 1, dimension.width - 1, 0);
                        }
                        case 1: 
                        case 4: 
                        case 6: {
                            graphics2D.drawLine(0, 0, dimension.width - 1, dimension.height - 1);
                            break;
                        }
                    }
                    graphics2D.dispose();
                    this.brush[n++] = new TexturePaint(bufferedImage, new Rectangle2D.Float(0.0f, 0.0f, dimension.width, dimension.height));
                    ++n4;
                }
                ++n3;
            }
            ++n2;
        }
    }

    public void clipRect(Graphics graphics, Bounds bounds) {
        try {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.clip(new Rectangle2D.Float(bounds.x, bounds.y, bounds.width, bounds.height));
        }
        catch (Exception exception) {
            super.clipRect(graphics, bounds);
        }
    }

    public Image createImage(byte[] byArray, int n, int n2) {
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        int[] nArray = new int[n];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            int n5 = 0;
            while (n5 < n) {
                int n6 = byArray[n3++] & 0xFF;
                int n7 = byArray[n3++] & 0xFF;
                int n8 = byArray[n3++] & 0xFF;
                nArray[n5] = 0xFF000000 | n6 << 16 | n7 << 8 | n8;
                ++n5;
            }
            bufferedImage.setRGB(0, n4, n, 1, nArray, 0, n);
            ++n4;
        }
        return bufferedImage;
    }

    public StyleSheet createStyleSheet() {
        return new StyleSheet2D();
    }

    public void drawHLine(Graphics graphics, float f, float f2, float f3, int n, int n2, int n3) {
        try {
            Graphics2D graphics2D = (Graphics2D)graphics;
            if ((!(graphics instanceof CustomGraphics) || ((CustomGraphics)graphics).isSupported(1)) && (n & 0x1000) != 0 && (n & 0xF0) != 0) {
                int n4 = (n2 & 0x1000) != 0 || (n3 & 0x1000) != 0 ? 0 : Math.min(n2 & 0xF, n3 & 0xF);
                this.drawLine(graphics, f2 + (float)n4, f, f3, f, n);
            } else {
                super.drawHLine(graphics, f, f2, f3, n, n2, n3);
            }
        }
        catch (Exception exception) {
            super.drawHLine(graphics, f, f2, f3, n, n2, n3);
        }
    }

    public void drawImage(Graphics graphics, Image image, float f, float f2, float f3, float f4, ImageObserver imageObserver) {
        try {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Dimension dimension = new Dimension(image.getWidth(null), image.getHeight(null));
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.translate(f, f2);
            if (dimension.width != (int)f3 && dimension.width != 0 && dimension.height != (int)f4 && dimension.height != 0) {
                String string = ReportEnv.getProperty((String)"StyleReport.ditherImage");
                if (string != null && string.equals("true")) {
                    image = image.getScaledInstance((int)f3, (int)f4, 4);
                } else {
                    affineTransform.scale(f3 / (float)dimension.width, f4 / (float)dimension.height);
                }
            }
            if (image instanceof RenderedImage) {
                graphics2D.drawRenderedImage((RenderedImage)((Object)image), affineTransform);
            } else {
                graphics2D.drawImage(image, affineTransform, imageObserver);
            }
        }
        catch (ClassCastException classCastException) {
            super.drawImage(graphics, image, f, f2, f3, f4, imageObserver);
        }
    }

    public void drawLine(Graphics graphics, float f, float f2, float f3, float f4, int n) {
        try {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Stroke stroke = null;
            if ((n & 0xF0) != 0) {
                int n2 = (n & 0xF0) >> 4;
                stroke = graphics2D.getStroke();
                graphics2D.setStroke(new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{n2}, 0.0f));
            } else {
                graphics2D.setStroke(new BasicStroke(1.0f, 0, 0));
            }
            graphics2D.draw(new Line2D.Float(f, f2, f3, f4));
            if (stroke != null) {
                graphics2D.setStroke(stroke);
            }
        }
        catch (ClassCastException classCastException) {
            super.drawLine(graphics, f, f2, f3, f4, n);
        }
    }

    public void drawVLine(Graphics graphics, float f, float f2, float f3, int n, int n2, int n3) {
        try {
            Graphics2D graphics2D = (Graphics2D)graphics;
            if ((!(graphics instanceof CustomGraphics) || ((CustomGraphics)graphics).isSupported(1)) && (n & 0x1000) != 0 && (n & 0xF0) != 0) {
                int n4 = (n2 & 0x1000) != 0 || (n3 & 0x1000) != 0 ? 0 : Math.min(n2 & 0xF, n3 & 0xF);
                this.drawLine(graphics, f + 0.5f, f2 + (float)n4, f + 0.5f, f3, n);
            } else {
                super.drawVLine(graphics, f, f2, f3, n, n2, n3);
            }
        }
        catch (Exception exception) {
            super.drawVLine(graphics, f, f2, f3, n, n2, n3);
        }
    }

    public void fill(Graphics graphics, Shape shape, Object object) {
        try {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Paint paint = graphics2D.getPaint();
            graphics2D.setPaint((Paint)object);
            graphics2D.fill(shape);
            graphics2D.setPaint(paint);
        }
        catch (ClassCastException classCastException) {
            super.fill(graphics, shape, object);
        }
    }

    public void fillRect(Graphics graphics, float f, float f2, float f3, float f4) {
        try {
            ((Graphics2D)graphics).fill(new Rectangle2D.Float(f, f2, f3, f4));
        }
        catch (ClassCastException classCastException) {
            super.fillRect(graphics, f, f2, f3, f4);
        }
    }

    public String[] getAllFonts() {
        if (this.fonts == null) {
            this.fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        }
        return this.fonts;
    }

    public String getFontName(Font font) {
        return font.getName();
    }

    public float getLineAdjustment(Graphics graphics) {
        return graphics instanceof PrinterGraphics && graphics instanceof Graphics2D ? 0.5f : 0.0f;
    }

    public String getPSName(Font font) {
        return font.getPSName();
    }

    public Object getPaint(int n) {
        return this.brush[n % this.brush.length];
    }

    public PreviewView getPreviewView() {
        return new Previewer2D();
    }

    public void paint(Graphics graphics, float f, float f2, float f3, float f4, Painter painter, float f5, float f6, float f7, float f8, float f9, Color color, Color color2) {
        try {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Shape shape = graphics2D.getClip();
            AffineTransform affineTransform = graphics2D.getTransform();
            Color color3 = graphics2D.getColor();
            graphics2D.translate(f, f2);
            graphics2D.clip(new Rectangle2D.Float(0.0f, 0.0f, f3, f4));
            if (color2 != null) {
                graphics2D.setColor(color2);
                graphics2D.fill(new Rectangle2D.Float(0.0f, 0.0f, f3, f4));
            }
            graphics2D.setColor(color);
            graphics2D.scale(f3 / f7, f4 / f8);
            painter.paint((Graphics)graphics2D, (int)f5, (int)f6, (int)f7, (int)f8);
            graphics2D.setTransform(affineTransform);
            graphics2D.setClip(shape);
            graphics2D.setColor(color3);
        }
        catch (ClassCastException classCastException) {
            super.paint(graphics, f, f2, f3, f4, painter, f5, f6, f7, f8, f9, color, color2);
        }
    }

    public void paintPage(Graphics graphics, PreviewPage previewPage) {
        PreviewPage2D.paintPage(graphics, previewPage);
    }

    public void paintRotate(Painter painter, Graphics graphics, float f, float f2, float f3, float f4) {
        try {
            Graphics2D graphics2D = (Graphics2D)graphics;
            AffineTransform affineTransform = graphics2D.getTransform();
            Color color = graphics2D.getColor();
            Font font = graphics2D.getFont();
            graphics2D.translate(f + f3 - 1.0f, f2);
            graphics2D.rotate(1.5707963267948966);
            painter.paint((Graphics)graphics2D, 0, 0, Gop.round((double)f4), Gop.round((double)f3));
            graphics2D.setTransform(affineTransform);
            graphics2D.setColor(color);
            graphics2D.setFont(font);
        }
        catch (ClassCastException classCastException) {
            super.paintRotate(painter, graphics, f, f2, f3, f4);
        }
    }

    public void print(StyleSheet styleSheet) throws Exception {
        PrinterJob printerJob = StylePrinter.getPrinterJob();
        if (printerJob.printDialog()) {
            Object object;
            PageFormat pageFormat = printerJob.defaultPage();
            String string = styleSheet.getProperty("Orientation");
            pageFormat.setOrientation(PaperSize.getOrientation((String)string));
            string = styleSheet.getProperty("PageSize");
            if (string != null) {
                object = PaperSize.getSize((String)string);
                pageFormat.getPaper().setSize(object.width, object.height);
            }
            object = new StyleBook(styleSheet, pageFormat);
            printerJob.setPageable((Pageable)object);
            printerJob.print();
        }
    }

    public void print(String string, Enumeration enumeration) throws Exception {
        if (!enumeration.hasMoreElements()) {
            return;
        }
        PrinterJob printerJob = string == null ? StylePrinter.getPrinterJob() : StylePrinter.getPrinterJob(string);
        Vector vector = new Vector();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        Object[] objectArray = new StylePage[vector.size()];
        vector.copyInto(objectArray);
        Dimension dimension = objectArray[0].getPageDimension();
        if (printerJob.printDialog()) {
            final PageFormat pageFormat = printerJob.defaultPage();
            Paper paper = pageFormat.getPaper();
            Margin margin = StyleSheet.getPrinterMargin();
            pageFormat.setOrientation(dimension.width > dimension.height ? 0 : 1);
            paper.setSize(dimension.width, dimension.height);
            paper.setImageableArea(paper.getImageableX() - margin.left * 72.0, 0.0, paper.getWidth(), paper.getHeight());
            pageFormat.setPaper(paper);
            Pageable pageable = new Pageable((StylePage[])objectArray){
                private final /* synthetic */ StylePage[] val$pgarr;
                {
                    this.val$pgarr = stylePageArray;
                }

                public int getNumberOfPages() {
                    return this.val$pgarr.length;
                }

                public PageFormat getPageFormat(int n) {
                    return pageFormat;
                }

                public Printable getPrintable(int n) {
                    return new Printable(n, this.val$pgarr){
                        private final /* synthetic */ int val$pageIndex;
                        private final /* synthetic */ StylePage[] val$pgarr;
                        {
                            this.val$pageIndex = n;
                            this.val$pgarr = stylePageArray;
                        }

                        public int print(Graphics graphics, PageFormat pageFormat, int n) {
                            this.val$pgarr[this.val$pageIndex].print(graphics);
                            return 0;
                        }
                    };
                }
            };
            printerJob.setPageable(pageable);
            printerJob.print();
        }
    }

    public void setClip(Graphics graphics, Bounds bounds) {
        try {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setClip(new Rectangle2D.Float(bounds.x, bounds.y, bounds.width, bounds.height));
        }
        catch (Exception exception) {
            super.setClip(graphics, bounds);
        }
    }

    public void startPage(Graphics graphics, StylePage stylePage) {
        super.startPage(graphics, stylePage);
        Rectangle rectangle = graphics.getClipBounds();
        if (graphics instanceof PrinterGraphics && !(graphics instanceof CustomGraphics) && rectangle.height > 50) {
            Object object;
            try {
                object = (Graphics2D)graphics;
                ((Graphics2D)object).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                ((Graphics2D)object).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
                ((Graphics2D)object).setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
                ((Graphics2D)object).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
                ((Graphics2D)object).setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
                ((Graphics2D)object).setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
            }
            catch (ClassCastException classCastException) {}
            object = stylePage.getPageDimension();
            Color color = graphics.getColor();
            graphics.drawImage(dot, ((Dimension)object).width / 2, ((Dimension)object).height / 2, null);
            graphics.setColor(Color.white);
            int n = rectangle.y + rectangle.height;
            int n2 = 0;
            int n3 = 0;
            while (n3 < stylePage.getPaintableCount()) {
                Rectangle rectangle2 = stylePage.getPaintable(n3).getBounds();
                n = Math.min(n, rectangle2.y);
                n2 = Math.max(n2, rectangle2.y + rectangle2.height);
                ++n3;
            }
            if (n2 > n) {
                graphics.drawLine(rectangle.x, n, rectangle.y, n2);
            }
        }
    }

    public float stringWidth(String string, Font font, FontMetrics fontMetrics) {
        return fontMetrics.stringWidth(string) + 1;
    }
}

