/*
 * Decompiled with CFR 0.152.
 */
package inetsoft.report.style;

import inetsoft.report.StyleFont;
import inetsoft.report.TableLens;
import inetsoft.report.internal.XMLException;
import inetsoft.report.internal.XMLTokenStream;
import inetsoft.report.style.TableStyle;
import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;

public class XTableStyle
extends TableStyle {
    Style style;
    String name = "XTableStyle";
    Hashtable attrmap = new Hashtable();

    public XTableStyle(TableLens tableLens) {
        this.setTable(tableLens);
    }

    public XTableStyle(TableLens tableLens, File file) throws IOException, XMLException {
        this.style = new Style(new FileInputStream(file));
        this.setTable(tableLens);
    }

    public XTableStyle(TableLens tableLens, InputStream inputStream) throws IOException, XMLException {
        this.style = new Style(inputStream);
        this.setTable(tableLens);
    }

    public void clear() {
        this.attrmap.clear();
    }

    public Object clone() {
        XTableStyle xTableStyle = new XTableStyle(this.getTable());
        xTableStyle.name = new String(this.name);
        xTableStyle.attrmap = (Hashtable)this.attrmap.clone();
        return xTableStyle;
    }

    protected TableLens createStyle(TableLens tableLens) {
        return this.style == null ? (this.style = new Style()) : this.style;
    }

    public void export(OutputStream outputStream) {
        String[] stringArray = new String[]{"top-border", "bottom-border", "left-border", "right-border", "header-row", "header-col", "trailer-row", "trailer-col", "body"};
        String[] stringArray2 = new String[]{"border", "color", "bcolor", "foreground", "background", "font", "alignment", "row-border", "rcolor", "col-border", "ccolor"};
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(outputStream));
        if (this.name == null) {
            printWriter.println("<table-style>");
        } else {
            printWriter.println("<table-style name=\"" + this.name + '\"' + ">");
        }
        int n = 0;
        while (n < stringArray.length) {
            printWriter.print("<" + stringArray[n] + " ");
            int n2 = 0;
            while (n2 < stringArray2.length) {
                Object object = this.get(String.valueOf(stringArray[n]) + "." + stringArray2[n2]);
                if (object != null) {
                    if (object instanceof Integer) {
                        printWriter.print(" " + stringArray2[n2] + "=\"" + (Integer)object + "\"");
                    } else if (object instanceof Color) {
                        printWriter.print(" " + stringArray2[n2] + "=\"" + ((Color)object).getRGB() + "\"");
                    } else if (object instanceof Font) {
                        printWriter.print(" " + stringArray2[n2] + "=\"" + StyleFont.toString((Font)object) + '\"');
                    } else {
                        printWriter.print(" " + stringArray2[n2] + "=" + '\"' + object + '\"');
                    }
                }
                ++n2;
            }
            printWriter.println(">");
            printWriter.println("</" + stringArray[n] + ">");
            ++n;
        }
        printWriter.println("</table-style>");
        printWriter.flush();
    }

    public Object get(String string) {
        return this.style.get(string);
    }

    public String getName() {
        return this.name;
    }

    public void parse(XMLTokenStream xMLTokenStream) throws XMLException, IOException {
        this.style = new Style(xMLTokenStream);
    }

    public void parse(InputStream inputStream) throws XMLException, IOException {
        this.style = new Style(inputStream);
    }

    public void put(String string, Object object) {
        this.style.put(string, object);
    }

    public void setName(String string) {
        this.name = string;
    }

    class Style
    extends TableStyle.Transparent {
        public Style() {
        }

        public Style(XMLTokenStream xMLTokenStream) throws IOException, XMLException {
            Object object;
            while ((object = xMLTokenStream.getToken()) != null) {
                if (!(object instanceof XMLTokenStream.Tag)) continue;
                XMLTokenStream.Tag tag = (XMLTokenStream.Tag)object;
                if (tag.getName().equals("TABLE-STYLE")) {
                    XTableStyle.this.name = tag.get("NAME");
                    continue;
                }
                if (tag.getName().equals("/TABLE-STYLE")) break;
                Enumeration enumeration = tag.getAttributes();
                while (enumeration.hasMoreElements()) {
                    int n;
                    String string = (String)enumeration.nextElement();
                    String string2 = tag.get(string);
                    if (string.equals("BORDER") || string.equals("ROW-BORDER") || string.equals("COL-BORDER")) {
                        n = StyleFont.decodeLineStyle(string2);
                        if (n < 0) {
                            throw new XMLException("Unknow border style: " + string2);
                        }
                        XTableStyle.this.attrmap.put(String.valueOf(tag.getName()) + "." + string, new Integer(n));
                        continue;
                    }
                    if (string.equals("COLOR") || string.equals("BCOLOR") || string.equals("RCOLOR") || string.equals("CCOLOR") || string.equals("FOREGROUND") || string.equals("BACKGROUND")) {
                        try {
                            XTableStyle.this.attrmap.put(String.valueOf(tag.getName()) + "." + string, new Color(Integer.decode(string2)));
                            continue;
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            throw new XMLException("Color format error: " + string2);
                        }
                    }
                    if (string.equals("FONT")) {
                        Font font = StyleFont.decode(string2);
                        if (font == null) {
                            throw new XMLException("Font format error: " + string2);
                        }
                        XTableStyle.this.attrmap.put(String.valueOf(tag.getName()) + "." + string, font);
                        continue;
                    }
                    if (!string.equals("ALIGNMENT")) continue;
                    n = 0;
                    if (Character.isDigit(string2.charAt(0))) {
                        n = Integer.decode(string2);
                    } else {
                        if (string2.indexOf("H_LEFT") >= 0) {
                            n |= 1;
                        } else if (string2.indexOf("H_CENTER") >= 0) {
                            n |= 2;
                        } else if (string2.indexOf("H_RIGHT") >= 0) {
                            n |= 4;
                        }
                        if (string2.indexOf("V_TOP") >= 0) {
                            n |= 8;
                        } else if (string2.indexOf("V_CENTER") >= 0) {
                            n |= 0x10;
                        } else if (string2.indexOf("V_BOTTOM") >= 0) {
                            n |= 0x20;
                        }
                    }
                    XTableStyle.this.attrmap.put(String.valueOf(tag.getName()) + "." + string, new Integer(n));
                }
            }
        }

        public Style(InputStream inputStream) throws IOException, XMLException {
            this(new XMLTokenStream(inputStream));
        }

        public Object get(String string) {
            return XTableStyle.this.attrmap.get(string.toUpperCase());
        }

        public int getAlignment(int n, int n2) {
            Object object;
            if (n == this.lastRow() && (object = this.get("trailer-row.alignment")) != null || XTableStyle.this.isHeaderRowFormat(n) && (object = this.get("header-row.alignment")) != null || n2 == this.lastCol() && (object = this.get("trailer-col.alignment")) != null || XTableStyle.this.isHeaderColFormat(n2) && (object = this.get("header-col.alignment")) != null || (object = this.get("body.alignment")) != null) {
                return (Integer)object;
            }
            return super.getAlignment(n, n2);
        }

        public Color getBackground(int n, int n2) {
            Object object;
            if (n == this.lastRow() && (object = this.get("trailer-row.background")) != null || XTableStyle.this.isHeaderRowFormat(n) && (object = this.get("header-row.background")) != null || n2 == this.lastCol() && (object = this.get("trailer-col.background")) != null || XTableStyle.this.isHeaderColFormat(n2) && (object = this.get("header-col.background")) != null || (object = this.get("body.background")) != null) {
                return (Color)object;
            }
            return super.getBackground(n, n2);
        }

        public int getColBorder(int n, int n2) {
            Object object;
            if (n2 == -1 && (object = this.get("left-border.border")) != null || n2 == this.lastCol() && (object = this.get("right-border.border")) != null || XTableStyle.this.isHeaderColFormat(n2) && (object = this.get("header-col.border")) != null || n2 == this.lastCol() - 1 && (object = this.get("trailer-col.border")) != null || (object = this.get("body.col-border")) != null) {
                return (Integer)object;
            }
            return super.getColBorder(n, n2);
        }

        public Color getColBorderColor(int n, int n2) {
            Object object;
            if (n2 == -1 && (object = this.get("left-border.color")) != null || n2 == this.lastCol() && (object = this.get("right-border.color")) != null || XTableStyle.this.isHeaderColFormat(n2) && (object = this.get("header-col.bcolor")) != null || n2 == this.lastCol() - 1 && (object = this.get("trailer-col.bcolor")) != null || (object = this.get("body.ccolor")) != null) {
                return (Color)object;
            }
            return super.getColBorderColor(n, n2);
        }

        public Font getFont(int n, int n2) {
            Object object;
            if (n == this.lastRow() && (object = this.get("trailer-row.font")) != null || XTableStyle.this.isHeaderRowFormat(n) && (object = this.get("header-row.font")) != null || n2 == this.lastCol() && (object = this.get("trailer-col.font")) != null || XTableStyle.this.isHeaderColFormat(n2) && (object = this.get("header-col.font")) != null || (object = this.get("body.font")) != null) {
                return (Font)object;
            }
            return super.getFont(n, n2);
        }

        public Color getForeground(int n, int n2) {
            Object object;
            if (n == this.lastRow() && (object = this.get("trailer-row.foreground")) != null || XTableStyle.this.isHeaderRowFormat(n) && (object = this.get("header-row.foreground")) != null || n2 == this.lastCol() && (object = this.get("trailer-col.foreground")) != null || XTableStyle.this.isHeaderColFormat(n2) && (object = this.get("header-col.foreground")) != null || (object = this.get("body.foreground")) != null) {
                return (Color)object;
            }
            return super.getForeground(n, n2);
        }

        public int getRowBorder(int n, int n2) {
            Object object;
            if (n == -1 && (object = this.get("top-border.border")) != null || n == this.lastRow() && (object = this.get("bottom-border.border")) != null || XTableStyle.this.isHeaderRowFormat(n) && (object = this.get("header-row.border")) != null || n == this.lastRow() - 1 && (object = this.get("trailer-row.border")) != null || (object = this.get("body.row-border")) != null) {
                return (Integer)object;
            }
            return super.getRowBorder(n, n2);
        }

        public Color getRowBorderColor(int n, int n2) {
            Object object;
            if (n == -1 && (object = this.get("top-border.color")) != null || n == this.lastRow() && (object = this.get("bottom-border.color")) != null || XTableStyle.this.isHeaderRowFormat(n) && (object = this.get("header-row.bcolor")) != null || n == this.lastRow() - 1 && (object = this.get("trailer-row.bcolor")) != null || (object = this.get("body.rcolor")) != null) {
                return (Color)object;
            }
            return super.getRowBorderColor(n, n2);
        }

        public void put(String string, Object object) {
            XTableStyle.this.attrmap.put(string.toUpperCase(), object);
        }
    }
}

