/*
 * Decompiled with CFR 0.152.
 */
package inetsoft.report.style;

import inetsoft.report.StyleFont;
import inetsoft.report.TableFilter;
import inetsoft.report.TableLens;
import inetsoft.report.lens.AbstractTableLens;
import inetsoft.report.lens.AttributeTableLens;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.util.Hashtable;

public class TableStyle
extends AttributeTableLens
implements Cloneable {
    public TableLens table;
    TableLens style;
    boolean headerRF = true;
    boolean headerCF = true;
    boolean widthF = false;
    boolean heightF = false;
    boolean rowBorderCF = true;
    boolean colBorderCF = true;
    boolean rowBorderF = true;
    boolean colBorderF = true;
    boolean insetsF = false;
    boolean spanF = false;
    boolean alignF = false;
    boolean fontF = true;
    boolean wrapF = false;
    boolean foregroundF = true;
    boolean backgroundF = true;
    boolean presenterF = true;
    Boolean firstRow = Boolean.TRUE;
    Boolean firstCol = null;
    boolean lastRow = false;
    boolean lastCol = false;
    Hashtable fnmap = new Hashtable();
    protected Font defFont = new Font("Dialog", 0, 10);

    protected TableStyle() {
        super.setTable(new StyleApplicator());
    }

    public TableStyle(TableLens tableLens) {
        this.setTable(tableLens);
    }

    public TableStyle(TableLens tableLens, TableLens tableLens2) {
        this.setTable(tableLens);
        this.style = tableLens2;
    }

    public Object clone() {
        try {
            TableStyle tableStyle = (TableStyle)super.clone();
            tableStyle.setTable(tableStyle.table);
            return tableStyle;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Font createFont(Font font, int n) {
        Font font2;
        if (font == null) {
            font = this.defFont;
        }
        if ((font2 = (Font)this.fnmap.get(font)) != null && font2.getStyle() == n) {
            return font2;
        }
        font2 = font instanceof StyleFont ? new StyleFont(font.getName(), n | ((StyleFont)font).getStyle() & 0xFFF0, font.getSize(), ((StyleFont)font).getLineStyle()) : new Font(font.getName(), n, font.getSize());
        this.fnmap.put(font, font2);
        return font2;
    }

    public Font createFont(Font font, int n, int n2) {
        if (font == null) {
            font = this.defFont;
        }
        return font instanceof StyleFont ? new StyleFont(font.getName(), n | ((StyleFont)font).getStyle() & 0xFFF0, n2, ((StyleFont)font).getLineStyle()) : new Font(font.getName(), n, n2);
    }

    protected TableLens createStyle(TableLens tableLens) {
        return new Transparent();
    }

    public String getName() {
        String string = this.getClass().getName();
        int n = string.lastIndexOf(".");
        return n > 0 ? string.substring(n + 1) : string;
    }

    public TableLens getTable() {
        return this.table;
    }

    public boolean isApplyAlignment() {
        return this.alignF;
    }

    public boolean isApplyBackground() {
        return this.backgroundF;
    }

    public boolean isApplyColBorder() {
        return this.colBorderF;
    }

    public boolean isApplyColBorderColor() {
        return this.colBorderCF;
    }

    public boolean isApplyColWidth() {
        return this.widthF;
    }

    public boolean isApplyFont() {
        return this.fontF;
    }

    public boolean isApplyForeground() {
        return this.foregroundF;
    }

    public boolean isApplyHeaderColCount() {
        return this.headerCF;
    }

    public boolean isApplyHeaderRowCount() {
        return this.headerRF;
    }

    public boolean isApplyInsets() {
        return this.insetsF;
    }

    public boolean isApplyLineWrap() {
        return this.wrapF;
    }

    public boolean isApplyPresenter() {
        return this.presenterF;
    }

    public boolean isApplyRowBorder() {
        return this.rowBorderF;
    }

    public boolean isApplyRowBorderColor() {
        return this.rowBorderCF;
    }

    public boolean isApplyRowHeight() {
        return this.heightF;
    }

    public boolean isApplySpan() {
        return this.spanF;
    }

    public boolean isFormatFirstCol() {
        return this.firstCol == null ? this.table.getHeaderColCount() >= 1 : this.firstCol;
    }

    public boolean isFormatFirstRow() {
        return this.firstRow == null ? this.table.getHeaderRowCount() >= 1 : this.firstRow;
    }

    public boolean isFormatLastCol() {
        return this.lastCol;
    }

    public boolean isFormatLastRow() {
        return this.lastRow;
    }

    protected boolean isHeaderColFormat(int n) {
        return this.isFormatFirstCol() && n >= 0 && n < this.getHeaderColCount();
    }

    protected boolean isHeaderRowFormat(int n) {
        return this.isFormatFirstRow() && n >= 0 && n < this.getHeaderRowCount();
    }

    public void setApplyAlignment(boolean bl) {
        this.alignF = bl;
    }

    public void setApplyBackground(boolean bl) {
        this.backgroundF = bl;
    }

    public void setApplyColBorder(boolean bl) {
        this.colBorderF = bl;
    }

    public void setApplyColBorderColor(boolean bl) {
        this.colBorderCF = bl;
    }

    public void setApplyColWidth(boolean bl) {
        this.widthF = bl;
    }

    public void setApplyFont(boolean bl) {
        this.fontF = bl;
    }

    public void setApplyForeground(boolean bl) {
        this.foregroundF = bl;
    }

    public void setApplyHeaderColCount(boolean bl) {
        this.headerCF = bl;
    }

    public void setApplyHeaderRowCount(boolean bl) {
        this.headerRF = bl;
    }

    public void setApplyInsets(boolean bl) {
        this.insetsF = bl;
    }

    public void setApplyLineWrap(boolean bl) {
        this.wrapF = bl;
    }

    public void setApplyPresenter(boolean bl) {
        this.presenterF = bl;
    }

    public void setApplyRowBorder(boolean bl) {
        this.rowBorderF = bl;
    }

    public void setApplyRowBorderColor(boolean bl) {
        this.rowBorderCF = bl;
    }

    public void setApplyRowHeight(boolean bl) {
        this.heightF = bl;
    }

    public void setApplySpan(boolean bl) {
        this.spanF = bl;
    }

    public void setFormatFirstCol(boolean bl) {
        this.firstCol = new Boolean(bl);
    }

    public void setFormatFirstRow(boolean bl) {
        this.firstRow = new Boolean(bl);
    }

    public void setFormatLastCol(boolean bl) {
        this.lastCol = bl;
    }

    public void setFormatLastRow(boolean bl) {
        this.lastRow = bl;
    }

    public void setTable(TableLens tableLens) {
        this.table = tableLens;
        this.style = this.createStyle(tableLens);
        super.setTable(new StyleApplicator());
    }

    class StyleApplicator
    implements TableFilter {
        StyleApplicator() {
        }

        public int getAlignment(int n, int n2) {
            return TableStyle.this.alignF ? TableStyle.this.style.getAlignment(n, n2) : TableStyle.this.table.getAlignment(n, n2);
        }

        public Color getBackground(int n, int n2) {
            return TableStyle.this.backgroundF ? TableStyle.this.style.getBackground(n, n2) : TableStyle.this.table.getBackground(n, n2);
        }

        public int getColBorder(int n, int n2) {
            return TableStyle.this.colBorderF ? TableStyle.this.style.getColBorder(n, n2) : TableStyle.this.table.getColBorder(n, n2);
        }

        public Color getColBorderColor(int n, int n2) {
            return TableStyle.this.colBorderCF ? TableStyle.this.style.getColBorderColor(n, n2) : TableStyle.this.table.getColBorderColor(n, n2);
        }

        public int getColCount() {
            return TableStyle.this.table.getColCount();
        }

        public int getColWidth(int n) {
            return TableStyle.this.widthF ? TableStyle.this.style.getColWidth(n) : TableStyle.this.table.getColWidth(n);
        }

        public Font getFont(int n, int n2) {
            return TableStyle.this.fontF ? TableStyle.this.style.getFont(n, n2) : TableStyle.this.table.getFont(n, n2);
        }

        public Color getForeground(int n, int n2) {
            return TableStyle.this.foregroundF ? TableStyle.this.style.getForeground(n, n2) : TableStyle.this.table.getForeground(n, n2);
        }

        public int getHeaderColCount() {
            return TableStyle.this.headerCF ? TableStyle.this.style.getHeaderColCount() : TableStyle.this.table.getHeaderColCount();
        }

        public int getHeaderRowCount() {
            return TableStyle.this.headerRF ? TableStyle.this.style.getHeaderRowCount() : TableStyle.this.table.getHeaderRowCount();
        }

        public Insets getInsets(int n, int n2) {
            return TableStyle.this.insetsF ? TableStyle.this.style.getInsets(n, n2) : TableStyle.this.table.getInsets(n, n2);
        }

        public Object getObject(int n, int n2) {
            return TableStyle.this.presenterF ? TableStyle.this.style.getObject(n, n2) : TableStyle.this.table.getObject(n, n2);
        }

        public int getRowBorder(int n, int n2) {
            return TableStyle.this.rowBorderF ? TableStyle.this.style.getRowBorder(n, n2) : TableStyle.this.table.getRowBorder(n, n2);
        }

        public Color getRowBorderColor(int n, int n2) {
            return TableStyle.this.rowBorderCF ? TableStyle.this.style.getRowBorderColor(n, n2) : TableStyle.this.table.getRowBorderColor(n, n2);
        }

        public int getRowCount() {
            return TableStyle.this.table.getRowCount();
        }

        public int getRowHeight(int n) {
            return TableStyle.this.heightF ? TableStyle.this.style.getRowHeight(n) : TableStyle.this.table.getRowHeight(n);
        }

        public Dimension getSpan(int n, int n2) {
            return TableStyle.this.spanF ? TableStyle.this.style.getSpan(n, n2) : TableStyle.this.table.getSpan(n, n2);
        }

        public boolean isLineWrap(int n, int n2) {
            return TableStyle.this.wrapF ? TableStyle.this.style.isLineWrap(n, n2) : TableStyle.this.table.isLineWrap(n, n2);
        }

        public void refresh() {
            if (TableStyle.this.table instanceof TableFilter) {
                ((TableFilter)TableStyle.this.table).refresh();
            }
        }
    }

    public class Transparent
    extends AbstractTableLens {
        public int getAlignment(int n, int n2) {
            return TableStyle.this.table.getAlignment(n, n2);
        }

        public Color getBackground(int n, int n2) {
            return TableStyle.this.table.getBackground(n, n2);
        }

        public int getColBorder(int n, int n2) {
            return TableStyle.this.table.getColBorder(n, n2);
        }

        public Color getColBorderColor(int n, int n2) {
            return TableStyle.this.table.getColBorderColor(n, n2);
        }

        public int getColCount() {
            return TableStyle.this.table.getColCount();
        }

        public int getColWidth(int n) {
            return TableStyle.this.table.getColWidth(n);
        }

        public Font getFont(int n, int n2) {
            return TableStyle.this.table.getFont(n, n2);
        }

        public Color getForeground(int n, int n2) {
            return TableStyle.this.table.getForeground(n, n2);
        }

        public int getHeaderColCount() {
            return TableStyle.this.table.getHeaderColCount();
        }

        public int getHeaderRowCount() {
            return TableStyle.this.table.getHeaderRowCount();
        }

        public Insets getInsets(int n, int n2) {
            return TableStyle.this.table.getInsets(n, n2);
        }

        public Object getObject(int n, int n2) {
            return TableStyle.this.table.getObject(n, n2);
        }

        public int getRowBorder(int n, int n2) {
            return TableStyle.this.table.getRowBorder(n, n2);
        }

        public Color getRowBorderColor(int n, int n2) {
            return TableStyle.this.table.getRowBorderColor(n, n2);
        }

        public int getRowCount() {
            return TableStyle.this.table.getRowCount();
        }

        public int getRowHeight(int n) {
            return TableStyle.this.table.getRowHeight(n);
        }

        public Dimension getSpan(int n, int n2) {
            return TableStyle.this.table.getSpan(n, n2);
        }

        public boolean isLineWrap(int n, int n2) {
            return TableStyle.this.table.isLineWrap(n, n2);
        }

        protected int lastCol() {
            return TableStyle.this.table.getColCount() - 1;
        }

        protected int lastRow() {
            return TableStyle.this.table.getRowCount() - 1;
        }
    }
}

