/*
 * Decompiled with CFR 0.152.
 */
package inetsoft.report.server;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Hashtable;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PDFServlet
extends HttpServlet {
    Hashtable cache = new Hashtable();

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Object object;
        System.err.println("PDFServlet: GET Received.");
        String string = httpServletRequest.getParameter("report");
        System.err.println("report parameter = " + string);
        if (string == null && (object = httpServletRequest.getCookies()) != null) {
            int n = 0;
            while (n < ((Cookie[])object).length) {
                if (object[n].getName().equals("PDFReport")) {
                    string = object[n].getValue();
                    break;
                }
                ++n;
            }
        }
        if (string != null) {
            System.err.println("Retrieving Report: " + string);
            object = Long.valueOf(string);
            byte[] byArray = (byte[])this.cache.get(object);
            httpServletResponse.setContentType("application/pdf");
            httpServletResponse.setHeader("extension", "pdf");
            httpServletResponse.setHeader("Content-disposition", "attachment; filename=report.pdf");
            httpServletResponse.setContentLength(byArray.length);
            httpServletResponse.getOutputStream().write(byArray);
            System.err.println("Sent " + byArray.length + " bytes");
            return;
        }
        try {
            System.err.println("Report information missing.");
            httpServletResponse.setContentType("text/html");
            object = new PrintWriter((OutputStream)httpServletResponse.getOutputStream());
            ((PrintWriter)object).println("<h2>Error: Cookie missing. Cookie must be enabled in the browser!</h2>");
            ((PrintWriter)object).close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Object object;
        ServletInputStream servletInputStream;
        System.err.println("PDFServlet: POST Received.");
        if (this.cache.size() > 0) {
            servletInputStream = this.cache.keys();
            long l = System.currentTimeMillis();
            while (servletInputStream.hasMoreElements()) {
                object = (Long)servletInputStream.nextElement();
                if (l - object.longValue() <= 300000L) continue;
                this.cache.remove(object);
            }
        }
        try {
            int n;
            servletInputStream = httpServletRequest.getInputStream();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            object = new byte[2048];
            while ((n = servletInputStream.read((byte[])object, 0, ((Object)object).length)) >= 0) {
                byteArrayOutputStream.write((byte[])object, 0, n);
            }
            long l = System.currentTimeMillis();
            while (this.cache.get(new Long(l)) != null) {
                ++l;
            }
            object = byteArrayOutputStream.toByteArray();
            this.cache.put(new Long(l), object);
            httpServletResponse.addCookie(new Cookie("PDFReport", Long.toString(l)));
            ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)servletOutputStream);
            outputStreamWriter.write(String.valueOf(Long.toString(l)) + "\n");
            ((Writer)outputStreamWriter).close();
            System.err.println("Report saved: " + l + " " + ((byte[])object).length);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

