/*
 * Decompiled with CFR 0.152.
 */
package inetsoft.report.pdf;

import inetsoft.report.pdf.FontInfo;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

class TTFontInfo
extends FontInfo {
    static final int TAG_CMAP = 1668112752;
    static final int TAG_HEAD = 1751474532;
    static final int TAG_NAME = 1851878757;
    static final int TAG_GLYF = 1735162214;
    static final int TAG_MAXP = 1835104368;
    static final int TAG_PREP = 1886545264;
    static final int TAG_HMTX = 1752003704;
    static final int TAG_KERN = 1801810542;
    static final int TAG_HDMX = 1751412088;
    static final int TAG_LOCA = 1819239265;
    static final int TAG_POST = 1886352244;
    static final int TAG_OS2 = 1330851634;
    static final int TAG_CVT = 1668707360;
    static final int TAG_GASP = 1734439792;
    static final int TAG_VDMX = 1447316824;
    static final int TAG_VMTX = 1986884728;
    static final int TAG_VHEA = 1986553185;
    static final int TAG_HHEA = 1751672161;
    static final int TAG_TYP1 = 1954115633;
    static final int TAG_BSLN = 1651731566;
    static final int TAG_GSUB = 1196643650;
    static final int TAG_DSIG = 1146308935;
    static final int TAG_FPGM = 1718642541;
    static final int TAG_FVAR = 1719034226;
    static final int TAG_GVAR = 1735811442;
    static final int TAG_CFF = 1128678944;
    static final int TAG_MMSD = 1296913220;
    static final int TAG_MMFX = 1296909912;
    static final int TAG_BASE = 1111577413;
    static final int TAG_GDEF = 1195656518;
    static final int TAG_GPOS = 1196445523;
    static final int TAG_JSTF = 1246975046;
    static final int TAG_EBDT = 0x45424454;
    static final int TAG_EBLC = 1161972803;
    static final int TAG_EBSC = 1161974595;
    static final int TAG_LTSH = 1280594760;
    static final int TAG_PCLT = 1346587732;
    static final int TAG_ACNT = 1633906292;
    static final int TAG_AVAR = 1635148146;
    static final int TAG_BDAT = 1650745716;
    static final int TAG_BLOC = 1651273571;
    static final int TAG_CVAR = 1668702578;
    static final int TAG_FEAT = 1717920116;
    static final int TAG_FDSC = 1717859171;
    static final int TAG_FMTX = 1718449272;
    static final int TAG_JUST = 1786082164;
    static final int TAG_LCAR = 1818452338;
    static final int TAG_MORT = 1836020340;
    static final int TAG_OPBD = 1836020340;
    static final int TAG_PROP = 1886547824;
    static final int TAG_TRAK = 1953653099;
    String psName = null;
    int firstChar = 32;
    int lastChar = 255;
    File file;

    TTFontInfo() {
    }

    static double getFIXED(byte[] byArray, int n) {
        return (double)TTFontInfo.getSHORT(byArray, n) + (double)TTFontInfo.getSHORT(byArray, n + 2) / 255.0;
    }

    public int getFirstChar() {
        return this.firstChar;
    }

    public File getFontFile() {
        return this.file;
    }

    public static String[] getFontNames(File file) throws IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        byte[] byArray = new byte[8192];
        String string = null;
        String string2 = null;
        randomAccessFile.read(byArray, 0, 12);
        int n = TTFontInfo.getSHORT(byArray, 4);
        int n2 = 0;
        while (n2 < n) {
            randomAccessFile.read(byArray, 0, 16);
            int n3 = TTFontInfo.getLONG(byArray, 0);
            if (n3 == 1851878757) {
                int n4 = TTFontInfo.getLONG(byArray, 8);
                int n5 = TTFontInfo.getLONG(byArray, 12);
                randomAccessFile.seek(n4);
                byArray = new byte[n5];
                randomAccessFile.read(byArray, 0, n5);
                int n6 = TTFontInfo.getSHORT(byArray, 2);
                int n7 = TTFontInfo.getSHORT(byArray, 4);
                int n8 = 6;
                int n9 = 0;
                while (n9 < n6) {
                    int n10 = TTFontInfo.getSHORT(byArray, n8 + 6);
                    int n11 = TTFontInfo.getSHORT(byArray, n8 + 8);
                    int n12 = TTFontInfo.getSHORT(byArray, n8 + 10);
                    String string3 = new String(byArray, n7 + n12, n11, "UnicodeBig");
                    if (n10 == 1) {
                        string = string3;
                    } else if (n10 == 4) {
                        string2 = string3;
                    }
                    ++n9;
                    n8 += 12;
                }
                break;
            }
            ++n2;
        }
        randomAccessFile.close();
        return new String[]{string, string2};
    }

    static int getLONG(byte[] byArray, int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < 4) {
            n2 = n2 << 8 | byArray[n++] & 0xFF;
            ++n3;
        }
        return n2;
    }

    public int getLastChar() {
        return this.lastChar;
    }

    public String getPSName() {
        return this.psName;
    }

    static int getSHORT(byte[] byArray, int n) {
        return byArray[n] << 8 | byArray[n + 1] & 0xFF;
    }

    public static void main(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            try {
                TTFontInfo tTFontInfo = new TTFontInfo();
                tTFontInfo.parse(new File(stringArray[n]));
                System.err.println("[" + stringArray[n] + "]");
                System.err.println("getFontName = " + tTFontInfo.getFontName());
                System.err.println("getFullName = " + tTFontInfo.getFullName());
                System.err.println("getFamilyName = " + tTFontInfo.getFamilyName());
                System.err.println("getPSName = " + tTFontInfo.getPSName());
                System.err.println("getWeight = " + tTFontInfo.getWeight());
                System.err.println("isFixedPitch = " + tTFontInfo.isFixedPitch());
                System.err.println("getAscent = " + tTFontInfo.getAscent());
                System.err.println("getDescent = " + tTFontInfo.getDescent());
                System.err.println("getMaxAdvance = " + tTFontInfo.getMaxAdvance());
                System.err.println("getItalicAngle = " + tTFontInfo.getItalicAngle());
                System.err.println("getFontBBox = " + tTFontInfo.getFontBBox());
                System.err.println("getEncoding = " + tTFontInfo.getEncoding());
                System.err.println("getCapHeight = " + tTFontInfo.getCapHeight());
                int[] nArray = tTFontInfo.getWidths();
                System.err.print("width[");
                int n2 = 0;
                while (n2 < nArray.length) {
                    if (n2 % 18 == 0) {
                        System.err.println("");
                    }
                    System.err.print(String.valueOf(nArray[n2]) + " ");
                    ++n2;
                }
                System.err.println("]");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ++n;
        }
    }

    public void parse(File file) throws IOException {
        int n;
        this.file = file;
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        int n2 = 0;
        byte[] byArray = new byte[4096];
        byte[] byArray2 = new byte[8192];
        int[] nArray = null;
        int n3 = 16;
        int n4 = 1;
        randomAccessFile.read(byArray, 0, 12);
        int n5 = TTFontInfo.getSHORT(byArray, 4);
        n2 += 12;
        int n6 = 0;
        while (n6 < n5) {
            int n7;
            int n8;
            int n9;
            int n10;
            int n11;
            randomAccessFile.seek(n2);
            randomAccessFile.read(byArray, 0, 16);
            n2 += 16;
            int n12 = TTFontInfo.getLONG(byArray, 0);
            n = TTFontInfo.getLONG(byArray, 8);
            int n13 = TTFontInfo.getLONG(byArray, 12);
            randomAccessFile.seek(n);
            if (byArray2.length < n13) {
                byArray2 = new byte[n13];
            }
            if (n12 == 1751474532) {
                randomAccessFile.read(byArray2, 0, n13);
                n3 = TTFontInfo.getSHORT(byArray2, 18);
                this.bbox = new Rectangle(TTFontInfo.getSHORT(byArray2, 36), TTFontInfo.getSHORT(byArray2, 38), TTFontInfo.getSHORT(byArray2, 40), TTFontInfo.getSHORT(byArray2, 42));
            } else if (n12 == 1751672161) {
                randomAccessFile.read(byArray2, 0, n13);
                this.ascender = TTFontInfo.getSHORT(byArray2, 4);
                this.descender = TTFontInfo.getSHORT(byArray2, 6);
                this.advance = TTFontInfo.getSHORT(byArray2, 10);
                n4 = TTFontInfo.getSHORT(byArray2, 34);
                if (this.capHeight == 0) {
                    this.capHeight = this.ascender;
                }
            } else if (n12 == 1886352244) {
                randomAccessFile.read(byArray2, 0, n13);
                this.italicAngle = TTFontInfo.getFIXED(byArray2, 4);
                this.fixedPitch = TTFontInfo.getLONG(byArray2, 12) != 0;
            } else if (n12 == 1346587732) {
                randomAccessFile.read(byArray2, 0, n13);
                this.capHeight = TTFontInfo.getSHORT(byArray2, 16);
            } else if (n12 == 1851878757) {
                randomAccessFile.read(byArray2, 0, n13);
                n11 = TTFontInfo.getSHORT(byArray2, 2);
                n10 = TTFontInfo.getSHORT(byArray2, 4);
                n9 = 6;
                n8 = 0;
                while (n8 < n11) {
                    n7 = TTFontInfo.getSHORT(byArray2, n9 + 6);
                    int n14 = TTFontInfo.getSHORT(byArray2, n9 + 8);
                    int n15 = TTFontInfo.getSHORT(byArray2, n9 + 10);
                    String string = new String(byArray2, n10 + n15, n14, "UnicodeBig");
                    switch (n7) {
                        case 1: {
                            this.familyName = string;
                            this.fontName = string;
                            break;
                        }
                        case 4: {
                            this.fullName = string;
                            break;
                        }
                        case 6: {
                            this.psName = string;
                            break;
                        }
                    }
                    ++n8;
                    n9 += 12;
                }
            } else if (n12 == 1668112752) {
                randomAccessFile.read(byArray2, 0, n13);
                n11 = TTFontInfo.getSHORT(byArray2, 2);
                n10 = 0;
                while (n10 < n11) {
                    n9 = TTFontInfo.getLONG(byArray2, 4 + n10 * 8 + 4);
                    n8 = TTFontInfo.getSHORT(byArray2, n9);
                    switch (n8) {
                        case 0: {
                            nArray = new int[256];
                            n7 = 0;
                            while (n7 < nArray.length) {
                                nArray[n7] = byArray2[n9 + 6 + n7] & 0xFF;
                                ++n7;
                            }
                            break;
                        }
                    }
                    ++n10;
                }
            } else if (n12 == 1752003704) {
                randomAccessFile.read(byArray2, 0, n13);
                this.widths = new int[Math.max(n4, 256)];
                n11 = 0;
                while (n11 < n4) {
                    this.widths[n11] = TTFontInfo.getSHORT(byArray2, n11 * 4);
                    ++n11;
                }
                n10 = n11;
                while (n10 < this.widths.length) {
                    this.widths[n10] = this.widths[n11 - 1];
                    ++n10;
                }
            } else if (n12 == 1668707360) {
                randomAccessFile.read(byArray2, 0, n13);
                n11 = 0;
                while (n11 < n13 / 2) {
                    ++n11;
                }
            }
            ++n6;
        }
        this.ascender = this.ascender * 1000 / n3;
        this.descender = this.descender * 1000 / n3;
        this.advance = this.advance * 1000 / n3;
        this.capHeight = this.capHeight * 1000 / n3;
        this.bbox.x = this.bbox.x * 1000 / n3;
        this.bbox.y = this.bbox.y * 1000 / n3;
        this.bbox.width = this.bbox.width * 1000 / n3;
        this.bbox.height = this.bbox.height * 1000 / n3;
        if (nArray != null) {
            int[] nArray2 = new int[256];
            n = 0;
            while (n < nArray2.length) {
                nArray2[n] = this.widths[nArray[n]];
                ++n;
            }
            this.widths = nArray2;
        } else {
            System.err.println("no format 0 table");
        }
        int n16 = 0;
        while (n16 < this.widths.length) {
            this.widths[n16] = this.widths[n16] * 1000 / n3;
            ++n16;
        }
        randomAccessFile.close();
    }
}

