/*
 * Decompiled with CFR 0.152.
 */
package inetsoft.report.pdf;

import inetsoft.report.Common;
import inetsoft.report.PDFPrinter;
import inetsoft.report.internal.AFManager;
import inetsoft.report.internal.AFontMetrics;
import inetsoft.report.internal.Encoder;
import inetsoft.report.pdf.FontInfo;
import inetsoft.report.pdf.FontManager;
import inetsoft.report.pdf.TTFontInfo;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.OutputStream;

public class PDF3Printer
extends PDFPrinter {
    static final String[] base14fonts = new String[]{"Times", "Helvetica", "Courier"};
    private boolean embedFont = false;
    private boolean base14 = false;
    private FontManager fontMgr = FontManager.getFontManager();

    public PDF3Printer(OutputStream outputStream) {
        super(outputStream);
    }

    protected void emitFont(Font font) {
        this.psFontName = this.getFontName(font);
        if (this.isBase14Font(this.psFontName)) {
            super.emitFont(font);
            return;
        }
        this.initPage();
        this.debug(this.pg, "%setFont3");
        String string = (String)this.fontFn.get(this.psFontName);
        if (string == null) {
            string = "F" + this.fontIdx++;
            String string2 = (String)this.fontObj.get(this.psFontName);
            if (string2 == null) {
                string2 = String.valueOf(this.objId) + " 0 R";
                this.fontObj.put(this.psFontName, string2);
                FontInfo fontInfo = this.fontMgr.getFontInfo(this.psFontName);
                boolean bl = fontInfo instanceof TTFontInfo;
                int[] nArray = fontInfo.getWidths();
                Rectangle rectangle = fontInfo.getFontBBox();
                String string3 = this.strip(fontInfo.getFontName(), " ");
                String string4 = "";
                if ((font.getStyle() & 1) != 0) {
                    string4 = String.valueOf(string4) + "Bold";
                }
                if ((font.getStyle() & 2) != 0) {
                    string4 = String.valueOf(string4) + "Italic";
                }
                if (string4.length() > 0) {
                    string3 = String.valueOf(string3) + "," + string4;
                }
                this.others.markObject(this.objId);
                this.others.println(String.valueOf(this.objId) + " 0 obj");
                ++this.objId;
                this.others.println("<<");
                this.others.println("/Type /Font");
                this.others.println("/Subtype /" + (bl ? "TrueType" : "Type1"));
                this.others.println("/Name /" + string);
                this.others.println("/BaseFont /" + string3);
                this.others.println("/Encoding /WinAnsiEncoding");
                this.others.println("/FirstChar 32");
                this.others.println("/LastChar 255");
                this.others.print("/Widths [");
                int n = 32;
                while (n <= 255) {
                    this.others.print(" " + nArray[n]);
                    ++n;
                }
                this.others.println("]");
                this.others.println("/FontDescriptor " + this.objId + " 0 R");
                this.others.println(">>");
                this.others.println("endobj");
                this.others.markObject(this.objId);
                this.others.println(String.valueOf(this.objId) + " 0 obj");
                ++this.objId;
                this.others.println("<<");
                this.others.println("/Type /FontDescriptor");
                this.others.println("/FontName /" + string3);
                this.others.println("/Flags 34");
                this.others.println("/FontBBox [ " + rectangle.x + " " + rectangle.y + " " + rectangle.width + " " + rectangle.height + " ]");
                this.others.println("/StemV 73");
                this.others.println("/ItalicAngle " + ((font.getStyle() & 2) != 0 ? fontInfo.getItalicAngle() : 0.0));
                this.others.println("/CapHeight " + fontInfo.getCapHeight());
                this.others.println("/Ascent " + fontInfo.getAscent());
                this.others.println("/Descent " + fontInfo.getDescent());
                if (bl && this.embedFont) {
                    this.others.println("/FontFile2 " + this.objId + " 0 R");
                }
                this.others.println(">>");
                this.others.println("endobj");
                if (bl && this.embedFont) {
                    try {
                        int n2;
                        File file = ((TTFontInfo)fontInfo).getFontFile();
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream((int)file.length());
                        FileInputStream fileInputStream = new FileInputStream(file);
                        byte[] byArray = new byte[4096];
                        while ((n2 = fileInputStream.read(byArray)) > 0) {
                            byteArrayOutputStream.write(byArray, 0, n2);
                        }
                        fileInputStream.close();
                        this.others.markObject(this.objId);
                        this.others.println(String.valueOf(this.objId) + " 0 obj");
                        ++this.objId;
                        this.others.println("<<");
                        this.others.println("/Filter [ /ASCII85Decode /FlateDecode ]");
                        this.others.println("/Length " + this.objId + " 0 R");
                        this.others.println(">>");
                        this.others.println("stream");
                        int n3 = this.others.getOffset();
                        byte[] byArray2 = Encoder.encodeAscii85(Encoder.deflate(byteArrayOutputStream.toByteArray()));
                        int n4 = 0;
                        while (n4 < byArray2.length) {
                            if (n4 > 0) {
                                this.others.println("");
                            }
                            this.others.write(byArray2, n4, Math.min(byArray2.length - n4, 78));
                            n4 += 78;
                        }
                        this.others.println("~>");
                        int n5 = this.others.getOffset() - n3;
                        this.others.println("endstream");
                        this.others.println("endobj");
                        this.others.markObject(this.objId);
                        this.others.println(String.valueOf(this.objId) + " 0 obj");
                        ++this.objId;
                        this.others.println(String.valueOf(n5));
                        this.others.println("endobj");
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
            this.fnList.addElement("/" + string + " " + string2 + " ");
        }
        this.pg.println("/" + string + " " + font.getSize() + " Tf");
        this.fontFn.put(this.psFontName, string);
    }

    public FontMetrics getFontMetrics(Font font) {
        AFontMetrics aFontMetrics = AFManager.getFontMetrics(this.getFontName(font), font.getSize());
        return aFontMetrics == null ? Common.getFontMetrics(font) : aFontMetrics;
    }

    public String getFontName(Font font) {
        if (!this.fontMgr.exists(Common.getFontName(font))) {
            return super.getFontName(font);
        }
        return Common.getFontName(font);
    }

    protected boolean isBase14Font(String string) {
        int n = 0;
        while (n < base14fonts.length) {
            if (string.equals(base14fonts[n]) || string.startsWith(String.valueOf(base14fonts[n]) + "-")) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean isBase14Only() {
        return this.base14;
    }

    public boolean isEmbedFont() {
        return this.embedFont;
    }

    public void setBase14Only(boolean bl) {
        this.base14 = bl;
    }

    public void setEmbedFont(boolean bl) {
        this.embedFont = bl;
    }

    String strip(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            if (string2.indexOf(string.charAt(n)) < 0) {
                stringBuffer.append(string.charAt(n));
            }
            ++n;
        }
        return stringBuffer.toString();
    }
}

