/*
 * Decompiled with CFR 0.152.
 */
package inetsoft.report.pdf;

import inetsoft.report.Paintable;
import inetsoft.report.ReportElement;
import inetsoft.report.Size;
import inetsoft.report.StylePage;
import inetsoft.report.StyleSheet;
import inetsoft.report.internal.PaperSize;
import inetsoft.report.internal.TextContext;
import inetsoft.report.internal.TextPaintable;
import inetsoft.report.pdf.Node;
import inetsoft.report.pdf.PDF3Printer;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.PrintJob;
import java.io.OutputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public class PDF3Generator {
    PDF3 printer = null;

    public PDF3Generator(OutputStream outputStream) {
        this.printer = new PDF3(outputStream);
    }

    private void addBookmark(Node node) {
        Node node2;
        String string = "<<\n";
        if (node.getLabel() != null) {
            string = String.valueOf(string) + "/Title (" + node + ")\n";
        }
        if (node.getPageID() != null) {
            string = String.valueOf(string) + "/Dest [" + node.getPageID() + " /FitH " + node.getPageY() + "]\n";
        }
        if (node.getParent() != null) {
            string = String.valueOf(string) + "/Parent " + node.getParent().getID() + " 0 R\n";
        }
        if ((node2 = node.getNext()) != null) {
            string = String.valueOf(string) + "/Next " + node2.getID() + " 0 R\n";
        }
        if (node.getChildCount() > 0) {
            Node node3 = node.getChild(0);
            string = String.valueOf(string) + "/First " + node3.getID() + " 0 R\n";
            node3 = node.getChild(node.getChildCount() - 1);
            string = String.valueOf(string) + "/Last " + node3.getID() + " 0 R\n";
            string = String.valueOf(string) + "/Count " + node.getNodeCount();
        }
        string = String.valueOf(string) + ">>\n";
        this.printer.addObject(node.getID(), string);
        int n = 0;
        while (n < node.getChildCount()) {
            this.addBookmark(node.getChild(n));
            ++n;
        }
    }

    public void generate(StyleSheet styleSheet) {
        StylePage stylePage;
        int n = PaperSize.getOrientation(styleSheet.getProperty("Orientation"));
        Size size = PaperSize.getSize(styleSheet.getProperty("PageSize"));
        if (size != null) {
            this.setPageSize(n == 0 ? size.rotate() : size);
        }
        boolean bl = true;
        Vector<StylePage> vector = new Vector<StylePage>();
        Date date = new Date();
        PrintJob printJob = this.printer.getPrintJob();
        Dimension dimension = printJob.getPageDimension();
        int n2 = printJob.getPageResolution();
        styleSheet.reset();
        while (bl) {
            stylePage = new StylePage(dimension, n2);
            bl = styleSheet.printNext(stylePage);
            vector.addElement(stylePage);
        }
        int n3 = styleSheet.getPageNumberingStart();
        int n4 = 0;
        while (n4 < vector.size()) {
            stylePage = (StylePage)vector.elementAt(n4);
            styleSheet.printHeaderFooter(stylePage, n4, n4 - n3 + 1, vector.size() - n3, date);
            Graphics graphics = printJob.getGraphics();
            stylePage.print(graphics);
            graphics.dispose();
            ++n4;
        }
        this.generate(vector);
    }

    public void generate(Enumeration enumeration) {
        Vector vector = new Vector();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        this.generate(vector);
    }

    public void generate(Vector vector) {
        Object object;
        Object object2;
        Object object3;
        if (vector.size() > 0) {
            object3 = ((StylePage)vector.elementAt(0)).getPageDimension();
            this.setPageSize(new Size((double)((Dimension)object3).width / 72.0, (double)((Dimension)object3).height / 72.0));
        }
        object3 = this.printer.getPrintJob();
        int n = ((PrintJob)object3).getPageDimension().height;
        int n2 = 0;
        while (n2 < vector.size()) {
            object2 = (StylePage)vector.elementAt(n2);
            object = ((PrintJob)object3).getGraphics();
            ((StylePage)object2).print((Graphics)object);
            ((Graphics)object).dispose();
            ++n2;
        }
        object2 = new Node(null);
        ((Node)object2).setID(this.printer.nextID());
        object = object2;
        int n3 = 0;
        int n4 = 0;
        while (n4 < vector.size()) {
            StylePage stylePage = (StylePage)vector.elementAt(n4);
            int n5 = 0;
            while (n5 < stylePage.getPaintableCount()) {
                Paintable paintable = stylePage.getPaintable(n5);
                ReportElement reportElement = paintable.getElement();
                if (reportElement instanceof TextContext) {
                    int n6 = ((TextContext)reportElement).getLevel();
                    Node node = new Node(((TextPaintable)paintable).getText());
                    node.setID(this.printer.nextID());
                    node.setPageID(this.printer.getPageID(n4));
                    node.setPageY(n - paintable.getBounds().y);
                    if (n6 > n3) {
                        ((Node)object).addChild(node);
                    } else if (n6 == n3) {
                        if ((object = ((Node)object).getParent()) == null) {
                            object = object2;
                        }
                        ((Node)object).addChild(node);
                    } else {
                        int n7 = 0;
                        while (n7 < n3 - n6 + 1 && object != null) {
                            object = ((Node)object).getParent();
                            ++n7;
                        }
                        if (object == null) {
                            object = object2;
                        }
                        ((Node)object).addChild(node);
                    }
                    object = node;
                    n3 = n6;
                }
                ++n5;
            }
            ++n4;
        }
        this.addBookmark((Node)object2);
        this.printer.flush();
        this.printer.setOutlines(String.valueOf(((Node)object2).getID()) + " 0 R");
        this.printer.close();
    }

    public Size getPageSize() {
        return this.printer.getPageSize();
    }

    public PDF3Printer getPrinter() {
        return this.printer;
    }

    public void setPageSize(Size size) {
        this.printer.setPageSize(size);
    }

    class PDF3
    extends PDF3Printer {
        public PDF3(OutputStream outputStream) {
            super(outputStream);
        }

        public void addObject(int n, String string) {
            this.others.markObject(n);
            this.others.println(String.valueOf(n) + " 0 obj");
            this.others.println(string);
            this.others.println("endobj");
        }

        public void flush() {
            this.writeOthers();
        }

        public String getPageID(int n) {
            return (String)this.pageIds.elementAt(n);
        }

        public int nextID() {
            return this.objId++;
        }

        public void setOutlines(String string) {
            this.outlines = string;
        }
    }
}

