/*
 * Decompiled with CFR 0.152.
 */
package inetsoft.report.pdf;

import java.util.Vector;

class Node {
    private String label;
    private Node parent = null;
    private Vector children = new Vector();
    private String pageId = null;
    private int pageY = 0;
    private int id = 0;

    Node(String string) {
        this.label = string;
    }

    void addChild(Node node) {
        if (node.parent != null) {
            node.parent.removeChild(node);
        }
        node.parent = this;
        this.children.addElement(node);
    }

    public Node getChild(int n) {
        return (Node)this.children.elementAt(n);
    }

    public int getChildCount() {
        return this.children.size();
    }

    public int getID() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public Node getNext() {
        if (this.parent != null) {
            int n = 0;
            while (n < this.parent.getChildCount()) {
                if (this.parent.getChild(n) == this) {
                    return n < this.parent.getChildCount() - 1 ? this.parent.getChild(n + 1) : null;
                }
                ++n;
            }
        }
        return null;
    }

    public int getNodeCount() {
        if (this.getChildCount() == 0) {
            return 0;
        }
        int n = this.getChildCount();
        int n2 = 0;
        while (n2 < this.getChildCount()) {
            n += this.getChild(n2).getNodeCount();
            ++n2;
        }
        return n;
    }

    public String getPageID() {
        return this.pageId;
    }

    public int getPageY() {
        return this.pageY;
    }

    public Node getParent() {
        return this.parent;
    }

    void removeChild(Node node) {
        int n = this.children.indexOf(node);
        if (n >= 0) {
            this.children.removeElementAt(n);
            node.parent = null;
        }
    }

    public void setID(int n) {
        this.id = n;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public void setPageID(String string) {
        this.pageId = string;
    }

    public void setPageY(int n) {
        this.pageY = n;
    }

    public String toString() {
        return this.getLabel();
    }
}

