/*
 * Decompiled with CFR 0.152.
 */
package inetsoft.report.pdf;

import inetsoft.report.ReportEnv;
import inetsoft.report.pdf.AFMFontInfo;
import inetsoft.report.pdf.FontInfo;
import inetsoft.report.pdf.TTFontInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class FontManager {
    private static FontManager fontMgr = null;
    private Hashtable cache = new Hashtable();
    private Hashtable ttNameMap = new Hashtable();
    private Hashtable ttFullMap = new Hashtable();
    private Hashtable afmNameMap = new Hashtable();
    private Hashtable afmFullMap = new Hashtable();

    private FontManager() {
        String[] stringArray;
        File file;
        int n;
        String[] stringArray2;
        File file2;
        String string;
        String string2 = ReportEnv.getProperty("font.truetype.path", "c:/winnt/fonts");
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ";");
        while (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
            file2 = new File(string);
            if (file2.exists()) {
                stringArray2 = file2.list();
                n = 0;
                while (n < stringArray2.length) {
                    if (stringArray2[n].toLowerCase().endsWith(".ttf")) {
                        try {
                            file = new File(string, stringArray2[n]);
                            stringArray = TTFontInfo.getFontNames(file);
                            this.ttNameMap.put(stringArray[0], file);
                            this.ttFullMap.put(stringArray[1], file);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    ++n;
                }
                continue;
            }
            System.err.println("TrueType font directory does not exist: " + string);
        }
        string2 = ReportEnv.getProperty("font.afm.path");
        if (string2 != null) {
            stringTokenizer = new StringTokenizer(string2, ";");
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
                file2 = new File(string);
                if (file2.exists()) {
                    stringArray2 = file2.list();
                    n = 0;
                    while (n < stringArray2.length) {
                        if (stringArray2[n].toLowerCase().endsWith(".afm")) {
                            try {
                                file = new File(string, stringArray2[n]);
                                stringArray = AFMFontInfo.getFontNames(new FileInputStream(file));
                                if (stringArray != null) {
                                    this.afmNameMap.put(stringArray[0], file);
                                    if (stringArray[1] == null) {
                                        this.afmFullMap.put(stringArray[0], file);
                                    } else {
                                        this.afmFullMap.put(stringArray[1], file);
                                    }
                                }
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                        ++n;
                    }
                    continue;
                }
                System.err.println("AFM font directory does not exist: " + string);
            }
        }
    }

    public boolean exists(String string) {
        return this.ttNameMap.get(string) != null || this.ttFullMap.get(string) != null || this.afmNameMap.get(string) != null || this.afmFullMap.get(string) != null;
    }

    public FontInfo getFontInfo(String string) {
        FontInfo fontInfo = (FontInfo)this.cache.get(string);
        if (fontInfo == null) {
            try {
                fontInfo = this.loadFontInfo(string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.cache.put(string, fontInfo == null ? new TTFontInfo() : fontInfo);
        }
        return fontInfo.getFamilyName() != null ? fontInfo : null;
    }

    public static synchronized FontManager getFontManager() {
        return fontMgr == null ? (fontMgr = new FontManager()) : fontMgr;
    }

    protected FontInfo loadFontInfo(String string) throws IOException {
        File file = (File)this.ttNameMap.get(string);
        if (file != null) {
            TTFontInfo tTFontInfo = new TTFontInfo();
            tTFontInfo.parse(file);
            return tTFontInfo;
        }
        file = (File)this.ttFullMap.get(string);
        if (file != null) {
            TTFontInfo tTFontInfo = new TTFontInfo();
            tTFontInfo.parse(file);
            return tTFontInfo;
        }
        file = (File)this.afmNameMap.get(string);
        if (file != null) {
            AFMFontInfo aFMFontInfo = new AFMFontInfo();
            aFMFontInfo.parse(new FileInputStream(file));
            return aFMFontInfo;
        }
        file = (File)this.afmFullMap.get(string);
        if (file != null) {
            AFMFontInfo aFMFontInfo = new AFMFontInfo();
            aFMFontInfo.parse(new FileInputStream(file));
            return aFMFontInfo;
        }
        return null;
    }
}

