/*
 * Decompiled with CFR 0.152.
 */
package inetsoft.report.painter;

import inetsoft.report.Common;
import inetsoft.report.Presenter;
import inetsoft.report.StyleConstants;
import inetsoft.report.internal.Bounds;
import inetsoft.report.internal.Util;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class ShadowPresenter
implements Presenter,
StyleConstants {
    private Font font = new Font("Serif", 1, 10);
    private FontMetrics fm = Common.getFontMetrics(this.font);
    private int shadow = 4;
    private Color textC = Color.black;
    private Color shading = Color.white;

    public ShadowPresenter() {
    }

    public ShadowPresenter(Font font) {
        this.font = font;
    }

    public Font getFont() {
        return this.font;
    }

    public Dimension getPreferredSize(Object object) {
        if (object == null) {
            return new Dimension(0, 0);
        }
        return new Dimension(this.fm.stringWidth(Util.toString(object)) + this.shadow + 8, this.fm.getHeight() + this.shadow + 2);
    }

    public Color getShading() {
        return this.shading;
    }

    public Color getTextColor() {
        return this.textC;
    }

    public boolean isPresenterOf(Class clazz) {
        return true;
    }

    public void paint(Graphics graphics, Object object, int n, int n2, int n3, int n4) {
        Color color = graphics.getColor();
        Font font = graphics.getFont();
        graphics.setColor(Color.white);
        graphics.fillRect(n, n2, n3, n4);
        graphics.setColor(Color.black);
        graphics.fillRect(n + this.shadow, n2 + this.shadow, n3 - this.shadow, n4 - this.shadow);
        graphics.setColor(this.shading);
        graphics.fillRect(n, n2, n3 - this.shadow, n4 - this.shadow);
        graphics.setColor(Color.black);
        graphics.drawRect(n, n2, n3 - this.shadow, n4 - this.shadow);
        if (object != null) {
            graphics.setColor(this.textC);
            graphics.setFont(this.font);
            Common.paintText(graphics, Util.toString(object), new Bounds(n, n2, n3 - this.shadow, n4 - this.shadow), 18, true, false);
        }
        graphics.setColor(color);
        graphics.setFont(font);
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public void setShading(Color color) {
        this.shading = color;
    }

    public void setTextColor(Color color) {
        this.textC = color;
    }
}

