/*
 * Decompiled with CFR 0.152.
 */
package inetsoft.report.painter;

import inetsoft.report.Common;
import inetsoft.report.Painter;
import inetsoft.report.internal.Encoder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class ImagePainter
implements Painter {
    protected static final Component component = new Component(){};
    protected static final MediaTracker tracker = new MediaTracker(component);
    private transient Image image;
    private Dimension isize;
    private boolean fit = true;

    public ImagePainter(Image image) {
        this.setImage(image);
    }

    public ImagePainter(Image image, boolean bl) {
        this(image);
        this.fit = bl;
    }

    public Image getImage() {
        return this.image;
    }

    public Dimension getPreferredSize() {
        return this.isize.width < 0 || this.isize.height < 0 ? new Dimension(20, 20) : new Dimension(this.isize);
    }

    public boolean isScalable() {
        return false;
    }

    public void paint(Graphics graphics, int n, int n2, int n3, int n4) {
        if (this.isize.width < 0 || this.isize.height < 0) {
            Color color = graphics.getColor();
            graphics.setColor(Color.gray);
            graphics.fillRect(n, n2, n3, n4);
            graphics.setColor(color);
        } else if (this.fit) {
            Common.drawImage(graphics, this.image, n, n2, n3, n4, component);
        } else {
            graphics.drawImage(this.image, n, n2, component);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        if (byArray != null) {
            int n = objectInputStream.readInt();
            int n2 = objectInputStream.readInt();
            this.image = Encoder.decodeImage(n, n2, byArray);
        }
    }

    public void setImage(Image image) {
        this.image = image;
        tracker.addImage(image, 0);
        try {
            tracker.waitForAll();
        }
        catch (Exception exception) {}
        this.isize = new Dimension(image.getWidth(null), image.getHeight(null));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        byte[] byArray = this.image != null ? Encoder.encodeImage(this.image) : null;
        objectOutputStream.writeObject(byArray);
        if (byArray != null) {
            objectOutputStream.writeInt(this.image.getWidth(null));
            objectOutputStream.writeInt(this.image.getHeight(null));
        }
    }
}

