/*
 * Decompiled with CFR 0.152.
 */
package inetsoft.report.painter;

import inetsoft.report.Common;
import inetsoft.report.Presenter;
import inetsoft.report.StyleConstants;
import inetsoft.report.internal.Bounds;
import inetsoft.report.internal.Util;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class ButtonPresenter
implements Presenter,
StyleConstants {
    private Color color = Color.lightGray;
    private Font font = new Font("Dialog", 1, 10);
    FontMetrics fm = Common.getFontMetrics(this.font);

    public ButtonPresenter() {
    }

    public ButtonPresenter(Color color, Font font) {
        this.color = color;
        this.font = font;
    }

    public Color getColor() {
        return this.color;
    }

    public Font getFont() {
        return this.font;
    }

    public Dimension getPreferredSize(Object object) {
        if (object == null) {
            return new Dimension(0, 0);
        }
        return new Dimension(this.fm.stringWidth(Util.toString(object)) + 4, this.fm.getHeight() + 4);
    }

    public boolean isPresenterOf(Class clazz) {
        return true;
    }

    public void paint(Graphics graphics, Object object, int n, int n2, int n3, int n4) {
        Color color = graphics.getColor();
        Font font = graphics.getFont();
        graphics.setColor(this.color);
        graphics.fill3DRect(n, n2, n3, n4, true);
        if (object != null) {
            graphics.setColor(Color.black);
            graphics.setFont(this.font);
            Common.paintText(graphics, Util.toString(object), new Bounds(n, n2, n3, n4), 18, true, false);
        }
        graphics.setColor(color);
        graphics.setFont(font);
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setFont(Font font) {
        this.font = font;
    }
}

