/*
 * Decompiled with CFR 0.152.
 */
package inetsoft.report.lens;

import inetsoft.report.lens.AbstractTableLens;
import inetsoft.report.lens.AttributeTableLens;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.Format;
import java.util.StringTokenizer;
import java.util.Vector;

public class TextTableLens
extends AttributeTableLens {
    Vector rows = new Vector();
    Format[] fmts = null;
    int ncol = 0;
    int hrow = 0;
    int hcol = 0;
    int maxr = 0;
    String delim = "\t";
    boolean[] colsmask;

    public TextTableLens(InputStream inputStream) throws IOException {
        this(inputStream, null, null, null);
    }

    public TextTableLens(InputStream inputStream, String string) throws IOException {
        this(inputStream, string, null, null);
    }

    public TextTableLens(InputStream inputStream, String string, int[] nArray) throws IOException {
        this(inputStream, string, nArray, null);
    }

    public TextTableLens(InputStream inputStream, String string, int[] nArray, Format[] formatArray) throws IOException {
        if (string != null) {
            this.delim = string;
        }
        if (nArray != null) {
            int n = 0;
            int n2 = 0;
            while (n2 < nArray.length) {
                n = Math.max(n, nArray[n2]);
                ++n2;
            }
            this.colsmask = new boolean[n + 1];
            int n3 = 0;
            while (n3 < nArray.length) {
                this.colsmask[nArray[n3]] = true;
                ++n3;
            }
        }
        this.fmts = formatArray;
        this.setTable(new TextTable(inputStream));
    }

    boolean includeColumn(int n) {
        return this.colsmask == null || n < this.colsmask.length && this.colsmask[n];
    }

    public void setHeaderRowCount(int n) {
        this.hrow = n;
    }

    public void setheaderColCount(int n) {
        this.hcol = n;
    }

    class TextTable
    extends AbstractTableLens {
        public TextTable(InputStream inputStream) throws IOException {
            try {
                String string;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                while ((string = bufferedReader.readLine()) != null) {
                    Vector<String> vector = new Vector<String>();
                    StringTokenizer stringTokenizer = new StringTokenizer(string, TextTableLens.this.delim);
                    int n = 0;
                    while (stringTokenizer.hasMoreTokens()) {
                        String string2 = stringTokenizer.nextToken();
                        if (string2.equals("null")) {
                            string2 = null;
                        }
                        if (TextTableLens.this.includeColumn(n)) {
                            if (TextTableLens.this.fmts != null && n < TextTableLens.this.fmts.length && TextTableLens.this.fmts[n] != null) {
                                try {
                                    Object object = TextTableLens.this.fmts[n].parseObject(string2);
                                    vector.addElement(string2);
                                }
                                catch (Exception exception) {
                                    vector.addElement(string2);
                                }
                            } else {
                                vector.addElement(string2);
                            }
                        }
                        ++n;
                    }
                    TextTableLens.this.rows.addElement(vector);
                    TextTableLens.this.ncol = Math.max(vector.size(), TextTableLens.this.ncol);
                    if (TextTableLens.this.maxr <= 0 || TextTableLens.this.rows.size() < TextTableLens.this.maxr) {
                        continue;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public int getAlignment(int n, int n2) {
            return 17;
        }

        public int getColBorder(int n, int n2) {
            return 0;
        }

        public Color getColBorderColor(int n, int n2) {
            return Color.black;
        }

        public int getColCount() {
            return TextTableLens.this.ncol;
        }

        public int getColWidth(int n) {
            return -1;
        }

        public Font getFont(int n, int n2) {
            return null;
        }

        public int getHeaderColCount() {
            return TextTableLens.this.hcol;
        }

        public int getHeaderRowCount() {
            return TextTableLens.this.hrow;
        }

        public Insets getInsets(int n, int n2) {
            return null;
        }

        public Object getObject(int n, int n2) {
            Vector vector = (Vector)TextTableLens.this.rows.elementAt(n);
            return n2 < vector.size() ? vector.elementAt(n2) : null;
        }

        public int getRowBorder(int n, int n2) {
            return n == 0 ? 8195 : 0;
        }

        public Color getRowBorderColor(int n, int n2) {
            return Color.black;
        }

        public int getRowCount() {
            return TextTableLens.this.rows.size();
        }

        public int getRowHeight(int n) {
            return -1;
        }

        public Dimension getSpan(int n, int n2) {
            return null;
        }
    }
}

