/*
 * Decompiled with CFR 0.152.
 */
package inetsoft.report.lens;

import inetsoft.report.TableFilter;
import inetsoft.report.TableLens;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;

public class SubTableLens
implements TableFilter {
    private TableLens table;
    private int[] rows;
    private int[] cols;

    public SubTableLens(TableLens tableLens, int n, int n2, int n3, int n4) {
        int n5;
        this.table = tableLens;
        if (n >= 0) {
            this.rows = new int[n3];
            n5 = 0;
            while (n5 < n3) {
                this.rows[n5] = n5 + n;
                ++n5;
            }
        }
        if (n2 >= 0) {
            this.cols = new int[n4];
            n5 = 0;
            while (n5 < n4) {
                this.cols[n5] = n5 + n2;
                ++n5;
            }
        }
        this.adjustHeader();
    }

    public SubTableLens(TableLens tableLens, Rectangle rectangle) {
        this(tableLens, rectangle.y, rectangle.x, rectangle.height, rectangle.width);
    }

    public SubTableLens(TableLens tableLens, int[] nArray, int[] nArray2) {
        this.table = tableLens;
        this.rows = nArray;
        this.cols = nArray2;
        this.adjustHeader();
    }

    private void adjustHeader() {
        int n = this.table.getHeaderRowCount();
        if (this.rows != null && n > 0 && this.rows[0] >= n) {
            int[] nArray = new int[this.rows.length + n];
            System.arraycopy(this.rows, 0, nArray, n, this.rows.length);
            int n2 = 0;
            while (n2 < n) {
                nArray[n2] = n2;
                ++n2;
            }
            this.rows = nArray;
        }
        int n3 = this.table.getHeaderColCount();
        if (this.cols != null && n3 > 0 && this.cols[0] >= n3) {
            int[] nArray = new int[this.cols.length + n3];
            System.arraycopy(this.cols, 0, nArray, n3, this.cols.length);
            int n4 = 0;
            while (n4 < n3) {
                nArray[n4] = n4;
                ++n4;
            }
            this.cols = nArray;
        }
    }

    public int getAlignment(int n, int n2) {
        return this.table.getAlignment(this.getR(n), this.getC(n2));
    }

    public Color getBackground(int n, int n2) {
        return this.table.getBackground(this.getR(n), this.getC(n2));
    }

    private int getC(int n) {
        return this.cols == null ? n : (n < 0 ? n : this.cols[n]);
    }

    public int getColBorder(int n, int n2) {
        return this.table.getColBorder(this.getR(n), this.getC(n2));
    }

    public Color getColBorderColor(int n, int n2) {
        return this.table.getColBorderColor(this.getR(n), this.getC(n2));
    }

    public int getColCount() {
        return this.cols != null ? this.cols.length : this.table.getColCount();
    }

    public int getColWidth(int n) {
        return this.table.getColWidth(this.getC(n));
    }

    public Font getFont(int n, int n2) {
        return this.table.getFont(this.getR(n), this.getC(n2));
    }

    public Color getForeground(int n, int n2) {
        return this.table.getForeground(this.getR(n), this.getC(n2));
    }

    public int getHeaderColCount() {
        if (this.cols == null) {
            return this.table.getHeaderColCount();
        }
        int n = 0;
        while (n < this.cols.length && this.cols[n] < this.table.getHeaderColCount()) {
            ++n;
        }
        return n;
    }

    public int getHeaderRowCount() {
        if (this.rows == null) {
            return this.table.getHeaderRowCount();
        }
        int n = 0;
        while (n < this.rows.length && this.rows[n] < this.table.getHeaderRowCount()) {
            ++n;
        }
        return n;
    }

    public Insets getInsets(int n, int n2) {
        return this.table.getInsets(this.getR(n), this.getC(n2));
    }

    public Object getObject(int n, int n2) {
        return this.table.getObject(this.getR(n), this.getC(n2));
    }

    private int getR(int n) {
        return this.rows == null ? n : (n < 0 ? n : this.rows[n]);
    }

    public int getRowBorder(int n, int n2) {
        return this.table.getRowBorder(this.getR(n), this.getC(n2));
    }

    public Color getRowBorderColor(int n, int n2) {
        return this.table.getRowBorderColor(this.getR(n), this.getC(n2));
    }

    public int getRowCount() {
        return this.rows != null ? this.rows.length : this.table.getRowCount();
    }

    public int getRowHeight(int n) {
        return this.table.getRowHeight(this.getR(n));
    }

    public Dimension getSpan(int n, int n2) {
        return this.table.getSpan(this.getR(n), this.getC(n2));
    }

    public boolean isLineWrap(int n, int n2) {
        return this.table.isLineWrap(this.getR(n), this.getC(n2));
    }

    public void refresh() {
        if (this.table instanceof TableFilter) {
            ((TableFilter)this.table).refresh();
        }
    }
}

