/*
 * Decompiled with CFR 0.152.
 */
package inetsoft.report.lens;

import inetsoft.report.TableFilter;
import inetsoft.report.TableLens;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;

public class CompositeTableLens
implements TableFilter {
    private TableLens[] table = new TableLens[2];
    private int gap = 10;

    public CompositeTableLens(TableLens tableLens, TableLens tableLens2) {
        this.table[0] = tableLens;
        this.table[1] = tableLens2;
    }

    public int getAlignment(int n, int n2) {
        Index index = this.getIndex(n, n2, new Point(0, 0));
        if (index == null) {
            return 2;
        }
        return this.table[index.table].getAlignment(index.row, index.col);
    }

    public Color getBackground(int n, int n2) {
        Index index = this.getIndex(n, n2, new Point(0, 0));
        if (index == null) {
            return null;
        }
        return this.table[index.table].getBackground(index.row, index.col);
    }

    public int getColBorder(int n, int n2) {
        Index index = this.getIndex(n, n2, new Point(1, 0));
        if (index == null) {
            return 0;
        }
        return this.table[index.table].getColBorder(index.row, index.col);
    }

    public Color getColBorderColor(int n, int n2) {
        Index index = this.getIndex(n, n2, new Point(1, 0));
        if (index == null) {
            return null;
        }
        return this.table[index.table].getColBorderColor(index.row, index.col);
    }

    public int getColCount() {
        return this.table[0].getColCount() + this.table[1].getColCount() + 1;
    }

    public int getColWidth(int n) {
        if (n < this.table[0].getColCount()) {
            return this.table[0].getColWidth(n);
        }
        if ((n -= this.table[0].getColCount()) == 0) {
            return this.gap;
        }
        return this.table[1].getColWidth(n - 1);
    }

    public Font getFont(int n, int n2) {
        Index index = this.getIndex(n, n2, new Point(0, 0));
        if (index == null) {
            return null;
        }
        return this.table[index.table].getFont(index.row, index.col);
    }

    public Color getForeground(int n, int n2) {
        Index index = this.getIndex(n, n2, new Point(0, 0));
        if (index == null) {
            return null;
        }
        return this.table[index.table].getForeground(index.row, index.col);
    }

    public int getGap() {
        return this.gap;
    }

    public int getHeaderColCount() {
        return this.table[0].getHeaderRowCount();
    }

    public int getHeaderRowCount() {
        return Math.min(this.table[0].getHeaderRowCount(), this.table[1].getHeaderRowCount());
    }

    Index getIndex(int n, int n2, Point point) {
        Index index = new Index();
        if (n2 < this.table[0].getColCount()) {
            index.table = 0;
            index.col = n2;
        } else if ((n2 -= this.table[0].getColCount() + 1) + point.x >= 0) {
            index.table = 1;
            index.col = n2;
        } else {
            return null;
        }
        if (n < this.table[index.table].getRowCount()) {
            index.row = n;
            return index;
        }
        return null;
    }

    public Insets getInsets(int n, int n2) {
        Index index = this.getIndex(n, n2, new Point(0, 0));
        if (index == null) {
            return null;
        }
        return this.table[index.table].getInsets(index.row, index.col);
    }

    public Object getObject(int n, int n2) {
        Index index = this.getIndex(n, n2, new Point(0, 0));
        if (index == null) {
            return null;
        }
        return this.table[index.table].getObject(index.row, index.col);
    }

    public int getRowBorder(int n, int n2) {
        Index index = this.getIndex(n, n2, new Point(0, 1));
        if (index == null) {
            return 0;
        }
        return this.table[index.table].getRowBorder(index.row, index.col);
    }

    public Color getRowBorderColor(int n, int n2) {
        Index index = this.getIndex(n, n2, new Point(0, 1));
        if (index == null) {
            return null;
        }
        return this.table[index.table].getRowBorderColor(index.row, index.col);
    }

    public int getRowCount() {
        return Math.max(this.table[0].getRowCount(), this.table[1].getRowCount());
    }

    public int getRowHeight(int n) {
        int n2 = n < this.table[0].getRowCount() ? this.table[0].getRowHeight(n) : -1;
        int n3 = n < this.table[1].getRowCount() ? this.table[1].getRowHeight(n) : -1;
        return Math.max(n2, n3);
    }

    public Dimension getSpan(int n, int n2) {
        Index index = this.getIndex(n, n2, new Point(0, 0));
        if (index == null) {
            return null;
        }
        return this.table[index.table].getSpan(index.row, index.col);
    }

    public boolean isLineWrap(int n, int n2) {
        Index index = this.getIndex(n, n2, new Point(0, 0));
        if (index == null) {
            return false;
        }
        return this.table[index.table].isLineWrap(index.row, index.col);
    }

    public void refresh() {
        int n = 0;
        while (n < this.table.length) {
            if (this.table[n] instanceof TableFilter) {
                ((TableFilter)this.table[n]).refresh();
            }
            ++n;
        }
    }

    public void setGap(int n) {
        this.gap = n;
    }

    static class Index {
        int table;
        int row;
        int col;

        Index() {
        }

        public String toString() {
            return "Index[" + this.table + " @ " + this.row + "," + this.col + "]";
        }
    }
}

