/*
 * Decompiled with CFR 0.152.
 */
package inetsoft.report.lens;

import inetsoft.report.ChartLens;
import inetsoft.report.Common;
import inetsoft.report.Painter;
import inetsoft.report.internal.Util;
import inetsoft.report.lens.AbstractTableLens;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;

public class ChartTable
extends AbstractTableLens {
    public static int NO_HEADER = 0;
    public static int TEXT_HEADER = 1;
    public static int LEGEND_HEADER = 3;
    int opt = LEGEND_HEADER;
    boolean row = true;
    ChartLens chart;
    Font headerFN = new Font("Serif", 1, 10);
    FontMetrics headerFM = Common.getFontMetrics(this.headerFN);

    public ChartTable(ChartLens chartLens) {
        this(chartLens, LEGEND_HEADER);
    }

    public ChartTable(ChartLens chartLens, int n) {
        this.chart = chartLens;
        this.opt = n;
    }

    public int getColCount() {
        return !this.row ? this.chart.getDatasetCount() + 1 : this.chart.getDatasetSize() + this.getHeaderColCount();
    }

    public int getHeaderColCount() {
        return !this.row ? 1 : this.opt & 1;
    }

    public Font getHeaderFont() {
        return this.headerFN;
    }

    public int getHeaderRowCount() {
        return this.row ? 1 : this.opt & 1;
    }

    public Object getObject(int n, int n2) {
        String string;
        if (!this.row) {
            int n3 = n;
            n = n2;
            n2 = n3;
        }
        if (n == 0) {
            String string2;
            String string3 = string2 = n2 < this.getHeaderColCount() ? null : this.chart.getLabel(n2 - this.getHeaderColCount());
            if (string2 != null && this.opt == LEGEND_HEADER && Util.isFlatDatasetChart(this.chart.getStyle()) && this.chart.getDatasetCount() == 1) {
                return new HeaderPainter(string2, this.chart.getColor(n2 - this.getHeaderColCount()));
            }
            return string2;
        }
        if (n2 < this.getHeaderColCount()) {
            String string4 = this.chart.getDatasetLabel(n - 1);
            if (!(this.opt != LEGEND_HEADER || Util.isFlatDatasetChart(this.chart.getStyle()) && this.chart.getDatasetCount() <= 1)) {
                return new HeaderPainter(string4, this.chart.getColor(n - 1));
            }
            return string4;
        }
        Number number = this.chart.getData(n - 1, n2 - this.getHeaderColCount());
        if (this.chart.getPrecision() > 0 && (string = Util.toString(number, this.chart.getPrecision())).length() != number.toString().length()) {
            return Double.valueOf(string);
        }
        return number;
    }

    public int getRowCount() {
        return this.row ? this.chart.getDatasetCount() + 1 : this.chart.getDatasetSize() + this.getHeaderColCount();
    }

    public boolean isRowMajor() {
        return this.row;
    }

    public void setHeaderFont(Font font) {
        this.headerFN = font;
        this.headerFM = Common.getFontMetrics(this.headerFN);
    }

    public void setRowMajor(boolean bl) {
        this.row = bl;
    }

    class HeaderPainter
    implements Painter {
        String hd;
        Object color;

        public HeaderPainter(String string, Object object) {
            this.hd = string == null ? "" : string;
            this.color = object;
        }

        public Dimension getPreferredSize() {
            return new Dimension(ChartTable.this.headerFM.stringWidth(this.hd) + ChartTable.this.headerFM.getHeight() + 6, ChartTable.this.headerFM.getHeight() + 2);
        }

        public boolean isScalable() {
            return true;
        }

        public void paint(Graphics graphics, int n, int n2, int n3, int n4) {
            Graphics graphics2 = graphics.create(n, n2, n3, n4);
            graphics2.setColor(Color.white);
            graphics2.fillRect(0, 0, n3, n4);
            int n5 = n4 - 8;
            Rectangle rectangle = new Rectangle(4, 4, n5, n5);
            Common.fill(graphics2, rectangle, this.color);
            if (this.hd != null && this.hd.length() > 0) {
                graphics2.setColor(Color.black);
                graphics2.setFont(ChartTable.this.headerFN);
                graphics2.drawString(this.hd, 6 + n5, (n4 - ChartTable.this.headerFM.getHeight()) / 2 + ChartTable.this.headerFM.getAscent());
            }
            graphics2.dispose();
        }
    }
}

