/*
 * Decompiled with CFR 0.152.
 */
package inetsoft.report.io;

import inetsoft.report.Margin;
import inetsoft.report.PageArea;
import inetsoft.report.Position;
import inetsoft.report.ReportElement;
import inetsoft.report.ReportEnv;
import inetsoft.report.Size;
import inetsoft.report.StyleFont;
import inetsoft.report.StyleSheet;
import inetsoft.report.TOC;
import inetsoft.report.XStyleSheet;
import inetsoft.report.internal.EmptyContainer;
import inetsoft.report.internal.EmptyPainter;
import inetsoft.report.internal.StyleCore;
import inetsoft.report.internal.Util;
import inetsoft.report.internal.XMLException;
import inetsoft.report.internal.XMLTokenStream;
import inetsoft.report.internal.XStyleCore;
import inetsoft.report.io.Parser;
import inetsoft.report.lens.AttributeChartLens;
import inetsoft.report.lens.AttributeFormLens;
import inetsoft.report.lens.DefaultFormLens;
import inetsoft.report.lens.DefaultHeadingLens;
import inetsoft.report.lens.DefaultTableLens;
import inetsoft.report.lens.DefaultTextLens;
import inetsoft.report.painter.BulletPainter;
import inetsoft.report.style.TableStyle;
import inetsoft.report.style.XTableStyle;
import java.awt.Color;
import java.awt.Insets;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class TemplateParser
implements Parser {
    protected XMLTokenStream xml;
    Hashtable stylemap = new Hashtable();
    protected XStyleSheet xsheet;
    protected StyleSheet sheet;

    public TemplateParser(InputStream inputStream) {
        this.xml = new XMLTokenStream(inputStream);
    }

    public StyleSheet createSheet(String string) {
        this.xsheet = new XStyleSheet();
        this.sheet = this.xsheet;
        if (string == null) {
            try {
                string = ReportEnv.getProperty("user.dir");
            }
            catch (Exception exception) {
                string = ".";
            }
        }
        this.xsheet.setDirectory(string);
        return this.xsheet;
    }

    public TableStyle getStyle(String string) {
        TableStyle tableStyle;
        block2: {
            tableStyle = (TableStyle)this.stylemap.get(string);
            if (tableStyle != null) break block2;
            try {
                string = "inetsoft.report.style." + string;
                tableStyle = (TableStyle)Class.forName(string).newInstance();
                this.stylemap.put(string, tableStyle);
            }
            catch (Exception exception) {}
        }
        return (TableStyle)tableStyle.clone();
    }

    public Object read() throws IOException {
        try {
            Object object;
            while ((object = this.xml.getToken()) != null) {
                String[] stringArray;
                Object object2;
                if (!(object instanceof XMLTokenStream.Tag)) continue;
                XMLTokenStream.Tag tag = (XMLTokenStream.Tag)object;
                if (tag.getName().equals("REPORT")) {
                    object2 = new Margin(0.0, 0.0, 0.0, 0.0);
                    try {
                        ((Margin)object2).top = Double.valueOf(tag.get("Top"));
                        ((Margin)object2).left = Double.valueOf(tag.get("Left"));
                        ((Margin)object2).bottom = Double.valueOf(tag.get("Bottom"));
                        ((Margin)object2).right = Double.valueOf(tag.get("Right"));
                        this.sheet.setMargin((Margin)object2);
                    }
                    catch (NullPointerException nullPointerException) {}
                    try {
                        this.sheet.setHeaderFromEdge(Double.valueOf(tag.get("HeaderFromEdge")));
                        this.sheet.setFooterFromEdge(Double.valueOf(tag.get("FooterFromEdge")));
                    }
                    catch (NullPointerException nullPointerException) {}
                    String string = tag.get("TabStops");
                    if (string == null) continue;
                    stringArray = Util.split(string, ',');
                    double[] dArray = new double[stringArray.length];
                    int n = 0;
                    while (n < dArray.length) {
                        try {
                            dArray[n] = Double.valueOf(stringArray[n]);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            dArray[n] = n > 0 ? dArray[n - 1] : 0.0;
                        }
                        ++n;
                    }
                    this.sheet.setCurrentTabStops(dArray);
                    continue;
                }
                if (tag.getName().equals("PROPERTY")) {
                    int n = 0;
                    while ((object2 = tag.get("Name" + n)) != null) {
                        this.sheet.setProperty((String)object2, tag.get("Value" + n));
                        ++n;
                    }
                    continue;
                }
                if (tag.getName().equals("HEADER")) {
                    object2 = tag.get("ID");
                    stringArray = tag.get("Header");
                    stringArray = stringArray != null && stringArray.equals("false") ? "footer." : "header.";
                    return object2 == null ? Integer.valueOf(tag.get("Type")) : String.valueOf(stringArray) + (String)object2;
                }
                if (tag.getName().equals("/HEADER")) {
                    return new Integer(0);
                }
                if (tag.getName().equals("TEXTELEMENT")) {
                    return this.readText(tag);
                }
                if (tag.getName().equals("HEADINGELEMENT")) {
                    return this.readHeading(tag);
                }
                if (tag.getName().equals("TABLEELEMENT")) {
                    return this.readTable(tag);
                }
                if (tag.getName().equals("FORMELEMENT")) {
                    return this.readForm(tag);
                }
                if (tag.getName().equals("IMAGEELEMENT")) {
                    return this.readImage(tag);
                }
                if (tag.getName().equals("PAINTERELEMENT")) {
                    return this.readPainter(tag);
                }
                if (tag.getName().equals("CHARTELEMENT")) {
                    return this.readChart(tag);
                }
                if (tag.getName().equals("TEXTBOXELEMENT")) {
                    return this.readTextBox(tag);
                }
                if (tag.getName().equals("TABELEMENT")) {
                    return this.readTab(tag);
                }
                if (tag.getName().equals("NEWLINEELEMENT")) {
                    return this.readNewline(tag);
                }
                if (tag.getName().equals("AREABREAKELEMENT")) {
                    return this.readAreaBreak(tag);
                }
                if (tag.getName().equals("PAGEBREAKELEMENT")) {
                    return this.readPageBreak(tag);
                }
                if (tag.getName().equals("PAGELAYOUTELEMENT")) {
                    return this.readPageLayout(tag);
                }
                if (tag.getName().equals("CONDPAGEBREAKELEMENT")) {
                    return this.readCondPageBreak(tag);
                }
                if (tag.getName().equals("SPACEELEMENT")) {
                    return this.readSpace(tag);
                }
                if (tag.getName().equals("SEPARATORELEMENT")) {
                    return this.readSeparator(tag);
                }
                if (tag.getName().equals("TOCELEMENT")) {
                    return this.readTOC(tag);
                }
                if (tag.getName().equals("COMPOSITEELEMENT")) {
                    return this.readComposite(tag);
                }
                if (tag.getName().equals("BUTTONELEMENT")) {
                    return this.readButton(tag);
                }
                if (tag.getName().equals("IMAGEBUTTONELEMENT")) {
                    return this.readImageButton(tag);
                }
                if (tag.getName().equals("CHECKBOXELEMENT")) {
                    return this.readCheckBox(tag);
                }
                if (tag.getName().equals("RADIOBUTTONELEMENT")) {
                    return this.readRadioButton(tag);
                }
                if (tag.getName().equals("CHOICEELEMENT")) {
                    return this.readChoice(tag);
                }
                if (tag.getName().equals("TEXTFIELDELEMENT")) {
                    return this.readTextField(tag);
                }
                if (tag.getName().equals("TEXTAREAELEMENT")) {
                    return this.readTextArea(tag);
                }
                if (!tag.getName().equals("TABLE-STYLE")) continue;
                object2 = new XTableStyle(new DefaultTableLens(1, 1));
                ((XTableStyle)object2).parse(this.xml);
                ((XTableStyle)object2).setName(tag.get("Name"));
                this.stylemap.put(((XTableStyle)object2).getName(), object2);
                return object2;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IOException(exception.toString());
        }
        return null;
    }

    protected Object readAreaBreak(XMLTokenStream.Tag tag) throws IOException, XMLException {
        StyleCore.AreaBreakElement areaBreakElement = this.sheet.new StyleCore.AreaBreakElement();
        this.setElementAttributes(areaBreakElement, tag);
        return areaBreakElement;
    }

    protected Object readButton(XMLTokenStream.Tag tag) throws IOException, XMLException {
        StyleSheet styleSheet = this.sheet;
        styleSheet.getClass();
        StyleCore.ButtonElement buttonElement = (StyleCore)styleSheet.new StyleCore.ButtonElement(null, null, null);
        this.setElementAttributes(buttonElement, tag);
        this.setPainterAttributes(buttonElement, tag);
        buttonElement.setName(tag.get("Name"));
        buttonElement.setForm(tag.get("Form"));
        buttonElement.setText(tag.get("Text"));
        return buttonElement;
    }

    protected Object readChart(XMLTokenStream.Tag tag) throws IOException, XMLException {
        DefaultTableLens defaultTableLens = new DefaultTableLens(5, 5);
        XStyleCore.ChartXElement chartXElement = this.xsheet.new XStyleCore.ChartXElement();
        AttributeChartLens attributeChartLens = (AttributeChartLens)chartXElement.getChart();
        this.setElementAttributes(chartXElement, tag);
        this.setPainterAttributes(chartXElement, tag);
        String string = tag.get("Embedded");
        if (string != null) {
            chartXElement.setEmbedded(Boolean.valueOf(string));
        }
        if ((tag = (XMLTokenStream.Tag)this.xml.getToken()).getName().equals("CHART")) {
            defaultTableLens.setRowCount(Integer.parseInt(tag.get("Datasets")) + 1);
            defaultTableLens.setColCount(Integer.parseInt(tag.get("Size")) + 1);
            defaultTableLens.setHeaderRowCount(1);
            defaultTableLens.setHeaderColCount(1);
            string = tag.get("Style");
            if (string != null) {
                attributeChartLens.setStyle(Integer.parseInt(string));
            }
            if ((string = tag.get("Maximum")) != null) {
                attributeChartLens.setMaximum(Double.valueOf(string));
            }
            if ((string = tag.get("Minimum")) != null) {
                attributeChartLens.setMinimum(Double.valueOf(string));
            }
            if ((string = tag.get("Increment")) != null) {
                attributeChartLens.setIncrement(Double.valueOf(string));
            }
            if ((string = tag.get("MinorIncrement")) != null) {
                attributeChartLens.setMinorIncrement(Double.valueOf(string));
            }
            if ((string = tag.get("Gap")) != null) {
                attributeChartLens.setGap(Integer.parseInt(string));
            }
            if ((string = tag.get("XTitle")) != null) {
                attributeChartLens.setXTitle(string);
            }
            if ((string = tag.get("YTitle")) != null) {
                attributeChartLens.setYTitle(string);
            }
            if ((string = tag.get("TitleFont")) != null) {
                attributeChartLens.setTitleFont(StyleFont.decode(string));
            }
            if ((string = tag.get("GridStyle")) != null) {
                attributeChartLens.setGridStyle(Integer.parseInt(string));
            }
            if ((string = tag.get("BorderStyle")) != null) {
                attributeChartLens.setBorderStyle(Integer.parseInt(string));
            }
            if ((string = tag.get("ShowValue")) != null) {
                attributeChartLens.setShowValue(Boolean.valueOf(string));
            }
            if ((string = tag.get("Precision")) != null) {
                attributeChartLens.setPrecision(Integer.parseInt(string));
            }
            if ((string = tag.get("LegendPosition")) != null) {
                attributeChartLens.setLegendPosition(Integer.parseInt(string));
            }
            if ((string = tag.get("BlackWhite")) != null) {
                attributeChartLens.setBlackWhite(Boolean.valueOf(string));
            }
        }
        chartXElement.setChart(attributeChartLens);
        String[] stringArray = Util.split((String)this.xml.getToken(), "\n\r");
        String[] stringArray2 = Util.split(stringArray[0], '|');
        int n = 0;
        while (n < stringArray2.length && n < defaultTableLens.getRowCount() - 1) {
            defaultTableLens.setObject(n + 1, 0, stringArray2[n]);
            ++n;
        }
        stringArray2 = Util.split(stringArray[1], '|');
        int n2 = 0;
        while (n2 < stringArray2.length && n2 < defaultTableLens.getColCount() - 1) {
            defaultTableLens.setObject(0, n2 + 1, stringArray2[n2]);
            ++n2;
        }
        int n3 = 0;
        int n4 = 2;
        while (n4 < stringArray.length) {
            stringArray2 = Util.split(stringArray[n4], '|');
            int n5 = 0;
            while (n5 < stringArray2.length) {
                defaultTableLens.setObject(n3 + 1, n5 + 1, stringArray2[n5]);
                ++n5;
            }
            ++n3;
            ++n4;
        }
        chartXElement.setData(defaultTableLens);
        return chartXElement;
    }

    protected Object readCheckBox(XMLTokenStream.Tag tag) throws IOException, XMLException {
        StyleSheet styleSheet = this.sheet;
        styleSheet.getClass();
        StyleCore.CheckBoxElement checkBoxElement = (StyleCore)styleSheet.new StyleCore.CheckBoxElement(null, null, null, false);
        this.setElementAttributes(checkBoxElement, tag);
        this.setPainterAttributes(checkBoxElement, tag);
        checkBoxElement.setName(tag.get("Name"));
        checkBoxElement.setForm(tag.get("Form"));
        checkBoxElement.setText(tag.get("Text"));
        String string = tag.get("Selected");
        checkBoxElement.setSelected(string != null && string.equalsIgnoreCase("true"));
        return checkBoxElement;
    }

    protected Object readChoice(XMLTokenStream.Tag tag) throws IOException, XMLException {
        StyleSheet styleSheet = this.sheet;
        styleSheet.getClass();
        StyleCore.ChoiceElement choiceElement = (StyleCore)styleSheet.new StyleCore.ChoiceElement(null, null, null, null);
        this.setElementAttributes(choiceElement, tag);
        this.setPainterAttributes(choiceElement, tag);
        choiceElement.setName(tag.get("Name"));
        choiceElement.setForm(tag.get("Form"));
        choiceElement.setSelectedItem(tag.get("SelectedItem"));
        Vector<Object> vector = new Vector<Object>();
        tag = (XMLTokenStream.Tag)this.xml.getToken();
        while (!tag.getName().equals("/CHOICEELEMENT")) {
            if (tag.getName().equals("CHOICE")) {
                Object object = this.xml.getToken();
                if (object instanceof String) {
                    vector.addElement(object);
                    this.xml.getToken();
                }
            } else {
                throw new IOException("ChoiceElement missing Choice: " + tag);
            }
            tag = (XMLTokenStream.Tag)this.xml.getToken();
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        choiceElement.setChoices(objectArray);
        return choiceElement;
    }

    protected Object readComposite(XMLTokenStream.Tag tag) throws IOException, XMLException {
        StyleSheet styleSheet = this.sheet;
        styleSheet.getClass();
        StyleCore.CompositeElement compositeElement = (StyleCore)styleSheet.new StyleCore.CompositeElement(new EmptyContainer());
        String string = tag.get("ID");
        if (string != null) {
            compositeElement.setID(string);
        }
        return compositeElement;
    }

    protected Object readCondPageBreak(XMLTokenStream.Tag tag) throws IOException, XMLException {
        StyleSheet styleSheet = this.sheet;
        styleSheet.getClass();
        StyleCore.CondPageBreakElement condPageBreakElement = (StyleCore)styleSheet.new StyleCore.CondPageBreakElement(1);
        this.setElementAttributes(condPageBreakElement, tag);
        String string = tag.get("CondHeight");
        if (string != null) {
            condPageBreakElement.setCondHeight(Double.valueOf(string));
        }
        return condPageBreakElement;
    }

    protected Object readForm(XMLTokenStream.Tag tag) throws IOException, XMLException {
        Object object;
        DefaultFormLens defaultFormLens = new DefaultFormLens();
        XStyleCore.FormXElement formXElement = this.xsheet.new XStyleCore.FormXElement();
        AttributeFormLens attributeFormLens = (AttributeFormLens)formXElement.getForm();
        this.setElementAttributes(formXElement, tag);
        String string = tag.get("FieldPerRow");
        if (string != null) {
            attributeFormLens.setFieldPerRow(Integer.parseInt(string));
        }
        if ((string = tag.get("LabelFont")) != null) {
            attributeFormLens.setLabelFont(StyleFont.decode(string));
        }
        if ((string = tag.get("LabelForeground")) != null) {
            attributeFormLens.setLabelForeground(new Color(Integer.parseInt(string)));
        }
        if ((string = tag.get("LabelBackground")) != null) {
            attributeFormLens.setLabelBackground(new Color(Integer.parseInt(string)));
        }
        if ((string = tag.get("FieldFont")) != null) {
            attributeFormLens.setFont(StyleFont.decode(string));
        }
        if ((string = tag.get("FieldForeground")) != null) {
            attributeFormLens.setForeground(new Color(Integer.parseInt(string)));
        }
        if ((string = tag.get("FieldBackground")) != null) {
            attributeFormLens.setBackground(new Color(Integer.parseInt(string)));
        }
        if ((string = tag.get("Underline")) != null) {
            attributeFormLens.setUnderline(Integer.parseInt(string));
        }
        if ((string = tag.get("EmbedWidth")) != null) {
            formXElement.setEmbedWidth(Boolean.valueOf(string));
        }
        if ((string = tag.get("Embedded")) != null) {
            formXElement.setEmbedded(Boolean.valueOf(string));
        }
        if ((string = tag.get("FixedWidths")) != null) {
            object = Util.split(string, ',');
            int[] nArray = new int[((String[])object).length];
            int n = 0;
            while (n < nArray.length) {
                nArray[n] = Integer.parseInt(object[n]);
                ++n;
            }
            formXElement.setFixedWidths(nArray);
        }
        if (formXElement.isEmbedded()) {
            tag = (XMLTokenStream.Tag)this.xml.getToken();
            defaultFormLens.setFieldCount(Integer.parseInt(tag.get("Fields")));
            object = new StringTokenizer((String)this.xml.getToken(), "\n\r");
            int n = 0;
            while (((StringTokenizer)object).hasMoreTokens()) {
                String[] stringArray = Util.split(((StringTokenizer)object).nextToken(), '|');
                defaultFormLens.setLabel(n, stringArray[0]);
                defaultFormLens.setField(n, stringArray[1]);
                ++n;
            }
            formXElement.setForm(defaultFormLens);
        }
        return formXElement;
    }

    protected Object readHeading(XMLTokenStream.Tag tag) throws IOException, XMLException {
        DefaultHeadingLens defaultHeadingLens = new DefaultHeadingLens("", 1);
        StyleSheet styleSheet = this.sheet;
        styleSheet.getClass();
        StyleCore.HeadingElement headingElement = (StyleCore)styleSheet.new StyleCore.HeadingElement(defaultHeadingLens);
        this.setElementAttributes(headingElement, tag);
        String string = tag.get("Justify");
        if (string != null) {
            headingElement.setJustify(Boolean.valueOf(string));
        }
        if ((string = tag.get("Orphan")) != null) {
            headingElement.setOrphanControl(Boolean.valueOf(string));
        }
        if ((string = tag.get("TextAdvance")) != null) {
            headingElement.setTextAdvance(Integer.parseInt(string));
        }
        if ((string = tag.get("Level")) != null) {
            headingElement.setLevel(Integer.parseInt(string));
        }
        Object object = this.xml.getToken();
        defaultHeadingLens.setText((String)object);
        return headingElement;
    }

    protected Object readImage(XMLTokenStream.Tag tag) throws IOException, XMLException {
        XStyleCore.ImageXElement imageXElement = this.xsheet.new XStyleCore.ImageXElement();
        this.setElementAttributes(imageXElement, tag);
        this.setPainterAttributes(imageXElement, tag);
        String string = tag.get("PathType");
        if (string != null) {
            imageXElement.setPathType(Integer.parseInt(string));
        }
        if ((string = tag.get("Path")) != null) {
            imageXElement.setPath(string);
        }
        return imageXElement;
    }

    protected Object readImageButton(XMLTokenStream.Tag tag) throws IOException, XMLException {
        StyleSheet styleSheet = this.sheet;
        styleSheet.getClass();
        StyleCore.ImageButtonElement imageButtonElement = styleSheet.new StyleCore.ImageButtonElement(null, null);
        this.setElementAttributes(imageButtonElement, tag);
        this.setPainterAttributes(imageButtonElement, tag);
        imageButtonElement.setName(tag.get("Name"));
        imageButtonElement.setForm(tag.get("Form"));
        imageButtonElement.setResource(tag.get("Resource"));
        return imageButtonElement;
    }

    protected Object readNewline(XMLTokenStream.Tag tag) throws IOException, XMLException {
        StyleSheet styleSheet = this.sheet;
        styleSheet.getClass();
        StyleCore.NewlineElement newlineElement = styleSheet.new StyleCore.NewlineElement(1, false);
        this.setElementAttributes(newlineElement, tag);
        String string = tag.get("Count");
        if (string != null) {
            newlineElement.setCount(Integer.parseInt(string));
        }
        return newlineElement;
    }

    protected PageArea readPageArea(XMLTokenStream.Tag tag) {
        PageArea pageArea = new PageArea(0.0, 0.0, 0.0, 0.0);
        pageArea.x = Double.valueOf(tag.get("X"));
        pageArea.y = Double.valueOf(tag.get("Y"));
        pageArea.width = Double.valueOf(tag.get("Width"));
        pageArea.height = Double.valueOf(tag.get("Height"));
        pageArea.setRelative(Boolean.valueOf(tag.get("Relative")));
        pageArea.setBorder(Integer.parseInt(tag.get("Border")));
        String string = tag.get("Flow");
        if (string != null) {
            pageArea.setFlow(Boolean.valueOf(string));
        }
        if ((string = tag.get("BorderColor")) != null) {
            pageArea.setBorderColor(new Color(Integer.parseInt(string)));
        }
        if ((string = tag.get("Insets")) != null) {
            String[] stringArray = Util.split(string, ',');
            pageArea.setInsets(new Insets(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]), Integer.parseInt(stringArray[3])));
        }
        return pageArea;
    }

    protected Object readPageBreak(XMLTokenStream.Tag tag) throws IOException, XMLException {
        StyleCore.PageBreakElement pageBreakElement = this.sheet.new StyleCore.PageBreakElement();
        this.setElementAttributes(pageBreakElement, tag);
        return pageBreakElement;
    }

    protected Object readPageLayout(XMLTokenStream.Tag tag) throws IOException, XMLException {
        StyleSheet styleSheet = this.sheet;
        styleSheet.getClass();
        StyleCore.PageLayoutElement pageLayoutElement = (StyleCore)styleSheet.new StyleCore.PageLayoutElement(null);
        this.setElementAttributes(pageLayoutElement, tag);
        int n = Integer.parseInt(tag.get("Count"));
        PageArea[] pageAreaArray = new PageArea[n];
        int n2 = 0;
        while (n2 < n) {
            pageAreaArray[n2] = this.readPageArea((XMLTokenStream.Tag)this.xml.getToken());
            ++n2;
        }
        pageLayoutElement.setPageAreas(pageAreaArray);
        return pageLayoutElement;
    }

    protected Object readPainter(XMLTokenStream.Tag tag) throws IOException, XMLException {
        StyleSheet styleSheet = this.sheet;
        styleSheet.getClass();
        StyleCore.PainterElement painterElement = (StyleCore)styleSheet.new StyleCore.PainterElement(new EmptyPainter());
        this.setElementAttributes(painterElement, tag);
        this.setPainterAttributes(painterElement, tag);
        String string = tag.get("Painter");
        if (string != null && string.equals("bullet")) {
            painterElement.setPainter(new BulletPainter());
        }
        return painterElement;
    }

    protected Object readRadioButton(XMLTokenStream.Tag tag) throws IOException, XMLException {
        StyleSheet styleSheet = this.sheet;
        styleSheet.getClass();
        StyleCore.RadioButtonElement radioButtonElement = styleSheet.new StyleCore.RadioButtonElement(null, null, null, false, null);
        this.setElementAttributes(radioButtonElement, tag);
        this.setPainterAttributes(radioButtonElement, tag);
        radioButtonElement.setName(tag.get("Name"));
        radioButtonElement.setForm(tag.get("Form"));
        radioButtonElement.setText(tag.get("Text"));
        radioButtonElement.setGroup(tag.get("Group"));
        String string = tag.get("Selected");
        radioButtonElement.setSelected(string != null && string.equalsIgnoreCase("true"));
        return radioButtonElement;
    }

    protected Object readSeparator(XMLTokenStream.Tag tag) throws IOException, XMLException {
        StyleSheet styleSheet = this.sheet;
        styleSheet.getClass();
        StyleCore.SeparatorElement separatorElement = (StyleCore)styleSheet.new StyleCore.SeparatorElement(0);
        this.setElementAttributes(separatorElement, tag);
        String string = tag.get("Style");
        if (string != null) {
            separatorElement.setStyle(Integer.parseInt(string));
        }
        return separatorElement;
    }

    protected Object readSpace(XMLTokenStream.Tag tag) throws IOException, XMLException {
        StyleSheet styleSheet = this.sheet;
        styleSheet.getClass();
        StyleCore.SpaceElement spaceElement = (StyleCore)styleSheet.new StyleCore.SpaceElement(10);
        this.setElementAttributes(spaceElement, tag);
        String string = tag.get("Space");
        if (string != null) {
            spaceElement.setSpace(Integer.parseInt(string));
        }
        return spaceElement;
    }

    protected Object readTOC(XMLTokenStream.Tag tag) throws IOException, XMLException {
        StyleSheet styleSheet = this.sheet;
        styleSheet.getClass();
        StyleCore.TOCElement tOCElement = new StyleCore.TOCElement((StyleCore)styleSheet, TOC.DEFAULT);
        this.setElementAttributes(tOCElement, tag);
        String string = tag.get("Style");
        if (string != null) {
            try {
                tOCElement.setTOC((TOC)Class.forName(string).newInstance());
            }
            catch (Exception exception) {
                throw new IOException("Class " + string + " not found");
            }
        }
        return tOCElement;
    }

    protected Object readTab(XMLTokenStream.Tag tag) throws IOException, XMLException {
        StyleSheet styleSheet = this.sheet;
        styleSheet.getClass();
        StyleCore.TabElement tabElement = (StyleCore)styleSheet.new StyleCore.TabElement(0);
        this.setElementAttributes(tabElement, tag);
        this.setTabAttributes(tabElement, tag);
        return tabElement;
    }

    protected Object readTable(XMLTokenStream.Tag tag) throws IOException, XMLException {
        int n;
        Object object;
        Object object2;
        DefaultTableLens defaultTableLens = new DefaultTableLens(5, 5);
        XStyleSheet xStyleSheet = this.xsheet;
        xStyleSheet.getClass();
        XStyleCore.TableXElement tableXElement = xStyleSheet.new XStyleCore.TableXElement(defaultTableLens);
        this.setElementAttributes(tableXElement, tag);
        String string = tag.get("TableWidth");
        if (string != null) {
            tableXElement.setTableWidth(Double.valueOf(string));
        }
        if ((string = tag.get("FixedWidths")) != null) {
            object2 = Util.split(string, ',');
            object = new int[((String[])object2).length];
            n = 0;
            while (n < ((int[])object).length) {
                object[n] = Integer.parseInt(object2[n]);
                ++n;
            }
            tableXElement.setFixedWidths((int[])object);
        }
        if ((string = tag.get("Layout")) != null) {
            tableXElement.setLayout(Integer.parseInt(string));
        }
        if ((string = tag.get("TableAdvance")) != null) {
            tableXElement.setTableAdvance(Integer.parseInt(string));
        }
        if ((string = tag.get("Padding")) != null) {
            object2 = Util.split(string, ',');
            tableXElement.setPadding(new Insets(Integer.parseInt(object2[0]), Integer.parseInt(object2[1]), Integer.parseInt(object2[2]), Integer.parseInt(object2[3])));
        }
        object2 = null;
        string = tag.get("Style");
        if (string != null) {
            object2 = this.getStyle(string);
            tableXElement.setStyle((TableStyle)object2);
        }
        if ((string = tag.get("EmbedWidth")) != null) {
            tableXElement.setEmbedWidth(Boolean.valueOf(string));
        }
        if ((string = tag.get("Embedded")) != null) {
            tableXElement.setEmbedded(Boolean.valueOf(string));
        }
        while (true) {
            if ((tag = (XMLTokenStream.Tag)this.xml.getToken()).getName().equals("TABLE")) {
                defaultTableLens.setRowCount(Integer.parseInt(tag.get("Rows")));
                defaultTableLens.setColCount(Integer.parseInt(tag.get("Cols")));
                defaultTableLens.setHeaderRowCount(Integer.parseInt(tag.get("HeaderRow")));
                defaultTableLens.setHeaderColCount(Integer.parseInt(tag.get("HeaderCol")));
                object = this.xml.getToken();
                if (object instanceof String) {
                    String string2 = (String)object;
                    StringTokenizer stringTokenizer = new StringTokenizer(string2, "\n\r");
                    int n2 = 0;
                    while (stringTokenizer.hasMoreTokens()) {
                        String[] stringArray = Util.split(stringTokenizer.nextToken(), '|');
                        int n3 = 0;
                        while (n3 < stringArray.length) {
                            defaultTableLens.setObject(n2, n3, stringArray[n3]);
                            ++n3;
                        }
                        ++n2;
                    }
                } else {
                    n = -1;
                    int n4 = 0;
                    tag = (XMLTokenStream.Tag)object;
                    while (!tag.getName().equals("/TABLE")) {
                        if (tag.getName().equals("TR")) {
                            ++n;
                            n4 = 0;
                        } else if (tag.getName().equals("TD")) {
                            Object object3 = this.xml.getToken();
                            object = object3;
                            if (object3 instanceof String) {
                                defaultTableLens.setObject(n, n4, object.equals("null") ? null : object);
                            }
                            ++n4;
                        }
                        tag = (XMLTokenStream.Tag)this.xml.getToken();
                    }
                }
                tableXElement.setData(defaultTableLens);
                continue;
            }
            if (tag.getName().equals("STYLE") && object2 != null) {
                ((TableStyle)object2).setApplyRowBorderColor(Boolean.valueOf(tag.get("RowBorderC")));
                ((TableStyle)object2).setApplyColBorderColor(Boolean.valueOf(tag.get("ColBorderC")));
                ((TableStyle)object2).setApplyRowBorder(Boolean.valueOf(tag.get("RowBorder")));
                ((TableStyle)object2).setApplyColBorder(Boolean.valueOf(tag.get("ColBorder")));
                ((TableStyle)object2).setApplyInsets(Boolean.valueOf(tag.get("Insets")));
                ((TableStyle)object2).setApplyAlignment(Boolean.valueOf(tag.get("Alignment")));
                ((TableStyle)object2).setApplyFont(Boolean.valueOf(tag.get("Font")));
                ((TableStyle)object2).setApplyLineWrap(Boolean.valueOf(tag.get("LineWrap")));
                ((TableStyle)object2).setApplyForeground(Boolean.valueOf(tag.get("Foreground")));
                ((TableStyle)object2).setApplyBackground(Boolean.valueOf(tag.get("Background")));
                ((TableStyle)object2).setFormatFirstRow(Boolean.valueOf(tag.get("FirstRow")));
                ((TableStyle)object2).setFormatFirstCol(Boolean.valueOf(tag.get("FirstCol")));
                ((TableStyle)object2).setFormatLastRow(Boolean.valueOf(tag.get("LastRow")));
                ((TableStyle)object2).setFormatLastCol(Boolean.valueOf(tag.get("LastCol")));
                continue;
            }
            if (tag.getName().equals("/TABLEELEMENT")) break;
        }
        return tableXElement;
    }

    protected Object readText(XMLTokenStream.Tag tag) throws IOException, XMLException {
        DefaultTextLens defaultTextLens = new DefaultTextLens();
        StyleSheet styleSheet = this.sheet;
        styleSheet.getClass();
        StyleCore.TextElement textElement = (StyleCore)styleSheet.new StyleCore.TextElement(defaultTextLens);
        this.setElementAttributes(textElement, tag);
        this.setTabAttributes(textElement, tag);
        String string = tag.get("Justify");
        if (string != null) {
            textElement.setJustify(Boolean.valueOf(string));
        }
        if ((string = tag.get("Orphan")) != null) {
            textElement.setOrphanControl(Boolean.valueOf(string));
        }
        if ((string = tag.get("TextAdvance")) != null) {
            textElement.setTextAdvance(Integer.parseInt(string));
        }
        Object object = this.xml.getToken();
        defaultTextLens.setText((String)object);
        return textElement;
    }

    protected Object readTextArea(XMLTokenStream.Tag tag) throws IOException, XMLException {
        StyleSheet styleSheet = this.sheet;
        styleSheet.getClass();
        StyleCore.TextAreaElement textAreaElement = (StyleCore)styleSheet.new StyleCore.TextAreaElement(null, null, null);
        this.setElementAttributes(textAreaElement, tag);
        this.setPainterAttributes(textAreaElement, tag);
        textAreaElement.setName(tag.get("Name"));
        textAreaElement.setForm(tag.get("Form"));
        textAreaElement.setText(tag.get("Text"));
        return textAreaElement;
    }

    protected Object readTextBox(XMLTokenStream.Tag tag) throws IOException, XMLException {
        DefaultTextLens defaultTextLens = new DefaultTextLens();
        StyleSheet styleSheet = this.sheet;
        styleSheet.getClass();
        StyleCore.TextBoxElement textBoxElement = (StyleCore)styleSheet.new StyleCore.TextBoxElement(defaultTextLens);
        this.setElementAttributes(textBoxElement, tag);
        this.setPainterAttributes(textBoxElement, tag);
        String string = tag.get("Border");
        if (string != null) {
            textBoxElement.setBorder(Integer.parseInt(string));
        }
        if ((string = tag.get("Justify")) != null) {
            textBoxElement.setJustify(Boolean.valueOf(string));
        }
        if ((string = tag.get("TextAlignment")) != null) {
            textBoxElement.setTextAlignment(Integer.parseInt(string));
        }
        if ((string = tag.get("Padding")) != null) {
            String[] stringArray = Util.split(string, ',');
            textBoxElement.setPadding(new Insets(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]), Integer.parseInt(stringArray[3])));
        }
        Object object = this.xml.getToken();
        defaultTextLens.setText((String)object);
        return textBoxElement;
    }

    protected Object readTextField(XMLTokenStream.Tag tag) throws IOException, XMLException {
        StyleSheet styleSheet = this.sheet;
        styleSheet.getClass();
        StyleCore.TextFieldElement textFieldElement = (StyleCore)styleSheet.new StyleCore.TextFieldElement(null, null, null);
        this.setElementAttributes(textFieldElement, tag);
        this.setPainterAttributes(textFieldElement, tag);
        textFieldElement.setName(tag.get("Name"));
        textFieldElement.setForm(tag.get("Form"));
        textFieldElement.setText(tag.get("Text"));
        return textFieldElement;
    }

    protected void setElementAttributes(ReportElement reportElement, XMLTokenStream.Tag tag) {
        StyleCore.Element element = (StyleCore.Element)reportElement;
        String string = tag.get("ID");
        if (string != null) {
            element.setID(string);
        }
        if ((string = tag.get("Alignment")) != null) {
            element.setAlignment(Integer.parseInt(string));
        }
        if ((string = tag.get("Indent")) != null) {
            element.setIndent(Double.valueOf(string));
        }
        if ((string = tag.get("Hindent")) != null) {
            element.setHindent(Integer.parseInt(string));
        }
        if ((string = tag.get("Font")) != null) {
            element.setFont(StyleFont.decode(string));
        }
        if ((string = tag.get("Foreground")) != null) {
            element.setForeground(new Color(Integer.parseInt(string)));
        }
        if ((string = tag.get("Background")) != null) {
            element.setBackground(new Color(Integer.parseInt(string)));
        }
        if ((string = tag.get("Spacing")) != null) {
            element.setSpacing(Integer.parseInt(string));
        }
        if ((string = tag.get("Block")) != null) {
            element.setBlock(Boolean.valueOf(string));
        }
        if ((string = tag.get("Continuation")) != null) {
            element.setContinuation(Boolean.valueOf(string));
        }
        if ((string = tag.get("Visible")) != null) {
            element.setVisible(Boolean.valueOf(string));
        }
    }

    protected void setPainterAttributes(StyleCore.PainterElement painterElement, XMLTokenStream.Tag tag) {
        String[] stringArray;
        String string = tag.get("Layout");
        if (string != null) {
            painterElement.setLayout(Integer.parseInt(string));
        }
        if ((string = tag.get("Wrapping")) != null) {
            painterElement.setWrapping(Integer.parseInt(string));
        }
        if ((string = tag.get("Anchor")) != null) {
            stringArray = Util.split(string, ',');
            painterElement.setAnchor(new Position(Float.valueOf(stringArray[0]).floatValue(), Float.valueOf(stringArray[1]).floatValue()));
        }
        if ((string = tag.get("Size")) != null) {
            stringArray = Util.split(string, 'x');
            painterElement.setSize(new Size(Float.valueOf(stringArray[0]).floatValue(), Float.valueOf(stringArray[1]).floatValue()));
        }
        if ((string = tag.get("Margin")) != null) {
            stringArray = Util.split(string, ',');
            painterElement.setMargin(new Insets(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]), Integer.parseInt(stringArray[3])));
        }
    }

    protected void setTabAttributes(StyleCore.TabSupport tabSupport, XMLTokenStream.Tag tag) {
        String string = tag.get("FillStyle");
        if (string != null) {
            tabSupport.setFillStyle(Integer.parseInt(string));
        }
        if ((string = tag.get("TabStops")) != null) {
            String[] stringArray = Util.split(string, ',');
            double[] dArray = new double[stringArray.length];
            int n = 0;
            while (n < dArray.length) {
                try {
                    dArray[n] = Double.valueOf(stringArray[n]);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    dArray[n] = n > 0 ? dArray[n - 1] : 0.0;
                }
                ++n;
            }
            tabSupport.setTabStops(dArray);
        }
    }
}

