/*
 * Decompiled with CFR 0.152.
 */
package inetsoft.report.io;

import inetsoft.report.AreaBreakElement;
import inetsoft.report.ChartElement;
import inetsoft.report.ChartLens;
import inetsoft.report.CompositeElement;
import inetsoft.report.CondPageBreakElement;
import inetsoft.report.FormElement;
import inetsoft.report.FormLens;
import inetsoft.report.HeadingElement;
import inetsoft.report.Margin;
import inetsoft.report.NewlineElement;
import inetsoft.report.PageArea;
import inetsoft.report.PageBreakElement;
import inetsoft.report.PageLayoutElement;
import inetsoft.report.PainterElement;
import inetsoft.report.Position;
import inetsoft.report.ReportElement;
import inetsoft.report.SeparatorElement;
import inetsoft.report.Size;
import inetsoft.report.SpaceElement;
import inetsoft.report.StyleFont;
import inetsoft.report.StyleSheet;
import inetsoft.report.TOCElement;
import inetsoft.report.TabElement;
import inetsoft.report.TableElement;
import inetsoft.report.TableLens;
import inetsoft.report.TextBoxElement;
import inetsoft.report.TextElement;
import inetsoft.report.internal.EmptyContainer;
import inetsoft.report.internal.StyleCore;
import inetsoft.report.internal.XStyleCore;
import inetsoft.report.io.Formatter;
import inetsoft.report.lens.AttributeChartLens;
import inetsoft.report.painter.BulletPainter;
import inetsoft.report.style.TableStyle;
import inetsoft.report.style.XTableStyle;
import java.awt.Insets;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

class TemplateFormatter
implements Formatter {
    protected PrintWriter writer;
    protected OutputStream output;
    protected StyleSheet sheet;

    public TemplateFormatter(OutputStream outputStream) {
        try {
            this.output = outputStream;
            this.writer = new PrintWriter(new OutputStreamWriter(this.output, "UTF8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
    }

    public void end() {
        this.writer.println("</Report>");
        this.writer.flush();
    }

    public void endHeader() {
        this.writer.println("</Header>");
    }

    public void prolog(StyleSheet styleSheet) {
        this.sheet = styleSheet;
        this.writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        Margin margin = styleSheet.getMargin();
        this.writer.print("<Report Top=\"" + margin.top + "\" Left=\"" + margin.left + "\" Bottom=\"" + margin.bottom + "\" Right=\"" + margin.right + "\" HeaderFromEdge=\"" + styleSheet.getHeaderFromEdge() + "\" FooterFromEdge=\"" + styleSheet.getFooterFromEdge() + "\" PageNumbering=\"" + styleSheet.getPageNumberingStart() + "\"");
        this.writer.print(" TabStops=\"");
        double[] dArray = styleSheet.getCurrentTabStops();
        int n = 0;
        while (n < dArray.length) {
            if (n > 0) {
                this.writer.print(",");
            }
            this.writer.print(dArray[n]);
            ++n;
        }
        this.writer.println("\">");
        Properties properties = styleSheet.getProperties();
        if (((Hashtable)properties).size() > 0) {
            Enumeration<?> enumeration = properties.propertyNames();
            this.writer.print("<Property");
            int n2 = 0;
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                this.writer.print(" Name" + n2 + "=\"" + string + "\"" + " Value" + n2 + "=\"" + properties.getProperty(string) + "\"");
                ++n2;
            }
            this.writer.println(">");
            this.writer.println("</Property>");
        }
    }

    public void startHeader(int n) {
        this.writer.println("<Header Type=\"" + n + "\">");
    }

    public void startHeader(String string, boolean bl) {
        this.writer.println("<Header Type=\"Element\" ID=\"" + string + "\" Header=\"" + bl + "\">");
    }

    protected static String toString(Object object) {
        return object == null ? "" : object.toString();
    }

    public void write(AreaBreakElement areaBreakElement) {
        this.writer.print("<AreaBreakElement ");
        this.writeElementAttributes(areaBreakElement);
        this.writer.println(">");
        this.writer.println("</AreaBreakElement>");
    }

    public void write(ChartElement chartElement) {
        XStyleCore.ChartXElement chartXElement = (XStyleCore.ChartXElement)chartElement;
        this.writer.print("<ChartElement ");
        this.writeElementAttributes(chartElement);
        this.writePainterAttributes(chartElement);
        this.writer.println(" Embedded=\"" + chartXElement.isEmbedded() + "\">");
        this.write(chartElement.getChart(), chartXElement.isEmbedded());
        this.writer.println("</ChartElement>");
    }

    protected void write(ChartLens chartLens, boolean bl) {
        this.writer.print("<Chart Datasets=\"" + chartLens.getDatasetCount() + "\" Size=\"" + chartLens.getDatasetSize() + "\"");
        this.writer.print(" Style=\"" + chartLens.getStyle() + "\"");
        if (chartLens.getMaximum() != null) {
            this.writer.print(" Maximum=\"" + chartLens.getMaximum() + "\"");
        }
        if (chartLens.getMinimum() != null) {
            this.writer.print(" Minimum=\"" + chartLens.getMinimum() + "\"");
        }
        if (chartLens.getIncrement() != null) {
            this.writer.print(" Increment=\"" + chartLens.getIncrement() + "\"");
        }
        if (chartLens.getMinorIncrement() != null) {
            this.writer.print(" MinorIncrement=\"" + chartLens.getMinorIncrement() + "\"");
        }
        this.writer.print(" Gap=\"" + chartLens.getGap() + "\"");
        if (chartLens.getXTitle() != null) {
            this.writer.print(" XTitle=\"" + chartLens.getXTitle() + '\"');
        }
        if (chartLens.getYTitle() != null) {
            this.writer.print(" YTitle=\"" + chartLens.getYTitle() + '\"');
        }
        if (chartLens.getTitleFont() != null) {
            this.writer.print(" TitleFont=\"" + StyleFont.toString(chartLens.getTitleFont()) + "\"");
        }
        if (chartLens instanceof AttributeChartLens) {
            this.writer.print(" BlackWhite=\"" + ((AttributeChartLens)chartLens).isBlackWhite() + "\"");
        }
        this.writer.println(" GridStyle=\"" + chartLens.getGridStyle() + "\" BorderStyle=\"" + chartLens.getBorderStyle() + "\" ShowValue=\"" + chartLens.isShowValue() + "\" Precision=\"" + chartLens.getPrecision() + "\" LegendPosition=\"" + chartLens.getLegendPosition() + "\">");
        this.writer.print("<![CDATA[");
        int n = 0;
        while (n < chartLens.getDatasetCount()) {
            if (n > 0) {
                this.writer.print("|");
            }
            this.writer.print(TemplateFormatter.toString(chartLens.getDatasetLabel(n)));
            ++n;
        }
        this.writer.println("|");
        int n2 = 0;
        while (n2 < chartLens.getDatasetSize()) {
            if (n2 > 0) {
                this.writer.print("|");
            }
            this.writer.print(TemplateFormatter.toString(chartLens.getLabel(n2)));
            ++n2;
        }
        this.writer.println("|");
        int n3 = 0;
        while (n3 < chartLens.getDatasetCount()) {
            int n4 = 0;
            while (n4 < chartLens.getDatasetSize()) {
                if (n4 > 0) {
                    this.writer.print("|");
                }
                this.writer.print(TemplateFormatter.toString(chartLens.getData(n3, n4)));
                ++n4;
            }
            this.writer.println("");
            ++n3;
        }
        this.writer.println("]]></Chart>");
    }

    public void write(CompositeElement compositeElement) {
        if (compositeElement.getComposite() instanceof EmptyContainer) {
            this.writer.print("<CompositeElement ID=\"" + compositeElement.getID() + "\"/>");
        }
    }

    public void write(CondPageBreakElement condPageBreakElement) {
        this.writer.print("<CondPageBreakElement ");
        this.writeElementAttributes(condPageBreakElement);
        this.writer.println(" CondHeight=\"" + condPageBreakElement.getCondHeight() + "\">");
        this.writer.println("</CondPageBreakElement>");
    }

    public void write(FormElement formElement) {
        int[] nArray;
        XStyleCore.FormXElement formXElement = (XStyleCore.FormXElement)formElement;
        FormLens formLens = formXElement.getForm();
        this.writer.print("<FormElement ");
        this.writeElementAttributes(formElement);
        this.writer.print(" FieldPerRow=\"" + formLens.getFieldPerRow() + "\"");
        if (formLens.getLabelFont(0) != null) {
            this.writer.print(" LabelFont=\"" + StyleFont.toString(formLens.getLabelFont(0)) + "\"");
        }
        if (formLens.getLabelForeground(0) != null) {
            this.writer.print(" LabelForeground=\"" + formLens.getLabelForeground(0).getRGB() + "\"");
        }
        if (formLens.getLabelBackground(0) != null) {
            this.writer.print(" LabelBackground=\"" + formLens.getLabelBackground(0).getRGB() + "\"");
        }
        if (formLens.getFont(0) != null) {
            this.writer.print(" FieldFont=\"" + StyleFont.toString(formLens.getFont(0)) + "\"");
        }
        if (formLens.getForeground(0) != null) {
            this.writer.print(" FieldForeground=\"" + formLens.getForeground(0).getRGB() + "\"");
        }
        if (formLens.getBackground(0) != null) {
            this.writer.print(" FieldBackground=\"" + formLens.getBackground(0).getRGB() + "\"");
        }
        this.writer.print(" Underline=\"" + formLens.getUnderline() + "\"");
        this.writer.print(" EmbedWidth=\"" + formXElement.isEmbedWidth() + "\" Embedded=\"" + formXElement.isEmbedded() + "\"");
        if (formXElement.isEmbedWidth() && (nArray = formElement.getFixedWidths()) != null) {
            this.writer.print(" FixedWidths=\"");
            int n = 0;
            while (n < nArray.length) {
                if (n > 0) {
                    this.writer.print(",");
                }
                this.writer.print(nArray[n]);
                ++n;
            }
            this.writer.print("\" ");
        }
        this.writer.println(">");
        if (formXElement.isEmbedded()) {
            this.write(formXElement.getForm());
        }
        this.writer.println("</FormElement>");
    }

    protected void write(FormLens formLens) {
        this.writer.println("<Form Fields=\"" + formLens.getFieldCount() + "\">");
        this.writer.print("<![CDATA[");
        int n = 0;
        while (n < formLens.getFieldCount()) {
            this.writer.println(String.valueOf(TemplateFormatter.toString(formLens.getLabel(n))) + "|" + TemplateFormatter.toString(formLens.getField(n)));
            ++n;
        }
        this.writer.println("]]></Form>");
    }

    public void write(HeadingElement headingElement) {
        this.writer.print("<HeadingElement ");
        this.writeElementAttributes(headingElement);
        this.writer.print(" Level=\"" + headingElement.getLevel() + "\" ");
        this.writer.print(" Justify=\"" + headingElement.isJustify() + "\"");
        this.writer.print(" Orphan=\"" + headingElement.isOrphanControl() + "\"");
        this.writer.println(" TextAdvance=\"" + headingElement.getTextAdvance() + "\">");
        this.writer.println("<![CDATA[" + headingElement.getText() + "]]>");
        this.writer.println("</HeadingElement>");
    }

    public void write(NewlineElement newlineElement) {
        this.writer.print("<NewlineElement ");
        this.writeElementAttributes(newlineElement);
        this.writer.println(" Count=\"" + newlineElement.getCount() + "\">");
        this.writer.println("</NewlineElement>");
    }

    public void write(PageBreakElement pageBreakElement) {
        this.writer.print("<PageBreakElement ");
        this.writeElementAttributes(pageBreakElement);
        this.writer.println(">");
        this.writer.println("</PageBreakElement>");
    }

    public void write(PageLayoutElement pageLayoutElement) {
        PageArea[] pageAreaArray = pageLayoutElement.getPageAreas();
        this.writer.print("<PageLayoutElement Count=\"" + pageAreaArray.length + "\" ");
        this.writeElementAttributes(pageLayoutElement);
        this.writer.println(">");
        int n = 0;
        while (n < pageAreaArray.length) {
            this.writer.println("<Area X=\"" + pageAreaArray[n].x + "\" Y=\"" + pageAreaArray[n].y + "\" Width=\"" + pageAreaArray[n].width + "\" Height=\"" + pageAreaArray[n].height + "\" Relative=\"" + pageAreaArray[n].isRelative() + "\" Flow=\"" + pageAreaArray[n].isFlow() + "\" Border=\"" + pageAreaArray[n].getBorder() + "\" BorderColor=\"" + pageAreaArray[n].getBorderColor().getRGB() + "\" Insets=\"" + pageAreaArray[n].getInsets().top + "," + pageAreaArray[n].getInsets().left + "," + pageAreaArray[n].getInsets().bottom + "," + pageAreaArray[n].getInsets().right + "\">");
            ++n;
        }
        this.writer.println("</PageLayoutElement>");
    }

    public void write(PainterElement painterElement) {
        if (painterElement instanceof XStyleCore.ImageXElement) {
            XStyleCore.ImageXElement imageXElement = (XStyleCore.ImageXElement)painterElement;
            this.writer.print("<ImageElement ");
            this.writeElementAttributes(painterElement);
            this.writePainterAttributes(painterElement);
            this.writer.println(" PathType=\"" + imageXElement.getPathType() + "\" Path=\"" + imageXElement.getAdjustedPath() + "\">");
            this.writer.println("</ImageElement>");
        } else if (painterElement instanceof StyleCore.ButtonElement) {
            StyleCore.ButtonElement buttonElement = (StyleCore.ButtonElement)painterElement;
            this.writer.print("<ButtonElement ");
            this.writeElementAttributes(painterElement);
            this.writePainterAttributes(painterElement);
            this.writer.println(" Name=\"" + buttonElement.getName() + "\"" + " Form=\"" + buttonElement.getForm() + "\"" + " Text=\"" + buttonElement.getText() + "\"/>");
        } else if (painterElement instanceof StyleCore.ImageButtonElement) {
            StyleCore.ImageButtonElement imageButtonElement = (StyleCore.ImageButtonElement)painterElement;
            this.writer.print("<ImageButtonElement ");
            this.writeElementAttributes(painterElement);
            this.writePainterAttributes(painterElement);
            this.writer.println(" Name=\"" + imageButtonElement.getName() + "\"" + " Form=\"" + imageButtonElement.getForm() + "\"" + " Resource=\"" + imageButtonElement.getResource() + "\"/>");
        } else if (painterElement instanceof StyleCore.RadioButtonElement) {
            StyleCore.RadioButtonElement radioButtonElement = (StyleCore.RadioButtonElement)painterElement;
            this.writer.print("<RadioButtonElement ");
            this.writeElementAttributes(painterElement);
            this.writePainterAttributes(painterElement);
            this.writer.println(" Name=\"" + radioButtonElement.getName() + "\"" + " Form=\"" + radioButtonElement.getForm() + "\"" + " Text=\"" + radioButtonElement.getText() + "\"" + " Selected=\"" + radioButtonElement.isSelected() + "\"" + " Group=\"" + radioButtonElement.getGroup() + "\"/>");
        } else if (painterElement instanceof StyleCore.CheckBoxElement) {
            StyleCore.CheckBoxElement checkBoxElement = (StyleCore.CheckBoxElement)painterElement;
            this.writer.print("<CheckBoxElement ");
            this.writeElementAttributes(painterElement);
            this.writePainterAttributes(painterElement);
            this.writer.println(" Name=\"" + checkBoxElement.getName() + "\"" + " Form=\"" + checkBoxElement.getForm() + "\"" + " Text=\"" + checkBoxElement.getText() + "\"" + " Selected=\"" + checkBoxElement.isSelected() + "\"/>");
        } else if (painterElement instanceof StyleCore.ChoiceElement) {
            StyleCore.ChoiceElement choiceElement = (StyleCore.ChoiceElement)painterElement;
            this.writer.print("<ChoiceElement ");
            this.writeElementAttributes(painterElement);
            this.writePainterAttributes(painterElement);
            this.writer.println(" Name=\"" + choiceElement.getName() + "\"" + " Form=\"" + choiceElement.getForm() + "\"" + " SelectedItem=\"" + choiceElement.getSelectedItem() + "\">");
            Object[] objectArray = choiceElement.getChoices();
            int n = 0;
            while (n < objectArray.length) {
                this.writer.println("<Choice>\"" + objectArray[n] + "\"</Choice>");
                ++n;
            }
            this.writer.println("</ChoiceElement>");
        } else if (painterElement instanceof StyleCore.TextFieldElement) {
            StyleCore.TextFieldElement textFieldElement = (StyleCore.TextFieldElement)painterElement;
            this.writer.print("<TextFieldElement ");
            this.writeElementAttributes(painterElement);
            this.writePainterAttributes(painterElement);
            this.writer.println(" Name=\"" + textFieldElement.getName() + "\"" + " Form=\"" + textFieldElement.getForm() + "\"" + " Text=\"" + textFieldElement.getText() + "\"/>");
        } else if (painterElement instanceof StyleCore.TextAreaElement) {
            StyleCore.TextAreaElement textAreaElement = (StyleCore.TextAreaElement)painterElement;
            this.writer.print("<TextAreaElement ");
            this.writeElementAttributes(painterElement);
            this.writePainterAttributes(painterElement);
            this.writer.println(" Name=\"" + textAreaElement.getName() + "\"" + " Form=\"" + textAreaElement.getForm() + "\"" + " Text=\"" + textAreaElement.getText() + "\"/>");
        } else {
            this.writer.print("<PainterElement ");
            this.writeElementAttributes(painterElement);
            this.writePainterAttributes(painterElement);
            if (painterElement.getPainter() instanceof BulletPainter) {
                this.writer.print(" Painter=\"bullet\"");
            }
            this.writer.println(">");
            this.writer.println("</PainterElement>");
        }
    }

    public void write(SeparatorElement separatorElement) {
        this.writer.print("<SeparatorElement ");
        this.writeElementAttributes(separatorElement);
        this.writer.println(" Style=\"" + separatorElement.getStyle() + "\">");
        this.writer.println("</SeparatorElement>");
    }

    public void write(SpaceElement spaceElement) {
        this.writer.print("<SpaceElement ");
        this.writeElementAttributes(spaceElement);
        this.writer.println(" Space=\"" + spaceElement.getSpace() + "\">");
        this.writer.println("</SpaceElement>");
    }

    public void write(TOCElement tOCElement) {
        this.writer.print("<TOCElement ");
        this.writeElementAttributes(tOCElement);
        this.writer.println(" Style=\"" + tOCElement.getTOC().getClass().getName() + "\">");
        this.writer.println("</TOCElement>");
    }

    public void write(TabElement tabElement) {
        this.writer.print("<TabElement ");
        this.writeElementAttributes(tabElement);
        this.writeTabAttributes((StyleCore.TabSupport)((Object)tabElement));
        this.writer.println(">");
        this.writer.println("</TabElement>");
    }

    public void write(TableElement tableElement) {
        TableStyle tableStyle;
        Object object;
        XStyleCore.TableXElement tableXElement = (XStyleCore.TableXElement)tableElement;
        this.writer.print("<TableElement ");
        this.writeElementAttributes(tableElement);
        this.writer.print(" TableWidth=\"" + tableElement.getTableWidth() + "\"");
        if (tableXElement.isEmbedWidth() && (object = tableElement.getFixedWidths()) != null) {
            this.writer.print(" FixedWidths=\"");
            int n = 0;
            while (n < ((int[])object).length) {
                if (n > 0) {
                    this.writer.print(",");
                }
                this.writer.print(object[n]);
                ++n;
            }
            this.writer.print("\" ");
        }
        this.writer.print(" Layout=\"" + tableElement.getLayout() + "\"");
        this.writer.print(" TableAdvance=\"" + tableElement.getTableAdvance() + "\"");
        object = tableElement.getPadding();
        if (object != null) {
            this.writer.print(" Padding=\"" + object.top + "," + object.left + "," + object.bottom + "," + object.right + "\"");
        }
        if ((tableStyle = tableXElement.getStyle()) != null) {
            this.writer.print(" Style=\"" + tableStyle.getName() + "\"");
        }
        this.writer.println(" EmbedWidth=\"" + tableXElement.isEmbedWidth() + "\" Embedded=\"" + tableXElement.isEmbedded() + "\">");
        if (tableStyle != null) {
            this.writer.print("<Style");
            this.writer.println(" RowBorderC=\"" + tableStyle.isApplyRowBorderColor() + "\" ColBorderC=\"" + tableStyle.isApplyColBorderColor() + "\" RowBorder=\"" + tableStyle.isApplyRowBorder() + "\" ColBorder=\"" + tableStyle.isApplyColBorder() + "\" Insets=\"" + tableStyle.isApplyInsets() + "\" Alignment=\"" + tableStyle.isApplyAlignment() + "\" Font=\"" + tableStyle.isApplyFont() + "\" LineWrap=\"" + tableStyle.isApplyLineWrap() + "\" Foreground=\"" + tableStyle.isApplyForeground() + "\" Background=\"" + tableStyle.isApplyBackground() + "\" FirstRow=\"" + tableStyle.isFormatFirstRow() + "\" FirstCol=\"" + tableStyle.isFormatFirstCol() + "\" LastRow=\"" + tableStyle.isFormatLastRow() + "\" LastCol=\"" + tableStyle.isFormatLastCol() + "\">");
        }
        if (tableXElement.isEmbedded()) {
            this.write(tableXElement.getTable());
        }
        this.writer.println("</TableElement>");
    }

    protected void write(TableLens tableLens) {
        this.writer.println("<Table Rows=\"" + tableLens.getRowCount() + "\" Cols=\"" + tableLens.getColCount() + "\" HeaderRow=\"" + tableLens.getHeaderRowCount() + "\" HeaderCol=\"" + tableLens.getHeaderColCount() + "\">");
        int n = 0;
        while (n < tableLens.getRowCount()) {
            this.writer.println("<TR>");
            int n2 = 0;
            while (n2 < tableLens.getColCount()) {
                this.writer.print("<TD>\"");
                this.writer.print(String.valueOf(tableLens.getObject(n, n2)));
                this.writer.print("\"</TD>");
                ++n2;
            }
            this.writer.println("</TR>");
            ++n;
        }
        this.writer.println("</Table>");
    }

    public void write(TextBoxElement textBoxElement) {
        this.writer.print("<TextBoxElement ");
        this.writeElementAttributes(textBoxElement);
        this.writePainterAttributes(textBoxElement);
        this.writer.print(" Border=\"" + textBoxElement.getBorder() + "\" Justify=\"" + textBoxElement.isJustify() + "\" TextAlignment=\"" + textBoxElement.getTextAlignment() + "\"");
        Insets insets = textBoxElement.getPadding();
        if (insets != null) {
            this.writer.print(" Padding=\"" + insets.top + "," + insets.left + "," + insets.bottom + "," + insets.right + "\"");
        }
        this.writer.println(">");
        this.writer.println("<![CDATA[" + textBoxElement.getText() + "]]>");
        this.writer.println("</TextBoxElement>");
    }

    public void write(TextElement textElement) {
        this.writer.print("<TextElement ");
        this.writeElementAttributes(textElement);
        this.writeTabAttributes((StyleCore.TabSupport)((Object)textElement));
        this.writer.print(" Justify=\"" + textElement.isJustify() + "\"");
        this.writer.print(" Orphan=\"" + textElement.isOrphanControl() + "\"");
        this.writer.println(" TextAdvance=\"" + textElement.getTextAdvance() + "\">");
        this.writer.println("<![CDATA[" + textElement.getText() + "]]>");
        this.writer.println("</TextElement>");
    }

    public void write(XTableStyle xTableStyle) {
        this.writer.flush();
        xTableStyle.export(this.output);
    }

    protected void writeElementAttributes(ReportElement reportElement) {
        StyleCore.Element element = (StyleCore.Element)reportElement;
        if (element.getID() != null) {
            this.writer.print("ID=\"" + element.getID() + "\" ");
        }
        this.writer.print("Alignment=\"" + element.getAlignment() + "\" Indent=\"" + element.getIndent() + "\" Hindent=\"" + element.getHindent() + "\" Font=\"" + StyleFont.toString(element.getFont()) + "\" Foreground=\"" + element.getForeground().getRGB() + "\" Background=\"" + element.getBackground().getRGB() + "\" Spacing=\"" + element.getSpacing() + "\" Block=\"" + element.isBlock() + "\" Continuation=\"" + element.isContinuation() + "\" Visible=\"" + element.isVisible() + "\"");
    }

    protected void writePainterAttributes(PainterElement painterElement) {
        Insets insets;
        Size size;
        this.writer.print(" Layout=\"" + painterElement.getLayout() + "\" Wrapping=\"" + painterElement.getWrapping() + "\"");
        Position position = painterElement.getAnchor();
        if (position != null) {
            this.writer.print(" Anchor=\"" + position.x + "," + position.y + "\"");
        }
        if ((size = painterElement.getSize()) != null) {
            this.writer.print(" Size=\"" + size.width + "x" + size.height + "\"");
        }
        if ((insets = painterElement.getMargin()) != null) {
            this.writer.print(" Margin=\"" + insets.top + "," + insets.left + "," + insets.bottom + "," + insets.right + "\"");
        }
    }

    protected void writeTabAttributes(StyleCore.TabSupport tabSupport) {
        this.writer.print(" FillStyle=\"" + tabSupport.getFillStyle() + "\" TabStops=\"");
        double[] dArray = tabSupport.getTabStops();
        int n = 0;
        while (n < dArray.length) {
            if (n > 0) {
                this.writer.print(",");
            }
            this.writer.print(dArray[n]);
            ++n;
        }
        this.writer.print("\"");
    }
}

