/*
 * Decompiled with CFR 0.152.
 */
package inetsoft.report.io;

import inetsoft.report.Common;
import inetsoft.report.StyleFont;
import inetsoft.report.StyleSheet;
import inetsoft.report.internal.EmptyPainter;
import inetsoft.report.internal.Encoder;
import inetsoft.report.internal.StyleCore;
import inetsoft.report.internal.Util;
import inetsoft.report.internal.XMLException;
import inetsoft.report.internal.XMLTokenStream;
import inetsoft.report.io.TemplateParser;
import inetsoft.report.lens.DefaultChartLens;
import inetsoft.report.lens.DefaultFormLens;
import inetsoft.report.lens.DefaultTableLens;
import inetsoft.report.painter.BulletPainter;
import inetsoft.report.painter.ImagePainter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;

public class ReportParser
extends TemplateParser {
    public ReportParser(InputStream inputStream) {
        super(inputStream);
    }

    public StyleSheet createSheet(String string) {
        this.sheet = Common.createStyleSheet();
        return this.sheet;
    }

    protected Object readChart(XMLTokenStream.Tag tag) throws IOException, XMLException {
        int n;
        String[] stringArray;
        DefaultChartLens defaultChartLens = new DefaultChartLens();
        StyleSheet styleSheet = this.sheet;
        styleSheet.getClass();
        StyleCore.ChartElement chartElement = (StyleCore)styleSheet.new StyleCore.ChartElement(defaultChartLens);
        this.setElementAttributes(chartElement, tag);
        this.setPainterAttributes(chartElement, tag);
        tag = (XMLTokenStream.Tag)this.xml.getToken();
        if (tag.getName().equals("CHART")) {
            defaultChartLens.setDatasetCount(Integer.parseInt(tag.get("Datasets")));
            defaultChartLens.setDatasetSize(Integer.parseInt(tag.get("Size")));
            String string = tag.get("Style");
            if (string != null) {
                defaultChartLens.setStyle(Integer.parseInt(string));
            }
            if ((string = tag.get("Maximum")) != null) {
                defaultChartLens.setMaximum(Double.valueOf(string));
            }
            if ((string = tag.get("Minimum")) != null) {
                defaultChartLens.setMinimum(Double.valueOf(string));
            }
            if ((string = tag.get("Increment")) != null) {
                defaultChartLens.setIncrement(Double.valueOf(string));
            }
            if ((string = tag.get("MinorIncrement")) != null) {
                defaultChartLens.setMinorIncrement(Double.valueOf(string));
            }
            if ((string = tag.get("Gap")) != null) {
                defaultChartLens.setGap(Integer.parseInt(string));
            }
            if ((string = tag.get("XTitle")) != null) {
                defaultChartLens.setXTitle(string);
            }
            if ((string = tag.get("YTitle")) != null) {
                defaultChartLens.setYTitle(string);
            }
            if ((string = tag.get("TitleFont")) != null) {
                defaultChartLens.setTitleFont(StyleFont.decode(string));
            }
            if ((string = tag.get("GridStyle")) != null) {
                defaultChartLens.setGridStyle(Integer.parseInt(string));
            }
            if ((string = tag.get("BorderStyle")) != null) {
                defaultChartLens.setBorderStyle(Integer.parseInt(string));
            }
            if ((string = tag.get("ShowValue")) != null) {
                defaultChartLens.setShowValue(Boolean.valueOf(string));
            }
            if ((string = tag.get("Precision")) != null) {
                defaultChartLens.setPrecision(Integer.parseInt(string));
            }
            if ((string = tag.get("LegendPosition")) != null) {
                defaultChartLens.setLegendPosition(Integer.parseInt(string));
            }
            if ((string = tag.get("BlackWhite")) != null) {
                defaultChartLens.setBlackWhite(Boolean.valueOf(string));
            }
        }
        chartElement.setChart(defaultChartLens);
        StringTokenizer stringTokenizer = new StringTokenizer((String)this.xml.getToken(), "\n\r");
        if (stringTokenizer.hasMoreTokens()) {
            stringArray = Util.split(stringTokenizer.nextToken(), '|');
            n = 0;
            while (n < stringArray.length && n < defaultChartLens.getDatasetCount()) {
                defaultChartLens.setDatasetLabel(n, stringArray[n]);
                ++n;
            }
        }
        if (stringTokenizer.hasMoreTokens()) {
            stringArray = Util.split(stringTokenizer.nextToken(), '|');
            n = 0;
            while (n < stringArray.length && n < defaultChartLens.getDatasetSize()) {
                defaultChartLens.setLabel(n, stringArray[n]);
                ++n;
            }
        }
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String[] stringArray2 = Util.split(stringTokenizer.nextToken(), '|');
            int n3 = 0;
            while (n3 < stringArray2.length) {
                if (stringArray2[n3].length() > 0) {
                    defaultChartLens.setData(n2, n3, Double.valueOf(stringArray2[n3]));
                }
                ++n3;
            }
            ++n2;
        }
        return chartElement;
    }

    protected Object readForm(XMLTokenStream.Tag tag) throws IOException, XMLException {
        Object object;
        DefaultFormLens defaultFormLens = new DefaultFormLens();
        StyleSheet styleSheet = this.sheet;
        styleSheet.getClass();
        StyleCore.FormElement formElement = (StyleCore)styleSheet.new StyleCore.FormElement(defaultFormLens);
        this.setElementAttributes(formElement, tag);
        String string = tag.get("FieldPerRow");
        if (string != null) {
            defaultFormLens.setFieldPerRow(Integer.parseInt(string));
        }
        if ((string = tag.get("LabelFont")) != null) {
            defaultFormLens.setLabelFont(StyleFont.decode(string));
        }
        if ((string = tag.get("LabelForeground")) != null) {
            defaultFormLens.setLabelForeground(new Color(Integer.parseInt(string)));
        }
        if ((string = tag.get("LabelBackground")) != null) {
            defaultFormLens.setLabelBackground(new Color(Integer.parseInt(string)));
        }
        if ((string = tag.get("FieldFont")) != null) {
            defaultFormLens.setFont(StyleFont.decode(string));
        }
        if ((string = tag.get("FieldForeground")) != null) {
            defaultFormLens.setForeground(new Color(Integer.parseInt(string)));
        }
        if ((string = tag.get("FieldBackground")) != null) {
            defaultFormLens.setBackground(new Color(Integer.parseInt(string)));
        }
        if ((string = tag.get("Underline")) != null) {
            defaultFormLens.setUnderline(Integer.parseInt(string));
        }
        if ((string = tag.get("FixedWidths")) != null) {
            object = Util.split(string, ',');
            int[] nArray = new int[((String[])object).length];
            int n = 0;
            while (n < nArray.length) {
                nArray[n] = Integer.parseInt(object[n]);
                ++n;
            }
            formElement.setFixedWidths(nArray);
        }
        tag = (XMLTokenStream.Tag)this.xml.getToken();
        defaultFormLens.setFieldCount(Integer.parseInt(tag.get("Fields")));
        object = new StringTokenizer((String)this.xml.getToken(), "\n\r");
        int n = 0;
        while (((StringTokenizer)object).hasMoreTokens()) {
            String[] stringArray = Util.split(((StringTokenizer)object).nextToken(), '|');
            defaultFormLens.setLabel(n, stringArray[0]);
            defaultFormLens.setField(n, stringArray[1]);
            ++n;
        }
        return formElement;
    }

    protected Image readImageData(XMLTokenStream.Tag tag) throws IOException, XMLException {
        int n = Integer.parseInt(tag.get("Width"));
        int n2 = Integer.parseInt(tag.get("Height"));
        String string = (String)this.xml.getToken();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n3 = 0;
        while (n3 < string.length()) {
            char c = string.charAt(n3);
            if (!Character.isWhitespace(c)) {
                byteArrayOutputStream.write((byte)c);
            }
            ++n3;
        }
        Image image = Encoder.decodeImage(n, n2, Encoder.inflate(Encoder.decodeAscii85(byteArrayOutputStream.toByteArray())));
        return image;
    }

    protected Object readPainter(XMLTokenStream.Tag tag) throws IOException, XMLException {
        StyleSheet styleSheet = this.sheet;
        styleSheet.getClass();
        StyleCore.PainterElement painterElement = (StyleCore)styleSheet.new StyleCore.PainterElement(new EmptyPainter());
        this.setElementAttributes(painterElement, tag);
        this.setPainterAttributes(painterElement, tag);
        String string = tag.get("Painter");
        if (string != null && string.equals("bullet")) {
            painterElement.setPainter(new BulletPainter());
        }
        tag = (XMLTokenStream.Tag)this.xml.getToken();
        Image image = this.readImageData(tag);
        painterElement.setPainter(new ImagePainter(image));
        return painterElement;
    }

    protected Object readTable(XMLTokenStream.Tag tag) throws IOException, XMLException {
        String[] stringArray;
        DefaultTableLens defaultTableLens = new DefaultTableLens(5, 5);
        StyleSheet styleSheet = this.sheet;
        styleSheet.getClass();
        StyleCore.TableElement tableElement = (StyleCore)styleSheet.new StyleCore.TableElement(defaultTableLens);
        this.setElementAttributes(tableElement, tag);
        String string = tag.get("TableWidth");
        if (string != null) {
            tableElement.setTableWidth(Double.valueOf(string));
        }
        if ((string = tag.get("FixedWidths")) != null) {
            stringArray = Util.split(string, ',');
            int[] nArray = new int[stringArray.length];
            int n = 0;
            while (n < nArray.length) {
                nArray[n] = Integer.parseInt(stringArray[n]);
                ++n;
            }
            tableElement.setFixedWidths(nArray);
        }
        if ((string = tag.get("Layout")) != null) {
            tableElement.setLayout(Integer.parseInt(string));
        }
        if ((string = tag.get("Padding")) != null) {
            stringArray = Util.split(string, ',');
            tableElement.setPadding(new Insets(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]), Integer.parseInt(stringArray[3])));
        }
        while (true) {
            if ((tag = (XMLTokenStream.Tag)this.xml.getToken()).getName().equals("TABLE")) {
                Object object;
                defaultTableLens.setRowCount(Integer.parseInt(tag.get("Rows")));
                defaultTableLens.setColCount(Integer.parseInt(tag.get("Cols")));
                defaultTableLens.setHeaderRowCount(Integer.parseInt(tag.get("HeaderRow")));
                defaultTableLens.setHeaderColCount(Integer.parseInt(tag.get("HeaderCol")));
                int n = -1;
                int n2 = 0;
                while ((object = this.xml.getToken()) != null) {
                    if (!(object instanceof XMLTokenStream.Tag)) continue;
                    tag = (XMLTokenStream.Tag)object;
                    if (tag.getName().equals("TD")) {
                        String[] stringArray2;
                        string = tag.get("Width");
                        if (string != null) {
                            defaultTableLens.setColWidth(n2, Integer.parseInt(string));
                        }
                        if ((string = tag.get("Row0BorderColor")) != null) {
                            defaultTableLens.setRowBorderColor(-1, n2, new Color(Integer.parseInt(string)));
                        }
                        if ((string = tag.get("Row0Border")) != null) {
                            defaultTableLens.setRowBorder(-1, n2, Integer.parseInt(string));
                        }
                        if ((string = tag.get("Col0BorderColor")) != null) {
                            defaultTableLens.setColBorderColor(n, -1, new Color(Integer.parseInt(string)));
                        }
                        if ((string = tag.get("Col0Border")) != null) {
                            defaultTableLens.setColBorder(n, -1, Integer.parseInt(string));
                        }
                        if ((string = tag.get("RowBorderColor")) != null) {
                            defaultTableLens.setRowBorderColor(n, n2, new Color(Integer.parseInt(string)));
                        }
                        if ((string = tag.get("RowBorder")) != null) {
                            defaultTableLens.setRowBorder(n, n2, Integer.parseInt(string));
                        }
                        if ((string = tag.get("ColBorderColor")) != null) {
                            defaultTableLens.setColBorderColor(n, n2, new Color(Integer.parseInt(string)));
                        }
                        if ((string = tag.get("ColBorder")) != null) {
                            defaultTableLens.setColBorder(n, n2, Integer.parseInt(string));
                        }
                        if ((string = tag.get("Insets")) != null) {
                            stringArray2 = Util.split(string, ',');
                            defaultTableLens.setInsets(n, n2, new Insets(Integer.parseInt(stringArray2[0]), Integer.parseInt(stringArray2[1]), Integer.parseInt(stringArray2[2]), Integer.parseInt(stringArray2[3])));
                        }
                        if ((string = tag.get("Span")) != null) {
                            stringArray2 = Util.split(string, 'x');
                            defaultTableLens.setSpan(n, n2, new Dimension(Integer.parseInt(stringArray2[0]), Integer.parseInt(stringArray2[1])));
                        }
                        if ((string = tag.get("Alignment")) != null) {
                            defaultTableLens.setAlignment(n, n2, Integer.parseInt(string));
                        }
                        if ((string = tag.get("Font")) != null) {
                            defaultTableLens.setFont(n, n2, StyleFont.decode(string));
                        }
                        if ((string = tag.get("LineWrap")) != null) {
                            defaultTableLens.setLineWrap(n, n2, Boolean.valueOf(string));
                        }
                        if ((string = tag.get("Foreground")) != null) {
                            defaultTableLens.setForeground(n, n2, new Color(Integer.parseInt(string)));
                        }
                        if ((string = tag.get("Background")) != null) {
                            defaultTableLens.setBackground(n, n2, new Color(Integer.parseInt(string)));
                        }
                        if ((object = this.xml.getToken()) instanceof String) {
                            defaultTableLens.setObject(n, n2, object.equals("null") ? null : object);
                        } else {
                            tag = (XMLTokenStream.Tag)object;
                            if (tag.getName().equals("IMAGE")) {
                                defaultTableLens.setObject(n, n2, this.readImageData(tag));
                            }
                        }
                        ++n2;
                        continue;
                    }
                    if (tag.getName().equals("TR")) {
                        ++n;
                        n2 = 0;
                        string = tag.get("Height");
                        if (string == null) continue;
                        defaultTableLens.setRowHeight(n, Integer.parseInt(string));
                        continue;
                    }
                    if (tag.getName().equals("/TABLE")) break;
                }
                tableElement.setTable(defaultTableLens);
                continue;
            }
            if (tag.getName().equals("/TABLEELEMENT")) break;
        }
        return tableElement;
    }
}

