/*
 * Decompiled with CFR 0.152.
 */
package inetsoft.report.io;

import inetsoft.report.ChartElement;
import inetsoft.report.Common;
import inetsoft.report.CompositeElement;
import inetsoft.report.CompositeLens;
import inetsoft.report.Context;
import inetsoft.report.FormElement;
import inetsoft.report.FormLens;
import inetsoft.report.Painter;
import inetsoft.report.PainterElement;
import inetsoft.report.Presenter;
import inetsoft.report.ReportElement;
import inetsoft.report.StyleFont;
import inetsoft.report.TOCElement;
import inetsoft.report.TableElement;
import inetsoft.report.TableLens;
import inetsoft.report.internal.Encoder;
import inetsoft.report.internal.StyleCore;
import inetsoft.report.internal.XMLTokenStream;
import inetsoft.report.io.Builder;
import inetsoft.report.io.TemplateFormatter;
import inetsoft.report.painter.BulletPainter;
import inetsoft.report.painter.ComponentPainter;
import inetsoft.report.painter.ImagePainter;
import inetsoft.report.painter.PresenterPainter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.io.OutputStream;
import java.text.Format;

class ReportFormatter
extends TemplateFormatter {
    public ReportFormatter(OutputStream outputStream) {
        super(outputStream);
    }

    public void write(ChartElement chartElement) {
        this.writer.print("<ChartElement ");
        this.writeElementAttributes(chartElement);
        this.writer.print(" ");
        this.writePainterAttributes(chartElement);
        this.writer.println(">");
        this.write(chartElement.getChart(), true);
        this.writer.println("</ChartElement>");
    }

    public void write(CompositeElement compositeElement) {
        Object object;
        Context context = new Context(this.sheet);
        CompositeLens compositeLens = compositeElement.getComposite();
        compositeLens.reset();
        while ((object = compositeLens.nextElement(context)) != null) {
            ReportElement reportElement = this.sheet.getCompositeElement(compositeElement.getID(), object, context);
            if (reportElement != null) {
                reportElement.setContext(context);
                Builder.write(this, reportElement);
            }
            context = new Context(this.sheet);
        }
    }

    public void write(FormElement formElement) {
        FormLens formLens = formElement.getForm();
        this.writer.print("<FormElement ");
        this.writeElementAttributes(formElement);
        this.writer.print(" FieldPerRow=\"" + formLens.getFieldPerRow() + "\"");
        if (formLens.getLabelFont(0) != null) {
            this.writer.print(" LabelFont=\"" + StyleFont.toString(formLens.getLabelFont(0)) + "\"");
        }
        if (formLens.getLabelForeground(0) != null) {
            this.writer.print(" LabelForeground=\"" + formLens.getLabelForeground(0).getRGB() + "\"");
        }
        if (formLens.getLabelBackground(0) != null) {
            this.writer.print(" LabelBackground=\"" + formLens.getLabelBackground(0).getRGB() + "\"");
        }
        if (formLens.getFont(0) != null) {
            this.writer.print(" FieldFont=\"" + StyleFont.toString(formLens.getFont(0)) + "\"");
        }
        if (formLens.getForeground(0) != null) {
            this.writer.print(" FieldForeground=\"" + formLens.getForeground(0).getRGB() + "\"");
        }
        if (formLens.getBackground(0) != null) {
            this.writer.print(" FieldBackground=\"" + formLens.getBackground(0).getRGB() + "\"");
        }
        this.writer.print(" Underline=\"" + formLens.getUnderline() + "\"");
        if (formElement.getFixedWidths() != null) {
            int[] nArray = formElement.getFixedWidths();
            this.writer.print(" FixedWidths=\"");
            int n = 0;
            while (n < nArray.length) {
                if (n > 0) {
                    this.writer.print(",");
                }
                this.writer.print(nArray[n]);
                ++n;
            }
            this.writer.print("\" ");
        }
        this.writer.println(">");
        this.write(formLens);
        this.writer.println("</FormElement>");
    }

    protected void write(Painter painter, ReportElement reportElement) {
        Dimension dimension = painter.getPreferredSize();
        Image image = Common.createImage(dimension.width, dimension.height);
        Graphics graphics = image.getGraphics();
        graphics.setColor(reportElement.getBackground());
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        graphics.setColor(reportElement.getForeground());
        painter.paint(graphics, 0, 0, dimension.width, dimension.height);
        graphics.dispose();
        byte[] byArray = Encoder.encodeAscii85(Encoder.deflate(Encoder.encodeImage(image)));
        this.writer.println("<Image Width=\"" + dimension.width + "\" Height=\"" + dimension.height + "\">");
        String string = new String(byArray);
        int n = 0;
        while (n < byArray.length) {
            try {
                String string2 = string.substring(n, n + Math.min(byArray.length - n, 80));
                this.writer.println(XMLTokenStream.encodeXML(string2));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            n += 80;
        }
        this.writer.println("</Image>");
    }

    public void write(PainterElement painterElement) {
        if (painterElement instanceof StyleCore.FieldElement) {
            super.write(painterElement);
            return;
        }
        this.writer.print("<PainterElement ");
        this.writeElementAttributes(painterElement);
        this.writer.print(" ");
        this.writePainterAttributes(painterElement);
        if (painterElement.getPainter() instanceof BulletPainter) {
            this.writer.print(" Painter=\"bullet\"");
        }
        this.writer.println(">");
        this.write(painterElement.getPainter(), painterElement);
        this.writer.println("</PainterElement>");
    }

    public void write(TOCElement tOCElement) {
        this.write((StyleCore.CompositeElement)((Object)tOCElement));
    }

    public void write(TableElement tableElement) {
        Object object;
        this.writer.print("<TableElement ");
        this.writeElementAttributes(tableElement);
        this.writer.print(" TableWidth=\"" + tableElement.getTableWidth() + "\"");
        if (tableElement.getFixedWidths() != null) {
            object = tableElement.getFixedWidths();
            this.writer.print(" FixedWidths=\"");
            int n = 0;
            while (n < ((int[])object).length) {
                if (n > 0) {
                    this.writer.print(",");
                }
                this.writer.print(object[n]);
                ++n;
            }
            this.writer.print("\" ");
        }
        this.writer.print(" Layout=\"" + tableElement.getLayout() + "\"");
        object = tableElement.getPadding();
        if (object != null) {
            this.writer.print(" Padding=\"" + object.top + "," + object.left + "," + object.bottom + "," + object.right + "\"");
        }
        this.writer.println(">");
        this.write(tableElement.getTable(), tableElement);
        this.writer.println("</TableElement>");
    }

    protected void write(TableLens tableLens, TableElement tableElement) {
        this.writer.println("<Table Rows=\"" + tableLens.getRowCount() + "\" Cols=\"" + tableLens.getColCount() + "\" HeaderRow=\"" + tableLens.getHeaderRowCount() + "\" HeaderCol=\"" + tableLens.getHeaderColCount() + "\">");
        int n = 0;
        while (n < tableLens.getRowCount()) {
            this.writer.println("<TR Height=\"" + tableLens.getRowHeight(n) + "\">");
            int n2 = 0;
            while (n2 < tableLens.getColCount()) {
                Dimension dimension;
                Color color;
                this.writer.print("<TD");
                if (n == 0) {
                    this.writer.print(" Width=\"" + tableLens.getColWidth(n2) + "\"");
                    color = tableLens.getRowBorderColor(-1, n2);
                    if (color != null) {
                        this.writer.print(" Row0BorderColor=\"" + color.getRGB() + "\" Row0Border=\"" + tableLens.getRowBorder(-1, n2) + "\"");
                    }
                }
                if (n2 == 0) {
                    color = tableLens.getColBorderColor(n, -1);
                    if (color != null) {
                        this.writer.print(" Col0BorderColor=\"" + color.getRGB() + "\"");
                    }
                    this.writer.print(" Col0Border=\"" + tableLens.getColBorder(n, -1) + "\"");
                }
                if ((color = tableLens.getRowBorderColor(n, n2)) != null) {
                    this.writer.print(" RowBorderColor=\"" + color.getRGB() + "\"");
                }
                if ((color = tableLens.getColBorderColor(n, n2)) != null) {
                    this.writer.print(" ColBorderColor=\"" + color.getRGB() + "\"");
                }
                this.writer.print(" RowBorder=\"" + tableLens.getRowBorder(n, n2) + "\" ColBorder=\"" + tableLens.getColBorder(n, n2) + "\"");
                Insets insets = tableLens.getInsets(n, n2);
                if (insets != null) {
                    this.writer.print(" Insets=\"" + insets.top + "," + insets.left + "," + insets.bottom + "," + insets.right + "\"");
                }
                if ((dimension = tableLens.getSpan(n, n2)) != null) {
                    this.writer.print(" Span=\"" + dimension.width + "x" + dimension.height + "\"");
                }
                this.writer.print(" Alignment=\"" + tableLens.getAlignment(n, n2) + "\"");
                Font font = tableLens.getFont(n, n2);
                if (font != null) {
                    this.writer.print(" Font=\"" + StyleFont.toString(font) + "\"");
                }
                this.writer.print(" LineWrap=\"" + tableLens.isLineWrap(n, n2) + "\"");
                color = tableLens.getForeground(n, n2);
                if (color != null) {
                    this.writer.print(" Foreground=\"" + color.getRGB() + "\"");
                }
                if ((color = tableLens.getBackground(n, n2)) != null) {
                    this.writer.print(" Background=\"" + color.getRGB() + "\"");
                }
                this.writer.println(">");
                Object object = tableLens.getObject(n, n2);
                if (object != null) {
                    Presenter presenter = tableElement.getPresenter(object.getClass());
                    if (presenter != null) {
                        this.write(new PresenterPainter(object, presenter), (ReportElement)tableElement);
                    } else if (object instanceof Image) {
                        this.write(new ImagePainter((Image)object), (ReportElement)tableElement);
                    } else if (object instanceof Component) {
                        this.write(new ComponentPainter((Component)object), (ReportElement)tableElement);
                    } else if (object instanceof Painter) {
                        this.write((Painter)object, (ReportElement)tableElement);
                    } else {
                        Format format = tableElement.getFormat(object.getClass());
                        if (format != null) {
                            object = format.format(object);
                        }
                        this.writer.println("<![CDATA[" + object + "]]>");
                    }
                }
                this.writer.print("</TD>");
                ++n2;
            }
            this.writer.println("</TR>");
            ++n;
        }
        this.writer.println("</Table>");
    }
}

