/*
 * Decompiled with CFR 0.152.
 */
package inetsoft.report.io;

import inetsoft.report.AreaBreakElement;
import inetsoft.report.ChartElement;
import inetsoft.report.Common;
import inetsoft.report.CompositeElement;
import inetsoft.report.CompositeLens;
import inetsoft.report.CondPageBreakElement;
import inetsoft.report.Context;
import inetsoft.report.FormElement;
import inetsoft.report.HeadingElement;
import inetsoft.report.Margin;
import inetsoft.report.NewlineElement;
import inetsoft.report.PageBreakElement;
import inetsoft.report.PageLayoutElement;
import inetsoft.report.Painter;
import inetsoft.report.PainterElement;
import inetsoft.report.ReportElement;
import inetsoft.report.ScaledPainter;
import inetsoft.report.SeparatorElement;
import inetsoft.report.Size;
import inetsoft.report.SpaceElement;
import inetsoft.report.StyleFont;
import inetsoft.report.StyleSheet;
import inetsoft.report.TOCElement;
import inetsoft.report.TabElement;
import inetsoft.report.TableElement;
import inetsoft.report.TableLens;
import inetsoft.report.TextBoxElement;
import inetsoft.report.TextElement;
import inetsoft.report.internal.PixelConsumer;
import inetsoft.report.internal.StyleCore;
import inetsoft.report.internal.Util;
import inetsoft.report.io.Builder;
import inetsoft.report.io.Formatter;
import inetsoft.report.painter.ComponentPainter;
import inetsoft.report.painter.ImagePainter;
import inetsoft.report.style.XTableStyle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;

public class RTFFormatter
implements Formatter {
    protected PrintWriter writer;
    protected OutputStream output;
    Hashtable fontmap = new Hashtable();
    Hashtable colormap = new Hashtable();
    Dimension pagesize = new Dimension(12240, 15840);
    int pagewidth;
    double currX = 0.0;
    double floatH = 0.0;
    boolean inHeader = false;
    boolean ignore = false;
    private static Hashtable fontnames = new Hashtable();
    private static final int EMU = 12700;
    protected StyleSheet sheet;

    public RTFFormatter(OutputStream outputStream) {
        fontnames.put("dialog", "Helvetica");
        fontnames.put("dialoginput", "Courier");
        fontnames.put("serif", "Times");
        fontnames.put("sansserif", "Helvetica");
        fontnames.put("monospaced", "Courier");
        fontnames.put("timesroman", "Times");
        fontnames.put("courier", "Courier");
        fontnames.put("helvetica", "Helvetica");
        this.output = outputStream;
        this.writer = new PrintWriter(this.output);
    }

    public void end() {
        this.writer.println("}");
        this.writer.flush();
    }

    public void endHeader() {
        this.writer.println("}");
        this.inHeader = false;
        this.ignore = false;
    }

    protected String getBorder(int n) {
        switch (n) {
            case 4097: {
                return "\\brdrs";
            }
            case 4098: 
            case 4099: {
                return "\\brdrth";
            }
            case 24578: 
            case 24579: 
            case 40962: 
            case 40963: {
                return "\\brdrsh";
            }
            case 8195: {
                return "\\brdrdb";
            }
            case 4113: {
                return "\\brdrdot";
            }
            case 4145: 
            case 4193: 
            case 4241: {
                return "\\brdrdash";
            }
        }
        return "\\brdrs";
    }

    protected String getFontName(Font font) {
        String string = font.getName();
        Object v = fontnames.get(string.toLowerCase());
        return v == null ? string : v.toString();
    }

    protected String getLineProperty(int n) {
        switch (n) {
            case 0: {
                return "{\\sp{\\sn fLine}{\\sv 0}}";
            }
            case 4097: {
                return "{\\sp{\\sn lineWidth}{\\sv 12700}}{\\sp{\\sn lineStyle}{\\sv 0}}";
            }
            case 4098: {
                return "{\\sp{\\sn lineWidth}{\\sv 25400}}{\\sp{\\sn lineStyle}{\\sv 0}}";
            }
            case 4099: {
                return "{\\sp{\\sn lineWidth}{\\sv 38100}}{\\sp{\\sn lineStyle}{\\sv 0}}";
            }
            case 24578: {
                return "{\\sp{\\sn lineWidth}{\\sv 25400}}{\\sp{\\sn lineStyle}{\\sv 3}}";
            }
            case 24579: {
                return "{\\sp{\\sn lineWidth}{\\sv 38100}}{\\sp{\\sn lineStyle}{\\sv 3}}";
            }
            case 40962: {
                return "{\\sp{\\sn lineWidth}{\\sv 25400}}{\\sp{\\sn lineStyle}{\\sv 2}}";
            }
            case 40963: {
                return "{\\sp{\\sn lineWidth}{\\sv 38100}}{\\sp{\\sn lineStyle}{\\sv 2}}";
            }
            case 8195: {
                return "{\\sp{\\sn lineWidth}{\\sv 38100}}{\\sp{\\sn lineStyle}{\\sv 1}}";
            }
            case 4113: {
                return "{\\sp{\\sn lineWidth}{\\sv 12700}}{\\sp{\\sn lineStyle}{\\sv 0}}{\\sp{\\sn lineDashing}{\\sv 2}}";
            }
            case 4145: {
                return "{\\sp{\\sn lineWidth}{\\sv 12700}}{\\sp{\\sn lineStyle}{\\sv 0}}{\\sp{\\sn lineDashing}{\\sv 1}}";
            }
            case 4193: {
                return "{\\sp{\\sn lineWidth}{\\sv 12700}}{\\sp{\\sn lineStyle}{\\sv 0}}{\\sp{\\sn lineDashing}{\\sv 10}}";
            }
            case 4241: {
                return "{\\sp{\\sn lineWidth}{\\sv 12700}}{\\sp{\\sn lineStyle}{\\sv 0}}{\\sp{\\sn lineDashing}{\\sv 8}}";
            }
        }
        return "";
    }

    void newline() {
        if (this.currX != 0.0) {
            this.writer.print("\\sa0\\f1\\fs8 {");
            int n = 4;
            while ((double)n < this.floatH) {
                this.writer.print("\\par ");
                n += 4;
            }
            this.writer.print("}\\pard");
            this.currX = 0.0;
            this.floatH = 0.0;
        }
    }

    public void prolog(StyleSheet styleSheet) {
        Serializable serializable;
        int n;
        this.sheet = styleSheet;
        this.pagewidth = (int)((double)this.pagesize.width - styleSheet.getMargin().left * 1440.0 - styleSheet.getMargin().right * 1440.0);
        this.writer.print("{\\rtf1\\ansi\\ansicpg1252\\uc1 \\deff0");
        this.writer.print("\\deflang1033\\deflangfe1033{\\fonttbl");
        Vector[] vectorArray = new Vector[]{styleSheet.getElements(256), styleSheet.getElements(257), styleSheet.getElements(258), styleSheet.getElements(259), styleSheet.getElements(512), styleSheet.getElements(513), styleSheet.getElements(514), styleSheet.getElements(515), styleSheet.getElements(0)};
        int n2 = 1;
        int n3 = 0;
        while (n3 < vectorArray.length) {
            if (vectorArray[n3] != null) {
                n = 0;
                while (n < vectorArray[n3].size()) {
                    serializable = (ReportElement)vectorArray[n3].elementAt(n);
                    if (this.fontmap.get(serializable.getFont()) == null) {
                        this.fontmap.put(serializable.getFont(), new Integer(n2));
                        this.writer.print("{\\f" + n2 + "\\fcharset0\\fprq2 " + serializable.getFont().getName() + ";}");
                    }
                    ++n;
                    ++n2;
                }
            }
            ++n3;
        }
        this.writer.print("}");
        this.writer.print("{\\colortbl;");
        n = 0;
        while (n < vectorArray.length) {
            if (vectorArray[n] != null) {
                int n4 = 0;
                while (n4 < vectorArray[n].size()) {
                    ReportElement reportElement = (ReportElement)vectorArray[n].elementAt(n4);
                    this.writeColorTable(reportElement.getForeground());
                    this.writeColorTable(reportElement.getBackground());
                    if (reportElement instanceof TableElement) {
                        TableLens tableLens = ((TableElement)reportElement).getTable();
                        int n5 = -1;
                        while (n5 < tableLens.getRowCount()) {
                            int n6 = -1;
                            while (n6 < tableLens.getColCount()) {
                                this.writeColorTable(tableLens.getRowBorderColor(n5, n6));
                                this.writeColorTable(tableLens.getColBorderColor(n5, n6));
                                if (n5 >= 0 && n6 >= 0) {
                                    this.writeColorTable(tableLens.getForeground(n5, n6));
                                    this.writeColorTable(tableLens.getBackground(n5, n6));
                                }
                                ++n6;
                            }
                            ++n5;
                        }
                    }
                    ++n4;
                }
            }
            ++n;
        }
        this.writer.print("}");
        this.writer.print("\\widowctrl\\ftnbj\\aenddoc\\formshade\\viewkind1\\viewscale100\\pgbrdrhead\\pgbrdrfoot \\fet0\\sectd \\linex0\\endnhere");
        serializable = styleSheet.getMargin();
        this.writer.print("\\paperw" + this.pagesize.width + "\\paperh" + this.pagesize.height + "\\margl" + (int)(((Margin)serializable).left * 1440.0) + "\\margr" + (int)(((Margin)serializable).right * 1440.0) + "\\margt" + (int)(((Margin)serializable).top * 1440.0) + "\\margb" + (int)(((Margin)serializable).bottom * 1440.0));
        this.writer.print("\\headery" + (int)(styleSheet.getHeaderFromEdge() * 1440.0) + "\\footery" + (int)(styleSheet.getFooterFromEdge() * 1440.0));
        this.writer.println("");
    }

    public void setPageSize(double d, double d2) {
        this.pagesize = new Dimension((int)(d * 1440.0), (int)(d2 * 1440.0));
    }

    public void setPageSize(Size size) {
        this.setPageSize(size.width, size.height);
    }

    public void startHeader(int n) {
        switch (n) {
            case 256: {
                this.writer.println("{\\header");
                break;
            }
            case 257: {
                this.writer.println("{\\headerf");
                break;
            }
            case 259: {
                this.writer.println("{\\headerr");
                break;
            }
            case 258: {
                this.writer.println("{\\headerl");
                break;
            }
            case 512: {
                this.writer.println("{\\footer");
                break;
            }
            case 513: {
                this.writer.println("{\\footerf");
                break;
            }
            case 515: {
                this.writer.println("{\\footerr");
                break;
            }
            case 514: {
                this.writer.println("{\\footerl");
                break;
            }
        }
        this.inHeader = true;
    }

    public void startHeader(String string, boolean bl) {
        this.ignore = true;
    }

    public void write(AreaBreakElement areaBreakElement) {
        if (this.ignore || !areaBreakElement.isVisible()) {
            return;
        }
        this.newline();
        this.writer.print("{\\column\\par}\\pard");
    }

    public void write(ChartElement chartElement) {
        this.write((PainterElement)chartElement);
    }

    public void write(CompositeElement compositeElement) {
        Object object;
        Context context = new Context(this.sheet);
        CompositeLens compositeLens = compositeElement.getComposite();
        compositeLens.reset();
        while ((object = compositeLens.nextElement(context)) != null) {
            ReportElement reportElement = this.sheet.getCompositeElement(compositeElement.getID(), object, context);
            if (reportElement != null) {
                reportElement.setContext(context);
                Builder.write(this, reportElement);
            }
            context = new Context(this.sheet);
        }
    }

    public void write(CondPageBreakElement condPageBreakElement) {
        if (this.ignore || !condPageBreakElement.isVisible()) {
            return;
        }
        this.newline();
        this.writer.print("\\pard{\\par}");
    }

    public void write(FormElement formElement) {
        this.write((TableElement)formElement);
    }

    public void write(HeadingElement headingElement) {
        this.write((TextElement)headingElement);
    }

    public void write(NewlineElement newlineElement) {
        if (this.ignore || !newlineElement.isVisible()) {
            return;
        }
        int n = 0;
        while (n < newlineElement.getCount()) {
            this.writer.print("{\\par}");
            ++n;
        }
        this.newline();
        this.writer.print("\\pard");
    }

    public void write(PageBreakElement pageBreakElement) {
        if (this.ignore || !pageBreakElement.isVisible()) {
            return;
        }
        this.newline();
        this.writer.print("{\\page\\par}\\pard");
    }

    public void write(PageLayoutElement pageLayoutElement) {
        if (this.ignore || !pageLayoutElement.isVisible()) {
            return;
        }
        this.newline();
        this.writer.print("\\pard{\\par}");
    }

    public void write(PainterElement painterElement) {
        StyleCore.PainterElement painterElement2 = (StyleCore.PainterElement)painterElement;
        if (this.ignore || !painterElement2.isVisible()) {
            return;
        }
        Painter painter = painterElement2.getPainter();
        this.writeAlignment(painterElement2.getAlignment());
        this.writeWrapSpace(painterElement2.getMargin());
        if (painterElement2.getAnchor() != null) {
            double d = painterElement2.getAnchor().x * 1440.0f;
            if (d < 0.0) {
                d += (double)this.pagewidth;
            }
            this.writer.print("\\li" + (int)d + " ");
        } else if (painterElement2.getIndent() > 0.0) {
            this.writer.print("\\li" + (int)(painterElement2.getIndent() * 1440.0) + " ");
        }
        this.writePainter(painter, painterElement2.getPreferredSize(), painterElement2.getForeground(), painterElement2.getBackground());
        if (painterElement2.isLastOnLine()) {
            this.newline();
            this.writer.print("\\pard{\\par}");
        } else {
            this.currX += (double)painterElement2.getPreferredSize().width;
        }
    }

    public void write(SeparatorElement separatorElement) {
        if (this.ignore || !separatorElement.isVisible()) {
            return;
        }
        this.newline();
        this.writer.print("{\\par}{\\shp{\\*\\shpinst\\shpleft0\\shptop0");
        this.writer.print("\\shpright" + this.pagewidth + "\\shpbottom0\\shpwr1");
        this.writer.print("\\shpbxcolumn\\shpbypara{\\sp{\\sn shapeType}{\\sv 20}}");
        this.writer.print("{\\sp{\\sn shapePath}{\\sv 4}}}");
        this.writer.print(this.getLineProperty(separatorElement.getStyle()));
        this.writer.print("{\\shprslt{\\*\\do\\dobxcolumn\\dobypara");
        this.writer.print("\\dodhgt8192\\dpline\\dpptx0\\dppty0");
        this.writer.print("\\dpx0\\dpy0\\dpxsize" + this.pagewidth + "\\dpysize30");
        this.writer.print("\\dplinecor0\\dplinecog0\\dplinecob0}}}");
        this.newline();
        this.writer.print("\\pard{\\par}");
    }

    public void write(SpaceElement spaceElement) {
        if (this.ignore || !spaceElement.isVisible()) {
            return;
        }
        int n = spaceElement.getSpace() / 8;
        this.writer.print("{");
        int n2 = 0;
        while (n2 < n) {
            this.writer.print(" ");
            ++n2;
        }
        this.writer.print("}");
    }

    public void write(TOCElement tOCElement) {
        Object object;
        if (this.ignore || !tOCElement.isVisible()) {
            return;
        }
        this.newline();
        Context context = new Context(this.sheet);
        CompositeLens compositeLens = tOCElement.getComposite();
        compositeLens.reset();
        while ((object = compositeLens.nextElement(context)) != null) {
            ReportElement reportElement = this.sheet.getCompositeElement(tOCElement.getID(), object, context);
            if (reportElement != null) {
                reportElement.setContext(context);
                Builder.write(this, reportElement);
            }
            context = new Context(this.sheet);
        }
    }

    public void write(TabElement tabElement) {
        if (this.ignore || !tabElement.isVisible()) {
            return;
        }
        double[] dArray = tabElement.getTabStops();
        int n = 0;
        int n2 = 0;
        while (n2 < dArray.length) {
            if (dArray[n2] * 72.0 > this.currX) {
                this.currX = dArray[n2] * 72.0;
                n = (int)(this.currX * 20.0);
                break;
            }
            ++n2;
        }
        if (n == 0) {
            return;
        }
        switch (tabElement.getFillStyle()) {
            case 4097: {
                this.writer.print("\\tlul");
                break;
            }
            case 4098: 
            case 4099: 
            case 24578: 
            case 40962: {
                this.writer.print("\\tlth");
                break;
            }
            case 8195: 
            case 24579: 
            case 40963: {
                this.writer.print("\\tlul");
                break;
            }
            case 4113: {
                this.writer.print("\\tldot");
                break;
            }
            case 4145: 
            case 4193: 
            case 4241: {
                this.writer.print("\\tlhyph");
                break;
            }
        }
        this.writer.print("\\tx" + n + "{\\tab}");
    }

    public void write(TableElement tableElement) {
        int n;
        int n2;
        int n3;
        StyleCore.TableElement tableElement2 = (StyleCore.TableElement)tableElement;
        if (this.ignore || !tableElement2.isVisible()) {
            return;
        }
        this.newline();
        this.writer.println("{\\par}");
        TableLens tableLens = tableElement2.getTable();
        Font font = tableElement2.getFont();
        int n4 = (int)(tableElement2.getIndent() * 1440.0);
        int n5 = tableElement2.getLayout();
        int[] nArray = new int[tableLens.getColCount()];
        int[] nArray2 = tableElement2.getFixedWidths();
        if (nArray2 != null) {
            int n6 = 0;
            while (n6 < nArray2.length) {
                nArray[n6] = nArray2[n6] * 20;
                ++n6;
            }
        } else if (n5 == 2) {
            int n7 = this.pagewidth / nArray.length;
            int n8 = 0;
            while (n8 < nArray.length) {
                nArray[n8] = n7;
                ++n8;
            }
        } else {
            int n9;
            float f = this.pagewidth * 2 / (nArray.length * 20);
            float[] fArray = tableElement2.calcColWidth(f);
            n3 = 0;
            n2 = 0;
            int n10 = 0;
            while (n10 < fArray.length) {
                if (fArray[n10] != 0.0f) {
                    nArray[n10] = (int)(fArray[n10] * 20.0f);
                    n3 += nArray[n10];
                } else {
                    ++n2;
                }
                ++n10;
            }
            if (n2 > 0) {
                n9 = (this.pagewidth - n3) / n2;
                n = 0;
                while (n < fArray.length) {
                    if (fArray[n] == 0.0f) {
                        nArray[n] = n9;
                    }
                    ++n;
                }
            }
            if (n5 == 1) {
                n3 = 0;
                n9 = 0;
                while (n9 < nArray.length) {
                    n3 += nArray[n9];
                    ++n9;
                }
                n = 0;
                while (n < nArray.length) {
                    nArray[n] = nArray[n] * this.pagewidth / Math.max(n3, 1);
                    ++n;
                }
            }
        }
        Hashtable<Point, Rectangle> hashtable = new Hashtable<Point, Rectangle>();
        int n11 = 0;
        while (n11 < tableLens.getRowCount()) {
            this.writer.print("\\trowd\\trgaph108\\trleft" + n4);
            if (n11 < tableLens.getHeaderRowCount()) {
                this.writer.print("\\trhdr");
            }
            n3 = 0;
            while (n3 < tableLens.getColCount()) {
                block48: {
                    Serializable serializable;
                    int n12;
                    Color color;
                    int n13;
                    int n14;
                    int n15;
                    Dimension dimension;
                    block47: {
                        block46: {
                            n2 = 1;
                            this.writer.print("\\pard");
                            dimension = tableLens.getSpan(n11, n3);
                            if (dimension == null || dimension.height <= 1 && dimension.width <= 1) break block46;
                            if (dimension.height > 1) {
                                this.writer.print("\\clvmgf");
                            }
                            int n16 = 0;
                            while (n16 < dimension.height) {
                                n = 0;
                                while (n < dimension.width) {
                                    hashtable.put(new Point(n3 + n, n11 + n16), new Rectangle(-n, -n16, dimension.width - n, dimension.height - n16));
                                    ++n;
                                }
                                ++n16;
                            }
                            n2 = dimension.width;
                            break block47;
                        }
                        if (hashtable.get(new Point(n3, n11)) == null) break block47;
                        Rectangle rectangle = (Rectangle)hashtable.get(new Point(n3, n11));
                        if (rectangle.y == 0 || rectangle.width > 1) break block48;
                        if (rectangle.y < 0) {
                            this.writer.print("\\clvmrg");
                        }
                    }
                    if (n11 == 0 && (n15 = tableLens.getRowBorder(n11 - 1, n3)) != 0) {
                        Color color2 = tableLens.getRowBorderColor(n11 - 1, n3);
                        this.writer.print("\\clbrdrt" + this.getBorder(n15) + "\\brdrcf" + this.colormap.get(color2));
                    }
                    if (n3 == 0 && (n14 = tableLens.getColBorder(n11, n3 - 1)) != 0) {
                        Color color3 = tableLens.getColBorderColor(n11, n3 - 1);
                        this.writer.print("\\clbrdrl" + this.getBorder(n14) + "\\brdrcf" + this.colormap.get(color3));
                    }
                    if ((n13 = tableLens.getRowBorder(n11 + (dimension == null ? 0 : dimension.height - 1), n3)) != 0) {
                        Color color4 = tableLens.getRowBorderColor(n11, n3);
                        this.writer.print("\\clbrdrb" + this.getBorder(n13) + "\\brdrcf" + this.colormap.get(color4));
                    }
                    if ((n = tableLens.getColBorder(n11, n3 + (dimension == null ? 0 : dimension.width - 1))) != 0) {
                        color = tableLens.getColBorderColor(n11, n3);
                        this.writer.print("\\clbrdrr" + this.getBorder(n) + "\\brdrcf" + this.colormap.get(color));
                    }
                    if ((color = tableLens.getBackground(n11, n3)) != null && color != Color.white) {
                        this.writer.print("\\clcbpat" + this.colormap.get(color));
                    }
                    if (((n12 = tableLens.getAlignment(n11, n3)) & 8) != 0) {
                        this.writer.print("\\clvertalt ");
                    } else if ((n12 & 0x10) != 0) {
                        this.writer.print("\\clvertalc ");
                    } else if ((n12 & 0x20) != 0) {
                        this.writer.print("\\clvertalb ");
                    }
                    this.writeAlignment(n12);
                    int n17 = 0;
                    int n18 = 0;
                    while (n18 < n3 + n2) {
                        n17 += nArray[n18];
                        ++n18;
                    }
                    this.writer.print("\\intbl\\cellx" + n17);
                    this.writer.print("{");
                    Object object = tableLens.getObject(n11, n3);
                    Color color5 = tableLens.getForeground(n11, n3);
                    if (object != null && (serializable = tableElement2.getFormat(object.getClass())) != null) {
                        object = serializable.format(object);
                    }
                    if (object instanceof Component) {
                        this.writePainter(new ComponentPainter((Component)object), null, color5, color);
                    } else if (object instanceof Image) {
                        this.writePainter(new ImagePainter((Image)object), null, color5, color);
                    } else if (object instanceof Painter) {
                        this.writePainter((Painter)object, null, color5, color);
                    } else if (object != null) {
                        serializable = tableLens.getFont(n11, n3);
                        this.writeParagraph(object, (Font)(serializable == null ? font : serializable), color5);
                    }
                    this.writer.print("\\cell}");
                }
                ++n3;
            }
            this.writer.println("{\\row}");
            ++n11;
        }
        this.newline();
        this.writer.print("\\pard{\\par}");
    }

    public void write(TextBoxElement textBoxElement) {
        Point point;
        StyleCore.TextBoxElement textBoxElement2 = (StyleCore.TextBoxElement)textBoxElement;
        if (this.ignore || !textBoxElement2.isVisible()) {
            return;
        }
        Point point2 = point = textBoxElement2.getAnchor() == null ? new Point((int)(this.currX * 20.0), 0) : new Point((int)(textBoxElement2.getAnchor().x * 1440.0f), (int)(textBoxElement2.getAnchor().y * 1440.0f));
        if (point.x < 0) {
            point.x += this.pagewidth;
        }
        Size size = textBoxElement2.getPreferredSize();
        Dimension dimension = new Dimension((int)(size.width * 20.0f), (int)(size.height * 20.0f));
        this.writer.print("{\\shp{\\*\\shpinst");
        this.writer.print("\\shpleft" + point.x + "\\shptop" + point.y + "\\shpright" + (point.x + dimension.width) + "\\shpbottom" + (point.y + dimension.height) + "\\shpbxcolumn\\shpbypara");
        switch (textBoxElement2.getWrapping()) {
            case 0: {
                this.writer.print("\\shpwr3");
                break;
            }
            case 1: {
                this.writer.print("\\shpwr2\\shpwrk1");
                break;
            }
            case 2: {
                this.writer.print("\\shpwr2\\shpwrk2");
                break;
            }
            case 3: {
                this.writer.print("\\shpwr2\\shpwrk0");
                break;
            }
            case 256: {
                this.writer.print("\\shpwr1");
                break;
            }
        }
        this.writer.print("{\\sp{\\sn shapeType}{\\sv 202}}");
        this.writer.print("{\\sp{\\sn lineType}{\\sv 0}}");
        Insets insets = textBoxElement2.getPadding();
        if (insets != null) {
            this.writer.print("{\\sp{\\sn dyTextTop}{\\sv " + insets.top * 12700 + "}}");
            this.writer.print("{\\sp{\\sn dxTextLeft}{\\sv " + insets.left * 12700 + "}}");
            this.writer.print("{\\sp{\\sn dyTextBottom}{\\sv " + insets.bottom * 12700 + "}}");
            this.writer.print("{\\sp{\\sn dxTextRight}{\\sv " + insets.right * 12700 + "}}");
        }
        this.writeWrapSpace(textBoxElement2.getMargin());
        this.writer.print(this.getLineProperty(textBoxElement2.getBorder()));
        this.writer.print("{\\shptxt\\pard");
        this.writeAlignment(textBoxElement2.getTextAlignment());
        this.writer.print("{");
        this.writeParagraph(String.valueOf(textBoxElement2.getText()) + "\n", textBoxElement2.getFont(), textBoxElement2.getForeground());
        this.writer.print("}}}}");
        this.floatH = Math.max(this.floatH, (double)(size.height + (float)(point.y / 20)));
        if (textBoxElement2.isLastOnLine()) {
            this.newline();
            this.writer.print("\\pard{\\par}");
        } else {
            this.currX += (double)size.width;
        }
    }

    public void write(TextElement textElement) {
        StyleCore.TextElement textElement2 = (StyleCore.TextElement)textElement;
        if (this.ignore || !textElement2.isVisible()) {
            return;
        }
        if (textElement2.isJustify()) {
            this.writer.print("\\qj ");
        }
        this.writeAlignment(textElement2.getAlignment());
        if (textElement2.getIndent() > 0.0) {
            this.writer.print("\\li" + (int)(textElement2.getIndent() * 1440.0) + " ");
        }
        if (textElement2.getSpacing() > 0) {
            this.writer.print("\\sa" + textElement2.getSpacing() * 20 + " ");
        }
        this.writer.print("{");
        if (textElement2.isNewline()) {
            this.writer.print("\\par ");
        }
        String string = textElement2.getText();
        if (this.inHeader) {
            int n;
            int n2;
            int n3;
            String string2 = "{\\field{\\*\\fldinst {\\cs17  PAGE }}{\\fldrslt {\\cs17\\lang1024 1}}}";
            String string3 = "{\\field{\\*\\fldinst {\\cs17  NUMPAGES }}{\\fldrslt {\\cs17\\lang1024 1}}}";
            String string4 = "{\\field{\\*\\fldinst {\\cs17  DATE \\\\@ \"";
            String string5 = "MM/dd/yy";
            String string6 = "\" }}{\\fldrslt {\\cs17\\lang1024 04/15/99}}}";
            String string7 = "{\\field{\\*\\fldinst {\\cs17  TIME \\\\@ \"";
            String string8 = "h:mm AM/PM";
            String string9 = "\"}}{\\fldrslt {\\cs17\\lang1024 12:08 PM}}}";
            int n4 = 0;
            while ((n4 = string.indexOf("{P", n4)) >= 0) {
                n3 = string.indexOf("}", n4);
                string = String.valueOf(string.substring(0, n4)) + string2 + string.substring(n3 + 1);
                n4 += string2.length();
            }
            n3 = 0;
            while ((n3 = string.indexOf("{N", n3)) >= 0) {
                n2 = string.indexOf("}", n3);
                string = String.valueOf(string.substring(0, n3)) + string3 + string.substring(n2 + 1);
                n3 += string3.length();
            }
            n2 = 0;
            while ((n2 = string.indexOf("{D", n2)) >= 0) {
                String string10 = string5;
                int n5 = string.indexOf(",", n2);
                n = string.indexOf("}", n2);
                if (n5 >= 0) {
                    string10 = string.substring(n5 + 1, n);
                }
                string = String.valueOf(string.substring(0, n2)) + string4 + string10 + string6 + string.substring(n + 1);
                n2 = n2 + string4.length() + string10.length() + string6.length();
            }
            int n6 = 0;
            while ((n6 = string.indexOf("{T", n6)) >= 0) {
                String string11 = string8;
                n = string.indexOf(",", n6);
                int n7 = string.indexOf("}", n6);
                if (n >= 0) {
                    string11 = string.substring(n + 1, n7);
                }
                string = String.valueOf(string.substring(0, n6)) + string7 + string11 + string9 + string.substring(n7 + 1);
                n6 = n6 + string7.length() + string11.length() + string9.length();
            }
        }
        this.writeParagraph(string, textElement2.getFont(), textElement2.getForeground());
        if (textElement2.isLastOnLine()) {
            this.writer.print("\\par");
        }
        this.writer.println("}");
        if (textElement2.isLastOnLine()) {
            this.newline();
            this.writer.print("\\pard{\\par}");
        } else {
            this.currX += (double)textElement2.getPreferredSize().width;
        }
    }

    public void write(XTableStyle xTableStyle) {
    }

    protected void write(OutputStream outputStream, int n, int n2) {
        int n3 = 255;
        int n4 = 0;
        while (n4 < n2) {
            try {
                outputStream.write((n & n3) >> n4 * 8);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            n3 <<= 8;
            ++n4;
        }
    }

    protected void writeAlignment(int n) {
        if ((n & 1) != 0) {
            this.writer.print("\\ql ");
        } else if ((n & 2) != 0) {
            this.writer.print("\\qc ");
        } else if ((n & 4) != 0) {
            this.writer.print("\\qr ");
        }
    }

    protected void writeColorTable(Color color) {
        if (color != null && this.colormap.get(color) == null) {
            this.colormap.put(color, new Integer(this.colormap.size() + 1));
            this.writer.print("\\red" + color.getRed() + "\\green" + color.getGreen() + "\\blue" + color.getBlue() + ";");
        }
    }

    protected void writePainter(Painter painter, Size size, Color color, Color color2) {
        int n;
        Dimension dimension = painter.getPreferredSize();
        Dimension dimension2 = null;
        if (painter instanceof ScaledPainter) {
            dimension2 = new Dimension((int)(((ScaledPainter)painter).getSize().width * 1440.0f), (int)(((ScaledPainter)painter).getSize().width * 1440.0f));
        }
        if (dimension.width < 0) {
            dimension.width = (int)((double)(-dimension.width) * 468.0 / 1000.0);
        }
        if (dimension.height < 0) {
            dimension.height = (int)((double)(-dimension.height) * 468.0 / 1000.0);
        }
        Image image = Common.createImage(dimension.width, dimension.height);
        Graphics graphics = image.getGraphics();
        graphics.setColor(color2);
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        graphics.setColor(color);
        painter.paint(graphics, 0, 0, dimension.width, dimension.height);
        graphics.dispose();
        this.writer.println("{\\pict\\dibitmap0\\wbmbitspixel24\\wbmplanes1\\wbmwidthbytes" + (int)Math.ceil((double)(dimension.width * 3) / 2.0) * 2);
        this.writer.print("\\picw" + dimension.width + "\\pich" + dimension.height);
        if (size != null && size.width > 0.0f && size.height > 0.0f) {
            this.writer.print("\\picscalex" + (int)(size.width * 100.0f / (float)dimension.width) + "\\picscaley" + (int)(size.height * 100.0f / (float)dimension.height));
        }
        if (dimension2 != null) {
            this.writer.print("\\picwgoal" + dimension2.width + "\\pichgoal" + dimension2.height);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.write(byteArrayOutputStream, 40, 4);
        this.write(byteArrayOutputStream, dimension.width, 4);
        this.write(byteArrayOutputStream, dimension.height, 4);
        this.write(byteArrayOutputStream, 1, 2);
        this.write(byteArrayOutputStream, 24, 2);
        this.write(byteArrayOutputStream, 0, 4);
        this.write(byteArrayOutputStream, dimension.width * dimension.height * 3, 4);
        this.write(byteArrayOutputStream, 0, 4);
        this.write(byteArrayOutputStream, 0, 4);
        this.write(byteArrayOutputStream, 0, 4);
        this.write(byteArrayOutputStream, 0, 4);
        try {
            byteArrayOutputStream.write(Util.getImageBytesRGB(new PixelConsumer(image), Color.white));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < byArray.length) {
            int n3 = 240;
            n = 0;
            while (n < 2) {
                int n4 = (byArray[n2] & n3) >> (1 - n) * 4;
                stringBuffer.append((char)(n4 < 10 ? 48 + n4 : 97 + n4 - 10));
                n3 >>= 4;
                ++n;
            }
            ++n2;
        }
        String string = stringBuffer.toString();
        n = 0;
        while (n < string.length()) {
            try {
                this.writer.println("");
                String string2 = string.substring(n, n + Math.min(string.length() - n, 80));
                this.writer.print(string2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            n += 80;
        }
        this.writer.println("}");
    }

    protected void writeParagraph(Object object, Font font, Color color) {
        String string = "";
        if (font != null) {
            this.writer.print("\\f" + this.fontmap.get(font) + "\\fs" + font.getSize() * 2);
            if ((font.getStyle() & 1) != 0) {
                this.writer.print("\\b");
            }
            if ((font.getStyle() & 2) != 0) {
                this.writer.print("\\i");
            }
            if ((font.getStyle() & 0x10) != 0) {
                switch (((StyleFont)font).getLineStyle()) {
                    case 8195: {
                        this.writer.print("\\uldb");
                        break;
                    }
                    case 4113: {
                        this.writer.print("\\uld");
                        break;
                    }
                    case 4098: 
                    case 4099: {
                        this.writer.print("\\ulth");
                        break;
                    }
                    case 4145: 
                    case 4193: 
                    case 4241: {
                        this.writer.print("\\uldash");
                        break;
                    }
                    default: {
                        this.writer.print("\\ul");
                        break;
                    }
                }
            }
            if ((font.getStyle() & 0x20) != 0) {
                switch (((StyleFont)font).getLineStyle()) {
                    case 8195: {
                        this.writer.print("\\striked1");
                        break;
                    }
                    default: {
                        this.writer.print("\\strike");
                        break;
                    }
                }
            }
            if ((font.getStyle() & 0x40) != 0) {
                this.writer.print("\\super");
            }
            if ((font.getStyle() & 0x80) != 0) {
                this.writer.print("\\sub");
            }
            if ((font.getStyle() & 0x100) != 0) {
                this.writer.print("\\shad");
            }
            if ((font.getStyle() & 0x200) != 0) {
                this.writer.print("\\scaps");
            }
            if ((font.getStyle() & 0x400) != 0) {
                this.writer.print("\\caps");
            }
            string = " ";
        }
        if (color != null && color != Color.black) {
            this.writer.print("\\cf" + this.colormap.get(color));
            string = " ";
        }
        this.writer.print(string);
        String string2 = object.toString();
        int n = 0;
        while ((n = string2.indexOf(10)) >= 0) {
            this.writer.print(string2.substring(0, n));
            this.writer.print("\\par ");
            string2 = string2.substring(n + 1);
        }
        this.writer.print(string2);
    }

    protected void writeWrapSpace(Insets insets) {
        if (insets == null) {
            return;
        }
        this.writer.print("{\\sp{\\sn dyWrapDistTop}{\\sv " + insets.top * 12700 + "}}");
        this.writer.print("{\\sp{\\sn dxWrapDistLeft}{\\sv " + insets.left * 12700 + "}}");
        this.writer.print("{\\sp{\\sn dyWrapDistBottom}{\\sv " + insets.bottom * 12700 + "}}");
        this.writer.print("{\\sp{\\sn dxWrapDistRight}{\\sv " + insets.right * 12700 + "}}");
    }
}

