/*
 * Decompiled with CFR 0.152.
 */
package inetsoft.report.io;

import inetsoft.report.AreaBreakElement;
import inetsoft.report.ChartElement;
import inetsoft.report.Common;
import inetsoft.report.CompositeElement;
import inetsoft.report.CompositeLens;
import inetsoft.report.CondPageBreakElement;
import inetsoft.report.Context;
import inetsoft.report.FormElement;
import inetsoft.report.FormLens;
import inetsoft.report.HeadingElement;
import inetsoft.report.NewlineElement;
import inetsoft.report.PageBreakElement;
import inetsoft.report.PageLayoutElement;
import inetsoft.report.Painter;
import inetsoft.report.PainterElement;
import inetsoft.report.ReportElement;
import inetsoft.report.SeparatorElement;
import inetsoft.report.Size;
import inetsoft.report.SpaceElement;
import inetsoft.report.StyleSheet;
import inetsoft.report.TOCElement;
import inetsoft.report.TabElement;
import inetsoft.report.TableElement;
import inetsoft.report.TableLens;
import inetsoft.report.TextBoxElement;
import inetsoft.report.TextElement;
import inetsoft.report.internal.StyleCore;
import inetsoft.report.io.Builder;
import inetsoft.report.io.Formatter;
import inetsoft.report.painter.ComponentPainter;
import inetsoft.report.painter.ImagePainter;
import inetsoft.report.style.XTableStyle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.Format;
import java.util.Hashtable;
import java.util.Vector;

public class HTMLFormatter
implements Formatter {
    protected String dir;
    protected PrintWriter writer;
    protected OutputStream output;
    protected Vector leftV = new Vector();
    protected Vector centerV = new Vector();
    protected Vector rightV = new Vector();
    protected int currAlign = 1;
    protected boolean inHeader = false;
    protected String prefix = "image";
    protected StyleSheet sheet = null;
    private static final int PAGEWIDTH = 468;
    private static Hashtable fontnames = new Hashtable();

    public HTMLFormatter(OutputStream outputStream, String string) {
        fontnames.put("dialog", "Helvetica");
        fontnames.put("dialoginput", "Courier");
        fontnames.put("serif", "Times");
        fontnames.put("sansserif", "Helvetica");
        fontnames.put("monospaced", "Courier");
        fontnames.put("timesroman", "Times");
        fontnames.put("courier", "Courier");
        fontnames.put("helvetica", "Helvetica");
        this.output = outputStream;
        this.writer = new PrintWriter(this.output);
        this.dir = string;
    }

    protected void addElement(ReportElement reportElement) {
        int n = reportElement.getAlignment() & 7;
        if (n < this.currAlign) {
            this.flushElements();
            this.addElement(reportElement);
            return;
        }
        this.currAlign = n;
        switch (n) {
            case 1: {
                this.leftV.addElement(reportElement);
                break;
            }
            case 2: {
                this.centerV.addElement(reportElement);
                break;
            }
            case 4: {
                this.rightV.addElement(reportElement);
                break;
            }
        }
    }

    public void end() {
        this.flushElements();
        this.writer.println("</BODY>");
        this.writer.println("</HTML>");
        this.writer.flush();
    }

    public void endHeader() {
        this.inHeader = false;
    }

    protected void flushElements() {
        if (this.centerV.size() == 0 && this.rightV.size() == 0) {
            this.writeParagraph(this.leftV, 1);
        } else {
            this.writer.println("<TABLE BORDER=0 WIDTH=\"100%\"><TR>");
            this.writer.println("<TD>");
            this.writeParagraph(this.leftV, 1);
            this.writer.println("</TD>");
            this.writer.println("<TD>");
            this.writeParagraph(this.centerV, 2);
            this.writer.println("</TD>");
            this.writer.println("<TD>");
            this.writeParagraph(this.rightV, 4);
            this.writer.println("</TD>");
            this.writer.println("</TR></TABLE>");
        }
        this.leftV.removeAllElements();
        this.centerV.removeAllElements();
        this.rightV.removeAllElements();
        this.currAlign = 1;
    }

    protected String getFontName(Font font) {
        String string = font.getName();
        Object v = fontnames.get(string.toLowerCase());
        return v == null ? string : v.toString();
    }

    public void prolog(StyleSheet styleSheet) {
        this.sheet = styleSheet;
        this.writer.println("<HTML>");
        this.writer.println("<HEAD>");
        this.writer.println("<META HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html\">");
        this.writer.println("<META NAME=\"Generator\" CONTENT=\"StyleReport\">");
        this.writer.println("<TITLE>Report</TITLE>");
        this.writer.println("</HEAD>");
        this.writer.println("<BODY>");
    }

    public void setJPEGPrefix(String string) {
        this.prefix = string;
    }

    public void startHeader(int n) {
        this.inHeader = true;
    }

    public void startHeader(String string, boolean bl) {
        this.inHeader = true;
    }

    protected String toString(Color color) {
        String string = "000000" + Integer.toString(color.getRGB() & 0xFFFFFF, 16);
        return string.substring(string.length() - 6);
    }

    public void write(AreaBreakElement areaBreakElement) {
        this.flushElements();
    }

    public void write(ChartElement chartElement) {
        this.write((PainterElement)chartElement);
    }

    public void write(CompositeElement compositeElement) {
        Object object;
        Context context = new Context(this.sheet);
        CompositeLens compositeLens = compositeElement.getComposite();
        compositeLens.reset();
        while ((object = compositeLens.nextElement(context)) != null) {
            ReportElement reportElement = this.sheet.getCompositeElement(compositeElement.getID(), object, context);
            if (reportElement != null) {
                reportElement.setContext(context);
                Builder.write(this, reportElement);
            }
            context = new Context(this.sheet);
        }
    }

    public void write(CondPageBreakElement condPageBreakElement) {
        this.flushElements();
    }

    public void write(FormElement formElement) {
        StyleCore.FormElement formElement2 = (StyleCore.FormElement)formElement;
        if (this.inHeader || !formElement2.isVisible()) {
            return;
        }
        this.flushElements();
        FormLens formLens = formElement2.getForm();
        int n = formLens.getFieldPerRow();
        this.writer.println("<TABLE BORDER=0 COLS=" + n * 2 + " WIDTH=\"100%\">");
        int n2 = 0;
        while (n2 < formLens.getFieldCount()) {
            if (n2 % n == 0) {
                if (n2 > 0) {
                    this.writer.println("</TR>");
                }
                this.writer.println("<TR>");
            }
            this.writer.println("<TD>");
            this.writeAlignment(4);
            this.writeText(formLens.getLabel(n2), formLens.getLabelFont(n2), formLens.getLabelForeground(n2), formLens.getLabelBackground(n2));
            this.writer.println("</TD>");
            this.writer.println("<TD><U>");
            this.writeAlignment(1);
            this.writeText(formLens.getField(n2), formLens.getFont(n2), formLens.getForeground(n2), formLens.getBackground(n2));
            this.writer.println("</U></TD>");
            ++n2;
        }
        this.writer.println("</TABLE>");
    }

    public void write(HeadingElement headingElement) {
        this.write((TextElement)headingElement);
    }

    public void write(NewlineElement newlineElement) {
        if (this.inHeader || !newlineElement.isVisible()) {
            return;
        }
        this.flushElements();
        int n = 1;
        while (n < newlineElement.getCount()) {
            this.writer.println("<P>");
            ++n;
        }
    }

    public void write(PageBreakElement pageBreakElement) {
        this.flushElements();
    }

    public void write(PageLayoutElement pageLayoutElement) {
        this.flushElements();
    }

    public void write(PainterElement painterElement) {
        StyleCore.PainterElement painterElement2 = (StyleCore.PainterElement)painterElement;
        if (this.inHeader || !painterElement2.isVisible()) {
            return;
        }
        if (painterElement2.isNewline()) {
            this.flushElements();
        }
        this.addElement(painterElement2);
        if (painterElement2.isLastOnLine()) {
            this.flushElements();
        }
    }

    public void write(SeparatorElement separatorElement) {
        if (this.inHeader || !separatorElement.isVisible()) {
            return;
        }
        this.flushElements();
        this.writer.println("<HR>");
    }

    public void write(SpaceElement spaceElement) {
        if (this.inHeader || !spaceElement.isVisible()) {
            return;
        }
        this.addElement(spaceElement);
    }

    public void write(TOCElement tOCElement) {
    }

    public void write(TabElement tabElement) {
        if (this.inHeader || !tabElement.isVisible()) {
            return;
        }
        this.addElement(tabElement);
    }

    public void write(TableElement tableElement) {
        int n;
        StyleCore.TableElement tableElement2 = (StyleCore.TableElement)tableElement;
        if (this.inHeader || !tableElement2.isVisible()) {
            return;
        }
        this.flushElements();
        TableLens tableLens = tableElement2.getTable();
        Hashtable<Point, String> hashtable = new Hashtable<Point, String>();
        int n2 = 0;
        int n3 = 0;
        while (n3 < tableLens.getRowCount()) {
            n = 0;
            while (n < tableLens.getColCount()) {
                if (tableLens.getRowBorder(n3, n) != 0 || tableLens.getColBorder(n3, n) != 0) {
                    n2 = 1;
                    break;
                }
                ++n;
            }
            ++n3;
        }
        this.writer.print("<TABLE BORDER=" + n2 + " CELLSPACING=0 CELLPADDING=0");
        if (tableElement2.getLayout() != 0) {
            this.writer.print(" WIDTH=\"100%\"");
        }
        this.writer.println(">");
        n = 0;
        while (n < tableLens.getRowCount()) {
            this.writer.println("<TR>");
            String string = "TD";
            if (n < tableLens.getHeaderRowCount()) {
                string = "TH";
            }
            int n4 = 0;
            while (n4 < tableLens.getColCount()) {
                block29: {
                    Format format;
                    int n5;
                    block28: {
                        block27: {
                            Dimension dimension = tableLens.getSpan(n, n4);
                            if (dimension == null || dimension.height <= 1) break block27;
                            int n6 = 0;
                            while (n6 < dimension.height) {
                                n5 = 0;
                                while (n5 < dimension.width) {
                                    hashtable.put(new Point(n4 + n5, n + n6), "span");
                                    ++n5;
                                }
                                ++n6;
                            }
                            this.writer.print("<" + string);
                            this.writer.print(" ROWSPAN=" + dimension.height + " COLSPAN=" + dimension.width);
                            break block28;
                        }
                        if (hashtable.get(new Point(n4, n)) != null) break block29;
                        this.writer.print("<" + string);
                    }
                    Color color = tableLens.getBackground(n, n4);
                    if (color != null && color != Color.white) {
                        this.writer.print(" BGCOLOR=\"#" + this.toString(color) + "\"");
                    }
                    if (((n5 = tableLens.getAlignment(n, n4)) & 8) != 0) {
                        this.writer.print(" VALIGN=TOP");
                    } else if ((n5 & 0x10) != 0) {
                        this.writer.print(" VALIGN=MIDDLE");
                    } else if ((n5 & 0x20) != 0) {
                        this.writer.print(" VALIGN=BOTTOM");
                    }
                    this.writer.print(">");
                    this.writeAlignment(n5);
                    Object object = tableLens.getObject(n, n4);
                    Color color2 = tableLens.getForeground(n, n4);
                    if (object != null && (format = tableElement2.getFormat(object.getClass())) != null) {
                        object = format.format(object);
                    }
                    if (object instanceof Component) {
                        this.writePainter(new ComponentPainter((Component)object), color2, color, n5, null, null);
                    } else if (object instanceof Image) {
                        this.writePainter(new ImagePainter((Image)object), color2, color, n5, null, null);
                    } else if (object instanceof Painter) {
                        this.writePainter((Painter)object, color2, color, n5, null, null);
                    } else if (object != null) {
                        this.writeText(object, tableLens.getFont(n, n4), color2, null);
                    }
                    this.writer.println("</" + string + ">");
                }
                ++n4;
            }
            this.writer.println("</TR>");
            ++n;
        }
        this.writer.println("</TABLE>");
    }

    public void write(TextBoxElement textBoxElement) {
        this.write((PainterElement)textBoxElement);
    }

    public void write(TextElement textElement) {
        StyleCore.TextElement textElement2 = (StyleCore.TextElement)textElement;
        if (this.inHeader || !textElement2.isVisible()) {
            return;
        }
        this.addElement(textElement2);
        if (textElement2.isLastOnLine()) {
            this.flushElements();
        }
    }

    public void write(XTableStyle xTableStyle) {
    }

    protected void writeAlignment(int n) {
        if ((n & 1) != 0) {
            this.writer.print("<P ALIGN=LEFT>");
        } else if ((n & 2) != 0) {
            this.writer.print("<P ALIGN=CENTER>");
        } else if ((n & 4) != 0) {
            this.writer.print("<P ALIGN=RIGHT>");
        }
    }

    protected String writeImage(Painter painter, Dimension dimension, Color color, Color color2) {
        if (dimension.width < 0) {
            dimension.width = -dimension.width * 468 / 1000;
        }
        if (dimension.height < 0) {
            dimension.height = -dimension.height * 468 / 1000;
        }
        Image image = Common.createImage(dimension.width, dimension.height);
        Graphics graphics = image.getGraphics();
        graphics.setColor(color);
        painter.paint(graphics, 0, 0, dimension.width, dimension.height);
        graphics.dispose();
        String string = null;
        File file = null;
        int n = 1;
        while ((file = new File(this.dir, string = String.valueOf(this.prefix) + n + ".jpg")).exists()) {
            ++n;
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            Common.writeJPEG(image, fileOutputStream);
            fileOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    protected void writePainter(Painter painter, Color color, Color color2, int n, Insets insets, Dimension dimension) {
        Dimension dimension2 = painter.getPreferredSize();
        if (dimension == null || dimension.width == 0 || dimension.height == 0) {
            dimension = dimension2;
        }
        String string = this.writeImage(painter, dimension2, color, color2);
        this.writer.print("<IMG SRC=\"" + string + "\"");
        if (dimension != null) {
            this.writer.print(" WIDTH=" + dimension.width + " HEIGHT=" + dimension.height);
        }
        if ((n & 8) != 0) {
            this.writer.print(" ALIGN=TOP");
        } else if ((n & 0x10) != 0) {
            this.writer.print(" ALIGN=MIDDLE");
        } else if ((n & 0x20) != 0) {
            this.writer.print(" ALIGN=BOTTOM");
        }
        if (insets != null) {
            this.writer.print(" HSPACE=" + Math.max(insets.left, insets.right) + " VSPACE=" + Math.max(insets.top, insets.bottom));
        }
        this.writer.println(">");
    }

    private void writePainter(PainterElement painterElement) {
        StyleCore.PainterElement painterElement2 = (StyleCore.PainterElement)painterElement;
        Painter painter = painterElement2.getPainter();
        Size size = painterElement2.getPreferredSize();
        Dimension dimension = new Dimension((int)size.width, (int)size.height);
        this.writePainter(painter, painterElement2.getForeground(), painterElement2.getBackground(), painterElement2.getAlignment(), painterElement2.getMargin(), dimension);
    }

    protected void writeParagraph(Vector vector, int n) {
        int n2 = 0;
        this.writeAlignment(n);
        int n3 = 0;
        while (n3 < vector.size()) {
            ReportElement reportElement = (ReportElement)vector.elementAt(n3);
            if (reportElement instanceof TextElement) {
                TextElement textElement = (TextElement)reportElement;
                this.writeText(textElement.getText(), textElement.getFont(), textElement.getForeground(), textElement.getBackground());
                n2 += (int)Common.stringWidth(textElement.getText(), textElement.getFont());
            } else if (reportElement instanceof PainterElement) {
                this.writePainter((PainterElement)reportElement);
                n2 += (int)((StyleCore.PainterElement)reportElement).getPreferredSize().width;
            } else if (reportElement instanceof TabElement) {
                double[] dArray = ((TabElement)reportElement).getTabStops();
                int n4 = 0;
                int n5 = 0;
                while (n5 < dArray.length) {
                    n4 = (int)(dArray[n5] * 72.0);
                    if (n2 < n4) break;
                    ++n5;
                }
                this.writeSpace(n4 - n2);
            } else if (reportElement instanceof SpaceElement) {
                int n6 = ((SpaceElement)reportElement).getSpace();
                this.writeSpace(n6);
                n2 += n6;
            }
            ++n3;
        }
    }

    private void writeSpace(int n) {
        this.writer.println("<SPACER TYPE=HORIZONTAL SIZE=" + n + ">");
    }

    protected void writeText(Object object, Font font, Color color, Color color2) {
        if (object == null) {
            return;
        }
        String string = "";
        String string2 = object.toString();
        if (font != null || color != null) {
            this.writer.print("<FONT ");
            if (color != null) {
                this.writer.print("COLOR=\"#" + this.toString(color) + "\" ");
            }
            if (font != null) {
                this.writer.print("FACE=\"" + this.getFontName(font) + "\">");
                string = "</FONT>" + string;
                this.writer.print("<SPAN STYLE=\"Font-Size: " + font.getSize() + "pt\"");
                if (color2 != null) {
                    this.writer.print("; Background-Color: \"#" + this.toString(color2) + "\"");
                }
                this.writer.print(">");
                string = "</SPAN>" + string;
                if ((font.getStyle() & 1) != 0) {
                    this.writer.print("<B>");
                    string = "</B>" + string;
                }
                if ((font.getStyle() & 2) != 0) {
                    this.writer.print("<I>");
                    string = "</I>" + string;
                }
                if ((font.getStyle() & 0x10) != 0) {
                    this.writer.print("<U>");
                    string = "</U>" + string;
                }
                if ((font.getStyle() & 0x20) != 0) {
                    this.writer.print("<STRIKE>");
                    string = "</STRIKE>" + string;
                }
                if ((font.getStyle() & 0x40) != 0) {
                    this.writer.print("<SUP>");
                    string = "</SUP>" + string;
                }
                if ((font.getStyle() & 0x80) != 0) {
                    this.writer.print("<SUB>");
                    string = "</SUB>" + string;
                }
                if ((font.getStyle() & 0x200) != 0 || (font.getStyle() & 0x400) != 0) {
                    string2 = string2.toUpperCase();
                }
            } else {
                this.writer.print(">");
            }
        }
        this.writer.println(String.valueOf(string2.length() == 0 ? "&nbsp;" : string2) + string);
    }
}

