/*
 * Decompiled with CFR 0.152.
 */
package inetsoft.report.io;

import inetsoft.report.AreaBreakElement;
import inetsoft.report.ChartElement;
import inetsoft.report.CompositeElement;
import inetsoft.report.CondPageBreakElement;
import inetsoft.report.FormElement;
import inetsoft.report.HeadingElement;
import inetsoft.report.NewlineElement;
import inetsoft.report.PageBreakElement;
import inetsoft.report.PageLayoutElement;
import inetsoft.report.PainterElement;
import inetsoft.report.ReportElement;
import inetsoft.report.SeparatorElement;
import inetsoft.report.SpaceElement;
import inetsoft.report.StyleSheet;
import inetsoft.report.TOCElement;
import inetsoft.report.TabElement;
import inetsoft.report.TableElement;
import inetsoft.report.TextBoxElement;
import inetsoft.report.TextElement;
import inetsoft.report.internal.Util;
import inetsoft.report.io.DelimitedFormatter;
import inetsoft.report.io.Formatter;
import inetsoft.report.io.HTMLFormatter;
import inetsoft.report.io.Parser;
import inetsoft.report.io.RTFFormatter;
import inetsoft.report.io.ReportFormatter;
import inetsoft.report.io.ReportParser;
import inetsoft.report.io.TemplateFormatter;
import inetsoft.report.io.TemplateParser;
import inetsoft.report.style.XTableStyle;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Builder {
    public static final int TEMPLATE = 1;
    public static final int REPORT = 2;
    public static final int CSV = 3;
    public static final int RTF = 4;
    public static final int HTML = 5;
    Formatter format;
    Parser parser;
    Vector styles = new Vector();

    public Builder(Formatter formatter) {
        this.format = formatter;
    }

    public Builder(Parser parser) {
        this.parser = parser;
    }

    public static Builder getBuilder(int n, InputStream inputStream) {
        switch (n) {
            case 1: {
                return new Builder(new TemplateParser(inputStream));
            }
            case 2: {
                return new Builder(new ReportParser(inputStream));
            }
        }
        return null;
    }

    public static Builder getBuilder(int n, OutputStream outputStream) {
        return Builder.getBuilder(n, outputStream, ".");
    }

    public static Builder getBuilder(int n, OutputStream outputStream, Object object) {
        switch (n) {
            case 1: {
                return new Builder(new TemplateFormatter(outputStream));
            }
            case 2: {
                return new Builder(new ReportFormatter(outputStream));
            }
            case 3: {
                return new Builder(new DelimitedFormatter(outputStream));
            }
            case 4: {
                return new Builder(new RTFFormatter(outputStream));
            }
            case 5: {
                return new Builder(new HTMLFormatter(outputStream, (String)object));
            }
        }
        return null;
    }

    public Vector getEmbeddedStyles() {
        return this.styles;
    }

    public StyleSheet read(String string) throws IOException {
        Object object;
        StyleSheet styleSheet = this.parser.createSheet(string);
        int n = 0;
        String string2 = null;
        this.styles.removeAllElements();
        while ((object = this.parser.read()) != null) {
            if (object instanceof Integer) {
                n = (Integer)object;
                if ((n & 0x100) != 0) {
                    styleSheet.setCurrentHeader(n);
                } else {
                    styleSheet.setCurrentFooter(n);
                }
                if (n != 0) continue;
                string2 = null;
                continue;
            }
            if (n != 0) {
                if ((n & 0x100) != 0) {
                    styleSheet.addHeaderElement((ReportElement)object);
                    continue;
                }
                styleSheet.addFooterElement((ReportElement)object);
                continue;
            }
            if (object instanceof String) {
                String string3 = (String)object;
                if (string3.startsWith("header.")) {
                    string2 = string3.substring(7);
                    styleSheet.setCurrentHeader(string2);
                    n = 256;
                    continue;
                }
                if (!string3.startsWith("footer.")) continue;
                string2 = string3.substring(7);
                styleSheet.setCurrentFooter(string2);
                n = 512;
                continue;
            }
            if (object instanceof ReportElement) {
                styleSheet.addElement((ReportElement)object);
                continue;
            }
            if (!(object instanceof XTableStyle)) continue;
            this.styles.addElement(object);
        }
        styleSheet.setCurrentHeader(256);
        styleSheet.setCurrentFooter(512);
        return styleSheet;
    }

    public void setEmbeddedStyles(Vector vector) {
        this.styles = vector;
    }

    public void write(StyleSheet styleSheet) throws IOException {
        int n;
        Cloneable cloneable;
        this.format.prolog(styleSheet);
        String string = Util.findDuplicate(styleSheet, false);
        if (string != null) {
            throw new IOException("Duplicated element ID: " + string);
        }
        int n2 = 0;
        while (n2 < this.styles.size()) {
            this.format.write((XTableStyle)this.styles.elementAt(n2));
            ++n2;
        }
        int[] nArray = new int[]{256, 257, 258, 259, 512, 513, 514, 515};
        int n3 = 0;
        while (n3 < nArray.length) {
            int n4;
            boolean bl;
            boolean bl2 = bl = (nArray[n3] & 0x100) != 0;
            if (bl) {
                styleSheet.setCurrentHeader(nArray[n3]);
            } else {
                styleSheet.setCurrentFooter(nArray[n3]);
            }
            int n5 = n4 = bl ? styleSheet.getHeaderElementCount() : styleSheet.getFooterElementCount();
            if (n4 != 0) {
                this.format.startHeader(nArray[n3]);
                int n6 = 0;
                while (n6 < n4) {
                    if (bl) {
                        Builder.write(this.format, styleSheet.getHeaderElement(n6));
                    } else {
                        Builder.write(this.format, styleSheet.getFooterElement(n6));
                    }
                    ++n6;
                }
                this.format.endHeader();
            }
            ++n3;
        }
        Hashtable hashtable = styleSheet.getElementHeaders();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            this.format.startHeader(string2, true);
            cloneable = (Vector)hashtable.get(string2);
            n = 0;
            while (n < ((Vector)cloneable).size()) {
                Builder.write(this.format, (ReportElement)((Vector)cloneable).elementAt(n));
                ++n;
            }
            this.format.endHeader();
        }
        hashtable = styleSheet.getElementFooters();
        enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            this.format.startHeader(string3, false);
            cloneable = (Vector)hashtable.get(string3);
            n = 0;
            while (n < ((Vector)cloneable).size()) {
                Builder.write(this.format, (ReportElement)((Vector)cloneable).elementAt(n));
                ++n;
            }
            this.format.endHeader();
        }
        int n7 = 0;
        while (n7 < styleSheet.getElementCount()) {
            cloneable = styleSheet.getElement(n7);
            Builder.write(this.format, (ReportElement)cloneable);
            ++n7;
        }
        this.format.end();
        styleSheet.setCurrentHeader(256);
        styleSheet.setCurrentFooter(512);
    }

    public static void write(Formatter formatter, ReportElement reportElement) {
        if (reportElement instanceof HeadingElement) {
            formatter.write((HeadingElement)reportElement);
        } else if (reportElement instanceof TextElement) {
            formatter.write((TextElement)reportElement);
        } else if (reportElement instanceof FormElement) {
            formatter.write((FormElement)reportElement);
        } else if (reportElement instanceof TableElement) {
            formatter.write((TableElement)reportElement);
        } else if (reportElement instanceof TextBoxElement) {
            formatter.write((TextBoxElement)reportElement);
        } else if (reportElement instanceof ChartElement) {
            formatter.write((ChartElement)reportElement);
        } else if (reportElement instanceof PainterElement) {
            formatter.write((PainterElement)reportElement);
        } else if (reportElement instanceof NewlineElement) {
            formatter.write((NewlineElement)reportElement);
        } else if (reportElement instanceof PageBreakElement) {
            formatter.write((PageBreakElement)reportElement);
        } else if (reportElement instanceof AreaBreakElement) {
            formatter.write((AreaBreakElement)reportElement);
        } else if (reportElement instanceof PageLayoutElement) {
            formatter.write((PageLayoutElement)reportElement);
        } else if (reportElement instanceof CondPageBreakElement) {
            formatter.write((CondPageBreakElement)reportElement);
        } else if (reportElement instanceof SpaceElement) {
            formatter.write((SpaceElement)reportElement);
        } else if (reportElement instanceof TabElement) {
            formatter.write((TabElement)reportElement);
        } else if (reportElement instanceof SeparatorElement) {
            formatter.write((SeparatorElement)reportElement);
        } else if (reportElement instanceof TOCElement) {
            formatter.write((TOCElement)reportElement);
        } else if (reportElement instanceof CompositeElement) {
            formatter.write((CompositeElement)reportElement);
        }
    }
}

