/*
 * Decompiled with CFR 0.152.
 */
package inetsoft.report.internal;

import inetsoft.report.ChartLens;
import inetsoft.report.ChartPainter;
import inetsoft.report.Common;
import inetsoft.report.FormLens;
import inetsoft.report.FormTable;
import inetsoft.report.StyleSheet;
import inetsoft.report.TableLens;
import inetsoft.report.internal.EmptyPainter;
import inetsoft.report.internal.StyleCore;
import inetsoft.report.lens.AttributeChartLens;
import inetsoft.report.lens.AttributeFormLens;
import inetsoft.report.lens.DefaultChartLens;
import inetsoft.report.lens.DefaultFormLens;
import inetsoft.report.lens.DefaultTableLens;
import inetsoft.report.locale.Catalog;
import inetsoft.report.painter.ImagePainter;
import inetsoft.report.style.TableStyle;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageProducer;
import java.io.File;
import java.net.URL;

public class XStyleCore
extends StyleSheet {
    public static final int FULL_PATH = 1;
    public static final int RELATIVE_PATH = 2;
    public static final int RESOURCE = 3;
    public static final int IMAGE_URL = 4;
    protected static String topdir = null;

    public static interface Tabular {
        public boolean isEmbedded();

        public void setData(TableLens var1);

        public void setEmbedded(boolean var1);
    }

    public class ChartXElement
    extends StyleCore.ChartElement
    implements Tabular {
        AttributeChartLens attr = (AttributeChartLens)this.getChart();
        boolean embed = true;

        public ChartXElement() {
            this(5);
        }

        public ChartXElement(int n) {
            super(new AttributeChartLens(new DefaultChartLens(1, 6)));
            this.attr.setStyle(n);
        }

        public Object clone() throws CloneNotSupportedException {
            ChartXElement chartXElement = (ChartXElement)super.clone();
            chartXElement.attr = (AttributeChartLens)this.attr.clone();
            chartXElement.chart = chartXElement.attr;
            chartXElement.setPainter(new ChartPainter(chartXElement.chart, chartXElement));
            return chartXElement;
        }

        public boolean isEmbedded() {
            return this.embed;
        }

        public void setChart(ChartLens chartLens) {
            if (chartLens != this.attr) {
                this.attr.setChart(chartLens);
            }
        }

        public void setData(TableLens tableLens) {
            DefaultChartLens defaultChartLens = new DefaultChartLens(tableLens.getRowCount() - 1, tableLens.getColCount() - 1);
            Double d = new Double(0.0);
            int n = 0;
            while (n < tableLens.getRowCount()) {
                int n2 = 0;
                while (n2 < tableLens.getColCount()) {
                    Object object;
                    if (n2 == 0 && n > 0) {
                        object = (String)tableLens.getObject(n, 0);
                        defaultChartLens.setDatasetLabel(n - 1, (String)(object == null ? String.valueOf(Catalog.getString("Dataset")) + n : object));
                    } else if (n == 0 && n2 > 0) {
                        object = (String)tableLens.getObject(0, n2);
                        defaultChartLens.setLabel(n2 - 1, (String)(object == null ? String.valueOf(n2) : object));
                    } else if (n > 0 && n2 > 0) {
                        object = tableLens.getObject(n, n2);
                        defaultChartLens.setData(n - 1, n2 - 1, object == null ? d : Double.valueOf("0" + object.toString()));
                    }
                    ++n2;
                }
                ++n;
            }
            this.setChart(defaultChartLens);
        }

        public void setEmbedded(boolean bl) {
            this.embed = bl;
        }
    }

    public class TableXElement
    extends StyleCore.TableElement
    implements Tabular {
        TableLens table;
        TableStyle style;
        boolean fixWidth = false;
        boolean embed = true;
        int hrows = 1;
        int hcols = 0;

        public TableXElement() {
            this(new DefaultTableLens(5, 5));
        }

        public TableXElement(DefaultTableLens defaultTableLens) {
            super(defaultTableLens);
            defaultTableLens.setRowHeight(15);
            defaultTableLens.setHeaderRowCount(1);
            this.table = defaultTableLens;
        }

        public Object clone() throws CloneNotSupportedException {
            TableXElement tableXElement = (TableXElement)super.clone();
            if (this.style != null) {
                tableXElement.setStyle((TableStyle)this.style.clone());
            }
            return tableXElement;
        }

        public int getHeaderColCount() {
            return this.hcols;
        }

        public int getHeaderRowCount() {
            return this.hrows;
        }

        public TableStyle getStyle() {
            return this.style;
        }

        public boolean isEmbedWidth() {
            return this.fixWidth;
        }

        public boolean isEmbedded() {
            return this.embed;
        }

        public void setData(TableLens tableLens) {
            DefaultTableLens defaultTableLens = new DefaultTableLens(tableLens.getRowCount(), tableLens.getColCount());
            int n = 0;
            while (n < tableLens.getRowCount()) {
                int n2 = 0;
                while (n2 < tableLens.getColCount()) {
                    Object object = tableLens.getObject(n, n2);
                    defaultTableLens.setObject(n, n2, object == null ? "" : object);
                    ++n2;
                }
                ++n;
            }
            defaultTableLens.setHeaderRowCount(tableLens.getHeaderRowCount());
            defaultTableLens.setHeaderColCount(tableLens.getHeaderColCount());
            this.setTable(defaultTableLens);
        }

        public void setEmbedWidth(boolean bl) {
            this.fixWidth = bl;
        }

        public void setEmbedded(boolean bl) {
            this.embed = bl;
        }

        public void setFixedWidths(int[] nArray) {
            super.setFixedWidths(nArray);
            this.setEmbedWidth(true);
        }

        public void setHeaderColCount(int n) {
            this.hcols = this.hcols;
        }

        public void setHeaderRowCount(int n) {
            this.hrows = n;
        }

        public void setStyle(TableStyle tableStyle) {
            this.style = tableStyle;
            if (tableStyle != null) {
                tableStyle.setTable(this.table);
                super.setTable(tableStyle);
            } else {
                super.setTable(this.table);
            }
        }

        public void setTable(TableLens tableLens) {
            if (this.style != null) {
                this.table = tableLens;
                this.style.setTable(this.table);
            } else {
                this.table = tableLens;
                super.setTable(this.table);
            }
        }

        public String toString() {
            return this.style != null ? String.valueOf(this.getID()) + " [" + Catalog.getString("Table") + ": " + this.style.getName() + "]" : super.toString();
        }
    }

    public class FormXElement
    extends StyleCore.FormElement
    implements Tabular {
        AttributeFormLens attr = (AttributeFormLens)this.getForm();
        boolean embed = true;
        boolean fixWidth = false;

        public FormXElement() {
            this(1, 2);
        }

        public FormXElement(int n, int n2) {
            super(new AttributeFormLens(new DefaultFormLens(n * n2)));
            this.attr.setFieldPerRow(n2);
        }

        public Object clone() throws CloneNotSupportedException {
            FormXElement formXElement = (FormXElement)super.clone();
            formXElement.attr = (AttributeFormLens)this.attr.clone();
            formXElement.form = formXElement.attr;
            formXElement.setTable(new FormTable(formXElement.form));
            return formXElement;
        }

        public String getType() {
            return "Form";
        }

        public boolean isEmbedWidth() {
            return this.fixWidth;
        }

        public boolean isEmbedded() {
            return this.embed;
        }

        public void setData(TableLens tableLens) {
            DefaultFormLens defaultFormLens = new DefaultFormLens();
            this.setForm(defaultFormLens);
            defaultFormLens.setFieldCount(tableLens.getRowCount());
            int n = 0;
            while (n < tableLens.getRowCount()) {
                defaultFormLens.setLabel(n, tableLens.getObject(n, 0));
                defaultFormLens.setField(n, tableLens.getObject(n, 1));
                ++n;
            }
        }

        public void setEmbedWidth(boolean bl) {
            this.fixWidth = bl;
        }

        public void setEmbedded(boolean bl) {
            this.embed = bl;
        }

        public void setFixedWidths(int[] nArray) {
            super.setFixedWidths(nArray);
            this.setEmbedWidth(true);
        }

        public void setForm(FormLens formLens) {
            if (formLens != this.attr) {
                this.attr.setForm(formLens);
            }
        }

        public String toString() {
            return String.valueOf(this.getID()) + " [" + Catalog.getString(this.getType()) + "]";
        }
    }

    public class ImageXElement
    extends StyleCore.PainterElement {
        String path;
        int pathtype = 1;

        public ImageXElement() {
            super(new EmptyPainter());
        }

        public String getAdjustedPath() {
            String string = this.path;
            if (this.path != null && this.pathtype == 2) {
                File file = new File(string);
                if (!file.isAbsolute()) {
                    return string;
                }
                if (topdir.indexOf(":\\") > 0) {
                    string = this.path.toLowerCase();
                }
                int n = 0;
                while (n < string.length() && n < topdir.length()) {
                    if (string.charAt(n) != topdir.charAt(n)) break;
                    ++n;
                }
                while (n >= 0) {
                    if (string.charAt(n) == File.separatorChar) break;
                    --n;
                }
                string = string.substring(n + 1);
                if (topdir.endsWith(File.separator)) {
                    ++n;
                }
                while ((n = topdir.indexOf(File.separator, n) + 1) > 0) {
                    string = ".." + File.separator + string;
                }
            }
            return string;
        }

        public String getPath() {
            return this.path;
        }

        public int getPathType() {
            return this.pathtype;
        }

        public String getType() {
            return "Image";
        }

        public void setPath(String string) {
            block5: {
                this.path = string;
                if (string == null) break block5;
                try {
                    Toolkit toolkit = Common.getToolkit();
                    if (this.pathtype == 3) {
                        Image image = Common.getImage(this, string);
                        this.setPainter(new ImagePainter(image));
                        break block5;
                    }
                    if (this.pathtype == 4) {
                        ImageProducer imageProducer = (ImageProducer)new URL(string).getContent();
                        this.setPainter(new ImagePainter(toolkit.createImage(imageProducer)));
                        break block5;
                    }
                    if (this.pathtype == 2) {
                        File file = new File(string);
                        String string2 = file.isAbsolute() ? string : String.valueOf(topdir) + File.separator + string;
                        this.setPainter(new ImagePainter(toolkit.getImage(string2)));
                        break block5;
                    }
                    this.setPainter(new ImagePainter(toolkit.getImage(string)));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        public void setPathType(int n) {
            this.pathtype = n;
            this.setPath(this.path);
        }

        public String toString() {
            return String.valueOf(this.getID()) + " [" + Catalog.getString(this.getType()) + ": " + this.path + "]";
        }
    }
}

