/*
 * Decompiled with CFR 0.152.
 */
package inetsoft.report.internal;

import inetsoft.report.internal.XMLException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;

public class XMLTokenStream
implements Serializable {
    private static final String[][] encoding = new String[][]{{"&nbsp;", "&amp;", "&lt;", "&gt;", "&apos;", "&quot;"}, {" ", "&", "<", ">", "'", "\""}};
    private BufferedReader reader;
    private int nextchar = -999;
    private Object nextTag = null;

    public XMLTokenStream(InputStream inputStream) {
        try {
            int n;
            int n2;
            int n3;
            char[] cArray = new char[256];
            while ((n3 = inputStream.read()) != 60 && n3 >= 0) {
            }
            int n4 = 0;
            int n5 = 0;
            while (n5 < cArray.length && (n3 = inputStream.read()) != 62) {
                cArray[n4++] = (char)n3;
                ++n5;
            }
            String string = new String(cArray, 0, n4).toUpperCase();
            int n6 = string.indexOf("ENCODING");
            String string2 = null;
            if (n6 > 0 && (n6 = string.indexOf(34, n6)) > 0 && (n2 = string.indexOf(34, n = n6 + 1)) > 0 && (string2 = string.substring(n, n2)).equals("UTF-8")) {
                string2 = "UTF8";
            }
            this.reader = string2 != null ? new BufferedReader(new InputStreamReader(inputStream, string2)) : new BufferedReader(new InputStreamReader(inputStream));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.reader = new BufferedReader(new InputStreamReader(inputStream));
            unsupportedEncodingException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static String encodeXML(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            block3: {
                int n2 = 0;
                while (n2 < encoding[1].length) {
                    if (string.charAt(n) == encoding[1][n2].charAt(0)) {
                        stringBuffer.append(encoding[0][n2]);
                        break block3;
                    }
                    ++n2;
                }
                stringBuffer.append(string.charAt(n));
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    protected String getName() throws IOException {
        if (this.nextchar == 34) {
            return this.getString();
        }
        if (Character.isUnicodeIdentifierStart((char)this.nextchar)) {
            StringBuffer stringBuffer = new StringBuffer();
            do {
                stringBuffer.append((char)this.nextchar);
                this.nextchar = this.reader.read();
            } while (Character.isUnicodeIdentifierPart((char)this.nextchar) || this.nextchar == 45);
            return stringBuffer.toString();
        }
        return null;
    }

    public Reader getReader() {
        return this.reader;
    }

    protected String getString() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.nextchar == 34) {
            while ((this.nextchar = this.reader.read()) >= 0 && this.nextchar != 34) {
                stringBuffer.append((char)this.nextchar);
            }
        } else {
            block5: while (true) {
                switch (this.nextchar) {
                    default: {
                        stringBuffer.append((char)this.nextchar);
                    }
                    case 9: 
                    case 10: 
                    case 13: {
                        if ((this.nextchar = this.reader.read()) >= 0) continue block5;
                    }
                    case 60: 
                }
                break;
            }
            String string = stringBuffer.toString();
            int n = 0;
            while (n < encoding[0].length) {
                int n2 = 0;
                while ((n2 = string.indexOf(encoding[0][n], n2)) >= 0) {
                    string = String.valueOf(string.substring(0, n2)) + encoding[1][n] + string.substring(n2 + encoding[0][n].length());
                }
                ++n;
            }
            return string;
        }
        this.nextchar = this.reader.read();
        return stringBuffer.toString();
    }

    public Object getToken() throws IOException, XMLException {
        if (this.nextTag != null) {
            Object object = this.nextTag;
            this.nextTag = null;
            return object;
        }
        if (this.nextchar == -999) {
            this.nextchar = this.reader.read();
        }
        if (this.nextchar == -1) {
            return null;
        }
        this.skipWhitespace();
        if (this.nextchar == 60) {
            boolean bl = false;
            this.nextchar = this.reader.read();
            this.skipWhitespace();
            StringBuffer stringBuffer = new StringBuffer();
            if (this.nextchar == 33) {
                while (this.nextchar >= 0 && this.nextchar != 62) {
                    if ((char)this.nextchar != '\r') {
                        stringBuffer.append((char)this.nextchar);
                    }
                    this.nextchar = this.reader.read();
                }
                if (stringBuffer.toString().startsWith("![CDATA[")) {
                    if (!(stringBuffer = new StringBuffer(stringBuffer.toString().substring(8))).toString().endsWith("]]")) {
                        while (this.nextchar >= 0) {
                            if (this.nextchar == 93) {
                                this.nextchar = this.reader.read();
                                if (this.nextchar != 93) {
                                    stringBuffer.append("]");
                                    if (this.nextchar < 0) break;
                                    stringBuffer.append((char)this.nextchar);
                                } else {
                                    this.nextchar = this.reader.read();
                                    if (this.nextchar == 62) break;
                                    stringBuffer.append("]]");
                                    if (this.nextchar < 0) break;
                                    stringBuffer.append((char)this.nextchar);
                                }
                            } else if ((char)this.nextchar != '\r') {
                                stringBuffer.append((char)this.nextchar);
                            }
                            this.nextchar = this.reader.read();
                        }
                    } else {
                        stringBuffer.setLength(stringBuffer.length() - 2);
                        this.nextchar = this.reader.read();
                    }
                    return stringBuffer.toString();
                }
                this.nextchar = this.reader.read();
                return new Tag(stringBuffer.toString());
            }
            if (this.nextchar == 63) {
                bl = true;
                this.nextchar = this.reader.read();
            } else if (this.nextchar == 47) {
                stringBuffer.append("/");
                this.nextchar = this.reader.read();
            }
            stringBuffer.append(this.getName());
            this.skipWhitespace();
            Tag tag = new Tag(stringBuffer.toString());
            while (this.nextchar != 62) {
                if (bl && this.nextchar == 63) {
                    this.nextchar = this.reader.read();
                    continue;
                }
                String string = tag.getName();
                if (this.nextchar != 61) {
                    string = this.getName();
                }
                this.skipWhitespace();
                char c = (char)this.nextchar;
                if (c == '=') {
                    this.nextchar = this.reader.read();
                    this.skipWhitespace();
                    String string2 = this.getValue();
                    if (string == null || c != '=' || string2 == null) {
                        throw new XMLException("XML tag format error: (" + stringBuffer + ":" + string + ":" + c + ":" + string2 + ")");
                    }
                    tag.put(string, string2);
                } else if (string != null) {
                    tag.put(string, "");
                } else {
                    if (c == '/') {
                        this.skipWhitespace();
                        this.nextchar = this.reader.read();
                        if (this.nextchar == 62) {
                            this.nextTag = new Tag("/" + tag.getName());
                            break;
                        }
                        throw new XMLException("XML tag format error: (" + c + "): " + tag.getName());
                    }
                    throw new XMLException("XML tag format error: (" + c + "): " + tag.getName());
                }
                this.skipWhitespace();
            }
            this.nextchar = this.reader.read();
            return tag;
        }
        return this.getString();
    }

    protected String getValue() throws IOException {
        if (this.nextchar == 34) {
            return this.getString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        do {
            stringBuffer.append((char)this.nextchar);
            this.nextchar = this.reader.read();
        } while (this.nextchar > 0 && !Character.isWhitespace((char)this.nextchar) && this.nextchar != 62);
        return stringBuffer.toString();
    }

    public void skipWhitespace() throws IOException {
        while (this.nextchar >= 0 && Character.isWhitespace((char)this.nextchar)) {
            this.nextchar = this.reader.read();
        }
    }

    public static class Tag
    implements Serializable {
        private String name = "";
        private Hashtable attrmap = new Hashtable();

        public Tag(String string) {
            this.name = string.toUpperCase();
        }

        public String get(String string) {
            return (String)this.attrmap.get(string.toUpperCase());
        }

        public Enumeration getAttributes() {
            return this.attrmap.keys();
        }

        public String getName() {
            return this.name;
        }

        public void put(String string, String string2) {
            this.attrmap.put(string.toUpperCase(), string2);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("<" + this.name);
            Enumeration enumeration = this.attrmap.keys();
            Enumeration enumeration2 = this.attrmap.elements();
            while (enumeration.hasMoreElements()) {
                stringBuffer.append(" " + enumeration.nextElement() + "=" + enumeration2.nextElement());
            }
            stringBuffer.append(">");
            return stringBuffer.toString();
        }
    }
}

